/*
 * Copyright 2020 GridGain Systems, Inc. and Contributors.
 *
 * Licensed under the GridGain Community Edition License (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.gridgain.com/products/software/community-edition/gridgain-community-edition-license
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.ignite.internal.visor.diagnostic.availability;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Map;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.dto.IgniteDataTransferObject;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.jetbrains.annotations.Nullable;

/**
 * Connectivity task result
 */
public class VisorConnectivityResult extends IgniteDataTransferObject {
    /** */
    private static final long serialVersionUID = 0L;

    /** */
    @Nullable private Map<ClusterNode, Boolean> nodeStatuses;

    /**
     * Default constructor.
     */
    public VisorConnectivityResult() {
    }

    /**
     * @param nodeStatuses Node statuses.
     */
    public VisorConnectivityResult(@Nullable Map<ClusterNode, Boolean> nodeStatuses) {
        this.nodeStatuses = nodeStatuses;
    }

    /** {@inheritDoc} */
    @Override protected void writeExternalData(ObjectOutput out) throws IOException {
        U.writeMap(out, nodeStatuses);
    }

    /** {@inheritDoc} */
    @Override protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        nodeStatuses = U.readMap(in);
    }

    /**
     * Get connectivity statuses for a node
     */
    public @Nullable Map<ClusterNode, Boolean> getNodeIds() {
        return nodeStatuses;
    }

}
