/*
 * Copyright 2019 GridGain Systems, Inc. and Contributors.
 *
 * Licensed under the GridGain Community Edition License (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.gridgain.com/products/software/community-edition/gridgain-community-edition-license
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.ignite.spi.indexing.noop;

import java.util.Collection;
import java.util.Iterator;
import javax.cache.Cache;
import org.apache.ignite.spi.IgniteSpiAdapter;
import org.apache.ignite.spi.IgniteSpiException;
import org.apache.ignite.spi.IgniteSpiNoop;
import org.apache.ignite.spi.indexing.IndexingQueryFilter;
import org.apache.ignite.spi.indexing.IndexingSpi;
import org.jetbrains.annotations.Nullable;

/**
 * Default implementation of {@link IndexingSpi} which does not index cache.
 */
@IgniteSpiNoop
public class NoopIndexingSpi extends IgniteSpiAdapter implements IndexingSpi {
    /** {@inheritDoc} */
    @Override public Iterator<Cache.Entry<?,?>> query(@Nullable String cacheName, Collection<Object> params,
        @Nullable IndexingQueryFilter filters) throws IgniteSpiException {
        throw new IgniteSpiException("You have to configure custom GridIndexingSpi implementation.");
    }

    /** {@inheritDoc} */
    @Override public void store(@Nullable String cacheName, Object key, Object val, long expirationTime)
        throws IgniteSpiException {
        assert false;
    }

    /** {@inheritDoc} */
    @Override public void remove(@Nullable String cacheName, Object key) throws IgniteSpiException {
        assert false;
    }

    /** {@inheritDoc} */
    @Override public void spiStart(@Nullable String igniteInstanceName) throws IgniteSpiException {
        // No-op.
    }

    /** {@inheritDoc} */
    @Override public void spiStop() throws IgniteSpiException {
        // No-op.
    }

    /** {@inheritDoc} */
    @Override public NoopIndexingSpi setName(String name) {
        super.setName(name);

        return this;
    }
}