/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.cache.query;

import java.util.Iterator;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import javax.cache.CacheException;
import org.apache.ignite.cache.query.QueryCancelledException;
import org.apache.ignite.internal.processors.cache.QueryCursorImpl;
import org.apache.ignite.internal.processors.query.GridQueryCancel;
import org.apache.ignite.internal.processors.query.QueryUtils;
import org.apache.ignite.internal.processors.query.RunningQueryManager;

public class RegisteredQueryCursor<T>
extends QueryCursorImpl<T> {
    private static final AtomicReferenceFieldUpdater<RegisteredQueryCursor, Exception> FAIL_REASON_UPDATER = AtomicReferenceFieldUpdater.newUpdater(RegisteredQueryCursor.class, Exception.class, "failReason");
    private final AtomicBoolean unregistered = new AtomicBoolean(false);
    private RunningQueryManager runningQryMgr;
    private Long qryId;
    private volatile Exception failReason;

    public RegisteredQueryCursor(Iterable<T> iterExec, GridQueryCancel cancel, RunningQueryManager runningQryMgr, boolean lazy, Long qryId) {
        super(iterExec, cancel, true, lazy);
        assert (runningQryMgr != null);
        assert (qryId != null);
        this.runningQryMgr = runningQryMgr;
        this.qryId = qryId;
    }

    protected Iterator<T> iter() {
        try {
            return this.lazy() ? new RegisteredIterator(super.iter()) : super.iter();
        }
        catch (Exception e) {
            throw this.failReason(e);
        }
    }

    public void close() {
        super.close();
        this.unregisterQuery();
    }

    public void cancel() {
        FAIL_REASON_UPDATER.compareAndSet(this, null, (Exception)((Object)new QueryCancelledException()));
        this.close();
    }

    private void unregisterQuery() {
        if (this.unregistered.compareAndSet(false, true)) {
            this.runningQryMgr.unregister(this.qryId, (Throwable)this.failReason);
        }
    }

    private CacheException failReason(Exception e) {
        if (FAIL_REASON_UPDATER.compareAndSet(this, null, e) && QueryUtils.wasCancelled((Throwable)this.failReason)) {
            this.unregisterQuery();
        }
        return this.failReason instanceof CacheException ? (CacheException)this.failReason : new CacheException((Throwable)this.failReason);
    }

    private class RegisteredIterator
    implements Iterator<T> {
        final Iterator<T> delegateIt;

        private RegisteredIterator(Iterator<T> it) {
            this.delegateIt = it;
        }

        @Override
        public boolean hasNext() {
            try {
                return this.delegateIt.hasNext();
            }
            catch (Exception e) {
                throw RegisteredQueryCursor.this.failReason(e);
            }
        }

        @Override
        public T next() {
            try {
                return this.delegateIt.next();
            }
            catch (Exception e) {
                throw RegisteredQueryCursor.this.failReason(e);
            }
        }
    }
}

