/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2;

import java.io.File;
import java.util.ArrayList;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.LongBinaryOperator;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.IgniteSystemProperties;
import org.apache.ignite.cache.query.exceptions.SqlMemoryQuotaExceededException;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.metric.SqlMemoryStatisticsHolder;
import org.apache.ignite.internal.processors.cache.persistence.file.AsyncFileIOFactory;
import org.apache.ignite.internal.processors.cache.persistence.file.FileIOFactory;
import org.apache.ignite.internal.processors.cache.persistence.file.RandomAccessFileIOFactory;
import org.apache.ignite.internal.processors.query.GridQueryMemoryMetricProvider;
import org.apache.ignite.internal.processors.query.h2.H2ManagedGroupByData;
import org.apache.ignite.internal.processors.query.h2.H2MemoryTracker;
import org.apache.ignite.internal.processors.query.h2.ManagedGroupByDataFactory;
import org.apache.ignite.internal.processors.query.h2.QueryMemoryTracker;
import org.apache.ignite.internal.processors.query.h2.disk.ExternalResultData;
import org.apache.ignite.internal.processors.query.h2.disk.GroupedExternalResult;
import org.apache.ignite.internal.processors.query.h2.disk.PlainExternalResult;
import org.apache.ignite.internal.processors.query.h2.disk.SortedExternalResult;
import org.apache.ignite.internal.processors.query.h2.disk.TrackableFileIoFactory;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.A;
import org.apache.ignite.internal.util.typedef.internal.LT;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.gridgain.internal.h2.command.dml.GroupByData;
import org.gridgain.internal.h2.engine.Session;
import org.gridgain.internal.h2.expression.Expression;
import org.gridgain.internal.h2.result.ResultExternal;
import org.gridgain.internal.h2.result.SortOrder;
import org.gridgain.internal.h2.store.DataHandler;

public class QueryMemoryManager
implements H2MemoryTracker,
ManagedGroupByDataFactory {
    public static final String DISK_SPILL_DIR = "tmp/spill";
    private final GridKernalContext ctx;
    public static final long DFLT_MEMORY_RESERVATION_BLOCK_SIZE = 524288L;
    private final SqlMemoryStatisticsHolder metrics;
    static final LongBinaryOperator RELEASE_OP = new LongBinaryOperator(){

        @Override
        public long applyAsLong(long prev, long x) {
            long res = prev - x;
            if (res < 0L) {
                throw new IllegalStateException("Try to free more memory that ever be reserved: [reserved=" + prev + ", toFree=" + x + ']');
            }
            return res;
        }
    };
    private final IgniteLogger log;
    private volatile long globalQuota;
    private String globalQuotaInOriginalNotation;
    private volatile long qryQuota;
    private volatile String qryQuotaInOriginalNotation;
    private final long blockSize;
    private volatile boolean offloadingEnabled;
    private final AtomicLong reserved = new AtomicLong();
    private final TrackableFileIoFactory fileIOFactory;

    public QueryMemoryManager(GridKernalContext ctx) {
        this.ctx = ctx;
        this.log = ctx.log(QueryMemoryManager.class);
        this.setGlobalQuota(ctx.config().getSqlConfiguration().getSqlGlobalMemoryQuota());
        this.setQueryQuota(ctx.config().getSqlConfiguration().getSqlQueryMemoryQuota());
        this.offloadingEnabled = ctx.config().getSqlConfiguration().isSqlOffloadingEnabled();
        this.metrics = new SqlMemoryStatisticsHolder(this, ctx.metric());
        this.blockSize = Long.getLong("IGNITE_SQL_MEMORY_RESERVATION_BLOCK_SIZE", 524288L);
        AsyncFileIOFactory delegateFactory = IgniteSystemProperties.getBoolean((String)"IGNITE_USE_ASYNC_FILE_IO_FACTORY", (boolean)true) ? new AsyncFileIOFactory() : new RandomAccessFileIOFactory();
        this.fileIOFactory = new TrackableFileIoFactory((FileIOFactory)delegateFactory, this.metrics);
        A.ensure((this.blockSize > 0L ? 1 : 0) != 0, (String)("Block size must be > 0: blockSize=" + this.blockSize));
    }

    public boolean reserve(long size) {
        if (size == 0L) {
            return true;
        }
        long reserved0 = this.reserved.addAndGet(size);
        if (this.globalQuota > 0L && reserved0 >= this.globalQuota) {
            return this.onQuotaExceeded(size);
        }
        this.metrics.trackReserve();
        return true;
    }

    public void release(long size) {
        assert (size >= 0L);
        if (size == 0L) {
            return;
        }
        assert (size > 0L);
        this.reserved.accumulateAndGet(size, RELEASE_OP);
    }

    public GridQueryMemoryMetricProvider createQueryMemoryTracker(long maxQryMemory) {
        long globalQuota0 = this.globalQuota;
        if (globalQuota0 > 0L && globalQuota0 < maxQryMemory) {
            if (this.log.isInfoEnabled()) {
                LT.info((IgniteLogger)this.log, (String)("Query memory quota cannot exceed global memory quota. It will be reduced to the size of global quota: " + globalQuota0));
            }
            maxQryMemory = globalQuota0;
        }
        if (maxQryMemory == 0L) {
            long l = maxQryMemory = globalQuota0 > 0L ? Math.min(this.qryQuota, globalQuota0) : this.qryQuota;
        }
        if (maxQryMemory < 0L) {
            maxQryMemory = 0L;
        }
        QueryMemoryTracker tracker = new QueryMemoryTracker(this, maxQryMemory, this.blockSize, this.offloadingEnabled);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Memory tracker created: " + tracker);
        }
        return tracker;
    }

    public boolean onQuotaExceeded(long size) {
        this.reserved.addAndGet(-size);
        if (this.offloadingEnabled) {
            return false;
        }
        throw new SqlMemoryQuotaExceededException("SQL query ran out of memory: Global quota was exceeded.");
    }

    public synchronized void setGlobalQuota(String newGlobalQuota) {
        long globalQuota0 = U.parseBytes((String)newGlobalQuota);
        this.globalQuotaInOriginalNotation = newGlobalQuota;
        long heapSize = Runtime.getRuntime().maxMemory();
        A.ensure((heapSize > globalQuota0 ? 1 : 0) != 0, (String)("Sql global memory quota can't be more than heap size: heapSize=" + heapSize + ", quotaSize=" + globalQuota0));
        A.ensure((globalQuota0 >= 0L ? 1 : 0) != 0, (String)("Sql global memory quota must be >= 0: quotaSize=" + globalQuota0));
        this.globalQuota = globalQuota0;
        if (this.log.isInfoEnabled()) {
            this.log.info("SQL query global quota was set to " + this.globalQuota + ". Current memory tracking parameters: [qryQuota=" + this.qryQuota + ", globalQuota=" + this.globalQuota + ", offloadingEnabled=" + this.offloadingEnabled + ']');
        }
    }

    public long getGlobalQuota() {
        return this.globalQuota;
    }

    public String getGlobalQuotaInOriginalNotation() {
        return this.globalQuotaInOriginalNotation;
    }

    public synchronized void setQueryQuota(String newQryQuota) {
        long qryQuota0 = U.parseBytes((String)newQryQuota);
        this.qryQuotaInOriginalNotation = newQryQuota;
        A.ensure((qryQuota0 >= 0L ? 1 : 0) != 0, (String)("Sql query memory quota must be >= 0: quotaSize=" + qryQuota0));
        this.qryQuota = U.parseBytes((String)newQryQuota);
        if (this.log.isInfoEnabled()) {
            this.log.info("SQL query memory quota was set to " + this.qryQuota + ". Current memory tracking parameters: [qryQuota=" + this.qryQuota + ", globalQuota=" + this.globalQuota + ", offloadingEnabled=" + this.offloadingEnabled + ']');
        }
        if (this.qryQuota > this.globalQuota) {
            this.log.warning("The local quota was set higher than global. The new value will be truncated to the size of the global quota [qryQuota=" + this.qryQuota + ", globalQuota=" + this.globalQuota);
        }
    }

    public long getQueryQuota() {
        return this.qryQuota;
    }

    public String getQueryQuotaStrinInOriginalNotation() {
        return this.qryQuotaInOriginalNotation;
    }

    public synchronized void setOffloadingEnabled(boolean offloadingEnabled) {
        this.offloadingEnabled = offloadingEnabled;
        if (this.log.isInfoEnabled()) {
            this.log.info("SQL query query offloading enabled flag was set to " + offloadingEnabled + ". Current memory tracking parameters: [qryQuota=" + this.qryQuota + ", globalQuota=" + this.globalQuota + ", offloadingEnabled=" + this.offloadingEnabled + ']');
        }
    }

    public boolean isOffloadingEnabled() {
        return this.offloadingEnabled;
    }

    public long reserved() {
        return this.reserved.get();
    }

    public long memoryLimit() {
        return this.globalQuota;
    }

    public void spill(long size) {
    }

    public void unspill(long size) {
    }

    public void close() {
        if (this.log.isDebugEnabled() && this.reserved.get() != 0L) {
            this.log.debug("Potential memory leak in SQL processor. Some query cursors were not closed or forget to free memory.");
        }
    }

    public void incrementFilesCreated() {
    }

    public H2MemoryTracker createChildTracker() {
        throw new UnsupportedOperationException();
    }

    public long writtenOnDisk() {
        throw new UnsupportedOperationException();
    }

    public long totalWrittenOnDisk() {
        throw new UnsupportedOperationException();
    }

    public void onChildClosed(H2MemoryTracker child) {
        throw new UnsupportedOperationException();
    }

    public boolean closed() {
        throw new UnsupportedOperationException();
    }

    public long globalQuota() {
        return this.globalQuota;
    }

    public IgniteLogger log() {
        return this.log;
    }

    public void cleanSpillDirectory() {
        try {
            File spillDir = U.resolveWorkDirectory((String)this.ctx.config().getWorkDirectory(), (String)DISK_SPILL_DIR, (boolean)false);
            File[] spillFiles = spillDir.listFiles();
            if (spillFiles.length == 0) {
                return;
            }
            for (int i = 0; i < spillFiles.length; ++i) {
                try {
                    File spillFile = spillFiles[i];
                    String nodeId = spillFile.getName().split("_")[1];
                    UUID nodeUuid = UUID.fromString(nodeId);
                    if (this.ctx.discovery().alive(nodeUuid) && !this.ctx.localNodeId().equals(nodeUuid)) continue;
                    spillFile.delete();
                    continue;
                }
                catch (Exception e) {
                    this.log.debug("Error on cleaning spill directory. " + X.getFullStackTrace((Throwable)e));
                }
            }
        }
        catch (Exception e) {
            this.log.warning("Failed to cleanup the temporary directory for intermediate SQL query results from the previous node run.", (Throwable)e);
        }
    }

    public GroupByData newManagedGroupByData(Session ses, ArrayList<Expression> expressions, boolean isGrpQry, int[] grpIdx) {
        boolean spillingEnabled = this.ctx.config().getSqlConfiguration().isSqlOffloadingEnabled();
        if (!spillingEnabled) {
            return null;
        }
        assert (isGrpQry);
        return new H2ManagedGroupByData(ses, grpIdx);
    }

    public ResultExternal createPlainExternalResult(Session ses) {
        return new PlainExternalResult(ses);
    }

    public ResultExternal createSortedExternalResult(Session ses, boolean distinct, int[] distinctIndexes, int visibleColCnt, SortOrder sort, int rowCnt) {
        return new SortedExternalResult(ses, distinct, distinctIndexes, visibleColCnt, sort, rowCnt);
    }

    public GroupedExternalResult createGroupedExternalResult(Session ses, int size) {
        return new GroupedExternalResult(ses, size);
    }

    public <T> ExternalResultData<T> createExternalData(Session ses, boolean useHashIdx, long initSize, Class<T> cls) {
        H2MemoryTracker tracker = ses.memoryTracker();
        if (tracker.totalWrittenOnDisk() == 0L) {
            this.metrics.trackQueryOffloaded();
            if (this.log.isInfoEnabled()) {
                LT.info((IgniteLogger)this.log, (String)("Offloading started for query: " + ses.queryDescription()));
            }
        }
        return new ExternalResultData<T>(this.log, this.ctx.config().getWorkDirectory(), this.fileIOFactory, this.ctx.localNodeId(), useHashIdx, initSize, cls, ses.getDatabase().getCompareMode(), (DataHandler)ses.getDatabase(), ses.memoryTracker());
    }
}

