/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.database;

import java.util.List;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.configuration.CacheConfiguration;
import org.apache.ignite.internal.processors.query.IgniteSQLException;
import org.apache.ignite.internal.processors.query.h2.database.H2TreeIndexBase;
import org.apache.ignite.internal.processors.query.h2.database.InlineIndexColumn;
import org.apache.ignite.internal.processors.query.h2.database.inlinecolumn.InlineIndexColumnFactory;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2IndexBase;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2Table;
import org.apache.ignite.internal.processors.query.h2.opt.H2CacheRow;
import org.apache.ignite.spi.indexing.IndexingQueryCacheFilter;
import org.gridgain.internal.h2.engine.Session;
import org.gridgain.internal.h2.index.Cursor;
import org.gridgain.internal.h2.index.IndexType;
import org.gridgain.internal.h2.result.SearchRow;
import org.gridgain.internal.h2.table.IndexColumn;
import org.gridgain.internal.h2.table.Table;

public class H2TreeClientIndex
extends H2TreeIndexBase {
    private final int inlineSize;

    private H2TreeClientIndex(GridH2Table tbl, String name, IndexColumn[] cols, IndexType idxType, int inlineSize) {
        super(tbl, name, cols, idxType);
        this.inlineSize = inlineSize;
    }

    public static H2TreeClientIndex createIndex(GridH2Table tbl, String idxName, boolean pk, List<IndexColumn> colsList, int inlineSize, IgniteLogger log) {
        IndexColumn[] cols = GridH2IndexBase.columnsArray(tbl, colsList);
        IndexType idxType = pk ? IndexType.createPrimaryKey((boolean)false, (boolean)false) : IndexType.createNonUnique((boolean)false, (boolean)false, (boolean)false);
        CacheConfiguration ccfg = tbl.cacheInfo().config();
        List<InlineIndexColumn> inlineCols = H2TreeClientIndex.getAvailableInlineColumns(false, ccfg.getName(), idxName, log, pk, (Table)tbl, cols, new InlineIndexColumnFactory(tbl.getCompareMode()), true);
        inlineSize = H2TreeClientIndex.computeInlineSize(inlineCols, inlineSize, ccfg.getSqlIndexMaxInlineSize());
        return new H2TreeClientIndex(tbl, idxName, cols, idxType, inlineSize);
    }

    @Override
    public int inlineSize() {
        return this.inlineSize;
    }

    @Override
    public void refreshColumnIds() {
    }

    @Override
    public long totalRowCount(IndexingQueryCacheFilter partsFilter) {
        throw H2TreeClientIndex.unsupported();
    }

    @Override
    public int segmentsCount() {
        throw H2TreeClientIndex.unsupported();
    }

    public Cursor find(Session ses, SearchRow lower, SearchRow upper) {
        throw H2TreeClientIndex.unsupported();
    }

    @Override
    public H2CacheRow put(H2CacheRow row) {
        throw H2TreeClientIndex.unsupported();
    }

    @Override
    public boolean putx(H2CacheRow row) {
        throw H2TreeClientIndex.unsupported();
    }

    @Override
    public boolean removex(SearchRow row) {
        throw H2TreeClientIndex.unsupported();
    }

    public long getRowCount(Session ses) {
        throw H2TreeClientIndex.unsupported();
    }

    public Cursor findFirstOrLast(Session session, boolean first) {
        throw H2TreeClientIndex.unsupported();
    }

    private static IgniteException unsupported() {
        return new IgniteSQLException("Shouldn't be invoked on non-affinity node.");
    }
}

