/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.database.inlinecolumn;

import org.apache.ignite.internal.pagemem.PageUtils;
import org.apache.ignite.internal.processors.query.h2.database.inlinecolumn.AbstractInlineIndexColumn;
import org.gridgain.internal.h2.table.Column;
import org.gridgain.internal.h2.value.Value;
import org.gridgain.internal.h2.value.ValueInt;

public class ObjectHashInlineIndexColumn
extends AbstractInlineIndexColumn {
    public ObjectHashInlineIndexColumn(Column col) {
        super(col, 19, (short)4);
    }

    @Override
    protected int compare0(long pageAddr, int off, Value v, int type) {
        int val2;
        if (this.type() != type || type != v.getValueType()) {
            return Integer.MIN_VALUE;
        }
        int val1 = PageUtils.getInt((long)pageAddr, (int)(off + 1));
        int res = Integer.signum(Integer.compare(val1, val2 = v.getObject().hashCode()));
        return res == 0 ? -2 : res;
    }

    @Override
    protected int put0(long pageAddr, int off, Value val, int maxSize) {
        assert (this.type() == val.getValueType());
        PageUtils.putByte((long)pageAddr, (int)off, (byte)((byte)val.getValueType()));
        PageUtils.putInt((long)pageAddr, (int)(off + 1), (int)val.getObject().hashCode());
        return this.size() + 1;
    }

    @Override
    protected Value get0(long pageAddr, int off) {
        return null;
    }

    ValueInt inlinedValue(long pageAddr, int off) {
        return ValueInt.get((int)PageUtils.getInt((long)pageAddr, (int)(off + 1)));
    }

    @Override
    protected int inlineSizeOf0(Value val) {
        assert (val.getType().getValueType() == this.type());
        return this.size() + 1;
    }
}

