/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.disk;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Array;
import java.nio.ByteBuffer;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.processors.cache.persistence.file.FileIO;
import org.apache.ignite.internal.processors.query.h2.H2MemoryTracker;
import org.apache.ignite.internal.processors.query.h2.disk.ExternalResultHashIndex;
import org.apache.ignite.internal.processors.query.h2.disk.TrackableFileIoFactory;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.lang.IgniteBiTuple;
import org.gridgain.internal.h2.message.DbException;
import org.gridgain.internal.h2.store.Data;
import org.gridgain.internal.h2.store.DataHandler;
import org.gridgain.internal.h2.value.CompareMode;
import org.gridgain.internal.h2.value.Value;
import org.gridgain.internal.h2.value.ValueNull;
import org.gridgain.internal.h2.value.ValueRow;

public class ExternalResultData<T>
implements AutoCloseable {
    private static final AtomicLong idGen = new AtomicLong();
    private static final int ROW_HEADER_SIZE = 8;
    private static final int DEFAULT_ROW_SIZE = 512;
    private static final int TOMBSTONE = -1;
    private static final int TOMBSTONE_OFFSET = 4;
    private static final byte[] TOMBSTONE_BYTES = ByteBuffer.allocate(4).putInt(-1).array();
    private final Class<T> cls;
    private final IgniteLogger log;
    private final File file;
    private final FileIO fileIo;
    private final TrackableFileIoFactory fileIOFactory;
    private final ExternalResultHashIndex hashIdx;
    private long lastWrittenPos;
    private final Data writeBuff;
    private final Collection<Chunk> chunks = new ArrayList<Chunk>();
    private final ByteBuffer headReadBuff = ByteBuffer.allocate(8);
    private final CompareMode cmp;
    private final DataHandler hnd;
    private ByteBuffer readBuff;
    private final H2MemoryTracker tracker;
    private boolean closed;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExternalResultData(IgniteLogger log, String workDir, TrackableFileIoFactory fileIOFactory, UUID locNodeId, boolean useHashIdx, long initSize, Class<T> cls, CompareMode cmp, DataHandler hnd, H2MemoryTracker tracker) {
        this.log = log;
        this.cls = cls;
        this.cmp = cmp;
        this.fileIOFactory = fileIOFactory;
        this.tracker = tracker;
        String fileName = "spill_" + locNodeId + "_" + idGen.incrementAndGet();
        try {
            this.file = new File(U.resolveWorkDirectory((String)workDir, (String)"tmp/spill", (boolean)false), fileName);
            ExternalResultData externalResultData = this;
            synchronized (externalResultData) {
                this.checkCancelled();
                this.fileIo = fileIOFactory.create(this.file, tracker, StandardOpenOption.CREATE_NEW, StandardOpenOption.READ, StandardOpenOption.WRITE);
            }
            if (log.isDebugEnabled()) {
                log.debug("Created spill file " + this.file.getName());
            }
            this.hnd = hnd;
            this.writeBuff = Data.create((DataHandler)hnd, (int)512, (boolean)false);
            this.hashIdx = useHashIdx ? new ExternalResultHashIndex(fileIOFactory, this.file, this, initSize, tracker) : null;
        }
        catch (IOException | IgniteCheckedException | IgniteException e) {
            U.closeQuiet((AutoCloseable)this);
            throw new IgniteException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExternalResultData(ExternalResultData<T> parent) {
        try {
            this.log = parent.log;
            this.cmp = parent.cmp;
            this.cls = parent.cls;
            this.file = parent.file;
            this.fileIOFactory = parent.fileIOFactory;
            this.tracker = parent.tracker;
            ExternalResultData externalResultData = this;
            synchronized (externalResultData) {
                this.checkCancelled();
                this.fileIo = this.fileIOFactory.create(this.file, this.tracker, StandardOpenOption.READ);
            }
            this.writeBuff = parent.writeBuff;
            this.hnd = parent.hnd;
            this.hashIdx = parent.hashIdx != null ? parent.hashIdx.createShallowCopy() : null;
        }
        catch (IOException e) {
            throw new IgniteException("Failed to create external result data.", (Throwable)e);
        }
    }

    public void store(Collection<Map.Entry<ValueRow, T[]>> rows) {
        long initFilePos = this.lastWrittenPos;
        this.setFilePosition(this.lastWrittenPos);
        for (Map.Entry<ValueRow, T[]> row : rows) {
            this.writeToFile(row);
        }
        this.chunks.add(new Chunk(initFilePos, this.lastWrittenPos));
    }

    private void writeToFile(Map.Entry<ValueRow, T[]> row) {
        int i;
        this.writeBuff.reset();
        ValueNull rowKey = row.getKey() == null ? ValueNull.INSTANCE : (Value)row.getKey();
        T[] rowVal = row.getValue();
        assert (rowVal != null);
        int valLen = this.nonNullsLength(rowVal);
        this.writeBuff.checkCapacity(8);
        this.writeBuff.writeInt(0);
        this.writeBuff.writeInt(valLen + 1);
        this.writeBuff.checkCapacity(this.writeBuff.getValueLen((Object)rowKey));
        this.writeBuff.writeValue((Object)rowKey);
        int len = 0;
        for (i = 0; i < valLen; ++i) {
            len += this.writeBuff.getValueLen(rowVal[i]);
        }
        this.writeBuff.checkCapacity(len);
        for (i = 0; i < valLen; ++i) {
            this.writeBuff.writeValue(rowVal[i]);
        }
        this.writeBuff.setInt(0, this.writeBuff.length() - 8);
        this.writeToFile(this.writeBuff);
        if (this.hashIdx != null) {
            this.hashIdx.put(row.getKey(), this.lastWrittenPos);
        }
        this.lastWrittenPos = this.currentFilePosition();
    }

    private int nonNullsLength(T[] row) {
        for (int i = 0; i < row.length; ++i) {
            if (row[i] != null) continue;
            return i;
        }
        return row.length;
    }

    public boolean remove(ValueRow row) {
        assert (this.hashIdx != null);
        assert (row != null);
        long addr = this.hashIdx.remove(row);
        if (addr < 0L) {
            return false;
        }
        this.markRemoved(addr);
        return true;
    }

    private synchronized void markRemoved(long addr) {
        try {
            this.checkCancelled();
            this.fileIo.position(addr + 4L);
            this.fileIo.write(TOMBSTONE_BYTES, 0, TOMBSTONE_BYTES.length);
        }
        catch (IOException e) {
            this.close();
            throw new IgniteException("Failed to write tombstone to the spill file.", (Throwable)e);
        }
    }

    public boolean contains(ValueRow row) {
        assert (this.hashIdx != null);
        assert (row != null);
        return this.hashIdx.contains(row);
    }

    public Map.Entry<ValueRow, T[]> get(ValueRow key) {
        assert (this.hashIdx != null);
        assert (key != null);
        long addr = this.hashIdx.get(key);
        if (addr < 0L) {
            return null;
        }
        return this.readRowFromFile(addr);
    }

    Map.Entry<ValueRow, T[]> readRowFromFile() {
        return this.readRowFromFile(this.currentFilePosition());
    }

    Map.Entry<ValueRow, T[]> readRowFromFile(long pos) {
        this.setFilePosition(pos);
        this.headReadBuff.clear();
        this.readFromFile(this.headReadBuff);
        this.headReadBuff.flip();
        int size = this.headReadBuff.getInt();
        int colCnt = this.headReadBuff.getInt();
        if (colCnt == -1) {
            this.setFilePosition(pos + (long)size + 8L);
            return null;
        }
        if (this.readBuff == null || this.readBuff.capacity() < size) {
            this.readBuff = ByteBuffer.allocate(size * 2);
        }
        this.readBuff.clear();
        this.readBuff.limit(size);
        this.readFromFile(this.readBuff);
        this.readBuff.flip();
        Data buff = Data.create((DataHandler)this.hnd, (byte[])this.readBuff.array(), (boolean)true);
        buff.setCompareMode(this.cmp);
        IgniteBiTuple row = new IgniteBiTuple();
        Value rowKey = (Value)buff.readValue();
        if (rowKey == ValueNull.INSTANCE) {
            row.set1(null);
        } else {
            row.set1((Object)((ValueRow)rowKey));
        }
        Object[] rowVal = (Object[])Array.newInstance(this.cls, colCnt - 1);
        for (int i = 0; i < colCnt - 1; ++i) {
            rowVal[i] = buff.readValue();
        }
        row.set2((Object)rowVal);
        return row;
    }

    private synchronized void readFromFile(ByteBuffer buff) {
        try {
            this.checkCancelled();
            this.fileIo.readFully(buff);
        }
        catch (IOException e) {
            this.close();
            throw new IgniteException("Failed to write intermediate query result to the spill file.", (Throwable)e);
        }
    }

    private synchronized int writeToFile(Data buff) {
        try {
            this.checkCancelled();
            ByteBuffer byteBuff = ByteBuffer.wrap(buff.getBytes());
            byteBuff.limit(buff.length());
            this.fileIo.writeFully(byteBuff);
            return byteBuff.limit();
        }
        catch (IOException e) {
            this.close();
            throw new IgniteException("Failed to write intermediate query result to the spill file.", (Throwable)e);
        }
    }

    private synchronized void setFilePosition(long pos) {
        try {
            this.checkCancelled();
            this.fileIo.position(pos);
        }
        catch (IOException e) {
            this.close();
            throw new IgniteException("Failed to reset the spill file.", (Throwable)e);
        }
    }

    private synchronized long currentFilePosition() {
        try {
            this.checkCancelled();
            return this.fileIo.position();
        }
        catch (IOException e) {
            this.close();
            throw new IgniteException("Failed to access the spill file.", (Throwable)e);
        }
    }

    void rewindFile() {
        this.setFilePosition(0L);
    }

    Collection<Chunk> chunks() {
        return this.chunks;
    }

    private void checkCancelled() {
        if (this.closed) {
            throw DbException.get((int)57014);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        ExternalResultData externalResultData = this;
        synchronized (externalResultData) {
            if (this.closed) {
                return;
            }
            U.closeQuiet((AutoCloseable)this.fileIo);
            this.closed = true;
        }
        U.closeQuiet((AutoCloseable)this.hashIdx);
        this.file.delete();
        if (this.log.isDebugEnabled()) {
            this.log.debug("Deleted spill file " + this.file.getName());
        }
    }

    ExternalResultData createShallowCopy() {
        return new ExternalResultData<T>(this);
    }

    class Chunk {
        private final long start;
        private final long end;
        private long curPos;
        private Map.Entry<ValueRow, T[]> curRow;

        Chunk(long start, long end) {
            this.start = start;
            this.curPos = start;
            this.end = end;
        }

        boolean next() {
            while (this.curPos < this.end) {
                this.curRow = ExternalResultData.this.readRowFromFile(this.curPos);
                this.curPos = ExternalResultData.this.currentFilePosition();
                if (this.curRow == null) continue;
                return true;
            }
            return false;
        }

        void reset() {
            this.curPos = this.start;
            this.curRow = null;
        }

        Map.Entry<ValueRow, T[]> currentRow() {
            return this.curRow;
        }

        public long start() {
            return this.start;
        }
    }
}

