/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.opt;

import java.util.List;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.GridCacheContext;
import org.apache.ignite.internal.processors.query.h2.H2Utils;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2RowDescriptor;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2Table;
import org.apache.ignite.internal.processors.query.h2.opt.H2CacheRow;
import org.apache.ignite.internal.processors.query.h2.opt.H2IndexCostedBase;
import org.apache.ignite.internal.processors.query.h2.opt.QueryContext;
import org.apache.ignite.internal.processors.query.h2.opt.QueryContextRegistry;
import org.apache.ignite.internal.processors.query.h2.opt.join.CollocationModel;
import org.apache.ignite.internal.processors.query.h2.opt.join.CollocationModelMultiplier;
import org.apache.ignite.spi.indexing.IndexingQueryCacheFilter;
import org.gridgain.internal.h2.engine.Session;
import org.gridgain.internal.h2.index.Index;
import org.gridgain.internal.h2.index.IndexType;
import org.gridgain.internal.h2.message.DbException;
import org.gridgain.internal.h2.result.Row;
import org.gridgain.internal.h2.result.SearchRow;
import org.gridgain.internal.h2.table.IndexColumn;
import org.gridgain.internal.h2.table.Table;
import org.gridgain.internal.h2.table.TableFilter;
import org.gridgain.internal.h2.value.Value;
import org.jetbrains.annotations.NotNull;

public abstract class GridH2IndexBase
extends H2IndexCostedBase {
    protected GridH2IndexBase(GridH2Table tbl, String name, IndexColumn[] cols, IndexType type) {
        super(tbl, name, cols, type);
    }

    public final void close(Session ses) {
    }

    public void destroy(boolean rmv) {
    }

    protected int segment(QueryContext qctx) {
        if (this.segmentsCount() == 1) {
            return 0;
        }
        if (qctx == null) {
            throw new IllegalStateException("GridH2QueryContext is not initialized.");
        }
        return qctx.segment();
    }

    public abstract H2CacheRow put(H2CacheRow var1);

    public abstract boolean putx(H2CacheRow var1);

    public abstract boolean removex(SearchRow var1);

    public final int getDistributedMultiplier(Session ses, TableFilter[] filters, int filter) {
        CollocationModelMultiplier mul = CollocationModel.distributedMultiplier(ses, filters, filter);
        return mul.multiplier();
    }

    public GridH2Table getTable() {
        return (GridH2Table)super.getTable();
    }

    public long getDiskSpaceUsed() {
        return 0L;
    }

    public void checkRename() {
        throw DbException.getUnsupportedException((String)"rename");
    }

    public void add(Session ses, Row row) {
        throw DbException.getUnsupportedException((String)"add");
    }

    public void remove(Session ses, Row row) {
        throw DbException.getUnsupportedException((String)"remove row");
    }

    public void remove(Session ses) {
    }

    public void truncate(Session ses) {
        throw DbException.getUnsupportedException((String)"truncate");
    }

    public boolean needRebuild() {
        return false;
    }

    public void removeChildrenAndResources(Session session) {
        assert (this.table instanceof GridH2Table);
        ((GridH2Table)this.table).removeIndex(session, (Index)this);
        this.remove(session);
        this.database.removeMeta(session, this.getId());
    }

    public abstract int segmentsCount();

    public int segmentForPartition(int partition) {
        return this.segmentsCount() == 1 ? 0 : partition % this.segmentsCount();
    }

    protected int segmentForRow(GridCacheContext ctx, SearchRow row) {
        assert (row != null);
        if (this.segmentsCount() == 1 || ctx == null) {
            return 0;
        }
        Value keyColValue = row.getValue(0);
        assert (keyColValue != null);
        Object o = keyColValue.getObject();
        Object key = o instanceof CacheObject ? (CacheObject)o : ctx.toCacheKeyObject(o);
        return this.segmentForPartition(ctx.affinity().partition(key));
    }

    public void refreshColumnIds() {
        assert (this.columnIds.length == this.columns.length);
        for (int pos = 0; pos < this.columnIds.length; ++pos) {
            this.columnIds[pos] = this.columns[pos].getColumnId();
        }
    }

    protected GridH2RowDescriptor rowDescriptor() {
        return ((GridH2Table)this.table).rowDescriptor();
    }

    protected QueryContextRegistry queryContextRegistry() {
        return ((GridH2Table)this.table).rowDescriptor().indexing().queryContextRegistry();
    }

    @NotNull
    public static IndexColumn[] columnsArray(GridH2Table tbl, List<IndexColumn> colsList) {
        IndexColumn[] cols = colsList.toArray(H2Utils.EMPTY_COLUMNS);
        IndexColumn.mapColumns((IndexColumn[])cols, (Table)tbl);
        return cols;
    }

    public long getRowCountApproximation(Session ses) {
        return this.table.getRowCountApproximation(ses);
    }

    public abstract long totalRowCount(IndexingQueryCacheFilter var1);
}

