/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.sql;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Comparator;
import org.gridgain.internal.h2.api.AggregateFunction;

public class GridAggregateOrderedFunction
implements AggregateFunction {
    protected Object[] currentVal;
    protected boolean asc;
    protected Comparator<? super Comparable> comparator;

    public GridAggregateOrderedFunction(boolean asc, Comparator<? super Comparable> comparator) {
        this.asc = asc;
        this.comparator = comparator;
    }

    public void init(Connection conn) throws SQLException {
    }

    public int getType(int[] inputTypes) throws SQLException {
        if (inputTypes.length < 2) {
            throw new SQLException("Aggregation function should have at least two arguments.");
        }
        return inputTypes[0];
    }

    public void add(Object value) throws SQLException {
        Object[] objectArray;
        if (value instanceof Object[]) {
            objectArray = (Object[])value;
        } else {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = value;
        }
        Object[] arr = objectArray;
        if (this.currentVal == null) {
            this.currentVal = arr;
            return;
        }
        int compare = (this.asc ? 1 : -1) * this.compare(this.currentVal, arr);
        if (compare > 0) {
            this.currentVal = arr;
        }
    }

    protected int compare(Object[] arg1, Object[] arg2) throws SQLException {
        int result = 0;
        for (int i = 1; i < arg1.length; ++i) {
            int compare = this.comparator.compare((Comparable)arg1[i], (Comparable)arg2[i]);
            if (compare < 0) {
                result = -1;
                break;
            }
            if (compare <= 0) continue;
            result = 1;
            break;
        }
        return result;
    }

    public Object getResult() throws SQLException {
        if (this.currentVal == null) {
            return null;
        }
        return this.currentVal[0];
    }
}

