/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.sql;

import java.util.Collections;
import java.util.List;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2Table;
import org.apache.ignite.internal.processors.query.h2.sql.GridSqlElement;
import org.apache.ignite.internal.util.typedef.internal.SB;
import org.gridgain.internal.h2.command.Parser;
import org.gridgain.internal.h2.table.Table;
import org.jetbrains.annotations.Nullable;

public class GridSqlTable
extends GridSqlElement {
    private final String schema;
    private final String tblName;
    private final GridH2Table tbl;
    private List<String> useIndexes;

    public GridSqlTable(@Nullable String schema, String tblName) {
        this(schema, tblName, null);
    }

    public GridSqlTable(Table tbl) {
        this(tbl.getSchema().getName(), tbl.getName(), tbl);
    }

    private GridSqlTable(@Nullable String schema, String tblName, @Nullable Table tbl) {
        super(Collections.emptyList());
        assert (schema != null) : "schema";
        assert (tblName != null) : "tblName";
        this.schema = schema;
        this.tblName = tblName;
        this.tbl = tbl instanceof GridH2Table ? (GridH2Table)tbl : null;
    }

    @Override
    public String getSQL() {
        return this.getBeforeAliasSql(true) + this.getAfterAliasSQL(true);
    }

    public String getBeforeAliasSql(boolean alwaysQuote) {
        if (this.schema == null) {
            return Parser.quoteIdentifier((String)this.tblName, (boolean)alwaysQuote);
        }
        return Parser.quoteIdentifier((String)this.schema, (boolean)alwaysQuote) + '.' + Parser.quoteIdentifier((String)this.tblName, (boolean)alwaysQuote);
    }

    public String getAfterAliasSQL(boolean alwaysQuote) {
        if (this.useIndexes == null) {
            return "";
        }
        SB b = new SB();
        b.a(" USE INDEX (");
        boolean first = true;
        for (String idx : this.useIndexes) {
            if (first) {
                first = false;
            } else {
                b.a(", ");
            }
            b.a(Parser.quoteIdentifier((String)idx, (boolean)alwaysQuote));
        }
        b.a(')');
        return b.toString();
    }

    public void useIndexes(List<String> useIndexes) {
        this.useIndexes = useIndexes;
    }

    public String schema() {
        return this.schema;
    }

    public String tableName() {
        return this.tblName;
    }

    public GridH2Table dataTable() {
        return this.tbl;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        GridSqlTable that = (GridSqlTable)o;
        return this.schema.equals(that.schema) && this.tblName.equals(that.tblName);
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = 31 * result + this.schema.hashCode();
        result = 31 * result + this.tblName.hashCode();
        return result;
    }
}

