/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.sys.view;

import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.processors.query.h2.sys.view.SqlSystemView;
import org.gridgain.internal.h2.table.Column;

public abstract class SqlAbstractSystemView
implements SqlSystemView {
    protected static final long DEFAULT_ROW_COUNT_APPROXIMATION = 100L;
    protected final String tblName;
    protected final String desc;
    protected final GridKernalContext ctx;
    protected final IgniteLogger log;
    protected final Column[] cols;
    protected final String[] indexes;

    public SqlAbstractSystemView(String tblName, String desc, GridKernalContext ctx, Column[] cols, String[] indexes) {
        this.tblName = tblName;
        this.desc = desc;
        this.ctx = ctx;
        this.cols = cols;
        this.indexes = indexes;
        this.log = ctx.log(this.getClass());
    }

    protected static Column newColumn(String name) {
        return SqlAbstractSystemView.newColumn(name, 13);
    }

    protected static Column newColumn(String name, int type) {
        return new Column(name, type);
    }

    @Override
    public String getTableName() {
        return this.tblName;
    }

    @Override
    public String getDescription() {
        return this.desc;
    }

    @Override
    public Column[] getColumns() {
        return this.cols;
    }

    @Override
    public String[] getIndexes() {
        return this.indexes;
    }

    @Override
    public long getRowCount() {
        return 100L;
    }

    @Override
    public boolean canGetRowCount() {
        return false;
    }

    @Override
    public String getCreateSQL() {
        StringBuilder sql = new StringBuilder();
        sql.append("CREATE TABLE " + this.getTableName() + '(');
        boolean isFirst = true;
        for (Column col : this.getColumns()) {
            if (isFirst) {
                isFirst = false;
            } else {
                sql.append(", ");
            }
            sql.append(col.getCreateSQL());
        }
        sql.append(')');
        return sql.toString();
    }
}

