/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.sys.view;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.processors.query.GridRunningQueryInfo;
import org.apache.ignite.internal.processors.query.h2.IgniteH2Indexing;
import org.apache.ignite.internal.processors.query.h2.sys.view.SqlAbstractLocalSystemView;
import org.apache.ignite.internal.processors.query.h2.sys.view.SqlSystemViewColumnCondition;
import org.apache.ignite.plugin.security.SecurityPermission;
import org.gridgain.internal.h2.engine.Session;
import org.gridgain.internal.h2.result.Row;
import org.gridgain.internal.h2.result.SearchRow;

public class SqlSystemViewRunningQueries
extends SqlAbstractLocalSystemView {
    public SqlSystemViewRunningQueries(GridKernalContext ctx) {
        super("LOCAL_SQL_RUNNING_QUERIES", "Running queries", ctx, new String[]{"QUERY_ID"}, SqlSystemViewRunningQueries.newColumn("QUERY_ID"), SqlSystemViewRunningQueries.newColumn("SQL"), SqlSystemViewRunningQueries.newColumn("SCHEMA_NAME"), SqlSystemViewRunningQueries.newColumn("LOCAL", 1), SqlSystemViewRunningQueries.newColumn("START_TIME", 11), SqlSystemViewRunningQueries.newColumn("DURATION", 5), SqlSystemViewRunningQueries.newColumn("MEMORY_CURRENT", 5), SqlSystemViewRunningQueries.newColumn("MEMORY_MAX", 5), SqlSystemViewRunningQueries.newColumn("DISK_ALLOCATION_CURRENT", 5), SqlSystemViewRunningQueries.newColumn("DISK_ALLOCATION_MAX", 5), SqlSystemViewRunningQueries.newColumn("DISK_ALLOCATION_TOTAL", 5), SqlSystemViewRunningQueries.newColumn("INITIATOR_ID", 13));
    }

    @Override
    public Iterator<Row> getRows(Session ses, SearchRow first, SearchRow last) {
        this.ctx.security().authorize(SecurityPermission.GET_QUERY_VIEWS);
        SqlSystemViewColumnCondition qryIdCond = this.conditionForColumn("QUERY_ID", first, last);
        List<Object> runningSqlQueries = ((IgniteH2Indexing)this.ctx.query().getIndexing()).runningSqlQueries();
        if (qryIdCond.isEquality()) {
            String qryId = qryIdCond.valueForEquality().getString();
            runningSqlQueries = runningSqlQueries.stream().filter(r -> r.globalQueryId().equals(qryId)).findFirst().map(Collections::singletonList).orElse(Collections.emptyList());
        }
        if (runningSqlQueries.isEmpty()) {
            return Collections.emptyIterator();
        }
        long now = System.currentTimeMillis();
        ArrayList<Row> rows = new ArrayList<Row>(runningSqlQueries.size());
        for (GridRunningQueryInfo info : runningSqlQueries) {
            long duration = now - info.startTime();
            rows.add(this.createRow(ses, info.globalQueryId(), info.query(), info.schemaName(), info.local(), SqlSystemViewRunningQueries.valueTimestampFromMillis(info.startTime()), duration, info.memoryMetricProvider().reserved(), info.memoryMetricProvider().maxReserved(), info.memoryMetricProvider().writtenOnDisk(), info.memoryMetricProvider().maxWrittenOnDisk(), info.memoryMetricProvider().totalWrittenOnDisk(), info.queryInitiatorId()));
        }
        return rows.iterator();
    }

    @Override
    public boolean canGetRowCount() {
        return true;
    }

    @Override
    public long getRowCount() {
        return ((IgniteH2Indexing)this.ctx.query().getIndexing()).runningSqlQueries().size();
    }
}

