/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.twostep;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.processors.query.h2.H2Utils;
import org.apache.ignite.internal.processors.query.h2.opt.GridH2Cursor;
import org.apache.ignite.internal.processors.query.h2.opt.H2PlainRowFactory;
import org.apache.ignite.internal.processors.query.h2.twostep.AbstractReducer;
import org.apache.ignite.internal.processors.query.h2.twostep.ReduceResultPage;
import org.apache.ignite.internal.processors.query.h2.twostep.Reducer;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.gridgain.internal.h2.index.Cursor;
import org.gridgain.internal.h2.message.DbException;
import org.gridgain.internal.h2.result.Row;
import org.gridgain.internal.h2.result.SearchRow;
import org.gridgain.internal.h2.value.Value;
import org.jetbrains.annotations.Nullable;

public class SortedReducer
extends AbstractReducer {
    protected final Comparator<SearchRow> firstRowCmp = (rowInList, searchRow) -> {
        int res = this.compareRows((SearchRow)rowInList, (SearchRow)searchRow);
        return res == 0 ? 1 : res;
    };
    protected final Comparator<SearchRow> lastRowCmp = (rowInList, searchRow) -> {
        int res = this.compareRows((SearchRow)rowInList, (SearchRow)searchRow);
        return res == 0 ? -1 : res;
    };
    private final Comparator<RowStream> streamCmp = (o1, o2) -> {
        if (o1 == o2) {
            return 0;
        }
        if (o1 == null) {
            return -1;
        }
        if (o2 == null) {
            return 1;
        }
        return this.compareRows((SearchRow)((RowStream)o1).get(), (SearchRow)((RowStream)o2).get());
    };
    private final Lock lock = new ReentrantLock();
    private final Condition notEmpty = this.lock.newCondition();
    private final Reducer.RowComparator rowComparator;
    private Map<UUID, RowStream[]> streamsMap;
    private ReduceResultPage failPage;
    private MergeStreamIterator it;

    public SortedReducer(GridKernalContext ctx, Reducer.RowComparator rowComparator) {
        super(ctx);
        this.rowComparator = rowComparator;
    }

    private int compareRows(SearchRow rowData, SearchRow compare) {
        return this.rowComparator.compareRows(rowData, compare);
    }

    @Override
    public void setSources(Collection<ClusterNode> nodes, int segmentsCnt) {
        super.setSources(nodes, segmentsCnt);
        this.streamsMap = U.newHashMap((int)nodes.size());
        RowStream[] streams = new RowStream[nodes.size() * segmentsCnt];
        int i = 0;
        for (ClusterNode node : nodes) {
            RowStream[] segments = new RowStream[segmentsCnt];
            for (int s = 0; s < segmentsCnt; ++s) {
                streams[i++] = segments[s] = new RowStream();
            }
            if (this.streamsMap.put(node.id(), segments) == null) continue;
            throw new IllegalStateException();
        }
        this.it = new MergeStreamIterator(streams);
    }

    @Override
    public boolean fetchedAll() {
        return this.it.fetchedAll();
    }

    @Override
    protected Cursor findInStream(@Nullable SearchRow first, @Nullable SearchRow last) {
        return new FetchingCursor(first, last, this.it);
    }

    @Override
    protected Cursor findAllFetched(List<Row> fetched, SearchRow first, SearchRow last) {
        Iterator<Object> iter;
        if (fetched.isEmpty()) {
            iter = Collections.emptyIterator();
        } else if (first == null && last == null) {
            iter = fetched.iterator();
        } else {
            int low;
            int n = low = first == null ? 0 : SortedReducer.binarySearchRow(fetched, first, this.firstRowCmp, false);
            if (low == fetched.size()) {
                iter = Collections.emptyIterator();
            } else {
                int high = last == null ? fetched.size() : SortedReducer.binarySearchRow(fetched, last, this.lastRowCmp, false);
                iter = fetched.subList(low, high).iterator();
            }
        }
        return new GridH2Cursor(iter);
    }

    @Override
    protected void checkBounds(Row lastEvictedRow, SearchRow first, SearchRow last) {
        if (lastEvictedRow != null && first != null && this.compareRows((SearchRow)lastEvictedRow, first) < 0) {
            return;
        }
        super.checkBounds(lastEvictedRow, first, last);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void addPage0(ReduceResultPage page) {
        if (page.isFail()) {
            this.lock.lock();
            try {
                if (this.failPage != null) return;
                this.failPage = page;
                this.notEmpty.signalAll();
                return;
            }
            finally {
                this.lock.unlock();
            }
        } else {
            UUID src = page.source();
            this.streamsMap.get(src)[page.segmentId()].addPage(page);
        }
    }

    protected static int binarySearchRow(List<Row> rows, SearchRow searchRow, Comparator<SearchRow> cmp, boolean checkLast) {
        int res;
        assert (!rows.isEmpty());
        if (checkLast) {
            res = cmp.compare((SearchRow)SortedReducer.last(rows), searchRow);
            assert (res != 0);
            if (res < 0) {
                return rows.size();
            }
        }
        res = Collections.binarySearch(rows, searchRow, cmp);
        assert (res < 0) : res;
        return -res - 1;
    }

    private class FetchingCursor
    implements Cursor {
        private Iterator<Row> stream;
        private List<Row> rows;
        private int cur;
        private SearchRow first;
        private SearchRow last;
        private int lastFound = Integer.MAX_VALUE;

        FetchingCursor(SearchRow first, SearchRow last, Iterator<Row> stream) {
            assert (stream != null);
            this.rows = SortedReducer.this.fetched;
            this.stream = stream;
            this.first = first;
            this.last = last;
            if (this.haveBounds() && !this.rows.isEmpty()) {
                this.cur = this.findBounds();
            }
            --this.cur;
        }

        private boolean haveBounds() {
            return this.first != null || this.last != null;
        }

        private int findBounds() {
            assert (!this.rows.isEmpty()) : "rows";
            int firstFound = this.cur;
            if (this.first != null) {
                firstFound = SortedReducer.binarySearchRow(this.rows, this.first, SortedReducer.this.firstRowCmp, true);
                assert (firstFound >= this.cur && firstFound <= this.rows.size()) : "firstFound";
                if (firstFound == this.rows.size()) {
                    return firstFound;
                }
                this.first = null;
            }
            if (this.last != null) {
                assert (this.lastFound == Integer.MAX_VALUE) : "lastFound";
                int lastFound0 = SortedReducer.binarySearchRow(this.rows, this.last, SortedReducer.this.lastRowCmp, true);
                if (lastFound0 != this.rows.size()) {
                    this.lastFound = lastFound0;
                }
            }
            return firstFound;
        }

        private void fetchRows() {
            do {
                this.rows = SortedReducer.this.fetched.lastBlock();
                this.cur = this.rows.size();
                while (this.stream.hasNext()) {
                    SortedReducer.this.fetched.add(Objects.requireNonNull(this.stream.next()));
                    if (SortedReducer.this.fetched.size() == AbstractReducer.MAX_FETCH_SIZE) {
                        SortedReducer.this.onBlockEvict(SortedReducer.this.fetched.evictFirstBlock());
                        assert (SortedReducer.this.fetched.size() < AbstractReducer.MAX_FETCH_SIZE);
                    }
                    if (!this.haveBounds()) break;
                    if (SortedReducer.this.fetched.lastBlock() == this.rows) continue;
                    assert (SortedReducer.this.fetched.lastBlock().isEmpty());
                    break;
                }
                if (this.cur == this.rows.size()) {
                    this.cur = Integer.MAX_VALUE;
                    break;
                }
                if (!this.haveBounds()) break;
                this.cur = this.findBounds();
            } while (this.cur == this.rows.size());
        }

        public boolean next() {
            if (this.cur == Integer.MAX_VALUE) {
                return false;
            }
            if (++this.cur == this.rows.size()) {
                this.fetchRows();
            }
            return this.cur < this.lastFound;
        }

        public Row get() {
            return this.rows.get(this.cur);
        }

        public SearchRow getSearchRow() {
            return this.get();
        }

        public boolean previous() {
            throw DbException.getUnsupportedException((String)"previous");
        }
    }

    private final class RowStream
    implements AbstractReducer.Pollable<ReduceResultPage> {
        private Iterator<Value[]> iter = Collections.emptyIterator();
        private Row cur;
        private ReduceResultPage nextPage;

        private RowStream() {
        }

        private void addPage(ReduceResultPage page) {
            assert (!page.isFail());
            if (page.isLast() && page.rowsInPage() == 0) {
                page = SortedReducer.this.createDummyLastPage(page);
            }
            SortedReducer.this.lock.lock();
            try {
                assert (this.nextPage == null);
                this.nextPage = page;
                SortedReducer.this.notEmpty.signalAll();
            }
            finally {
                SortedReducer.this.lock.unlock();
            }
        }

        @Override
        public ReduceResultPage poll(long timeout, TimeUnit unit) throws InterruptedException {
            long nanos = unit.toNanos(timeout);
            SortedReducer.this.lock.lock();
            try {
                while (true) {
                    if (SortedReducer.this.failPage != null) {
                        ReduceResultPage reduceResultPage = SortedReducer.this.failPage;
                        return reduceResultPage;
                    }
                    ReduceResultPage page = this.nextPage;
                    if (page != null) {
                        this.nextPage = page.isLast() && page.response() != null ? SortedReducer.this.createDummyLastPage(page) : null;
                        ReduceResultPage reduceResultPage = page;
                        return reduceResultPage;
                    }
                    nanos = SortedReducer.this.notEmpty.awaitNanos(nanos);
                    if (nanos > 0L) continue;
                    ReduceResultPage reduceResultPage = null;
                    return reduceResultPage;
                }
            }
            finally {
                SortedReducer.this.lock.unlock();
            }
        }

        private boolean next() {
            this.cur = null;
            this.iter = SortedReducer.this.pollNextIterator(this, this.iter);
            if (!this.iter.hasNext()) {
                return false;
            }
            this.cur = H2PlainRowFactory.create(this.iter.next());
            return true;
        }

        private Row get() {
            assert (this.cur != null);
            return this.cur;
        }
    }

    private final class MergeStreamIterator
    implements Iterator<Row> {
        private boolean first = true;
        private int off;
        private boolean hasNext;
        private final RowStream[] streams;

        MergeStreamIterator(RowStream[] streams) {
            assert (!F.isEmpty((Object[])streams));
            this.streams = streams;
        }

        private boolean fetchedAll() {
            return this.off == this.streams.length;
        }

        private void goFirst() {
            assert (this.first);
            this.first = false;
            for (int i = 0; i < this.streams.length; ++i) {
                RowStream s = this.streams[i];
                if (s.next()) continue;
                this.streams[i] = null;
                ++this.off;
            }
            if (this.off < this.streams.length) {
                Arrays.sort(this.streams, SortedReducer.this.streamCmp);
            }
        }

        private void goNext() {
            if (this.off == this.streams.length) {
                return;
            }
            if (this.streams[this.off].next()) {
                H2Utils.bubbleUp(this.streams, this.off, SortedReducer.this.streamCmp);
            } else {
                this.streams[this.off++] = null;
            }
        }

        @Override
        public boolean hasNext() {
            if (this.hasNext) {
                return true;
            }
            if (this.first) {
                this.goFirst();
            } else {
                this.goNext();
            }
            this.hasNext = this.off < this.streams.length;
            return this.hasNext;
        }

        @Override
        public Row next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.hasNext = false;
            return this.streams[this.off].get();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

