/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.h2.twostep.msg;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteException;
import org.apache.ignite.configuration.IgniteConfiguration;
import org.apache.ignite.internal.GridDirectCollection;
import org.apache.ignite.internal.GridDirectMap;
import org.apache.ignite.internal.GridDirectTransient;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.IgniteCodeGeneratingFail;
import org.apache.ignite.internal.binary.BinaryMarshaller;
import org.apache.ignite.internal.processors.affinity.AffinityTopologyVersion;
import org.apache.ignite.internal.processors.cache.mvcc.MvccSnapshot;
import org.apache.ignite.internal.processors.cache.query.GridCacheQueryMarshallable;
import org.apache.ignite.internal.processors.cache.query.GridCacheSqlQuery;
import org.apache.ignite.internal.processors.cache.query.QueryTable;
import org.apache.ignite.internal.processors.query.h2.twostep.msg.GridH2SelectForUpdateTxDetails;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.apache.ignite.marshaller.Marshaller;
import org.apache.ignite.plugin.extensions.communication.Message;
import org.apache.ignite.plugin.extensions.communication.MessageCollectionItemType;
import org.apache.ignite.plugin.extensions.communication.MessageReader;
import org.apache.ignite.plugin.extensions.communication.MessageWriter;
import org.jetbrains.annotations.Nullable;

@IgniteCodeGeneratingFail
public class GridH2QueryRequest
implements Message,
GridCacheQueryMarshallable {
    private static final long serialVersionUID = 0L;
    public static final int FLAG_DISTRIBUTED_JOINS = 1;
    public static final int FLAG_ENFORCE_JOIN_ORDER = 2;
    public static final int FLAG_UNUSED = 4;
    public static final int FLAG_EXPLAIN = 8;
    public static final int FLAG_REPLICATED = 16;
    public static final int FLAG_LAZY = 32;
    private static final int FLAG_DATA_PAGE_SCAN_SHIFT = 6;
    private static final int FLAG_DATA_PAGE_SCAN_MASK = 192;
    private static final int FLAG_DATA_PAGE_SCAN_DFLT = 0;
    private static final int FLAG_DATA_PAGE_SCAN_ENABLED = 64;
    private static final int FLAG_DATA_PAGE_SCAN_DISABLED = 128;
    private long reqId;
    @GridToStringInclude
    @GridDirectCollection(value=Integer.class)
    private List<Integer> caches;
    private AffinityTopologyVersion topVer;
    @GridToStringInclude
    @GridDirectMap(keyType=UUID.class, valueType=int[].class)
    private Map<UUID, int[]> parts;
    @GridToStringInclude
    private int[] qryParts;
    private int pageSize;
    @GridToStringInclude
    @GridDirectCollection(value=Message.class)
    private List<GridCacheSqlQuery> qrys;
    private byte flags;
    @GridToStringInclude
    @GridDirectCollection(value=Message.class)
    private Collection<QueryTable> tbls;
    private int timeout;
    @GridToStringInclude(sensitive=true)
    @GridDirectTransient
    private Object[] params;
    private byte[] paramsBytes;
    private String schemaName;
    private MvccSnapshot mvccSnapshot;
    private GridH2SelectForUpdateTxDetails txReq;
    private long maxMem;
    @GridDirectTransient
    private Long runningQryId;
    private boolean explicitTimeout;

    public GridH2QueryRequest() {
    }

    public GridH2QueryRequest(GridH2QueryRequest req) {
        this.reqId = req.reqId;
        this.caches = req.caches;
        this.topVer = req.topVer;
        this.parts = req.parts;
        this.qryParts = req.qryParts;
        this.pageSize = req.pageSize;
        this.qrys = req.qrys;
        this.flags = req.flags;
        this.tbls = req.tbls;
        this.timeout = req.timeout;
        this.params = req.params;
        this.paramsBytes = req.paramsBytes;
        this.schemaName = req.schemaName;
        this.mvccSnapshot = req.mvccSnapshot;
        this.txReq = req.txReq;
        this.maxMem = req.maxMem;
        this.runningQryId = req.runningQryId;
        this.explicitTimeout = req.explicitTimeout;
    }

    @Nullable
    public MvccSnapshot mvccSnapshot() {
        return this.mvccSnapshot;
    }

    public GridH2QueryRequest mvccSnapshot(MvccSnapshot mvccSnapshot) {
        this.mvccSnapshot = mvccSnapshot;
        return this;
    }

    public Object[] parameters() {
        return this.params;
    }

    public GridH2QueryRequest parameters(Object[] params) {
        if (params == null) {
            params = GridCacheSqlQuery.EMPTY_PARAMS;
        }
        this.params = params;
        return this;
    }

    public GridH2QueryRequest tables(Collection<QueryTable> tbls) {
        this.tbls = tbls;
        return this;
    }

    public Collection<QueryTable> tables() {
        return this.tbls;
    }

    public GridH2QueryRequest requestId(long reqId) {
        this.reqId = reqId;
        return this;
    }

    public long requestId() {
        return this.reqId;
    }

    public GridH2QueryRequest caches(List<Integer> caches) {
        this.caches = caches;
        return this;
    }

    public List<Integer> caches() {
        return this.caches;
    }

    public GridH2QueryRequest topologyVersion(AffinityTopologyVersion topVer) {
        this.topVer = topVer;
        return this;
    }

    public AffinityTopologyVersion topologyVersion() {
        return this.topVer;
    }

    public Map<UUID, int[]> partitions() {
        return this.parts;
    }

    public GridH2QueryRequest partitions(Map<UUID, int[]> parts) {
        this.parts = parts;
        return this;
    }

    public int[] queryPartitions() {
        return this.qryParts;
    }

    public GridH2QueryRequest queryPartitions(int[] qryParts) {
        this.qryParts = qryParts;
        return this;
    }

    public GridH2QueryRequest pageSize(int pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    public int pageSize() {
        return this.pageSize;
    }

    public GridH2QueryRequest queries(List<GridCacheSqlQuery> qrys) {
        this.qrys = qrys;
        return this;
    }

    public List<GridCacheSqlQuery> queries() {
        return this.qrys;
    }

    public GridH2QueryRequest flags(int flags) {
        assert (flags >= 0 && flags <= 255) : flags;
        this.flags = (byte)flags;
        return this;
    }

    public boolean isFlagSet(int flags) {
        return (this.flags & flags) == flags;
    }

    public int timeout() {
        return this.timeout;
    }

    public GridH2QueryRequest timeout(int timeout) {
        this.timeout = timeout;
        return this;
    }

    public boolean explicitTimeout() {
        return this.explicitTimeout;
    }

    public GridH2QueryRequest explicitTimeout(boolean explicitTimeout) {
        this.explicitTimeout = explicitTimeout;
        return this;
    }

    public String schemaName() {
        return this.schemaName;
    }

    public GridH2QueryRequest schemaName(String schemaName) {
        this.schemaName = schemaName;
        return this;
    }

    public GridH2SelectForUpdateTxDetails txDetails() {
        return this.txReq;
    }

    public void txDetails(GridH2SelectForUpdateTxDetails txReq) {
        this.txReq = txReq;
    }

    public static int setDataPageScanEnabled(int flags, Boolean dataPageScanEnabled) {
        int x = dataPageScanEnabled == null ? 0 : (dataPageScanEnabled != false ? 64 : 128);
        flags &= 0xFFFFFF3F;
        return flags |= x;
    }

    public static int queryFlags(boolean distributedJoins, boolean enforceJoinOrder, boolean lazy, boolean replicatedOnly, boolean explain, Boolean dataPageScanEnabled) {
        int flags;
        int n = flags = enforceJoinOrder ? 2 : 0;
        if (distributedJoins) {
            flags |= 1;
        }
        if (explain) {
            flags |= 8;
        }
        if (replicatedOnly) {
            flags |= 0x10;
        }
        if (lazy) {
            flags |= 0x20;
        }
        flags = GridH2QueryRequest.setDataPageScanEnabled(flags, dataPageScanEnabled);
        return flags;
    }

    public long maxMemory() {
        return this.maxMem;
    }

    public GridH2QueryRequest maxMemory(long maxMem) {
        this.maxMem = maxMem;
        return this;
    }

    public Long runningQryId() {
        return this.runningQryId;
    }

    public GridH2QueryRequest runningQryId(Long runningQryId) {
        this.runningQryId = runningQryId;
        return this;
    }

    public Boolean isDataPageScanEnabled() {
        return GridH2QueryRequest.isDataPageScanEnabled(this.flags);
    }

    public static Boolean isDataPageScanEnabled(int flags) {
        switch (flags & 0xC0) {
            case 64: {
                return true;
            }
            case 128: {
                return false;
            }
        }
        return null;
    }

    public void marshall(Marshaller m) {
        if (this.paramsBytes != null) {
            return;
        }
        assert (this.params != null);
        try {
            this.paramsBytes = U.marshal((Marshaller)m, (Object)this.params);
        }
        catch (IgniteCheckedException e) {
            throw new IgniteException((Throwable)e);
        }
    }

    public void unmarshall(Marshaller m, GridKernalContext ctx) {
        assert (this.paramsBytes != null);
        try {
            ClassLoader ldr = U.resolveClassLoader((IgniteConfiguration)ctx.config());
            this.params = m instanceof BinaryMarshaller ? (Object[])((BinaryMarshaller)m).binaryMarshaller().unmarshal(this.paramsBytes, ldr) : (Object[])U.unmarshal((Marshaller)m, (byte[])this.paramsBytes, (ClassLoader)ldr);
        }
        catch (IgniteCheckedException e) {
            throw new IgniteException((Throwable)e);
        }
    }

    public boolean writeTo(ByteBuffer buf, MessageWriter writer) {
        writer.setBuffer(buf);
        if (!writer.isHeaderWritten()) {
            if (!writer.writeHeader(this.directType(), this.fieldsCount())) {
                return false;
            }
            writer.onHeaderWritten();
        }
        switch (writer.state()) {
            case 0: {
                if (!writer.writeCollection("caches", this.caches, MessageCollectionItemType.INT)) {
                    return false;
                }
                writer.incrementState();
            }
            case 1: {
                if (!writer.writeByte("flags", this.flags)) {
                    return false;
                }
                writer.incrementState();
            }
            case 2: {
                if (!writer.writeInt("pageSize", this.pageSize)) {
                    return false;
                }
                writer.incrementState();
            }
            case 3: {
                if (!writer.writeByteArray("paramsBytes", this.paramsBytes)) {
                    return false;
                }
                writer.incrementState();
            }
            case 4: {
                if (!writer.writeMap("parts", this.parts, MessageCollectionItemType.UUID, MessageCollectionItemType.INT_ARR)) {
                    return false;
                }
                writer.incrementState();
            }
            case 5: {
                if (!writer.writeCollection("qrys", this.qrys, MessageCollectionItemType.MSG)) {
                    return false;
                }
                writer.incrementState();
            }
            case 6: {
                if (!writer.writeLong("reqId", this.reqId)) {
                    return false;
                }
                writer.incrementState();
            }
            case 7: {
                if (!writer.writeCollection("tbls", this.tbls, MessageCollectionItemType.MSG)) {
                    return false;
                }
                writer.incrementState();
            }
            case 8: {
                if (!writer.writeInt("timeout", this.timeout)) {
                    return false;
                }
                writer.incrementState();
            }
            case 9: {
                if (!writer.writeAffinityTopologyVersion("topVer", this.topVer)) {
                    return false;
                }
                writer.incrementState();
            }
            case 10: {
                if (!writer.writeIntArray("qryParts", this.qryParts)) {
                    return false;
                }
                writer.incrementState();
            }
            case 11: {
                if (!writer.writeString("schemaName", this.schemaName)) {
                    return false;
                }
                writer.incrementState();
            }
            case 12: {
                if (!writer.writeMessage("mvccSnapshot", (Message)this.mvccSnapshot)) {
                    return false;
                }
                writer.incrementState();
            }
            case 13: {
                if (!writer.writeMessage("txReq", (Message)this.txReq)) {
                    return false;
                }
                writer.incrementState();
            }
            case 14: {
                if (!writer.writeLong("maxMem", this.maxMem)) {
                    return false;
                }
                writer.incrementState();
            }
            case 15: {
                if (!writer.writeBoolean("explicitTimeout", this.explicitTimeout)) {
                    return false;
                }
                writer.incrementState();
            }
        }
        return true;
    }

    public boolean readFrom(ByteBuffer buf, MessageReader reader) {
        reader.setBuffer(buf);
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                this.caches = (List)reader.readCollection("caches", MessageCollectionItemType.INT);
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 1: {
                this.flags = reader.readByte("flags");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 2: {
                this.pageSize = reader.readInt("pageSize");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 3: {
                this.paramsBytes = reader.readByteArray("paramsBytes");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 4: {
                this.parts = reader.readMap("parts", MessageCollectionItemType.UUID, MessageCollectionItemType.INT_ARR, false);
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 5: {
                this.qrys = (List)reader.readCollection("qrys", MessageCollectionItemType.MSG);
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 6: {
                this.reqId = reader.readLong("reqId");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 7: {
                this.tbls = reader.readCollection("tbls", MessageCollectionItemType.MSG);
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 8: {
                this.timeout = reader.readInt("timeout");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 9: {
                this.topVer = reader.readAffinityTopologyVersion("topVer");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 10: {
                this.qryParts = reader.readIntArray("qryParts");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 11: {
                this.schemaName = reader.readString("schemaName");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 12: {
                this.mvccSnapshot = (MvccSnapshot)reader.readMessage("mvccSnapshot");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 13: {
                this.txReq = (GridH2SelectForUpdateTxDetails)reader.readMessage("txReq");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 14: {
                this.maxMem = reader.readLong("maxMem");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
            case 15: {
                this.explicitTimeout = reader.readBoolean("explicitTimeout");
                if (!reader.isLastRead()) {
                    return false;
                }
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(GridH2QueryRequest.class);
    }

    public short directType() {
        return -33;
    }

    public byte fieldsCount() {
        return 16;
    }

    public void onAckReceived() {
    }

    public String toString() {
        return S.toString(GridH2QueryRequest.class, (Object)this);
    }
}

