/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.metric.sql;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Predicate;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.processors.metric.MetricRegistry;
import org.apache.ignite.internal.processors.query.h2.sys.view.SqlAbstractLocalSystemView;
import org.apache.ignite.spi.metric.Metric;
import org.apache.ignite.spi.metric.ReadOnlyMetricRegistry;
import org.gridgain.internal.h2.engine.Session;
import org.gridgain.internal.h2.result.Row;
import org.gridgain.internal.h2.result.SearchRow;
import org.jetbrains.annotations.Nullable;

public class MetricSetLocalSystemView
extends SqlAbstractLocalSystemView {
    private ReadOnlyMetricRegistry mreg;
    @Nullable
    private Predicate<MetricRegistry> filter;

    public MetricSetLocalSystemView(GridKernalContext ctx, ReadOnlyMetricRegistry mreg, @Nullable Predicate<MetricRegistry> filter) {
        super("METRICS", "Ignite metrics", ctx, MetricSetLocalSystemView.newColumn("NAME", 13), MetricSetLocalSystemView.newColumn("VALUE", 13), MetricSetLocalSystemView.newColumn("DESCRIPTION", 13));
        this.mreg = mreg;
        this.filter = filter;
    }

    @Override
    public Iterator<Row> getRows(final Session ses, SearchRow first, SearchRow last) {
        return new Iterator<Row>(){
            private Iterator<MetricRegistry> grps;
            private Iterator<Metric> curr;
            {
                this.grps = MetricSetLocalSystemView.this.mreg.iterator();
                this.curr = Collections.emptyIterator();
            }

            private boolean advance() {
                while (this.grps.hasNext()) {
                    MetricRegistry mreg = this.grps.next();
                    if (!MetricSetLocalSystemView.this.filter.test(mreg)) continue;
                    this.curr = mreg.iterator();
                    if (!this.curr.hasNext()) continue;
                    return true;
                }
                return false;
            }

            @Override
            public boolean hasNext() {
                if (this.curr.hasNext()) {
                    return true;
                }
                return this.advance();
            }

            @Override
            public Row next() {
                Metric m = this.curr.next();
                return MetricSetLocalSystemView.this.createRow(ses, new Object[]{m.name(), m.getAsString(), m.description()});
            }
        };
    }
}

