/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.spi.metric.sql;

import java.util.function.Predicate;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.internal.GridKernalContext;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.metric.MetricRegistry;
import org.apache.ignite.internal.processors.query.h2.IgniteH2Indexing;
import org.apache.ignite.internal.processors.query.h2.SchemaManager;
import org.apache.ignite.spi.IgniteSpiAdapter;
import org.apache.ignite.spi.IgniteSpiContext;
import org.apache.ignite.spi.IgniteSpiException;
import org.apache.ignite.spi.metric.MetricExporterSpi;
import org.apache.ignite.spi.metric.ReadOnlyMetricRegistry;
import org.apache.ignite.spi.metric.sql.MetricSetLocalSystemView;
import org.jetbrains.annotations.Nullable;

public class SqlViewExporterSpi
extends IgniteSpiAdapter
implements MetricExporterSpi {
    public static final String SYS_VIEW_NAME = "METRICS";
    @Nullable
    private Predicate<MetricRegistry> filter;
    private ReadOnlyMetricRegistry mreg;

    protected void onContextInitialized0(IgniteSpiContext spiCtx) throws IgniteSpiException {
        GridKernalContext ctx = ((IgniteEx)this.ignite()).context();
        SchemaManager mgr = ((IgniteH2Indexing)ctx.query().getIndexing()).schemaManager();
        try {
            mgr.createSystemView("MONITORING", new MetricSetLocalSystemView(ctx, this.mreg, this.filter));
        }
        catch (IgniteCheckedException e) {
            throw new IgniteSpiException((Throwable)e);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("METRICS SQL view for metrics created.");
        }
    }

    public void spiStart(@Nullable String igniteInstanceName) throws IgniteSpiException {
    }

    public void spiStop() throws IgniteSpiException {
    }

    public void setMetricRegistry(ReadOnlyMetricRegistry mreg) {
        this.mreg = mreg;
    }

    public void setExportFilter(Predicate<MetricRegistry> filter) {
        this.filter = filter;
    }
}

