/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.internal.com.jcraft.jsch.jce;

import javax.crypto.Mac;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.SecretKeySpec;
import org.gridkit.internal.com.jcraft.jsch.MAC;

public class HMACSHA1
implements MAC {
    private static final String name = "hmac-sha1";
    private static final int bsize = 20;
    private Mac mac;
    private final byte[] tmp = new byte[4];

    @Override
    public int getBlockSize() {
        return 20;
    }

    @Override
    public void init(byte[] key) throws Exception {
        if (key.length > 20) {
            byte[] tmp = new byte[20];
            System.arraycopy(key, 0, tmp, 0, 20);
            key = tmp;
        }
        SecretKeySpec skey = new SecretKeySpec(key, "HmacSHA1");
        this.mac = Mac.getInstance("HmacSHA1");
        this.mac.init(skey);
    }

    @Override
    public void update(int i) {
        this.tmp[0] = (byte)(i >>> 24);
        this.tmp[1] = (byte)(i >>> 16);
        this.tmp[2] = (byte)(i >>> 8);
        this.tmp[3] = (byte)i;
        this.update(this.tmp, 0, 4);
    }

    @Override
    public void update(byte[] foo, int s, int l) {
        this.mac.update(foo, s, l);
    }

    @Override
    public void doFinal(byte[] buf, int offset) {
        try {
            this.mac.doFinal(buf, offset);
        }
        catch (ShortBufferException shortBufferException) {
            // empty catch block
        }
    }

    @Override
    public String getName() {
        return name;
    }
}

