/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.lab.util.shell;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.List;

class Tailer {
    private RandomAccessFile data;
    private long position;
    private List<String> buffer = new ArrayList<String>();
    private StringBuilder remaineder = new StringBuilder();

    public Tailer(File file) throws FileNotFoundException {
        this.data = new RandomAccessFile(file, "r");
    }

    public synchronized String nextLine() throws IOException {
        if (this.buffer.isEmpty()) {
            this.feed();
        }
        if (this.buffer.isEmpty()) {
            return null;
        }
        return this.buffer.remove(0);
    }

    public void close() {
        this.buffer.clear();
        try {
            this.data.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public synchronized String getRemainder() throws IOException {
        return this.remaineder.toString();
    }

    private synchronized void feed() throws IOException {
        long size = this.data.length();
        if (this.position < size) {
            byte[] block = new byte[65536];
            this.data.seek(this.position);
            int n = this.data.read(block);
            this.position += (long)n;
            for (int i = 0; i != n; ++i) {
                if (10 == block[i]) {
                    this.trimRf(this.remaineder);
                    this.buffer.add(this.remaineder.toString());
                    this.remaineder.setLength(0);
                    continue;
                }
                this.remaineder.append((char)block[i]);
            }
        }
    }

    private void trimRf(StringBuilder buf) {
        if (buf.length() > 0 && buf.charAt(buf.length() - 1) == '\r') {
            buf.setLength(buf.length() - 1);
        }
    }
}

