/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.nanocloud.telecontrol.ssh;

import java.util.List;
import java.util.Map;
import org.gridkit.internal.com.jcraft.jsch.JSchException;
import org.gridkit.internal.com.jcraft.jsch.Session;
import org.gridkit.nanocloud.telecontrol.HostControlConsole;
import org.gridkit.nanocloud.telecontrol.SimpleTunnelInitiator;
import org.gridkit.vicluster.CloudContext;
import org.gridkit.vicluster.ViEngine;
import org.gridkit.vicluster.telecontrol.FileBlob;
import org.gridkit.vicluster.telecontrol.StreamCopyService;
import org.gridkit.vicluster.telecontrol.ssh.SimpleSshSessionProvider;
import org.gridkit.vicluster.telecontrol.ssh.SshHostControlConsole;
import org.gridkit.zerormi.zlog.ZLogFactory;

public class RemoteConsoleInitializer
implements ViEngine.InductiveRule {
    public boolean apply(ViEngine.QuorumGame game) {
        if (game.get("#spi:ssh:target-host") != null && game.get("#spi:ssh:target-account") != null) {
            game.setProp("#spi:control-console", (Object)this.initConsole(game));
            if (game.get("jvm:exec-command") == null) {
                game.setProp("jvm:exec-command", (Object)this.resolveBootCmd(game));
            }
            return true;
        }
        return false;
    }

    public HostControlConsole initConsole(ViEngine.QuorumGame game) {
        String host = this.getHost(game);
        String account = this.getAccount(game);
        String bootCmd = this.getBootCmd(game);
        String cachePath = this.getCachePath(game);
        CloudContext.ServiceKey key = CloudContext.Helper.key(HostControlConsole.class);
        key = key.with("host", host).with("account", account);
        if (bootCmd != null) {
            key = key.with("java", bootCmd);
        }
        if (cachePath != null) {
            key = key.with("cache-path", cachePath);
        }
        return (HostControlConsole)game.getCloudContext().lookup(key, (CloudContext.ServiceProvider)new TunnelInitializer((CloudContext.ServiceKey<HostControlConsole>)key, game));
    }

    protected String getHost(ViEngine.QuorumGame game) {
        String host = (String)game.get("#spi:ssh:target-host");
        if (host == null) {
            throw new RuntimeException("Remote hostname is not resolved");
        }
        return host;
    }

    protected String getAccount(ViEngine.QuorumGame game) {
        String account = (String)game.get("#spi:ssh:target-account");
        if (account == null) {
            throw new RuntimeException("Remote account is not resolved");
        }
        return account;
    }

    protected String getBootCmd(ViEngine.QuorumGame game) {
        String cmd = (String)game.get("#spi:remote-runtime:bootstrap-jvm-exec");
        return cmd;
    }

    protected String resolveBootCmd(ViEngine.QuorumGame game) {
        String cmd = (String)game.get("remote-runtime:bootstrap-jvm-exec");
        if (cmd == null) {
            cmd = (String)game.get("#spi:remote-runtime:bootstrap-jvm-exec");
        }
        if (cmd == null) {
            cmd = (String)game.get("jvm:exec-command");
        }
        if (cmd == null) {
            cmd = (String)game.get("remote-runtime:fallback-jvm-exec");
        }
        if (cmd == null) {
            throw new RuntimeException("No Java executable configured");
        }
        return cmd;
    }

    protected String getCachePath(ViEngine.QuorumGame game) {
        String path = (String)game.get("#spi:remote-runtime:jar-cache");
        return path;
    }

    protected String resolveCachePath(ViEngine.QuorumGame game) {
        String path = (String)game.get("#spi:remote-runtime:jar-cache");
        if (path == null && (path = (String)game.get("remote-runtime:jar-cache")) != null) {
            game.setProp("#spi:remote-runtime:jar-cache", (Object)path);
        }
        if (path == null) {
            throw new RuntimeException("Jar cache path is not configured");
        }
        return path;
    }

    protected String resolvePassword(ViEngine.QuorumGame game) {
        String password = (String)game.get("ssh:password");
        if (password == null) {
            password = (String)game.get("#spi:ssh:password");
        }
        return password;
    }

    protected String resolveKeyFile(ViEngine.QuorumGame game) {
        String keyFile = (String)game.get("ssh:private-key-file");
        if (keyFile == null) {
            keyFile = (String)game.get("#spi:ssh:private-key-file");
        }
        return keyFile;
    }

    private static <E extends Throwable> E doThrow(Throwable e) throws E {
        throw e;
    }

    private class HostConsoleWrapper
    implements HostControlConsole {
        TunnelInitializer initializer;

        public HostConsoleWrapper(TunnelInitializer initializer) {
            this.initializer = initializer;
        }

        public String cacheFile(FileBlob blob) {
            TunnelInitializer tunnelInitializer = this.initializer;
            synchronized (tunnelInitializer) {
                this.initializer.ensureConsole();
                try {
                    return this.initializer.console.cacheFile(blob);
                }
                catch (Exception e) {
                    this.initializer.console = null;
                    throw this.throwAny(e);
                }
            }
        }

        public List<String> cacheFiles(List<? extends FileBlob> blobs) {
            TunnelInitializer tunnelInitializer = this.initializer;
            synchronized (tunnelInitializer) {
                this.initializer.ensureConsole();
                try {
                    return this.initializer.console.cacheFiles(blobs);
                }
                catch (Exception e) {
                    this.initializer.console = null;
                    throw this.throwAny(e);
                }
            }
        }

        public HostControlConsole.Destroyable openSocket(HostControlConsole.SocketHandler handler) {
            TunnelInitializer tunnelInitializer = this.initializer;
            synchronized (tunnelInitializer) {
                this.initializer.ensureConsole();
                try {
                    return this.initializer.console.openSocket(handler);
                }
                catch (Exception e) {
                    this.initializer.console = null;
                    throw this.throwAny(e);
                }
            }
        }

        public HostControlConsole.Destroyable startProcess(String workDir, String[] command, Map<String, String> env, HostControlConsole.ProcessHandler handler) {
            TunnelInitializer tunnelInitializer = this.initializer;
            synchronized (tunnelInitializer) {
                this.initializer.ensureConsole();
                try {
                    return this.initializer.console.startProcess(workDir, command, env, handler);
                }
                catch (Exception e) {
                    this.initializer.console = null;
                    throw this.throwAny(e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void terminate() {
            TunnelInitializer tunnelInitializer = this.initializer;
            synchronized (tunnelInitializer) {
                if (this.initializer.console != null) {
                    this.initializer.console.terminate();
                    this.initializer.console = null;
                }
            }
        }

        private RuntimeException throwAny(Throwable e) {
            RemoteConsoleInitializer.doThrow(e);
            return null;
        }
    }

    private class TunnelInitializer
    implements CloudContext.ServiceProvider<HostControlConsole> {
        private CloudContext.ServiceKey<HostControlConsole> key;
        private ViEngine.QuorumGame game;
        private CloudContext cloudContext;
        private HostControlConsole console;
        private HostConsoleWrapper consoleWrapper;

        public TunnelInitializer(CloudContext.ServiceKey<HostControlConsole> key, ViEngine.QuorumGame game) {
            this.consoleWrapper = new HostConsoleWrapper(this);
            this.key = key;
            this.game = game;
        }

        public HostControlConsole getService(CloudContext context) {
            if (this.console == null) {
                this.cloudContext = context;
                this.ensureConsole();
            }
            return this.consoleWrapper;
        }

        void ensureConsole() {
            CloudContext.ServiceKey key3;
            Session session;
            if (this.console != null) {
                return;
            }
            CloudContext context = this.cloudContext;
            String host = RemoteConsoleInitializer.this.getHost(this.game);
            String account = RemoteConsoleInitializer.this.getAccount(this.game);
            String bootCmd = RemoteConsoleInitializer.this.resolveBootCmd(this.game);
            String cachePath = RemoteConsoleInitializer.this.resolveCachePath(this.game);
            SimpleSshSessionProvider factory = new SimpleSshSessionProvider();
            factory.setUser(account);
            for (String key : this.game.getConfigProps("#spi:ssh:jsch:").keySet()) {
                String opt = key.substring("#spi:ssh:jsch:".length());
                factory.setConfig(opt, (String)this.game.get(key));
            }
            String password = RemoteConsoleInitializer.this.resolvePassword(this.game);
            String keyFile = RemoteConsoleInitializer.this.resolveKeyFile(this.game);
            if (password != null) {
                factory.setPassword(password);
            }
            if (keyFile != null) {
                factory.setKeyFile(keyFile);
            }
            try {
                session = factory.getSession(host, account);
            }
            catch (JSchException e) {
                throw new RuntimeException(e);
            }
            SshHostControlConsole shhConsole = new SshHostControlConsole(session, cachePath, true, 1);
            SimpleTunnelInitiator initiator = new SimpleTunnelInitiator(bootCmd, cachePath, (StreamCopyService)context.lookup(CloudContext.Helper.key(StreamCopyService.class)), ZLogFactory.getDefaultRootLogger());
            this.console = initiator.initTunnel((HostControlConsole)shhConsole);
            CloudContext.ServiceKey key2 = CloudContext.Helper.key(HostControlConsole.class);
            key2 = key2.with("host", host).with("account", account);
            if (!this.key.equals((Object)key2)) {
                context.lookup(key2, (CloudContext.ServiceProvider)this);
            }
            if (!this.key.equals((Object)(key3 = key2.with("java", bootCmd)))) {
                context.lookup(key3, (CloudContext.ServiceProvider)this);
            }
            if (!this.key.equals((Object)(key3 = key2.with("cache-path", cachePath)))) {
                context.lookup(key3, (CloudContext.ServiceProvider)this);
            }
            if (!this.key.equals((Object)(key3 = key2.with("java", bootCmd).with("cache-path", cachePath)))) {
                context.lookup(key3, (CloudContext.ServiceProvider)this);
            }
        }
    }
}

