/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.vicluster.telecontrol.ssh;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import org.gridkit.zeroio.AbstractLineProcessingOutputStream;
import org.gridkit.zerormi.zlog.LogStream;

class LoggerPrintStream
extends PrintStream {
    public LoggerPrintStream(LogStream stream) {
        super((OutputStream)((Object)new StreamStub(stream, null)));
    }

    public LoggerPrintStream(LogStream stream, String prefix) {
        super((OutputStream)((Object)new StreamStub(stream, prefix)));
    }

    private static final class StreamStub
    extends AbstractLineProcessingOutputStream {
        private final LogStream logger;
        private final String prefix;

        private StreamStub(LogStream logger, String prefix) {
            logger.toString();
            this.logger = logger;
            this.prefix = prefix;
        }

        protected void processLine(byte[] data) throws IOException {
            if (this.logger.isEnabled()) {
                if (this.prefix == null) {
                    this.logLine(new String(data));
                } else {
                    this.logLine(this.prefix + new String(data));
                }
            }
        }

        private void logLine(String text) {
            if (text.length() > 0) {
                if (text.charAt(text.length() - 1) == '\n') {
                    text = text.substring(0, text.length() - 1);
                }
                if (text.charAt(text.length() - 1) == '\r') {
                    text = text.substring(0, text.length() - 1);
                }
                this.logger.log(text);
            }
        }
    }
}

