/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.vicluster.telecontrol.ssh;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.gridkit.internal.com.jcraft.jsch.ChannelSftp;
import org.gridkit.internal.com.jcraft.jsch.JSchException;
import org.gridkit.internal.com.jcraft.jsch.Session;
import org.gridkit.internal.com.jcraft.jsch.SftpException;
import org.gridkit.vicluster.telecontrol.FileBlob;
import org.gridkit.vicluster.telecontrol.ssh.RemoteFileCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SftFileCache
implements RemoteFileCache {
    private static final Logger LOGGER = LoggerFactory.getLogger(SftFileCache.class);
    private final Session session;
    private final String jarCachePath;
    private final boolean useRelativePaths;
    private String absoluteCachePath;
    private BlockingQueue<ChannelSftp> channels = new LinkedBlockingQueue<ChannelSftp>();
    private ExecutorService executor;
    private Map<String, String> fileMapping = new ConcurrentHashMap<String, String>();

    public SftFileCache(Session session, String cachePath, boolean useRelativePaths, int concurency) throws JSchException, InterruptedException, SftpException {
        this.session = session;
        this.jarCachePath = cachePath;
        this.useRelativePaths = useRelativePaths;
        if (concurency < 0) {
            throw new IllegalArgumentException("concurency should be positive");
        }
        for (int i = 0; i != concurency; ++i) {
            ChannelSftp sftp = (ChannelSftp)session.openChannel("sftp");
            this.channels.add(sftp);
        }
        if (concurency == 1) {
            this.executor = new SameThreadExecutor();
        } else {
            final String host = this.session.getUserName() + "@" + this.session.getHost();
            ThreadFactory tf = new ThreadFactory(){
                int counter;

                @Override
                public synchronized Thread newThread(Runnable r) {
                    Thread t = new Thread(r);
                    t.setDaemon(true);
                    t.setName("SftpWorker-" + host + "-" + this.counter++);
                    return t;
                }
            };
            this.executor = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 100L, TimeUnit.MILLISECONDS, new SynchronousQueue<Runnable>(), tf);
        }
        this.mkdirs();
        this.prime();
    }

    private void mkdirs() throws InterruptedException, SftpException, JSchException {
        ChannelSftp sftp = this.getSftp();
        sftp.connect();
        SftFileCache.sftpMkdirs(sftp, this.jarCachePath);
        sftp.cd(this.jarCachePath);
        this.absoluteCachePath = sftp.pwd();
        this.release(sftp);
    }

    private void prime() throws JSchException, SftpException {
        ArrayList all = new ArrayList();
        this.channels.drainTo(all);
        for (ChannelSftp sftp : all) {
            if (!sftp.isConnected()) {
                sftp.connect();
                sftp.cd(this.absoluteCachePath);
            }
            this.release(sftp);
        }
    }

    private ChannelSftp getSftp() throws InterruptedException {
        return this.channels.take();
    }

    private void release(ChannelSftp sftp) {
        this.channels.add(sftp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String upload(FileBlob blob) {
        if (this.fileMapping.containsKey(blob.getContentHash())) {
            return this.fileMapping.get(blob.getContentHash());
        }
        ChannelSftp sftp = this.getSftp();
        try {
            String string = this.upload(sftp, blob);
            this.release(sftp);
            return string;
        }
        catch (Throwable throwable) {
            try {
                this.release(sftp);
                throw throwable;
            }
            catch (InterruptedException e) {
                throw new RuntimeException("Interrupted");
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public List<String> upload(List<? extends FileBlob> blobs) {
        final String[] result = new String[blobs.size()];
        ArrayList futures = new ArrayList();
        try {
            for (int i = 0; i != blobs.size(); ++i) {
                final int n = i;
                final FileBlob blob = blobs.get(i);
                if (this.fileMapping.containsKey(blob.getContentHash())) {
                    result[i] = this.fileMapping.get(blob.getContentHash());
                    continue;
                }
                final ChannelSftp sftp = this.getSftp();
                futures.add(this.executor.submit(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        try {
                            result[n] = SftFileCache.this.upload(sftp, blob);
                        }
                        finally {
                            SftFileCache.this.release(sftp);
                        }
                    }
                }));
            }
            for (Future future : futures) {
                try {
                    future.get();
                }
                catch (ExecutionException e) {
                    throw new RuntimeException(e.getCause());
                    return Arrays.asList(result);
                }
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted");
        }
    }

    private String upload(ChannelSftp sftp, FileBlob blob) {
        String blobPath = blob.getContentHash() + "/" + blob.getFileName();
        String rname = this.absoluteCachePath + "/" + blobPath;
        try {
            SftFileCache.sftpMkdirs(sftp, this.absoluteCachePath + "/" + blob.getContentHash());
        }
        catch (SftpException e) {
            new RuntimeException("SFT error: " + e.getMessage());
        }
        for (int tries = 2; tries > 0; --tries) {
            try {
                if (!SftFileCache.exists(sftp, rname)) {
                    LOGGER.info("Uploading: " + this.session.getHost() + ":" + rname + " " + blob.size() + " bytes");
                    sftp.put(blob.getContent(), rname);
                    break;
                }
                LOGGER.debug("Already exists: " + this.session.getHost() + ":" + rname + " " + blob.size() + " bytes");
                break;
            }
            catch (SftpException e) {
                if (tries > 0) {
                    LOGGER.warn("upload \"" + rname + "\" failed: " + e.toString());
                    continue;
                }
                new RuntimeException("SFT error: " + e.getMessage());
                continue;
            }
        }
        if (this.useRelativePaths) {
            rname = this.jarCachePath.length() == 0 || this.jarCachePath.endsWith("/") ? this.jarCachePath + blobPath : this.jarCachePath + "/" + blobPath;
        }
        this.fileMapping.put(blob.getContentHash(), rname);
        return rname;
    }

    private static void sftpMkdirs(ChannelSftp sftp, String path) throws SftpException {
        if (path.lastIndexOf(47) > 0) {
            String parPath = path.substring(0, path.lastIndexOf(47));
            SftFileCache.sftpMkdirs(sftp, parPath);
        }
        for (int tries = 2; tries > 0; --tries) {
            try {
                if (!SftFileCache.exists(sftp, path)) {
                    sftp.mkdir(path);
                }
                return;
            }
            catch (SftpException e) {
                if (tries > 0) {
                    LOGGER.warn("mkdir has failed: " + e.toString());
                    continue;
                }
                throw e;
            }
        }
    }

    public void close() {
        this.executor.shutdown();
    }

    private static boolean exists(ChannelSftp sftp, String path) {
        try {
            return sftp.stat(path) != null;
        }
        catch (SftpException e) {
            return false;
        }
    }

    private static class SameThreadExecutor
    implements ExecutorService {
        private SameThreadExecutor() {
        }

        @Override
        public void execute(Runnable command) {
            command.run();
        }

        @Override
        public void shutdown() {
        }

        @Override
        public List<Runnable> shutdownNow() {
            return Collections.emptyList();
        }

        @Override
        public boolean isShutdown() {
            return false;
        }

        @Override
        public boolean isTerminated() {
            return false;
        }

        @Override
        public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
            return false;
        }

        @Override
        public <T> Future<T> submit(Callable<T> task) {
            FutureTask<T> f = new FutureTask<T>(task);
            f.run();
            return f;
        }

        @Override
        public <T> Future<T> submit(Runnable task, T result) {
            FutureTask<T> f = new FutureTask<T>(task, result);
            f.run();
            return f;
        }

        @Override
        public Future<?> submit(Runnable task) {
            FutureTask<Object> f = new FutureTask<Object>(task, null);
            f.run();
            return f;
        }

        @Override
        public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
            return null;
        }

        @Override
        public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
            throw new UnsupportedOperationException();
        }

        @Override
        public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
            throw new UnsupportedOperationException();
        }

        @Override
        public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            throw new UnsupportedOperationException();
        }
    }
}

