/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.vicluster.telecontrol.ssh;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.gridkit.internal.com.jcraft.jsch.JSchException;
import org.gridkit.internal.com.jcraft.jsch.Session;
import org.gridkit.internal.com.jcraft.jsch.SftpException;
import org.gridkit.nanocloud.telecontrol.HostControlConsole;
import org.gridkit.nanocloud.telecontrol.LocalControlConsole;
import org.gridkit.vicluster.telecontrol.ExecCommand;
import org.gridkit.vicluster.telecontrol.FileBlob;
import org.gridkit.vicluster.telecontrol.ssh.RemoteSshProcess;
import org.gridkit.vicluster.telecontrol.ssh.SftFileCache;

public class SshHostControlConsole
extends LocalControlConsole {
    private Session session;
    private SftFileCache fileCache;

    public SshHostControlConsole(Session session, String cachePath, boolean useRelativePaths, int sftpParallelFactor) {
        try {
            this.session = session;
            this.fileCache = new SftFileCache(session, cachePath, useRelativePaths, sftpParallelFactor);
            this.register(new CacheKiller(this.fileCache));
            this.register(new SessionKiller(session));
        }
        catch (JSchException e) {
            throw new RuntimeException(e);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (SftpException e) {
            throw new RuntimeException(e);
        }
    }

    public String cacheFile(FileBlob blob) {
        return this.fileCache.upload(blob);
    }

    public List<String> cacheFiles(List<? extends FileBlob> blobs) {
        return this.fileCache.upload(blobs);
    }

    public HostControlConsole.Destroyable openSocket(HostControlConsole.SocketHandler handler) {
        throw new UnsupportedOperationException();
    }

    protected Process startProcess(String workingDir, String[] command, Map<String, String> env) throws IOException {
        ExecCommand cmd = new ExecCommand(command[0]);
        for (int i = 1; i != command.length; ++i) {
            cmd.addArg(command[i]);
        }
        cmd.setWorkDir(workingDir);
        if (env != null) {
            for (String key : env.keySet()) {
                if (env.get(key) == null) continue;
                cmd.setEnvironment(key, env.get(key));
            }
        }
        try {
            return new RemoteSshProcess(this.session, cmd);
        }
        catch (JSchException e) {
            throw new IOException(e);
        }
    }

    private static class CacheKiller
    implements HostControlConsole.Destroyable {
        private final SftFileCache fileCache;

        public CacheKiller(SftFileCache fileCache) {
            this.fileCache = fileCache;
        }

        public void destroy() {
            this.fileCache.close();
        }
    }

    private static class SessionKiller
    implements HostControlConsole.Destroyable {
        private final Session session;

        public SessionKiller(Session session) {
            this.session = session;
        }

        public void destroy() {
            this.session.disconnect();
        }
    }
}

