/*
 * Decompiled with CFR 0.152.
 */
package org.grlea.log;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.Format;
import java.text.MessageFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import org.grlea.log.DebugLevel;
import org.grlea.log.SimpleLogger;

public final class SimpleLog {
    private static final String DEFAULT_PROPERTIES_FILE_NAME = "simplelog.properties";
    private static final String KEY_PREFIX = "simplelog.";
    private static final String KEY_FORMAT_PREFIX = "simplelog.format.";
    private static final String KEY_FORMAT_INSTANCE_SUFFIX = ".instance";
    private static final String KEY_FORMAT_DB = "simplelog.format.debug";
    private static final String KEY_FORMAT_DBO = "simplelog.format.debugObject";
    private static final String KEY_FORMAT_DBE = "simplelog.format.debugException";
    private static final String KEY_FORMAT_ENTRY = "simplelog.format.entry";
    private static final String KEY_FORMAT_EXIT = "simplelog.format.exit";
    private static final String KEY_RELOADING = "simplelog.reloading";
    private static final String RELOADING_DEFAULT = "false";
    private static final String KEY_LOG_FILE = "simplelog.logFile";
    private static final String KEY_INTERPRET_NAME = "simplelog.logFile.interpretName";
    private static final boolean INTREPRET_NAME_DEFAULT = true;
    private static final String KEY_APPEND = "simplelog.logFile.append";
    private static final boolean APPEND_DEFAULT = true;
    private static final String KEY_PIPE_TO_CONSOLE = "simplelog.logFile.andConsole";
    private static final boolean PIPE_TO_CONSOLE_DEFAULT = false;
    private static final String KEY_DEFAULT_LEVEL = "simplelog.defaultLevel";
    private static final String KEY_DEFAULT_TRACE = "simplelog.defaultTrace";
    private static final String KEY_DATE_FORMAT = "simplelog.dateFormat";
    private static final String DATE_FORMAT_DEFAULT = "EEE yyyy/MM/dd HH:mm:ss.SSS";
    private static final String KEY_PRINT_STACK_TRACES = "simplelog.printStackTraces";
    private static final String PRINT_STACK_TRACES_DEFAULT = "true";
    private static final int RELOAD_FILE_CHECK_PERIOD = 20000;
    private static final int RELOAD_URL_CHECK_PERIOD = 60000;
    private static final String TRACE_SUFFIX = "#trace";
    private static final String LINE_SEP = System.getProperty("line.separator");
    private static final String DEFAULT_FORMAT_STRING_DB = "{0}|   |{1}|{2}|{5}";
    private static final String DEFAULT_FORMAT_STRING_DBO = "{0}|---|{1}|{2}|{5}|{6}";
    private static final String DEFAULT_FORMAT_STRING_DBE = "{0}|***|{1}|{2}|{5}";
    private static final String DEFAULT_FORMAT_STRING_ENTRY = "{0}|>>>|{1}|{2}|{5}";
    private static final String DEFAULT_FORMAT_STRING_EXIT = "{0}|<<<|{1}|{2}|{5}";
    private static final String DEFAULT_FORMAT_STRING_DB_INSTANCE = "{0}|   |{1}|{2}[{3}]|{5}";
    private static final String DEFAULT_FORMAT_STRING_DBO_INSTANCE = "{0}|---|{1}|{2}[{3}]|{5}|{6}";
    private static final String DEFAULT_FORMAT_STRING_DBE_INSTANCE = "{0}|***|{1}|{2}[{3}]|{5}";
    private static final String DEFAULT_FORMAT_STRING_ENTRY_INSTANCE = "{0}|>>>|{1}|{2}[{3}]|{5}";
    private static final String DEFAULT_FORMAT_STRING_EXIT_INSTANCE = "{0}|<<<|{1}|{2}[{3}]|{5}";
    private static final int DEFAULT_FORMAT_EXCEPTION_INDEX = 5;
    private static final int DEFAULT_FORMAT_EXCEPTION_INDEX_INSTANCE = 5;
    private static SimpleLog defaultInstance = null;
    private static final Object defaultInstanceLock = new Object();
    private final URL configurationSource;
    private final Properties properties;
    private PrintWriter out;
    private boolean outputSetProgramatically = false;
    private String logFile;
    private boolean printWriterGoesToConsole = true;
    private boolean pipingOutputToConsole = false;
    private DebugLevel defaultLevel = DebugLevel.L4_INFO;
    private boolean defaultTracing = false;
    private final List loggers = new ArrayList(32);
    private final Object LOGGERS_LOCK = new Object();
    private DateFormat dateFormat;
    private MessageFormat dbFormat;
    private MessageFormat dboFormat;
    private MessageFormat dbeFormat;
    private MessageFormat entryFormat;
    private MessageFormat exitFormat;
    private MessageFormat dbFormat4Instance;
    private MessageFormat dboFormat4Instance;
    private MessageFormat dbeFormat4Instance;
    private MessageFormat entryFormat4Instance;
    private MessageFormat exitFormat4Instance;
    static /* synthetic */ Class class$org$grlea$log$SimpleLog;

    public SimpleLog(Properties properties) {
        if (properties == null) {
            throw new IllegalArgumentException("properties cannot be null.");
        }
        this.configurationSource = null;
        this.properties = properties;
        this.out = new PrintWriter(System.err, true);
        this.readSettingsFromProperties();
    }

    public SimpleLog(URL uRL) throws IOException {
        this.configurationSource = uRL;
        this.properties = new Properties();
        this.out = new PrintWriter(System.err, true);
        this.loadProperties();
        this.readSettingsFromProperties();
        String string = this.properties.getProperty(KEY_RELOADING, RELOADING_DEFAULT);
        boolean bl = Boolean.valueOf(string);
        if (bl) {
            int n;
            TimerTask timerTask;
            Timer timer = new Timer(true);
            if (uRL.getProtocol() != null && "file".equals(uRL.getProtocol().toLowerCase())) {
                timerTask = new FileConfigurationReloader();
                n = 20000;
            } else {
                timerTask = new UrlConfigurationReloader();
                n = 60000;
            }
            timer.schedule(timerTask, n, (long)n);
        }
    }

    private void loadProperties() throws IOException {
        if (this.properties == null) {
            return;
        }
        InputStream inputStream = this.configurationSource.openStream();
        Properties properties = new Properties();
        properties.load(inputStream);
        this.properties.clear();
        this.properties.putAll((Map<?, ?>)properties);
    }

    private void readSettingsFromProperties() {
        String string;
        Serializable serializable;
        Object object;
        boolean bl;
        String string2;
        String string3;
        if (!this.outputSetProgramatically) {
            boolean bl2;
            string3 = this.properties.getProperty(KEY_LOG_FILE);
            boolean bl3 = true;
            string2 = this.properties.getProperty(KEY_INTERPRET_NAME);
            if (string2 != null) {
                bl3 = !string2.trim().equalsIgnoreCase(RELOADING_DEFAULT);
            }
            boolean bl4 = string3 != null;
            boolean bl5 = bl2 = bl4 && string3.indexOf(123) != -1;
            if (bl4 && bl2 && bl3) {
                try {
                    MessageFormat messageFormat = new MessageFormat(string3);
                    string3 = messageFormat.format(new Object[]{new Date()});
                }
                catch (Exception exception) {
                    SimpleLog.printError("Error generating log file name", exception, true);
                    string3 = null;
                }
            }
            bl = this.logFile == null != (string3 == null);
            if (bl |= this.logFile != null && bl4 && !string3.equals(this.logFile)) {
                try {
                    if (string3 == null) {
                        this.out = new PrintWriter(System.err, true);
                        this.printWriterGoesToConsole = true;
                    } else {
                        object = new File(string3).getAbsoluteFile();
                        serializable = ((File)object).getParentFile();
                        if (serializable != null) {
                            ((File)serializable).mkdirs();
                        }
                        boolean bl6 = true;
                        String string4 = this.properties.getProperty(KEY_APPEND);
                        if (string4 != null) {
                            bl6 = !string4.trim().equalsIgnoreCase(RELOADING_DEFAULT);
                        }
                        FileWriter fileWriter = new FileWriter((File)object, bl6);
                        this.out = new PrintWriter((Writer)fileWriter, true);
                        this.printWriterGoesToConsole = false;
                    }
                    this.logFile = string3;
                }
                catch (IOException iOException) {
                    SimpleLog.printError("Error opening log file for writing", iOException, true);
                }
            }
        }
        string3 = this.properties.getProperty(KEY_PIPE_TO_CONSOLE);
        this.pipingOutputToConsole = false;
        if (string3 != null) {
            this.pipingOutputToConsole = string3.trim().equalsIgnoreCase(PRINT_STACK_TRACES_DEFAULT);
        }
        if ((string = this.properties.getProperty(KEY_DEFAULT_LEVEL)) != null) {
            string = string.trim();
            try {
                int n = Integer.parseInt(string);
                this.defaultLevel = DebugLevel.fromInt(n);
            }
            catch (NumberFormatException numberFormatException) {
                try {
                    this.defaultLevel = DebugLevel.fromName(string);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    SimpleLog.printError("Error parsing debug level for simplelog.defaultLevel", numberFormatException, true);
                    SimpleLog.printError("Error parsing debug level for simplelog.defaultLevel", illegalArgumentException, false);
                }
            }
        }
        if ((string2 = this.properties.getProperty(KEY_DEFAULT_TRACE)) != null) {
            this.defaultTracing = Boolean.valueOf(string2);
        }
        String string5 = this.properties.getProperty(KEY_DATE_FORMAT, DATE_FORMAT_DEFAULT);
        try {
            this.dateFormat = new SimpleDateFormat(string5);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            SimpleLog.printError("Error parsing date format", illegalArgumentException, false);
        }
        this.dbFormat = this.readFormat(KEY_FORMAT_DB, DEFAULT_FORMAT_STRING_DB);
        this.dboFormat = this.readFormat(KEY_FORMAT_DBO, DEFAULT_FORMAT_STRING_DBO);
        this.dbeFormat = this.readFormat(KEY_FORMAT_DBE, DEFAULT_FORMAT_STRING_DBE);
        this.entryFormat = this.readFormat(KEY_FORMAT_ENTRY, DEFAULT_FORMAT_STRING_ENTRY);
        this.exitFormat = this.readFormat(KEY_FORMAT_EXIT, DEFAULT_FORMAT_STRING_EXIT);
        this.dbFormat4Instance = this.readFormat("simplelog.format.debug.instance", DEFAULT_FORMAT_STRING_DB_INSTANCE);
        this.dboFormat4Instance = this.readFormat("simplelog.format.debugObject.instance", DEFAULT_FORMAT_STRING_DBO_INSTANCE);
        this.dbeFormat4Instance = this.readFormat("simplelog.format.debugException.instance", DEFAULT_FORMAT_STRING_DBE_INSTANCE);
        this.entryFormat4Instance = this.readFormat("simplelog.format.entry.instance", DEFAULT_FORMAT_STRING_ENTRY_INSTANCE);
        this.exitFormat4Instance = this.readFormat("simplelog.format.exit.instance", DEFAULT_FORMAT_STRING_EXIT_INSTANCE);
        this.updateDateFormats();
        String string6 = this.properties.getProperty(KEY_PRINT_STACK_TRACES, PRINT_STACK_TRACES_DEFAULT);
        bl = Boolean.valueOf(string6);
        if (bl) {
            object = new ExceptionFormat();
            this.dbeFormat.setFormatByArgumentIndex(5, (Format)object);
            this.dbeFormat4Instance.setFormatByArgumentIndex(5, (Format)object);
        }
        object = this.properties.propertyNames();
        serializable = new Properties();
        while (object.hasMoreElements()) {
            String string7 = (String)object.nextElement();
            if (string7.indexOf(36) == -1) continue;
            ((Properties)serializable).put(string7.replace('$', '.'), this.properties.getProperty(string7));
        }
        this.properties.putAll((Map<?, ?>)((Object)serializable));
    }

    public void reloadProperties() {
        try {
            if (this.configurationSource != null) {
                this.loadProperties();
            }
            this.readSettingsFromProperties();
            this.reconfigureAllLoggers();
        }
        catch (Exception exception) {
            SimpleLog.printError("Falied to reload properties", exception, true);
        }
    }

    private MessageFormat readFormat(String string, String string2) {
        MessageFormat messageFormat;
        String string3 = this.properties.getProperty(string, string2);
        try {
            messageFormat = new MessageFormat(string3);
        }
        catch (Exception exception) {
            SimpleLog.printError("Error reading format string from " + string, exception, false);
            messageFormat = new MessageFormat(string2);
        }
        return messageFormat;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SimpleLog defaultInstance() {
        Object object = defaultInstanceLock;
        synchronized (object) {
            if (defaultInstance == null) {
                URL uRL = (class$org$grlea$log$SimpleLog == null ? (class$org$grlea$log$SimpleLog = SimpleLog.class$("org.grlea.log.SimpleLog")) : class$org$grlea$log$SimpleLog).getClassLoader().getResource(DEFAULT_PROPERTIES_FILE_NAME);
                if (uRL != null) {
                    try {
                        defaultInstance = new SimpleLog(uRL);
                    }
                    catch (Exception exception) {
                        SimpleLog.printError("Error while attempting to load default properties", exception, true);
                    }
                }
                if (defaultInstance == null) {
                    defaultInstance = new SimpleLog(new Properties());
                    defaultInstance.setWriter(null);
                }
            }
        }
        return defaultInstance;
    }

    void println(String string) {
        if (this.out != null) {
            this.out.println(string);
            if (!this.printWriterGoesToConsole && this.pipingOutputToConsole) {
                System.err.println(string);
            }
        }
    }

    void configure(SimpleLogger simpleLogger) {
        simpleLogger.setDebugLevel(this.getDebugLevel(simpleLogger));
        simpleLogger.setTracing(this.getTracingFlag(simpleLogger));
    }

    private DebugLevel getDebugLevel(SimpleLogger simpleLogger) {
        if (this.properties == null) {
            return this.defaultLevel;
        }
        String string = simpleLogger.getConfigName();
        int n = string.length();
        DebugLevel debugLevel = null;
        do {
            String string2;
            if ((string2 = this.properties.getProperty(string = string.substring(0, n))) != null) {
                string2 = string2.trim();
                try {
                    int n2 = Integer.parseInt(string2);
                    debugLevel = DebugLevel.fromInt(n2);
                }
                catch (NumberFormatException numberFormatException) {
                    try {
                        debugLevel = DebugLevel.fromName(string2);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        SimpleLog.printError("Error parsing debug level for " + string, numberFormatException, true);
                        SimpleLog.printError("Error parsing debug level for " + string, illegalArgumentException, false);
                    }
                }
            }
            n = string.lastIndexOf(46);
        } while (debugLevel == null && n != -1);
        if (debugLevel == null) {
            debugLevel = this.defaultLevel;
        }
        return debugLevel;
    }

    private boolean getTracingFlag(SimpleLogger simpleLogger) {
        if (this.properties == null) {
            return this.defaultTracing;
        }
        String string = simpleLogger.getConfigName();
        int n = string.length();
        boolean bl = this.defaultTracing;
        do {
            String string2;
            if ((string2 = this.properties.getProperty((string = string.substring(0, n)) + TRACE_SUFFIX)) == null) continue;
            bl = Boolean.valueOf(string2);
            break;
        } while ((n = string.lastIndexOf(46)) != -1);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void register(SimpleLogger simpleLogger) {
        Object object = this.LOGGERS_LOCK;
        synchronized (object) {
            this.loggers.add(simpleLogger);
        }
        this.configure(simpleLogger);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reconfigureAllLoggers() {
        Object object = this.LOGGERS_LOCK;
        synchronized (object) {
            Iterator iterator = this.loggers.iterator();
            while (iterator.hasNext()) {
                this.configure((SimpleLogger)iterator.next());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void printError(String string, Throwable throwable, boolean bl) {
        String string2 = System.getProperty("simplelog.dev.printStackTraces");
        boolean bl2 = string2 != null && string2.trim().equalsIgnoreCase(PRINT_STACK_TRACES_DEFAULT);
        PrintStream printStream = System.err;
        synchronized (printStream) {
            System.err.println();
            System.err.print("   SimpleLog ERROR: ");
            System.err.print(string);
            System.err.print(": ");
            if (bl) {
                System.err.print(throwable);
            } else {
                System.err.print(throwable.getMessage());
            }
            System.err.println();
            if (bl2) {
                throwable.printStackTrace(System.err);
            }
            System.err.println();
        }
    }

    public DebugLevel getDefaultLevel() {
        return this.defaultLevel;
    }

    public void setDefaultLevel(DebugLevel debugLevel) {
        if (debugLevel == null) {
            throw new IllegalArgumentException("defaultLevel cannot be null.");
        }
        this.defaultLevel = debugLevel;
        this.reconfigureAllLoggers();
    }

    public boolean isDefaultTracing() {
        return this.defaultTracing;
    }

    public void setDefaultTracing(boolean bl) {
        this.defaultTracing = bl;
        this.reconfigureAllLoggers();
    }

    public DateFormat getDateFormat() {
        return this.dateFormat;
    }

    public void setDateFormat(DateFormat dateFormat) {
        this.dateFormat = dateFormat == null ? new SimpleDateFormat(DATE_FORMAT_DEFAULT) : dateFormat;
        this.updateDateFormats();
    }

    public PrintWriter getWriter() {
        return this.out;
    }

    public void setWriter(PrintWriter printWriter) {
        this.out = printWriter;
        this.outputSetProgramatically = true;
    }

    boolean isOutputting() {
        return this.out != null;
    }

    private void updateDateFormats() {
        this.dbFormat.setFormatByArgumentIndex(0, this.dateFormat);
        this.dboFormat.setFormatByArgumentIndex(0, this.dateFormat);
        this.dbeFormat.setFormatByArgumentIndex(0, this.dateFormat);
        this.entryFormat.setFormatByArgumentIndex(0, this.dateFormat);
        this.exitFormat.setFormatByArgumentIndex(0, this.dateFormat);
        this.dbFormat4Instance.setFormatByArgumentIndex(0, this.dateFormat);
        this.dboFormat4Instance.setFormatByArgumentIndex(0, this.dateFormat);
        this.dbeFormat4Instance.setFormatByArgumentIndex(0, this.dateFormat);
        this.entryFormat4Instance.setFormatByArgumentIndex(0, this.dateFormat);
        this.exitFormat4Instance.setFormatByArgumentIndex(0, this.dateFormat);
    }

    MessageFormat getDebugFormat() {
        return this.dbFormat;
    }

    MessageFormat getDebugInstanceFormat() {
        return this.dbFormat4Instance;
    }

    MessageFormat getDebugObjectFormat() {
        return this.dboFormat;
    }

    MessageFormat getDebugObjectInstanceFormat() {
        return this.dboFormat4Instance;
    }

    MessageFormat getDebugExceptionFormat() {
        return this.dbeFormat;
    }

    MessageFormat getDebugExceptionInstanceFormat() {
        return this.dbeFormat4Instance;
    }

    MessageFormat getEntryFormat() {
        return this.entryFormat;
    }

    MessageFormat getEntryInstanceFormat() {
        return this.entryFormat4Instance;
    }

    MessageFormat getExitFormat() {
        return this.exitFormat;
    }

    MessageFormat getExitInstanceFormat() {
        return this.exitFormat4Instance;
    }

    public boolean isPipingOutputToConsole() {
        return this.pipingOutputToConsole;
    }

    public void setPipingOutputToConsole(boolean bl) {
        this.pipingOutputToConsole = bl;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final class UrlConfigurationReloader
    extends TimerTask {
        private long previousLastModified;

        public UrlConfigurationReloader() {
            try {
                URLConnection uRLConnection = SimpleLog.this.configurationSource.openConnection();
                this.previousLastModified = uRLConnection.getLastModified();
            }
            catch (IOException iOException) {
                this.previousLastModified = 0L;
            }
        }

        public void run() {
            long l;
            Object object;
            try {
                object = SimpleLog.this.configurationSource.openConnection();
                l = ((URLConnection)object).getLastModified();
            }
            catch (IOException iOException) {
                l = 0L;
            }
            if (l == 0L) {
                object = new Properties();
                try {
                    InputStream inputStream = SimpleLog.this.configurationSource.openStream();
                    ((Properties)object).load(inputStream);
                    if (!((Properties)object).equals(SimpleLog.this.properties)) {
                        SimpleLog.this.reloadProperties();
                    }
                }
                catch (IOException iOException) {}
            } else if (this.previousLastModified != l) {
                SimpleLog.this.reloadProperties();
                this.previousLastModified = l;
            }
        }
    }

    private final class FileConfigurationReloader
    extends TimerTask {
        private final File configurationFile;
        private long previousLastModified;

        public FileConfigurationReloader() {
            try {
                URI uRI = new URI(SimpleLog.this.configurationSource.toExternalForm());
                this.configurationFile = new File(uRI);
                this.previousLastModified = this.configurationFile.lastModified();
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new IllegalArgumentException("Failed to create URI from URL");
            }
        }

        public void run() {
            long l = this.configurationFile.lastModified();
            if (this.previousLastModified != l) {
                SimpleLog.this.reloadProperties();
                this.previousLastModified = l;
            }
        }
    }

    private static final class ExceptionFormat
    extends Format {
        private ExceptionFormat() {
        }

        public StringBuffer format(Object object, StringBuffer stringBuffer, FieldPosition fieldPosition) {
            if (!(object instanceof Throwable)) {
                throw new IllegalArgumentException(this.getClass().getName() + " only formats Throwables.");
            }
            Throwable throwable = (Throwable)object;
            stringBuffer.append(throwable);
            StringWriter stringWriter = new StringWriter();
            throwable.printStackTrace(new PrintWriter(stringWriter));
            stringBuffer.append(LINE_SEP).append(stringWriter.toString());
            return stringBuffer;
        }

        public Object parseObject(String string, ParsePosition parsePosition) {
            throw new UnsupportedOperationException();
        }
    }
}

