/*
 * Decompiled with CFR 0.152.
 */
package org.grlea.log;

import java.text.MessageFormat;
import java.util.Date;
import org.grlea.log.DebugLevel;
import org.grlea.log.SimpleLog;

public class SimpleLogger {
    private static final char[] BYTE_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private final SimpleLog log;
    private final Class sourceClass;
    private final String className;
    private final String classNameShort;
    private Object instanceId;
    private final boolean isInstanceDebugger;
    private final boolean useLongName;
    private String configName;
    private DebugLevel debugLevel;
    private boolean tracing;

    public SimpleLogger(Class clazz) {
        this(SimpleLog.defaultInstance(), clazz);
    }

    public SimpleLogger(Class clazz, Object object) {
        this(SimpleLog.defaultInstance(), clazz, object);
    }

    public SimpleLogger(Class clazz, boolean bl) {
        this(SimpleLog.defaultInstance(), clazz, bl);
    }

    public SimpleLogger(Class clazz, Object object, boolean bl) {
        this(SimpleLog.defaultInstance(), clazz, object, bl);
    }

    public SimpleLogger(SimpleLog simpleLog, Class clazz) {
        this(simpleLog, clazz, false);
    }

    public SimpleLogger(SimpleLog simpleLog, Class clazz, Object object) {
        this(simpleLog, clazz, object, false);
    }

    public SimpleLogger(SimpleLog simpleLog, Class clazz, boolean bl) {
        this(simpleLog, clazz, null, bl);
    }

    public SimpleLogger(SimpleLog simpleLog, Class clazz, Object object, boolean bl) {
        this.log = simpleLog;
        this.sourceClass = clazz;
        this.instanceId = object;
        this.isInstanceDebugger = object != null;
        this.useLongName = bl;
        this.className = clazz.getName();
        this.classNameShort = this.createClassNameShort(clazz);
        this.generateConfigName();
        simpleLog.register(this);
    }

    private void generateConfigName() {
        String string = this.sourceClass.getName();
        if (this.isInstanceDebugger) {
            string = string + '.' + this.instanceId;
        }
        if (string.indexOf(36) != -1) {
            string = string.replace('$', '.');
        }
        this.configName = string;
    }

    private String createClassNameShort(Class clazz) {
        if (this.className.indexOf(46) == -1) {
            return this.className;
        }
        if (clazz.getPackage() != null && clazz.getPackage().getName() != null) {
            return this.className.substring(clazz.getPackage().getName().length() + 1);
        }
        String string = this.className;
        boolean bl = true;
        int n = string.indexOf(46);
        while (bl && n != -1) {
            string = string.substring(0, n);
            try {
                Class.forName(string);
                bl = true;
            }
            catch (Throwable throwable) {
                bl = false;
            }
            n = string.lastIndexOf(46);
        }
        if (string.length() == 0) {
            return this.className;
        }
        return this.className.substring(string.length() + 1);
    }

    public boolean isInstanceDebugger() {
        return this.isInstanceDebugger;
    }

    public Object getInstanceID() {
        return this.instanceId;
    }

    public void setInstanceID(Object object) {
        if (!this.isInstanceDebugger) {
            throw new IllegalStateException("This is not an instance debugger.");
        }
        if (object == null) {
            throw new IllegalArgumentException("instanceId cannot be null.");
        }
        this.instanceId = object;
        this.generateConfigName();
    }

    public String getConfigName() {
        return this.configName;
    }

    public DebugLevel getDebugLevel() {
        return this.debugLevel;
    }

    public boolean wouldLog(DebugLevel debugLevel) {
        return this.getDebugLevel().shouldLog(debugLevel);
    }

    public void setDebugLevel(DebugLevel debugLevel) {
        if (debugLevel == null) {
            throw new IllegalArgumentException("debugLevel cannot be null.");
        }
        this.debugLevel = debugLevel;
    }

    public boolean isTracing() {
        return this.tracing;
    }

    public void setTracing(boolean bl) {
        this.tracing = bl;
    }

    public Class getSourceClass() {
        return this.sourceClass;
    }

    private Object[] createData(DebugLevel debugLevel, int n) {
        Object[] objectArray = new Object[5 + n];
        objectArray[0] = new Date();
        objectArray[1] = Thread.currentThread().getName();
        objectArray[2] = this.useLongName ? this.className : this.classNameShort;
        objectArray[3] = this.instanceId;
        objectArray[4] = debugLevel;
        return objectArray;
    }

    public void fatal(String string) {
        this.db(DebugLevel.L1_FATAL, string);
    }

    public void error(String string) {
        this.db(DebugLevel.L2_ERROR, string);
    }

    public void warn(String string) {
        this.db(DebugLevel.L3_WARN, string);
    }

    public void info(String string) {
        this.db(DebugLevel.L4_INFO, string);
    }

    public void debug(String string) {
        this.db(DebugLevel.L5_DEBUG, string);
    }

    public void verbose(String string) {
        this.db(DebugLevel.L6_VERBOSE, string);
    }

    public void ludicrous(String string) {
        this.db(DebugLevel.L7_LUDICROUS, string);
    }

    public void db(DebugLevel debugLevel, String string) {
        if (!this.log.isOutputting() || !this.debugLevel.shouldLog(debugLevel)) {
            return;
        }
        Object[] objectArray = this.createData(debugLevel, 1);
        objectArray[objectArray.length - 1] = string;
        MessageFormat messageFormat = this.isInstanceDebugger ? this.log.getDebugInstanceFormat() : this.log.getDebugFormat();
        this.log.println(messageFormat.format(objectArray));
    }

    public void dbo(DebugLevel debugLevel, String string, Object object) {
        if (!this.log.isOutputting() || !this.debugLevel.shouldLog(debugLevel)) {
            return;
        }
        if (object instanceof Object[]) {
            this.dbo(debugLevel, string, (Object[])object);
        } else if (object instanceof byte[]) {
            this.dbo(debugLevel, string, (byte[])object);
        } else if (object instanceof char[]) {
            this.dbo(debugLevel, string, (char[])object);
        } else {
            this.dboNoCheck(debugLevel, string, object);
        }
    }

    private void dboNoCheck(DebugLevel debugLevel, String string, Object object) {
        Object[] objectArray = this.createData(debugLevel, 2);
        objectArray[objectArray.length - 2] = string;
        objectArray[objectArray.length - 1] = object;
        MessageFormat messageFormat = this.isInstanceDebugger ? this.log.getDebugObjectInstanceFormat() : this.log.getDebugObjectFormat();
        this.log.println(messageFormat.format(objectArray));
    }

    public void dbo(DebugLevel debugLevel, String string, Object[] objectArray) {
        if (!this.log.isOutputting() || !this.debugLevel.shouldLog(debugLevel)) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer("[");
        for (int i = 0; i < objectArray.length; ++i) {
            if (i == 0) {
                stringBuffer.append(objectArray[i]);
                continue;
            }
            stringBuffer.append(", ").append(objectArray[i]);
        }
        stringBuffer.append("]");
        this.dboNoCheck(debugLevel, string, stringBuffer);
    }

    public void dbo(DebugLevel debugLevel, String string, short s) {
        if (!this.log.isOutputting() || !this.debugLevel.shouldLog(debugLevel)) {
            return;
        }
        this.dboNoCheck(debugLevel, string, String.valueOf(s));
    }

    public void dbo(DebugLevel debugLevel, String string, int n) {
        if (!this.log.isOutputting() || !this.debugLevel.shouldLog(debugLevel)) {
            return;
        }
        this.dboNoCheck(debugLevel, string, String.valueOf(n));
    }

    public void dbo(DebugLevel debugLevel, String string, long l) {
        if (!this.log.isOutputting() || !this.debugLevel.shouldLog(debugLevel)) {
            return;
        }
        this.dboNoCheck(debugLevel, string, String.valueOf(l));
    }

    public void dbo(DebugLevel debugLevel, String string, boolean bl) {
        if (!this.log.isOutputting() || !this.debugLevel.shouldLog(debugLevel)) {
            return;
        }
        this.dboNoCheck(debugLevel, string, String.valueOf(bl));
    }

    public void dbo(DebugLevel debugLevel, String string, float f) {
        if (!this.log.isOutputting() || !this.debugLevel.shouldLog(debugLevel)) {
            return;
        }
        this.dboNoCheck(debugLevel, string, String.valueOf(f));
    }

    public void dbo(DebugLevel debugLevel, String string, double d) {
        if (!this.log.isOutputting() || !this.debugLevel.shouldLog(debugLevel)) {
            return;
        }
        this.dboNoCheck(debugLevel, string, String.valueOf(d));
    }

    public void dbo(DebugLevel debugLevel, String string, byte by) {
        if (!this.log.isOutputting() || !this.debugLevel.shouldLog(debugLevel)) {
            return;
        }
        this.dboNoCheck(debugLevel, string, SimpleLogger.toString(by));
    }

    public void dbo(DebugLevel debugLevel, String string, byte[] byArray) {
        if (!this.log.isOutputting() || !this.debugLevel.shouldLog(debugLevel)) {
            return;
        }
        this.dboNoCheck(debugLevel, string, SimpleLogger.toString(byArray));
    }

    public void dbo(DebugLevel debugLevel, String string, char c) {
        if (!this.log.isOutputting() || !this.debugLevel.shouldLog(debugLevel)) {
            return;
        }
        this.dboNoCheck(debugLevel, string, String.valueOf(c));
    }

    public void dbo(DebugLevel debugLevel, String string, char[] cArray) {
        if (!this.log.isOutputting() || !this.debugLevel.shouldLog(debugLevel)) {
            return;
        }
        this.dboNoCheck(debugLevel, string, String.valueOf(cArray));
    }

    public void infoObject(String string, Object object) {
        this.dbo(DebugLevel.L4_INFO, string, object);
    }

    public void infoObject(String string, boolean bl) {
        this.dbo(DebugLevel.L4_INFO, string, bl);
    }

    public void infoObject(String string, int n) {
        this.dbo(DebugLevel.L4_INFO, string, n);
    }

    public void debugObject(String string, Object object) {
        this.dbo(DebugLevel.L5_DEBUG, string, object);
    }

    public void debugObject(String string, boolean bl) {
        this.dbo(DebugLevel.L5_DEBUG, string, bl);
    }

    public void debugObject(String string, int n) {
        this.dbo(DebugLevel.L5_DEBUG, string, n);
    }

    public void verboseObject(String string, Object object) {
        this.dbo(DebugLevel.L6_VERBOSE, string, object);
    }

    public void verboseObject(String string, boolean bl) {
        this.dbo(DebugLevel.L6_VERBOSE, string, bl);
    }

    public void verboseObject(String string, int n) {
        this.dbo(DebugLevel.L6_VERBOSE, string, n);
    }

    public void ludicrousObject(String string, Object object) {
        this.dbo(DebugLevel.L7_LUDICROUS, string, object);
    }

    public void ludicrousObject(String string, boolean bl) {
        this.dbo(DebugLevel.L7_LUDICROUS, string, bl);
    }

    public void ludicrousObject(String string, int n) {
        this.dbo(DebugLevel.L7_LUDICROUS, string, n);
    }

    public void dbe(DebugLevel debugLevel, Throwable throwable) {
        if (!this.log.isOutputting() || !this.debugLevel.shouldLog(debugLevel)) {
            return;
        }
        Object[] objectArray = this.createData(debugLevel, 1);
        objectArray[objectArray.length - 1] = throwable;
        MessageFormat messageFormat = this.isInstanceDebugger ? this.log.getDebugExceptionInstanceFormat() : this.log.getDebugExceptionFormat();
        this.log.println(messageFormat.format(objectArray));
    }

    public void fatalException(Throwable throwable) {
        this.dbe(DebugLevel.L1_FATAL, throwable);
    }

    public void errorException(Throwable throwable) {
        this.dbe(DebugLevel.L2_ERROR, throwable);
    }

    public void warnException(Throwable throwable) {
        this.dbe(DebugLevel.L3_WARN, throwable);
    }

    public void entry(String string) {
        if (!this.log.isOutputting() || !this.tracing) {
            return;
        }
        Object[] objectArray = this.createData(DebugLevel.FAKE_TRACE, 1);
        objectArray[objectArray.length - 1] = string;
        MessageFormat messageFormat = this.isInstanceDebugger ? this.log.getEntryInstanceFormat() : this.log.getEntryFormat();
        this.log.println(messageFormat.format(objectArray));
    }

    public void exit(String string) {
        if (!this.log.isOutputting() || !this.tracing) {
            return;
        }
        Object[] objectArray = this.createData(DebugLevel.FAKE_TRACE, 1);
        objectArray[objectArray.length - 1] = string;
        MessageFormat messageFormat = this.isInstanceDebugger ? this.log.getExitInstanceFormat() : this.log.getExitFormat();
        this.log.println(messageFormat.format(objectArray));
    }

    private static String toString(byte by) {
        return "0x" + SimpleLogger.byteString(by);
    }

    private static String toString(byte[] byArray) {
        if (byArray == null) {
            return "null";
        }
        StringBuffer stringBuffer = new StringBuffer(byArray.length * 4);
        stringBuffer.append("0x[");
        boolean bl = true;
        for (int i = 0; i < byArray.length; ++i) {
            if (bl) {
                bl = false;
                if (!false) {
                    stringBuffer.append(SimpleLogger.byteString(byArray[i]));
                    continue;
                }
            }
            stringBuffer.append(", ").append(SimpleLogger.byteString(byArray[i]));
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    private static String byteString(byte by) {
        return new String(new char[]{BYTE_CHARS[by >> 4 & 0xF], BYTE_CHARS[by & 0xF]});
    }
}

