/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.safecss.shared;

import com.google.gwt.dom.client.Style;
import com.google.gwt.safecss.shared.SafeStyles;
import com.google.gwt.safecss.shared.SafeStylesString;
import com.google.gwt.safecss.shared.SafeStylesUtils;
import com.google.gwt.safehtml.shared.SafeUri;

public final class SafeStylesBuilder {
    private final StringBuilder sb = new StringBuilder();

    public SafeStylesBuilder append(SafeStyles styles) {
        this.sb.append(styles.asString());
        return this;
    }

    public SafeStylesBuilder appendTrustedString(String styles) {
        SafeStylesUtils.verifySafeStylesConstraints(styles);
        this.sb.append(styles);
        return this;
    }

    public SafeStylesBuilder backgroundImage(SafeUri uri) {
        return this.append(SafeStylesUtils.forBackgroundImage(uri));
    }

    public SafeStylesBuilder borderStyle(Style.BorderStyle value) {
        return this.append(SafeStylesUtils.forBorderStyle(value));
    }

    public SafeStylesBuilder borderWidth(double value, Style.Unit unit) {
        return this.append(SafeStylesUtils.forBorderWidth(value, unit));
    }

    public SafeStylesBuilder bottom(double value, Style.Unit unit) {
        return this.append(SafeStylesUtils.forBottom(value, unit));
    }

    public SafeStylesBuilder clear(Style.Clear value) {
        return this.append(SafeStylesUtils.forClear(value));
    }

    public SafeStylesBuilder cursor(Style.Cursor value) {
        return this.append(SafeStylesUtils.forCursor(value));
    }

    public SafeStylesBuilder display(Style.Display value) {
        return this.append(SafeStylesUtils.forDisplay(value));
    }

    public SafeStylesBuilder floatprop(Style.Float value) {
        return this.append(SafeStylesUtils.forFloat(value));
    }

    public SafeStylesBuilder fontSize(double value, Style.Unit unit) {
        return this.append(SafeStylesUtils.forFontSize(value, unit));
    }

    public SafeStylesBuilder fontStyle(Style.FontStyle value) {
        return this.append(SafeStylesUtils.forFontStyle(value));
    }

    public SafeStylesBuilder fontWeight(Style.FontWeight value) {
        return this.append(SafeStylesUtils.forFontWeight(value));
    }

    public SafeStylesBuilder height(double value, Style.Unit unit) {
        return this.append(SafeStylesUtils.forHeight(value, unit));
    }

    public SafeStylesBuilder left(double value, Style.Unit unit) {
        return this.append(SafeStylesUtils.forLeft(value, unit));
    }

    public SafeStylesBuilder listStyleType(Style.ListStyleType value) {
        return this.append(SafeStylesUtils.forListStyleType(value));
    }

    public SafeStylesBuilder margin(double value, Style.Unit unit) {
        return this.append(SafeStylesUtils.forMargin(value, unit));
    }

    public SafeStylesBuilder marginBottom(double value, Style.Unit unit) {
        return this.append(SafeStylesUtils.forMarginBottom(value, unit));
    }

    public SafeStylesBuilder marginLeft(double value, Style.Unit unit) {
        return this.append(SafeStylesUtils.forMarginLeft(value, unit));
    }

    public SafeStylesBuilder marginRight(double value, Style.Unit unit) {
        return this.append(SafeStylesUtils.forMarginRight(value, unit));
    }

    public SafeStylesBuilder marginTop(double value, Style.Unit unit) {
        return this.append(SafeStylesUtils.forMarginTop(value, unit));
    }

    public SafeStylesBuilder opacity(double value) {
        return this.append(SafeStylesUtils.forOpacity(value));
    }

    public SafeStylesBuilder overflow(Style.Overflow value) {
        return this.append(SafeStylesUtils.forOverflow(value));
    }

    public SafeStylesBuilder overflowX(Style.Overflow value) {
        return this.append(SafeStylesUtils.forOverflowX(value));
    }

    public SafeStylesBuilder overflowY(Style.Overflow value) {
        return this.append(SafeStylesUtils.forOverflowY(value));
    }

    public SafeStylesBuilder padding(double value, Style.Unit unit) {
        return this.append(SafeStylesUtils.forPadding(value, unit));
    }

    public SafeStylesBuilder paddingBottom(double value, Style.Unit unit) {
        return this.append(SafeStylesUtils.forPaddingBottom(value, unit));
    }

    public SafeStylesBuilder paddingLeft(double value, Style.Unit unit) {
        return this.append(SafeStylesUtils.forPaddingLeft(value, unit));
    }

    public SafeStylesBuilder paddingRight(double value, Style.Unit unit) {
        return this.append(SafeStylesUtils.forPaddingRight(value, unit));
    }

    public SafeStylesBuilder paddingTop(double value, Style.Unit unit) {
        return this.append(SafeStylesUtils.forPaddingTop(value, unit));
    }

    public SafeStylesBuilder position(Style.Position value) {
        return this.append(SafeStylesUtils.forPosition(value));
    }

    public SafeStylesBuilder right(double value, Style.Unit unit) {
        return this.append(SafeStylesUtils.forRight(value, unit));
    }

    public SafeStylesBuilder tableLayout(Style.TableLayout value) {
        return this.append(SafeStylesUtils.forTableLayout(value));
    }

    public SafeStylesBuilder textAlign(Style.TextAlign value) {
        return this.append(SafeStylesUtils.forTextAlign(value));
    }

    public SafeStylesBuilder textDecoration(Style.TextDecoration value) {
        return this.append(SafeStylesUtils.forTextDecoration(value));
    }

    public SafeStylesBuilder textIndent(double value, Style.Unit unit) {
        return this.append(SafeStylesUtils.forTextIndent(value, unit));
    }

    public SafeStylesBuilder textJustify(Style.TextJustify value) {
        return this.append(SafeStylesUtils.forTextJustify(value));
    }

    public SafeStylesBuilder textOverflow(Style.TextOverflow value) {
        return this.append(SafeStylesUtils.forTextOverflow(value));
    }

    public SafeStylesBuilder textTransform(Style.TextTransform value) {
        return this.append(SafeStylesUtils.forTextTransform(value));
    }

    public SafeStylesBuilder top(double value, Style.Unit unit) {
        return this.append(SafeStylesUtils.forTop(value, unit));
    }

    public SafeStyles toSafeStyles() {
        return new SafeStylesString(this.sb.toString());
    }

    public SafeStylesBuilder trustedBackgroundColor(String value) {
        return this.append(SafeStylesUtils.forTrustedBackgroundColor(value));
    }

    public SafeStylesBuilder trustedBackgroundImage(String value) {
        return this.append(SafeStylesUtils.forTrustedBackgroundImage(value));
    }

    public SafeStylesBuilder trustedBorderColor(String value) {
        return this.append(SafeStylesUtils.forTrustedBorderColor(value));
    }

    public SafeStylesBuilder trustedColor(String value) {
        return this.append(SafeStylesUtils.forTrustedColor(value));
    }

    public SafeStylesBuilder trustedNameAndValue(String name, double value, Style.Unit unit) {
        return this.append(SafeStylesUtils.fromTrustedNameAndValue(name, value, unit));
    }

    public SafeStylesBuilder trustedNameAndValue(String name, String value) {
        return this.append(SafeStylesUtils.fromTrustedNameAndValue(name, value));
    }

    public SafeStylesBuilder verticalAlign(double value, Style.Unit unit) {
        return this.append(SafeStylesUtils.forVerticalAlign(value, unit));
    }

    public SafeStylesBuilder verticalAlign(Style.VerticalAlign value) {
        return this.append(SafeStylesUtils.forVerticalAlign(value));
    }

    public SafeStylesBuilder visibility(Style.Visibility value) {
        return this.append(SafeStylesUtils.forVisibility(value));
    }

    public SafeStylesBuilder whiteSpace(Style.WhiteSpace whiteSpace) {
        return this.append(SafeStylesUtils.forWhiteSpace(whiteSpace));
    }

    public SafeStylesBuilder width(double value, Style.Unit unit) {
        return this.append(SafeStylesUtils.forWidth(value, unit));
    }

    public SafeStylesBuilder zIndex(int value) {
        return this.append(SafeStylesUtils.forZIndex(value));
    }
}

