/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.service.internal;

import java.util.LinkedHashSet;
import org.hibernate.integrator.internal.IntegratorServiceImpl;
import org.hibernate.integrator.spi.Integrator;
import org.hibernate.integrator.spi.IntegratorService;
import org.hibernate.service.BootstrapServiceRegistry;
import org.hibernate.service.Service;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.service.classloading.internal.ClassLoaderServiceImpl;
import org.hibernate.service.classloading.spi.ClassLoaderService;
import org.hibernate.service.spi.ServiceBinding;
import org.hibernate.service.spi.ServiceException;
import org.hibernate.service.spi.ServiceInitiator;
import org.hibernate.service.spi.ServiceRegistryImplementor;

public class BootstrapServiceRegistryImpl
implements ServiceRegistryImplementor,
BootstrapServiceRegistry,
ServiceBinding.OwningRegistry {
    private static final LinkedHashSet<Integrator> NO_INTEGRATORS = new LinkedHashSet();
    private final ServiceBinding<ClassLoaderService> classLoaderServiceBinding;
    private final ServiceBinding<IntegratorService> integratorServiceBinding;

    public BootstrapServiceRegistryImpl() {
        this((ClassLoaderService)new ClassLoaderServiceImpl(), NO_INTEGRATORS);
    }

    public BootstrapServiceRegistryImpl(ClassLoaderService classLoaderService, IntegratorService integratorService) {
        this.classLoaderServiceBinding = new ServiceBinding<ClassLoaderService>(this, ClassLoaderService.class, classLoaderService);
        this.integratorServiceBinding = new ServiceBinding<IntegratorService>(this, IntegratorService.class, integratorService);
    }

    public BootstrapServiceRegistryImpl(ClassLoaderService classLoaderService, LinkedHashSet<Integrator> providedIntegrators) {
        this(classLoaderService, new IntegratorServiceImpl(providedIntegrators, classLoaderService));
    }

    @Override
    public <R extends Service> R getService(Class<R> serviceRole) {
        ServiceBinding<R> binding = this.locateServiceBinding(serviceRole);
        return binding == null ? null : (R)binding.getService();
    }

    @Override
    public <R extends Service> ServiceBinding<R> locateServiceBinding(Class<R> serviceRole) {
        if (ClassLoaderService.class.equals(serviceRole)) {
            return this.classLoaderServiceBinding;
        }
        if (IntegratorService.class.equals(serviceRole)) {
            return this.integratorServiceBinding;
        }
        return null;
    }

    @Override
    public void destroy() {
    }

    @Override
    public ServiceRegistry getParentServiceRegistry() {
        return null;
    }

    @Override
    public <R extends Service> R initiateService(ServiceInitiator<R> serviceInitiator) {
        throw new ServiceException("Boot-strap registry should only contain directly built services");
    }
}

