/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend;

import java.io.IOException;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.SimpleAnalyzer;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.search.Similarity;
import org.hibernate.search.SearchException;
import org.hibernate.search.backend.LuceneIndexingParameters;
import org.hibernate.search.engine.DocumentBuilderIndexedEntity;
import org.hibernate.search.engine.SearchFactoryImplementor;
import org.hibernate.search.spi.WorkerBuildContext;
import org.hibernate.search.store.DirectoryProvider;
import org.hibernate.search.store.optimization.OptimizerStrategy;
import org.hibernate.search.util.LoggerFactory;
import org.slf4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Workspace {
    private static final Logger log = LoggerFactory.make();
    private static final Analyzer SIMPLE_ANALYZER = new SimpleAnalyzer();
    private static final IndexWriter.MaxFieldLength maxFieldLength = new IndexWriter.MaxFieldLength(10000);
    private final SearchFactoryImplementor searchFactoryImplementor;
    private final DirectoryProvider<?> directoryProvider;
    private final OptimizerStrategy optimizerStrategy;
    private final ReentrantLock lock;
    private final Set<Class<?>> entitiesInDirectory;
    private final LuceneIndexingParameters indexingParams;
    private final Similarity similarity;
    private IndexWriter writer;
    private final AtomicLong operations = new AtomicLong(0L);

    public Workspace(WorkerBuildContext context, DirectoryProvider<?> provider) {
        this.searchFactoryImplementor = context.getUninitializedSearchFactory();
        this.directoryProvider = provider;
        this.optimizerStrategy = context.getOptimizerStrategy(this.directoryProvider);
        this.entitiesInDirectory = context.getClassesInDirectoryProvider(provider);
        this.indexingParams = context.getIndexingParameters(this.directoryProvider);
        this.lock = context.getDirectoryProviderLock(provider);
        this.similarity = context.getSimilarity(this.directoryProvider);
    }

    public <T> DocumentBuilderIndexedEntity<T> getDocumentBuilder(Class<T> entity) {
        return this.searchFactoryImplementor.getDocumentBuilderIndexedEntity(entity);
    }

    public Analyzer getAnalyzer(String name) {
        return this.searchFactoryImplementor.getAnalyzer(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void optimizerPhase() {
        this.lock.lock();
        try {
            OptimizerStrategy optimizerStrategy = this.optimizerStrategy;
            synchronized (optimizerStrategy) {
                this.optimizerStrategy.addTransaction(this.operations.getAndSet(0L));
                this.optimizerStrategy.optimize(this);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void optimize() {
        this.lock.lock();
        try {
            OptimizerStrategy optimizerStrategy = this.optimizerStrategy;
            synchronized (optimizerStrategy) {
                this.optimizerStrategy.optimizationForced();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public synchronized IndexWriter getIndexWriter(boolean batchmode) {
        if (this.writer != null) {
            return this.writer;
        }
        try {
            this.writer = new IndexWriter(this.directoryProvider.getDirectory(), SIMPLE_ANALYZER, false, maxFieldLength);
            this.indexingParams.applyToWriter(this.writer, batchmode);
            this.writer.setSimilarity(this.similarity);
            log.trace("IndexWriter opened");
        }
        catch (IOException e) {
            this.writer = null;
            throw new SearchException("Unable to open IndexWriter", e);
        }
        return this.writer;
    }

    public synchronized void commitIndexWriter() {
        if (this.writer != null) {
            try {
                this.writer.commit();
                log.trace("Index changes commited.");
            }
            catch (IOException e) {
                throw new SearchException("Exception while commiting index changes", e);
            }
        }
    }

    public synchronized void closeIndexWriter() {
        IndexWriter toClose = this.writer;
        this.writer = null;
        if (toClose != null) {
            try {
                toClose.close();
                log.trace("IndexWriter closed");
            }
            catch (IOException e) {
                throw new SearchException("Exception while closing IndexWriter", e);
            }
        }
    }

    public void incrementModificationCounter(int modCount) {
        this.operations.addAndGet(modCount);
    }

    public Set<Class<?>> getEntitiesInDirectory() {
        return this.entitiesInDirectory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void forceLockRelease() {
        log.warn("going to force release of the IndexWriter lock");
        try {
            try {
                if (this.writer != null) {
                    this.writer.close();
                    log.trace("IndexWriter closed");
                }
            }
            finally {
                this.writer = null;
                IndexWriter.unlock(this.directoryProvider.getDirectory());
            }
        }
        catch (IOException ioe) {
            throw new SearchException("IOException while attempting to force release the Directory Lock", ioe);
        }
    }
}

