/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.impl;

import java.beans.Introspector;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.search.Similarity;
import org.hibernate.annotations.common.reflection.MetadataProvider;
import org.hibernate.annotations.common.reflection.MetadataProviderInjector;
import org.hibernate.annotations.common.reflection.ReflectionManager;
import org.hibernate.annotations.common.reflection.XClass;
import org.hibernate.annotations.common.reflection.java.JavaReflectionManager;
import org.hibernate.annotations.common.util.StringHelper;
import org.hibernate.search.SearchException;
import org.hibernate.search.Version;
import org.hibernate.search.annotations.AnalyzerDef;
import org.hibernate.search.annotations.AnalyzerDefs;
import org.hibernate.search.annotations.Factory;
import org.hibernate.search.annotations.FullTextFilterDef;
import org.hibernate.search.annotations.FullTextFilterDefs;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.Key;
import org.hibernate.search.backend.BackendQueueProcessorFactory;
import org.hibernate.search.backend.LuceneIndexingParameters;
import org.hibernate.search.backend.UpdatableBackendQueueProcessorFactory;
import org.hibernate.search.backend.Worker;
import org.hibernate.search.backend.WorkerFactory;
import org.hibernate.search.backend.configuration.ConfigurationParseHelper;
import org.hibernate.search.cfg.SearchConfiguration;
import org.hibernate.search.cfg.SearchMapping;
import org.hibernate.search.engine.DocumentBuilderContainedEntity;
import org.hibernate.search.engine.DocumentBuilderIndexedEntity;
import org.hibernate.search.engine.EntityState;
import org.hibernate.search.engine.FilterDef;
import org.hibernate.search.engine.SearchFactoryImplementor;
import org.hibernate.search.exception.ErrorHandler;
import org.hibernate.search.exception.impl.LogErrorHandler;
import org.hibernate.search.filter.FilterCachingStrategy;
import org.hibernate.search.filter.MRUFilterCachingStrategy;
import org.hibernate.search.filter.ShardSensitiveOnlyFilter;
import org.hibernate.search.impl.ConfigContext;
import org.hibernate.search.impl.ImmutableSearchFactory;
import org.hibernate.search.impl.IncrementalSearchConfiguration;
import org.hibernate.search.impl.MappingModelMetadataProvider;
import org.hibernate.search.impl.MutableSearchFactory;
import org.hibernate.search.impl.SearchMappingBuilder;
import org.hibernate.search.jmx.IndexControl;
import org.hibernate.search.jmx.JMXRegistrar;
import org.hibernate.search.reader.ReaderProvider;
import org.hibernate.search.reader.ReaderProviderFactory;
import org.hibernate.search.spi.WorkerBuildContext;
import org.hibernate.search.spi.WritableBuildContext;
import org.hibernate.search.spi.internals.DirectoryProviderData;
import org.hibernate.search.spi.internals.PolymorphicIndexHierarchy;
import org.hibernate.search.spi.internals.StateSearchFactoryImplementor;
import org.hibernate.search.store.DirectoryProvider;
import org.hibernate.search.store.DirectoryProviderFactory;
import org.hibernate.search.store.optimization.OptimizerStrategy;
import org.hibernate.search.util.LoggerFactory;
import org.hibernate.search.util.PluginLoader;
import org.hibernate.search.util.ReflectionHelper;
import org.slf4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchFactoryBuilder {
    private static final Logger log;
    private SearchConfiguration cfg;
    private MutableSearchFactory rootFactory;
    private final List<Class<?>> classes = new ArrayList();
    ReflectionManager reflectionManager;
    String indexingStrategy;
    Map<Class<?>, DocumentBuilderIndexedEntity<?>> documentBuildersIndexedEntities;
    Map<Class<?>, DocumentBuilderContainedEntity<?>> documentBuildersContainedEntities;
    Map<DirectoryProvider<?>, DirectoryProviderData> dirProviderData;
    Worker worker;
    ReaderProvider readerProvider;
    BackendQueueProcessorFactory backendQueueProcessorFactory;
    Map<String, FilterDef> filterDefinitions;
    FilterCachingStrategy filterCachingStrategy;
    Map<String, Analyzer> analyzers;
    int cacheBitResultsSize;
    Properties configurationProperties;
    ErrorHandler errorHandler;
    PolymorphicIndexHierarchy indexHierarchy;
    Map<DirectoryProvider, LuceneIndexingParameters> dirProviderIndexingParams;

    public SearchFactoryBuilder configuration(SearchConfiguration configuration) {
        this.cfg = configuration;
        return this;
    }

    public SearchFactoryBuilder rootFactory(MutableSearchFactory factory) {
        this.rootFactory = factory;
        return this;
    }

    public SearchFactoryBuilder addClass(Class<?> clazz) {
        this.classes.add(clazz);
        return this;
    }

    public SearchFactoryImplementor buildSearchFactory() {
        SearchFactoryImplementor searchFactoryImplementor;
        if (this.rootFactory == null) {
            if (this.classes.size() > 0) {
                throw new SearchException("Cannot add a class if the original SearchFactory is not passed");
            }
            searchFactoryImplementor = this.buildNewSearchFactory();
        } else {
            searchFactoryImplementor = this.buildIncrementalSearchFactory();
        }
        String enableJMX = this.configurationProperties.getProperty("hibernate.search.jmx_enabled");
        if ("true".equalsIgnoreCase(enableJMX)) {
            this.enableIndexControlBean(searchFactoryImplementor);
        }
        return searchFactoryImplementor;
    }

    private void enableIndexControlBean(SearchFactoryImplementor searchFactoryImplementor) {
        if (!searchFactoryImplementor.isJMXEnabled()) {
            return;
        }
        if (StringHelper.isEmpty((String)this.configurationProperties.getProperty("hibernate.session_factory_name"))) {
            log.debug("In order to bind the IndexControlMBean the Hibernate SessionFactory has to be available via JNDI");
            return;
        }
        if (JMXRegistrar.isNameRegistered("org.hibernate.search.jmx:type=IndexControlMBean")) {
            JMXRegistrar.unRegisterMBean("org.hibernate.search.jmx:type=IndexControlMBean");
        }
        IndexControl indexCtrlBean = new IndexControl(this.configurationProperties);
        JMXRegistrar.registerMBean(indexCtrlBean, "org.hibernate.search.jmx:type=IndexControlMBean");
    }

    private SearchFactoryImplementor buildIncrementalSearchFactory() {
        this.removeClassesAlreadyManaged();
        if (this.classes.size() == 0) {
            return this.rootFactory;
        }
        BuildContext buildContext = new BuildContext();
        this.copyStateFromOldFactory(this.rootFactory);
        IncrementalSearchConfiguration cfg = new IncrementalSearchConfiguration(this.classes, this.configurationProperties);
        this.reflectionManager = this.getReflectionManager(cfg);
        this.initDocumentBuilders(cfg, this.reflectionManager, buildContext);
        Set<Class<?>> indexedClasses = this.documentBuildersIndexedEntities.keySet();
        for (DocumentBuilderIndexedEntity<?> documentBuilderIndexedEntity : this.documentBuildersIndexedEntities.values()) {
            documentBuilderIndexedEntity.postInitialize(indexedClasses);
        }
        for (DocumentBuilderContainedEntity documentBuilderContainedEntity : this.documentBuildersContainedEntities.values()) {
            documentBuilderContainedEntity.postInitialize(indexedClasses);
        }
        this.fillSimilarityMapping();
        BackendQueueProcessorFactory backend = this.backendQueueProcessorFactory;
        if (backend instanceof UpdatableBackendQueueProcessorFactory) {
            UpdatableBackendQueueProcessorFactory updatableBackendQueueProcessorFactory = (UpdatableBackendQueueProcessorFactory)backend;
            updatableBackendQueueProcessorFactory.updateDirectoryProviders(this.dirProviderData.keySet(), buildContext);
        }
        ImmutableSearchFactory immutableSearchFactory = new ImmutableSearchFactory(this);
        this.rootFactory.setDelegate(immutableSearchFactory);
        return this.rootFactory;
    }

    private void removeClassesAlreadyManaged() {
        HashSet remove = new HashSet();
        Map<Class<?>, DocumentBuilderContainedEntity<?>> containedEntities = this.rootFactory.getDocumentBuildersContainedEntities();
        Map<Class<?>, DocumentBuilderIndexedEntity<?>> indexedEntities = this.rootFactory.getDocumentBuildersIndexedEntities();
        for (Class<Object> entity : this.classes) {
            if (!indexedEntities.containsKey(entity) && !containedEntities.containsKey(entity)) continue;
            remove.add(entity);
        }
        for (Class<Object> entity : remove) {
            this.classes.remove(entity);
        }
    }

    private void copyStateFromOldFactory(StateSearchFactoryImplementor stateFactory) {
        this.indexingStrategy = stateFactory.getIndexingStrategy();
        this.documentBuildersIndexedEntities = stateFactory.getDocumentBuildersIndexedEntities();
        this.documentBuildersContainedEntities = stateFactory.getDocumentBuildersContainedEntities();
        this.dirProviderData = stateFactory.getDirectoryProviderData();
        this.worker = stateFactory.getWorker();
        this.readerProvider = stateFactory.getReaderProvider();
        this.backendQueueProcessorFactory = stateFactory.getBackendQueueProcessorFactory();
        this.filterDefinitions = stateFactory.getFilterDefinitions();
        this.filterCachingStrategy = stateFactory.getFilterCachingStrategy();
        this.analyzers = stateFactory.getAnalyzers();
        this.cacheBitResultsSize = stateFactory.getCacheBitResultsSize();
        this.configurationProperties = stateFactory.getConfigurationProperties();
        this.errorHandler = stateFactory.getErrorHandler();
        this.indexHierarchy = stateFactory.getIndexHierarchy();
        this.dirProviderIndexingParams = stateFactory.getDirectoryProviderIndexingParams();
    }

    private SearchFactoryImplementor buildNewSearchFactory() {
        this.createCleanFactoryState();
        this.configurationProperties = this.cfg.getProperties();
        this.errorHandler = SearchFactoryBuilder.createErrorHandler(this.configurationProperties);
        this.reflectionManager = this.getReflectionManager(this.cfg);
        BuildContext buildContext = new BuildContext();
        SearchMapping mapping = SearchMappingBuilder.getSearchMapping(this.cfg);
        if (mapping != null) {
            if (!(this.reflectionManager instanceof MetadataProviderInjector)) {
                throw new SearchException("Programmatic mapping model used but ReflectionManager does not implement " + MetadataProviderInjector.class.getName());
            }
            MetadataProviderInjector injector = (MetadataProviderInjector)this.reflectionManager;
            MetadataProvider original = injector.getMetadataProvider();
            injector.setMetadataProvider((MetadataProvider)new MappingModelMetadataProvider(original, mapping));
        }
        this.indexingStrategy = SearchFactoryBuilder.defineIndexingStrategy(this.cfg);
        this.dirProviderIndexingParams = new HashMap<DirectoryProvider, LuceneIndexingParameters>();
        this.initDocumentBuilders(this.cfg, this.reflectionManager, buildContext);
        Set<Class<?>> indexedClasses = this.documentBuildersIndexedEntities.keySet();
        for (DocumentBuilderIndexedEntity<?> documentBuilderIndexedEntity : this.documentBuildersIndexedEntities.values()) {
            documentBuilderIndexedEntity.postInitialize(indexedClasses);
        }
        for (DocumentBuilderContainedEntity documentBuilderContainedEntity : this.documentBuildersContainedEntities.values()) {
            documentBuilderContainedEntity.postInitialize(indexedClasses);
        }
        this.fillSimilarityMapping();
        this.worker = WorkerFactory.createWorker(this.cfg, buildContext);
        this.readerProvider = ReaderProviderFactory.createReaderProvider(this.cfg, buildContext);
        this.filterCachingStrategy = SearchFactoryBuilder.buildFilterCachingStrategy(this.cfg.getProperties());
        this.cacheBitResultsSize = ConfigurationParseHelper.getIntValue(this.cfg.getProperties(), "hibernate.search.filter.cache_docidresults.size", 5);
        ImmutableSearchFactory factory = new ImmutableSearchFactory(this);
        this.rootFactory.setDelegate(factory);
        return this.rootFactory;
    }

    private void fillSimilarityMapping() {
        for (DirectoryProviderData directoryConfiguration : this.dirProviderData.values()) {
            for (Class<?> indexedType : directoryConfiguration.getClasses()) {
                DocumentBuilderIndexedEntity<?> documentBuilder = this.documentBuildersIndexedEntities.get(indexedType);
                Similarity similarity = documentBuilder.getSimilarity();
                Similarity prevSimilarity = directoryConfiguration.getSimilarity();
                if (prevSimilarity != null && !prevSimilarity.getClass().equals(similarity.getClass())) {
                    throw new SearchException("Multiple entities are sharing the same index but are declaring an inconsistent Similarity. When overrriding default Similarity make sure that all types sharing a same index declare the same Similarity implementation.");
                }
                directoryConfiguration.setSimilarity(similarity);
            }
        }
    }

    private static FilterCachingStrategy buildFilterCachingStrategy(Properties properties) {
        String impl = properties.getProperty("hibernate.search.filter.cache_strategy");
        FilterCachingStrategy filterCachingStrategy = StringHelper.isEmpty((String)impl) || "mru".equalsIgnoreCase(impl) ? new MRUFilterCachingStrategy() : PluginLoader.instanceFromName(FilterCachingStrategy.class, impl, ImmutableSearchFactory.class, "filterCachingStrategy");
        filterCachingStrategy.initialize(properties);
        return filterCachingStrategy;
    }

    private void createCleanFactoryState() {
        if (this.rootFactory == null) {
            this.rootFactory = new MutableSearchFactory();
            this.documentBuildersIndexedEntities = new HashMap();
            this.documentBuildersContainedEntities = new HashMap();
            this.dirProviderData = new HashMap();
            this.filterDefinitions = new HashMap<String, FilterDef>();
            this.indexHierarchy = new PolymorphicIndexHierarchy();
        }
    }

    private void initDocumentBuilders(SearchConfiguration cfg, ReflectionManager reflectionManager, BuildContext buildContext) {
        ConfigContext context = new ConfigContext(cfg);
        Iterator<Class<?>> iter = cfg.getClassMappings();
        DirectoryProviderFactory factory = new DirectoryProviderFactory();
        this.initProgrammaticAnalyzers(context, reflectionManager);
        this.initProgrammaticallyDefinedFilterDef(reflectionManager);
        while (iter.hasNext()) {
            XClass mappedXClass;
            Class<?> mappedClass = iter.next();
            if (mappedClass == null || (mappedXClass = reflectionManager.toXClass(mappedClass)) == null) continue;
            if (mappedXClass.isAnnotationPresent(Indexed.class)) {
                if (mappedXClass.isAbstract()) {
                    log.warn("Abstract classes can never insert index documents. Remove @Indexed.");
                    continue;
                }
                DirectoryProviderFactory.DirectoryProviders providers = factory.createDirectoryProviders(mappedXClass, cfg, buildContext, reflectionManager);
                DocumentBuilderIndexedEntity documentBuilder = new DocumentBuilderIndexedEntity(mappedXClass, context, providers.getProviders(), providers.getSelectionStrategy(), reflectionManager);
                this.indexHierarchy.addIndexedClass(mappedClass);
                this.documentBuildersIndexedEntities.put(mappedClass, documentBuilder);
            } else {
                DocumentBuilderContainedEntity documentBuilder = new DocumentBuilderContainedEntity(mappedXClass, context, reflectionManager);
                if (documentBuilder.getEntityState() != EntityState.NON_INDEXABLE) {
                    this.documentBuildersContainedEntities.put(mappedClass, documentBuilder);
                }
            }
            this.bindFilterDefs(mappedXClass);
        }
        this.analyzers = context.initLazyAnalyzers();
        factory.startDirectoryProviders();
    }

    private void bindFilterDefs(XClass mappedXClass) {
        FullTextFilterDefs defsAnn;
        FullTextFilterDef defAnn = (FullTextFilterDef)mappedXClass.getAnnotation(FullTextFilterDef.class);
        if (defAnn != null) {
            this.bindFilterDef(defAnn, mappedXClass);
        }
        if ((defsAnn = (FullTextFilterDefs)mappedXClass.getAnnotation(FullTextFilterDefs.class)) != null) {
            for (FullTextFilterDef def : defsAnn.value()) {
                this.bindFilterDef(def, mappedXClass);
            }
        }
    }

    private void bindFilterDef(FullTextFilterDef defAnn, XClass mappedXClass) {
        if (this.filterDefinitions.containsKey(defAnn.name())) {
            throw new SearchException("Multiple definition of @FullTextFilterDef.name=" + defAnn.name() + ": " + mappedXClass.getName());
        }
        this.bindFullTextFilterDef(defAnn);
    }

    private void bindFullTextFilterDef(FullTextFilterDef defAnn) {
        FilterDef filterDef = new FilterDef(defAnn);
        if (filterDef.getImpl().equals(ShardSensitiveOnlyFilter.class)) {
            this.filterDefinitions.put(defAnn.name(), filterDef);
            return;
        }
        try {
            filterDef.getImpl().newInstance();
        }
        catch (IllegalAccessException e) {
            throw new SearchException("Unable to create Filter class: " + filterDef.getImpl().getName(), e);
        }
        catch (InstantiationException e) {
            throw new SearchException("Unable to create Filter class: " + filterDef.getImpl().getName(), e);
        }
        for (Method method : filterDef.getImpl().getMethods()) {
            String name;
            if (method.isAnnotationPresent(Factory.class)) {
                if (filterDef.getFactoryMethod() != null) {
                    throw new SearchException("Multiple @Factory methods found" + defAnn.name() + ": " + filterDef.getImpl().getName() + "." + method.getName());
                }
                ReflectionHelper.setAccessible(method);
                filterDef.setFactoryMethod(method);
            }
            if (method.isAnnotationPresent(Key.class)) {
                if (filterDef.getKeyMethod() != null) {
                    throw new SearchException("Multiple @Key methods found" + defAnn.name() + ": " + filterDef.getImpl().getName() + "." + method.getName());
                }
                ReflectionHelper.setAccessible(method);
                filterDef.setKeyMethod(method);
            }
            if (!(name = method.getName()).startsWith("set") || method.getParameterTypes().length != 1) continue;
            filterDef.addSetter(Introspector.decapitalize(name.substring(3)), method);
        }
        this.filterDefinitions.put(defAnn.name(), filterDef);
    }

    private void initProgrammaticAnalyzers(ConfigContext context, ReflectionManager reflectionManager) {
        AnalyzerDef[] defs;
        Map defaults = reflectionManager.getDefaults();
        if (defaults != null && (defs = (AnalyzerDef[])defaults.get(AnalyzerDefs.class)) != null) {
            for (AnalyzerDef def : defs) {
                context.addAnalyzerDef(def);
            }
        }
    }

    private void initProgrammaticallyDefinedFilterDef(ReflectionManager reflectionManager) {
        Map defaults = reflectionManager.getDefaults();
        FullTextFilterDef[] filterDefs = (FullTextFilterDef[])defaults.get(FullTextFilterDefs.class);
        if (filterDefs != null && filterDefs.length != 0) {
            for (FullTextFilterDef defAnn : filterDefs) {
                if (this.filterDefinitions.containsKey(defAnn.name())) {
                    throw new SearchException("Multiple definition of @FullTextFilterDef.name=" + defAnn.name());
                }
                this.bindFullTextFilterDef(defAnn);
            }
        }
    }

    private static ErrorHandler createErrorHandler(Properties configuration) {
        String errorHandlerClassName = configuration.getProperty("hibernate.search.error_handler");
        if (StringHelper.isEmpty((String)errorHandlerClassName)) {
            return new LogErrorHandler();
        }
        if (errorHandlerClassName.trim().equals("log")) {
            return new LogErrorHandler();
        }
        return PluginLoader.instanceFromName(ErrorHandler.class, errorHandlerClassName, ImmutableSearchFactory.class, "Error Handler");
    }

    private ReflectionManager getReflectionManager(SearchConfiguration cfg) {
        ReflectionManager reflectionManager = cfg.getReflectionManager();
        return this.geReflectionManager(reflectionManager);
    }

    private ReflectionManager geReflectionManager(ReflectionManager reflectionManager) {
        if (reflectionManager == null) {
            reflectionManager = new JavaReflectionManager();
        }
        return reflectionManager;
    }

    private static String defineIndexingStrategy(SearchConfiguration cfg) {
        String indexingStrategy = cfg.getProperties().getProperty("hibernate.search.indexing_strategy", "event");
        if (!"event".equals(indexingStrategy) && !"manual".equals(indexingStrategy)) {
            throw new SearchException("hibernate.search.indexing_strategy unknown: " + indexingStrategy);
        }
        return indexingStrategy;
    }

    static {
        Version.touch();
        log = LoggerFactory.make();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class BuildContext
    implements WritableBuildContext,
    WorkerBuildContext {
        private BuildContext() {
        }

        @Override
        public void addOptimizerStrategy(DirectoryProvider<?> provider, OptimizerStrategy optimizerStrategy) {
            DirectoryProviderData data = SearchFactoryBuilder.this.dirProviderData.get(provider);
            if (data == null) {
                data = new DirectoryProviderData();
                SearchFactoryBuilder.this.dirProviderData.put(provider, data);
            }
            data.setOptimizerStrategy(optimizerStrategy);
        }

        @Override
        public void addIndexingParameters(DirectoryProvider<?> provider, LuceneIndexingParameters indexingParams) {
            SearchFactoryBuilder.this.dirProviderIndexingParams.put(provider, indexingParams);
        }

        @Override
        public void addClassToDirectoryProvider(Class<?> entity, DirectoryProvider<?> directoryProvider, boolean exclusiveIndexUsage) {
            DirectoryProviderData data = SearchFactoryBuilder.this.dirProviderData.get(directoryProvider);
            if (data == null) {
                data = new DirectoryProviderData();
                SearchFactoryBuilder.this.dirProviderData.put(directoryProvider, data);
            }
            data.getClasses().add(entity);
            data.setExclusiveIndexUsage(exclusiveIndexUsage);
        }

        @Override
        public SearchFactoryImplementor getUninitializedSearchFactory() {
            return SearchFactoryBuilder.this.rootFactory;
        }

        @Override
        public String getIndexingStrategy() {
            return SearchFactoryBuilder.this.indexingStrategy;
        }

        @Override
        public Set<DirectoryProvider<?>> getDirectoryProviders() {
            return SearchFactoryBuilder.this.dirProviderData.keySet();
        }

        @Override
        public void setBackendQueueProcessorFactory(BackendQueueProcessorFactory backendQueueProcessorFactory) {
            SearchFactoryBuilder.this.backendQueueProcessorFactory = backendQueueProcessorFactory;
        }

        @Override
        public OptimizerStrategy getOptimizerStrategy(DirectoryProvider<?> provider) {
            return SearchFactoryBuilder.this.dirProviderData.get(provider).getOptimizerStrategy();
        }

        @Override
        public Set<Class<?>> getClassesInDirectoryProvider(DirectoryProvider<?> directoryProvider) {
            return Collections.unmodifiableSet(SearchFactoryBuilder.this.dirProviderData.get(directoryProvider).getClasses());
        }

        @Override
        public LuceneIndexingParameters getIndexingParameters(DirectoryProvider<?> provider) {
            return SearchFactoryBuilder.this.dirProviderIndexingParams.get(provider);
        }

        @Override
        public ReentrantLock getDirectoryProviderLock(DirectoryProvider<?> dp) {
            return SearchFactoryBuilder.this.dirProviderData.get(dp).getDirLock();
        }

        @Override
        public Similarity getSimilarity(DirectoryProvider<?> provider) {
            Similarity similarity = SearchFactoryBuilder.this.dirProviderData.get(provider).getSimilarity();
            if (similarity == null) {
                throw new SearchException("Assertion error: a similarity should be defined for each provider");
            }
            return similarity;
        }

        @Override
        public boolean isExclusiveIndexUsageEnabled(DirectoryProvider<?> provider) {
            return SearchFactoryBuilder.this.dirProviderData.get(provider).isExclusiveIndexUsage();
        }

        @Override
        public ErrorHandler getErrorHandler() {
            return SearchFactoryBuilder.this.errorHandler;
        }

        @Override
        public <T> DocumentBuilderIndexedEntity<T> getDocumentBuilderIndexedEntity(Class<T> entityType) {
            return SearchFactoryBuilder.this.documentBuildersIndexedEntities.get(entityType);
        }
    }
}

