/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.store;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.lucene.store.FSDirectory;
import org.hibernate.annotations.common.reflection.ReflectionManager;
import org.hibernate.annotations.common.reflection.XClass;
import org.hibernate.annotations.common.reflection.java.JavaReflectionManager;
import org.hibernate.annotations.common.util.StringHelper;
import org.hibernate.search.SearchException;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.backend.LuceneIndexingParameters;
import org.hibernate.search.backend.configuration.ConfigurationParseHelper;
import org.hibernate.search.backend.configuration.MaskedProperty;
import org.hibernate.search.cfg.SearchConfiguration;
import org.hibernate.search.spi.WritableBuildContext;
import org.hibernate.search.store.DirectoryProvider;
import org.hibernate.search.store.FSDirectoryProvider;
import org.hibernate.search.store.IdHashShardingStrategy;
import org.hibernate.search.store.IndexShardingStrategy;
import org.hibernate.search.store.NotShardedStrategy;
import org.hibernate.search.store.optimization.IncrementalOptimizerStrategy;
import org.hibernate.search.store.optimization.NoOpOptimizerStrategy;
import org.hibernate.search.store.optimization.OptimizerStrategy;
import org.hibernate.search.util.PluginLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectoryProviderFactory {
    private final List<DirectoryProvider<?>> providers = new ArrayList();
    private static final String SHARDING_STRATEGY = "sharding_strategy";
    private static final String NBR_OF_SHARDS = "sharding_strategy.nbr_of_shards";

    public DirectoryProviders createDirectoryProviders(XClass entity, SearchConfiguration cfg, WritableBuildContext context, ReflectionManager reflectionManager) {
        String directoryProviderName = DirectoryProviderFactory.getDirectoryProviderName(entity, cfg);
        Properties[] indexProps = DirectoryProviderFactory.getDirectoryProperties(cfg, directoryProviderName);
        int nbrOfProviders = indexProps.length;
        DirectoryProvider[] providers = new DirectoryProvider[nbrOfProviders];
        for (int index = 0; index < nbrOfProviders; ++index) {
            String providerName = nbrOfProviders > 1 ? directoryProviderName + "." + index : directoryProviderName;
            providers[index] = this.createDirectoryProvider(providerName, indexProps[index], reflectionManager.toClass(entity), context);
        }
        String shardingStrategyName = indexProps[0].getProperty(SHARDING_STRATEGY);
        IndexShardingStrategy shardingStrategy = shardingStrategyName == null ? (indexProps.length == 1 ? new NotShardedStrategy() : new IdHashShardingStrategy()) : PluginLoader.instanceFromName(IndexShardingStrategy.class, shardingStrategyName, DirectoryProviderFactory.class, "IndexShardingStrategy");
        shardingStrategy.initialize(new MaskedProperty(indexProps[0], SHARDING_STRATEGY), providers);
        return new DirectoryProviders(shardingStrategy, providers);
    }

    public void startDirectoryProviders() {
        for (DirectoryProvider<?> provider : this.providers) {
            provider.start();
        }
    }

    private DirectoryProvider<?> createDirectoryProvider(String directoryProviderName, Properties indexProps, Class<?> entity, WritableBuildContext context) {
        String className = indexProps.getProperty("directory_provider");
        DirectoryProvider<FSDirectory> provider = StringHelper.isEmpty((String)className) ? new FSDirectoryProvider() : PluginLoader.instanceFromName(DirectoryProvider.class, className, DirectoryProviderFactory.class, "directory provider");
        try {
            provider.initialize(directoryProviderName, indexProps, context);
        }
        catch (Exception e) {
            throw new SearchException("Unable to initialize directory provider: " + directoryProviderName, e);
        }
        int index = this.providers.indexOf(provider);
        boolean exclusiveIndexUsage = DirectoryProviderFactory.isExclusiveIndexUsageEnabled(directoryProviderName, indexProps);
        if (index != -1) {
            DirectoryProvider<?> directoryProvider = this.providers.get(index);
            context.addClassToDirectoryProvider(entity, directoryProvider, exclusiveIndexUsage);
            return directoryProvider;
        }
        this.configureOptimizerStrategy(context, indexProps, provider);
        this.configureIndexingParameters(context, indexProps, provider);
        this.providers.add(provider);
        context.addClassToDirectoryProvider(entity, provider, exclusiveIndexUsage);
        return provider;
    }

    private void configureOptimizerStrategy(WritableBuildContext context, Properties indexProps, DirectoryProvider<?> provider) {
        OptimizerStrategy optimizerStrategy;
        boolean incremental;
        boolean bl = incremental = indexProps.containsKey("optimizer.operation_limit.max") || indexProps.containsKey("optimizer.transaction_limit.max");
        if (incremental) {
            optimizerStrategy = new IncrementalOptimizerStrategy();
            optimizerStrategy.initialize(provider, indexProps, context);
        } else {
            optimizerStrategy = new NoOpOptimizerStrategy();
        }
        context.addOptimizerStrategy(provider, optimizerStrategy);
    }

    private void configureIndexingParameters(WritableBuildContext context, Properties directoryProperties, DirectoryProvider<?> provider) {
        LuceneIndexingParameters indexingParams = new LuceneIndexingParameters(directoryProperties);
        context.addIndexingParameters(provider, indexingParams);
    }

    private static Properties[] getDirectoryProperties(SearchConfiguration cfg, String directoryProviderName) {
        MaskedProperty globalProperties;
        MaskedProperty rootCfg = new MaskedProperty(cfg.getProperties(), "hibernate.search");
        MaskedProperty directoryLocalProperties = new MaskedProperty(rootCfg, directoryProviderName, globalProperties = new MaskedProperty(rootCfg, "default"));
        String shardsCountValue = ((Properties)directoryLocalProperties).getProperty(NBR_OF_SHARDS);
        if (shardsCountValue == null) {
            return new Properties[]{directoryLocalProperties};
        }
        int shardsCount = ConfigurationParseHelper.parseInt(shardsCountValue, shardsCountValue + " is not a number");
        Properties[] shardLocalProperties = new Properties[shardsCount];
        for (int i = 0; i < shardsCount; ++i) {
            shardLocalProperties[i] = new MaskedProperty(directoryLocalProperties, Integer.toString(i), directoryLocalProperties);
        }
        return shardLocalProperties;
    }

    private static String getDirectoryProviderName(XClass clazz, SearchConfiguration cfg) {
        ReflectionManager reflectionManager = cfg.getReflectionManager();
        if (reflectionManager == null) {
            reflectionManager = new JavaReflectionManager();
        }
        Class<?> aClass = cfg.getClassMapping(clazz.getName());
        XClass rootIndex = null;
        do {
            XClass currentClazz;
            Indexed indexAnn;
            if ((indexAnn = (Indexed)(currentClazz = reflectionManager.toXClass(aClass)).getAnnotation(Indexed.class)) == null) continue;
            if (indexAnn.index().length() != 0) {
                return indexAnn.index();
            }
            rootIndex = currentClazz;
        } while ((aClass = aClass.getSuperclass()) != null);
        if (rootIndex != null) {
            return rootIndex.getName();
        }
        throw new SearchException("Trying to extract the index name from a non @Indexed class: " + clazz.getName());
    }

    private static boolean isExclusiveIndexUsageEnabled(String directoryProviderName, Properties indexProps) {
        String exclusiveIndexUsageProperty = indexProps.getProperty("exclusive_index_use", "false");
        boolean exclusiveIndexUsage = ConfigurationParseHelper.parseBoolean(exclusiveIndexUsageProperty, "Illegal value for property exclusive_index_use on index " + directoryProviderName);
        return exclusiveIndexUsage;
    }

    public static class DirectoryProviders {
        private final IndexShardingStrategy shardingStrategy;
        private final DirectoryProvider[] providers;

        public DirectoryProviders(IndexShardingStrategy shardingStrategy, DirectoryProvider[] providers) {
            this.shardingStrategy = shardingStrategy;
            this.providers = providers;
        }

        public IndexShardingStrategy getSelectionStrategy() {
            return this.shardingStrategy;
        }

        public DirectoryProvider[] getProviders() {
            return this.providers;
        }
    }
}

