/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.metadata.core;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import javax.validation.Constraint;
import javax.validation.ConstraintValidator;
import javax.validation.ValidationException;
import javax.validation.constraints.AssertFalse;
import javax.validation.constraints.AssertTrue;
import javax.validation.constraints.DecimalMax;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.Digits;
import javax.validation.constraints.Future;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Null;
import javax.validation.constraints.Past;
import javax.validation.constraints.Pattern;
import javax.validation.constraints.Size;
import org.hibernate.validator.constraints.ConstraintComposition;
import org.hibernate.validator.constraints.Email;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.ModCheck;
import org.hibernate.validator.constraints.NotBlank;
import org.hibernate.validator.constraints.SafeHtml;
import org.hibernate.validator.constraints.ScriptAssert;
import org.hibernate.validator.constraints.URL;
import org.hibernate.validator.internal.constraintvalidators.AssertFalseValidator;
import org.hibernate.validator.internal.constraintvalidators.AssertTrueValidator;
import org.hibernate.validator.internal.constraintvalidators.DecimalMaxValidatorForCharSequence;
import org.hibernate.validator.internal.constraintvalidators.DecimalMaxValidatorForNumber;
import org.hibernate.validator.internal.constraintvalidators.DecimalMinValidatorForCharSequence;
import org.hibernate.validator.internal.constraintvalidators.DecimalMinValidatorForNumber;
import org.hibernate.validator.internal.constraintvalidators.DigitsValidatorForCharSequence;
import org.hibernate.validator.internal.constraintvalidators.DigitsValidatorForNumber;
import org.hibernate.validator.internal.constraintvalidators.EmailValidator;
import org.hibernate.validator.internal.constraintvalidators.FutureValidatorForCalendar;
import org.hibernate.validator.internal.constraintvalidators.FutureValidatorForDate;
import org.hibernate.validator.internal.constraintvalidators.FutureValidatorForReadableInstant;
import org.hibernate.validator.internal.constraintvalidators.FutureValidatorForReadablePartial;
import org.hibernate.validator.internal.constraintvalidators.LengthValidator;
import org.hibernate.validator.internal.constraintvalidators.MaxValidatorForCharSequence;
import org.hibernate.validator.internal.constraintvalidators.MaxValidatorForNumber;
import org.hibernate.validator.internal.constraintvalidators.MinValidatorForCharSequence;
import org.hibernate.validator.internal.constraintvalidators.MinValidatorForNumber;
import org.hibernate.validator.internal.constraintvalidators.ModCheckValidator;
import org.hibernate.validator.internal.constraintvalidators.NotBlankValidator;
import org.hibernate.validator.internal.constraintvalidators.NotNullValidator;
import org.hibernate.validator.internal.constraintvalidators.NullValidator;
import org.hibernate.validator.internal.constraintvalidators.PastValidatorForCalendar;
import org.hibernate.validator.internal.constraintvalidators.PastValidatorForDate;
import org.hibernate.validator.internal.constraintvalidators.PastValidatorForReadableInstant;
import org.hibernate.validator.internal.constraintvalidators.PastValidatorForReadablePartial;
import org.hibernate.validator.internal.constraintvalidators.PatternValidator;
import org.hibernate.validator.internal.constraintvalidators.SafeHtmlValidator;
import org.hibernate.validator.internal.constraintvalidators.ScriptAssertValidator;
import org.hibernate.validator.internal.constraintvalidators.SizeValidatorForArray;
import org.hibernate.validator.internal.constraintvalidators.SizeValidatorForArraysOfBoolean;
import org.hibernate.validator.internal.constraintvalidators.SizeValidatorForArraysOfByte;
import org.hibernate.validator.internal.constraintvalidators.SizeValidatorForArraysOfChar;
import org.hibernate.validator.internal.constraintvalidators.SizeValidatorForArraysOfDouble;
import org.hibernate.validator.internal.constraintvalidators.SizeValidatorForArraysOfFloat;
import org.hibernate.validator.internal.constraintvalidators.SizeValidatorForArraysOfInt;
import org.hibernate.validator.internal.constraintvalidators.SizeValidatorForArraysOfLong;
import org.hibernate.validator.internal.constraintvalidators.SizeValidatorForCharSequence;
import org.hibernate.validator.internal.constraintvalidators.SizeValidatorForCollection;
import org.hibernate.validator.internal.constraintvalidators.SizeValidatorForMap;
import org.hibernate.validator.internal.constraintvalidators.URLValidator;
import org.hibernate.validator.internal.util.CollectionHelper;
import org.hibernate.validator.internal.util.Contracts;
import org.hibernate.validator.internal.util.logging.Log;
import org.hibernate.validator.internal.util.logging.LoggerFactory;
import org.hibernate.validator.internal.util.logging.Messages;
import org.hibernate.validator.internal.util.privilegedactions.GetAnnotationParameter;
import org.hibernate.validator.internal.util.privilegedactions.GetDeclaredMethod;
import org.hibernate.validator.internal.util.privilegedactions.GetDeclaredMethods;
import org.hibernate.validator.internal.util.privilegedactions.GetMethod;
import org.hibernate.validator.internal.util.privilegedactions.LoadClass;

public class ConstraintHelper {
    private static final Log log = LoggerFactory.make();
    private static final String JODA_TIME_CLASS_NAME = "org.joda.time.ReadableInstant";
    private final ConcurrentHashMap<Class<? extends Annotation>, List<Class<? extends ConstraintValidator<?, ?>>>> builtinConstraints = CollectionHelper.newConcurrentHashMap();
    private final ConcurrentHashMap<Class<? extends Annotation>, List<Class<? extends ConstraintValidator<? extends Annotation, ?>>>> constraintValidatorDefinitions = CollectionHelper.newConcurrentHashMap();

    public ConstraintHelper() {
        ArrayList constraintList = CollectionHelper.newArrayList();
        constraintList.add(AssertFalseValidator.class);
        this.builtinConstraints.put(AssertFalse.class, constraintList);
        constraintList = CollectionHelper.newArrayList();
        constraintList.add(AssertTrueValidator.class);
        this.builtinConstraints.put(AssertTrue.class, constraintList);
        constraintList = CollectionHelper.newArrayList();
        constraintList.add(DecimalMaxValidatorForNumber.class);
        constraintList.add(DecimalMaxValidatorForCharSequence.class);
        this.builtinConstraints.put(DecimalMax.class, constraintList);
        constraintList = CollectionHelper.newArrayList();
        constraintList.add(DecimalMinValidatorForNumber.class);
        constraintList.add(DecimalMinValidatorForCharSequence.class);
        this.builtinConstraints.put(DecimalMin.class, constraintList);
        constraintList = CollectionHelper.newArrayList();
        constraintList.add(DigitsValidatorForCharSequence.class);
        constraintList.add(DigitsValidatorForNumber.class);
        this.builtinConstraints.put(Digits.class, constraintList);
        constraintList = CollectionHelper.newArrayList();
        constraintList.add(FutureValidatorForCalendar.class);
        constraintList.add(FutureValidatorForDate.class);
        if (this.isJodaTimeInClasspath()) {
            constraintList.add(FutureValidatorForReadableInstant.class);
            constraintList.add(FutureValidatorForReadablePartial.class);
        }
        this.builtinConstraints.put(Future.class, constraintList);
        constraintList = CollectionHelper.newArrayList();
        constraintList.add(MaxValidatorForNumber.class);
        constraintList.add(MaxValidatorForCharSequence.class);
        this.builtinConstraints.put(Max.class, constraintList);
        constraintList = CollectionHelper.newArrayList();
        constraintList.add(MinValidatorForNumber.class);
        constraintList.add(MinValidatorForCharSequence.class);
        this.builtinConstraints.put(Min.class, constraintList);
        constraintList = CollectionHelper.newArrayList();
        constraintList.add(NotNullValidator.class);
        this.builtinConstraints.put(NotNull.class, constraintList);
        constraintList = CollectionHelper.newArrayList();
        constraintList.add(NullValidator.class);
        this.builtinConstraints.put(Null.class, constraintList);
        constraintList = CollectionHelper.newArrayList();
        constraintList.add(PastValidatorForCalendar.class);
        constraintList.add(PastValidatorForDate.class);
        if (this.isJodaTimeInClasspath()) {
            constraintList.add(PastValidatorForReadableInstant.class);
            constraintList.add(PastValidatorForReadablePartial.class);
        }
        this.builtinConstraints.put(Past.class, constraintList);
        constraintList = CollectionHelper.newArrayList();
        constraintList.add(PatternValidator.class);
        this.builtinConstraints.put(Pattern.class, constraintList);
        constraintList = CollectionHelper.newArrayList();
        constraintList.add(SizeValidatorForCharSequence.class);
        constraintList.add(SizeValidatorForCollection.class);
        constraintList.add(SizeValidatorForArray.class);
        constraintList.add(SizeValidatorForMap.class);
        constraintList.add(SizeValidatorForArraysOfBoolean.class);
        constraintList.add(SizeValidatorForArraysOfByte.class);
        constraintList.add(SizeValidatorForArraysOfChar.class);
        constraintList.add(SizeValidatorForArraysOfDouble.class);
        constraintList.add(SizeValidatorForArraysOfFloat.class);
        constraintList.add(SizeValidatorForArraysOfInt.class);
        constraintList.add(SizeValidatorForArraysOfLong.class);
        this.builtinConstraints.put(Size.class, constraintList);
        constraintList = CollectionHelper.newArrayList();
        constraintList.add(EmailValidator.class);
        this.builtinConstraints.put(Email.class, constraintList);
        constraintList = CollectionHelper.newArrayList();
        constraintList.add(LengthValidator.class);
        this.builtinConstraints.put(Length.class, constraintList);
        constraintList = CollectionHelper.newArrayList();
        constraintList.add(ModCheckValidator.class);
        this.builtinConstraints.put(ModCheck.class, constraintList);
        constraintList = CollectionHelper.newArrayList();
        constraintList.add(NotBlankValidator.class);
        this.builtinConstraints.put(NotBlank.class, constraintList);
        constraintList = CollectionHelper.newArrayList();
        constraintList.add(SafeHtmlValidator.class);
        this.builtinConstraints.put(SafeHtml.class, constraintList);
        constraintList = CollectionHelper.newArrayList();
        constraintList.add(ScriptAssertValidator.class);
        this.builtinConstraints.put(ScriptAssert.class, constraintList);
        constraintList = CollectionHelper.newArrayList();
        constraintList.add(URLValidator.class);
        this.builtinConstraints.put(URL.class, constraintList);
    }

    public List<Class<? extends ConstraintValidator<? extends Annotation, ?>>> getBuiltInConstraints(Class<? extends Annotation> annotationClass) {
        List<Class<ConstraintValidator<?, ?>>> builtInList = this.builtinConstraints.get(annotationClass);
        if (builtInList == null || builtInList.size() == 0) {
            throw log.getUnableToFindAnnotationConstraintsException(annotationClass);
        }
        ArrayList<Class<ConstraintValidator<Annotation, ?>>> constraints = CollectionHelper.newArrayList(builtInList.size());
        Iterator<Class<ConstraintValidator<?, ?>>> i$ = builtInList.iterator();
        while (i$.hasNext()) {
            Class<ConstraintValidator<?, ?>> validatorClass;
            Class<ConstraintValidator<?, ?>> safeValidatorClass = validatorClass = i$.next();
            constraints.add(safeValidatorClass);
        }
        return constraints;
    }

    public boolean isBuiltinConstraint(Class<? extends Annotation> annotationType) {
        return this.builtinConstraints.containsKey(annotationType);
    }

    public boolean isMultiValueConstraint(Class<? extends Annotation> annotationType) {
        Class<?> returnType;
        boolean isMultiValueConstraint = false;
        Method method = ConstraintHelper.run(GetMethod.action(annotationType, "value"));
        if (method != null && (returnType = method.getReturnType()).isArray() && returnType.getComponentType().isAnnotation()) {
            Class<?> componentType = returnType.getComponentType();
            isMultiValueConstraint = this.isConstraintAnnotation(componentType) || this.isBuiltinConstraint(componentType);
        }
        return isMultiValueConstraint;
    }

    public <A extends Annotation> List<Annotation> getConstraintsFromMultiValueConstraint(A multiValueConstraint) {
        Annotation[] annotations = ConstraintHelper.run(GetAnnotationParameter.action(multiValueConstraint, "value", Annotation[].class));
        return Arrays.asList(annotations);
    }

    public boolean isConstraintAnnotation(Class<? extends Annotation> annotationType) {
        Constraint constraint = annotationType.getAnnotation(Constraint.class);
        if (constraint == null) {
            return false;
        }
        this.assertMessageParameterExists(annotationType);
        this.assertGroupsParameterExists(annotationType);
        this.assertPayloadParameterExists(annotationType);
        this.assertNoParameterStartsWithValid(annotationType);
        return true;
    }

    private void assertNoParameterStartsWithValid(Class<? extends Annotation> annotationType) {
        Method[] methods;
        for (Method m : methods = ConstraintHelper.run(GetDeclaredMethods.action(annotationType))) {
            if (!m.getName().startsWith("valid")) continue;
            throw log.getConstraintParametersCannotStartWithValidException();
        }
    }

    private void assertPayloadParameterExists(Class<? extends Annotation> annotationType) {
        try {
            Method method = ConstraintHelper.run(GetDeclaredMethod.action(annotationType, "payload", new Class[0]));
            if (method == null) {
                throw log.getConstraintWithoutMandatoryParameterException("payload", annotationType.getName());
            }
            Class[] defaultPayload = (Class[])method.getDefaultValue();
            if (defaultPayload.length != 0) {
                throw log.getWrongDefaultValueForPayloadParameterException(annotationType.getName());
            }
        }
        catch (ClassCastException e) {
            throw log.getWrongTypeForPayloadParameterException(annotationType.getName(), e);
        }
    }

    private void assertGroupsParameterExists(Class<? extends Annotation> annotationType) {
        try {
            Method method = ConstraintHelper.run(GetMethod.action(annotationType, "groups"));
            if (method == null) {
                throw log.getConstraintWithoutMandatoryParameterException("groups", annotationType.getName());
            }
            Class[] defaultGroups = (Class[])method.getDefaultValue();
            if (defaultGroups.length != 0) {
                throw log.getWrongDefaultValueForGroupsParameterException(annotationType.getName());
            }
        }
        catch (ClassCastException e) {
            throw log.getWrongTypeForGroupsParameterException(annotationType.getName(), e);
        }
    }

    private void assertMessageParameterExists(Class<? extends Annotation> annotationType) {
        Method method = ConstraintHelper.run(GetMethod.action(annotationType, "message"));
        if (method == null) {
            throw log.getConstraintWithoutMandatoryParameterException("message", annotationType.getName());
        }
        if (method.getReturnType() != String.class) {
            throw log.getWrongTypeForMessageParameterException(annotationType.getName());
        }
    }

    public <T extends Annotation> List<Class<? extends ConstraintValidator<T, ?>>> getConstraintValidatorDefinition(Class<T> annotationClass) {
        Contracts.assertNotNull(annotationClass, Messages.MESSAGES.classCannotBeNull());
        List<Class<ConstraintValidator<Annotation, ?>>> list = this.constraintValidatorDefinitions.get(annotationClass);
        ArrayList<Class<ConstraintValidator<T, ?>>> constraintsValidators = CollectionHelper.newArrayList(list.size());
        Iterator<Class<ConstraintValidator<Annotation, ?>>> i$ = list.iterator();
        while (i$.hasNext()) {
            Class<ConstraintValidator<Annotation, ?>> validatorClass;
            Class<ConstraintValidator<Annotation, ?>> safeValidatorClass = validatorClass = i$.next();
            constraintsValidators.add(safeValidatorClass);
        }
        return constraintsValidators;
    }

    public <A extends Annotation> void addConstraintValidatorDefinition(Class<A> annotationClass, List<Class<? extends ConstraintValidator<? extends Annotation, ?>>> definitionClasses) {
        this.constraintValidatorDefinitions.putIfAbsent(annotationClass, definitionClasses);
    }

    public boolean containsConstraintValidatorDefinition(Class<? extends Annotation> annotationClass) {
        return this.constraintValidatorDefinitions.containsKey(annotationClass);
    }

    public boolean isConstraintComposition(Class<? extends Annotation> annotationType) {
        return annotationType == ConstraintComposition.class;
    }

    private boolean isJodaTimeInClasspath() {
        boolean isInClasspath;
        try {
            ConstraintHelper.run(LoadClass.action(JODA_TIME_CLASS_NAME, this.getClass()));
            isInClasspath = true;
        }
        catch (ValidationException e) {
            isInClasspath = false;
        }
        return isInClasspath;
    }

    private static <T> T run(PrivilegedAction<T> action) {
        return System.getSecurityManager() != null ? AccessController.doPrivileged(action) : action.run();
    }
}

