/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.community.dialect;

import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.sql.ast.SqlAstWalker;
import org.hibernate.sql.ast.spi.AbstractSqlAstTranslator;
import org.hibernate.sql.ast.tree.Statement;
import org.hibernate.sql.ast.tree.cte.CteMaterialization;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.Literal;
import org.hibernate.sql.ast.tree.expression.Summarization;
import org.hibernate.sql.ast.tree.predicate.BooleanExpressionPredicate;
import org.hibernate.sql.ast.tree.predicate.LikePredicate;
import org.hibernate.sql.ast.tree.select.QueryGroup;
import org.hibernate.sql.ast.tree.select.QueryPart;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.sql.exec.spi.JdbcOperation;

public class CockroachLegacySqlAstTranslator<T extends JdbcOperation>
extends AbstractSqlAstTranslator<T> {
    public CockroachLegacySqlAstTranslator(SessionFactoryImplementor sessionFactory, Statement statement) {
        super(sessionFactory, statement);
    }

    protected void renderExpressionAsClauseItem(Expression expression) {
        expression.accept((SqlAstWalker)this);
    }

    public void visitBooleanExpressionPredicate(BooleanExpressionPredicate booleanExpressionPredicate) {
        if (booleanExpressionPredicate.isNegated()) {
            super.visitBooleanExpressionPredicate(booleanExpressionPredicate);
        } else {
            boolean isNegated = booleanExpressionPredicate.isNegated();
            if (isNegated) {
                this.appendSql("not(");
            }
            booleanExpressionPredicate.getExpression().accept((SqlAstWalker)this);
            if (isNegated) {
                this.appendSql(')');
            }
        }
    }

    protected void renderMaterializationHint(CteMaterialization materialization) {
        if (this.getDialect().getVersion().isSameOrAfter(20, 2)) {
            if (materialization == CteMaterialization.NOT_MATERIALIZED) {
                this.appendSql("not ");
            }
            this.appendSql("materialized ");
        }
    }

    protected boolean supportsRowConstructor() {
        return true;
    }

    protected boolean supportsArrayConstructor() {
        return true;
    }

    protected String getForShare(int timeoutMillis) {
        return " for share";
    }

    protected String getForUpdate() {
        return this.getDialect().getVersion().isBefore(20, 1) ? "" : " for update";
    }

    protected AbstractSqlAstTranslator.LockStrategy determineLockingStrategy(QuerySpec querySpec, AbstractSqlAstTranslator.ForUpdateClause forUpdateClause, Boolean followOnLocking) {
        if (this.getDialect().getVersion().isBefore(20, 1)) {
            return AbstractSqlAstTranslator.LockStrategy.NONE;
        }
        return super.determineLockingStrategy(querySpec, forUpdateClause, followOnLocking);
    }

    protected void renderForUpdateClause(QuerySpec querySpec, AbstractSqlAstTranslator.ForUpdateClause forUpdateClause) {
        if (this.getDialect().getVersion().isBefore(20, 1)) {
            return;
        }
        super.renderForUpdateClause(querySpec, forUpdateClause);
    }

    protected boolean shouldEmulateFetchClause(QueryPart queryPart) {
        return this.useOffsetFetchClause(queryPart) && this.getQueryPartForRowNumbering() != queryPart && !this.isRowsOnlyFetchClauseType(queryPart);
    }

    public void visitQueryGroup(QueryGroup queryGroup) {
        if (this.shouldEmulateFetchClause((QueryPart)queryGroup)) {
            this.emulateFetchOffsetWithWindowFunctions((QueryPart)queryGroup, true);
        } else {
            super.visitQueryGroup(queryGroup);
        }
    }

    public void visitQuerySpec(QuerySpec querySpec) {
        if (this.shouldEmulateFetchClause((QueryPart)querySpec)) {
            this.emulateFetchOffsetWithWindowFunctions((QueryPart)querySpec, true);
        } else {
            super.visitQuerySpec(querySpec);
        }
    }

    public void visitOffsetFetchClause(QueryPart queryPart) {
        if (!this.isRowNumberingCurrentQueryPart()) {
            this.renderLimitOffsetClause(queryPart);
        }
    }

    protected void renderPartitionItem(Expression expression) {
        if (expression instanceof Literal) {
            this.appendSql("'0' || '0'");
        } else {
            if (expression instanceof Summarization) {
                throw new UnsupportedOperationException("Summarization is not supported by DBMS");
            }
            expression.accept((SqlAstWalker)this);
        }
    }

    public void visitLikePredicate(LikePredicate likePredicate) {
        likePredicate.getMatchExpression().accept((SqlAstWalker)this);
        if (likePredicate.isNegated()) {
            this.appendSql(" not");
        }
        if (likePredicate.isCaseSensitive()) {
            this.appendSql(" like ");
        } else {
            this.appendSql(' ');
            this.appendSql(this.getDialect().getCaseInsensitiveLike());
            this.appendSql(' ');
        }
        likePredicate.getPattern().accept((SqlAstWalker)this);
        if (likePredicate.getEscapeCharacter() != null) {
            this.appendSql(" escape ");
            likePredicate.getEscapeCharacter().accept((SqlAstWalker)this);
        } else {
            this.appendSql(" escape ''");
        }
    }

    protected boolean supportsRowValueConstructorSyntaxInQuantifiedPredicates() {
        return false;
    }
}

