/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.community.dialect;

import jakarta.persistence.TemporalType;
import java.sql.SQLException;
import java.time.temporal.TemporalAccessor;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.hibernate.ScrollMode;
import org.hibernate.boot.model.FunctionContributions;
import org.hibernate.boot.model.TypeContributions;
import org.hibernate.boot.model.relational.SqlStringGenerationContext;
import org.hibernate.community.dialect.SQLiteSqlAstTranslator;
import org.hibernate.community.dialect.identity.SQLiteIdentityColumnSupport;
import org.hibernate.dialect.DatabaseVersion;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.NationalizationSupport;
import org.hibernate.dialect.Replacer;
import org.hibernate.dialect.function.CommonFunctionFactory;
import org.hibernate.dialect.identity.IdentityColumnSupport;
import org.hibernate.dialect.pagination.LimitHandler;
import org.hibernate.dialect.pagination.LimitOffsetLimitHandler;
import org.hibernate.dialect.unique.AlterTableUniqueDelegate;
import org.hibernate.dialect.unique.UniqueDelegate;
import org.hibernate.engine.jdbc.dialect.spi.DialectResolutionInfo;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.exception.DataException;
import org.hibernate.exception.JDBCConnectionException;
import org.hibernate.exception.LockAcquisitionException;
import org.hibernate.exception.spi.SQLExceptionConversionDelegate;
import org.hibernate.exception.spi.TemplatedViolatedConstraintNameExtractor;
import org.hibernate.exception.spi.ViolatedConstraintNameExtractor;
import org.hibernate.internal.util.JdbcExceptionHelper;
import org.hibernate.mapping.Column;
import org.hibernate.query.SemanticException;
import org.hibernate.query.sqm.IntervalType;
import org.hibernate.query.sqm.NullOrdering;
import org.hibernate.query.sqm.TemporalUnit;
import org.hibernate.query.sqm.TrimSpec;
import org.hibernate.query.sqm.produce.function.FunctionParameterType;
import org.hibernate.query.sqm.produce.function.StandardFunctionReturnTypeResolvers;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.sql.ast.SqlAstNodeRenderingMode;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.SqlAstTranslatorFactory;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.spi.StandardSqlAstTranslatorFactory;
import org.hibernate.sql.ast.tree.Statement;
import org.hibernate.sql.exec.spi.JdbcOperation;
import org.hibernate.type.BasicType;
import org.hibernate.type.BasicTypeRegistry;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.descriptor.DateTimeUtils;
import org.hibernate.type.descriptor.jdbc.BlobJdbcType;
import org.hibernate.type.descriptor.jdbc.ClobJdbcType;
import org.hibernate.type.descriptor.jdbc.JdbcType;
import org.hibernate.type.descriptor.jdbc.spi.JdbcTypeRegistry;

public class SQLiteDialect
extends Dialect {
    private static final SQLiteIdentityColumnSupport IDENTITY_COLUMN_SUPPORT = new SQLiteIdentityColumnSupport();
    private final UniqueDelegate uniqueDelegate = new SQLiteUniqueDelegate(this);
    private static final int SQLITE_BUSY = 5;
    private static final int SQLITE_LOCKED = 6;
    private static final int SQLITE_IOERR = 10;
    private static final int SQLITE_CORRUPT = 11;
    private static final int SQLITE_NOTFOUND = 12;
    private static final int SQLITE_FULL = 13;
    private static final int SQLITE_CANTOPEN = 14;
    private static final int SQLITE_PROTOCOL = 15;
    private static final int SQLITE_TOOBIG = 18;
    private static final int SQLITE_CONSTRAINT = 19;
    private static final int SQLITE_MISMATCH = 20;
    private static final int SQLITE_NOTADB = 26;
    private static final ViolatedConstraintNameExtractor EXTRACTOR = new TemplatedViolatedConstraintNameExtractor(sqle -> {
        int errorCode = JdbcExceptionHelper.extractErrorCode((SQLException)sqle);
        if (errorCode == 19) {
            return TemplatedViolatedConstraintNameExtractor.extractUsingTemplate((String)"constraint ", (String)" failed", (String)sqle.getMessage());
        }
        return null;
    });

    public SQLiteDialect(DialectResolutionInfo info) {
        this(info.makeCopy());
        this.registerKeywords(info);
    }

    public SQLiteDialect() {
        this(DatabaseVersion.make((Integer)2, (Integer)0));
    }

    public SQLiteDialect(DatabaseVersion version) {
        super(version);
    }

    protected String columnType(int sqlTypeCode) {
        switch (sqlTypeCode) {
            case 3: {
                return this.getVersion().isBefore(3) ? this.columnType(2) : super.columnType(sqlTypeCode);
            }
            case 1: {
                return this.getVersion().isBefore(3) ? "char" : super.columnType(sqlTypeCode);
            }
            case -15: {
                return this.getVersion().isBefore(3) ? "nchar" : super.columnType(sqlTypeCode);
            }
            case 6: {
                return "float";
            }
            case 93: 
            case 2014: {
                return "timestamp";
            }
            case 2013: {
                return "time";
            }
            case -3: 
            case -2: {
                return "blob";
            }
        }
        return super.columnType(sqlTypeCode);
    }

    public int getMaxVarbinaryLength() {
        return -1;
    }

    public UniqueDelegate getUniqueDelegate() {
        return this.uniqueDelegate;
    }

    public String extractPattern(TemporalUnit unit) {
        switch (unit) {
            case SECOND: {
                return "cast(strftime('%S.%f',?2) as double)";
            }
            case MINUTE: {
                return "strftime('%M',?2)";
            }
            case HOUR: {
                return "strftime('%H',?2)";
            }
            case DAY: 
            case DAY_OF_MONTH: {
                return "(strftime('%d',?2)+1)";
            }
            case MONTH: {
                return "strftime('%m',?2)";
            }
            case YEAR: {
                return "strftime('%Y',?2)";
            }
            case DAY_OF_WEEK: {
                return "(strftime('%w',?2)+1)";
            }
            case DAY_OF_YEAR: {
                return "strftime('%j',?2)";
            }
            case EPOCH: {
                return "strftime('%s',?2)";
            }
            case WEEK: {
                return "((strftime('%j',date(?2,'-3 days','weekday 4'))-1)/7+1)";
            }
        }
        return super.extractPattern(unit);
    }

    public String timestampaddPattern(TemporalUnit unit, TemporalType temporalType, IntervalType intervalType) {
        String function = temporalType == TemporalType.DATE ? "date" : "datetime";
        switch (unit) {
            case NANOSECOND: 
            case NATIVE: {
                return "datetime(?3,'+?2 seconds')";
            }
            case QUARTER: {
                return function + "(?3,'+'||(?2*3)||' months')";
            }
            case WEEK: {
                return function + "(?3,'+'||(?2*7)||' days')";
            }
        }
        return function + "(?3,'+?2 ?1s')";
    }

    public String timestampdiffPattern(TemporalUnit unit, TemporalType fromTemporalType, TemporalType toTemporalType) {
        StringBuilder pattern = new StringBuilder();
        switch (unit) {
            case YEAR: {
                this.extractField(pattern, TemporalUnit.YEAR, unit);
                break;
            }
            case QUARTER: {
                pattern.append("(");
                this.extractField(pattern, TemporalUnit.YEAR, unit);
                pattern.append("+");
                this.extractField(pattern, TemporalUnit.QUARTER, unit);
                pattern.append(")");
                break;
            }
            case MONTH: {
                pattern.append("(");
                this.extractField(pattern, TemporalUnit.YEAR, unit);
                pattern.append("+");
                this.extractField(pattern, TemporalUnit.MONTH, unit);
                pattern.append(")");
                break;
            }
            case DAY: 
            case WEEK: {
                this.extractField(pattern, TemporalUnit.DAY, unit);
                break;
            }
            case SECOND: 
            case MINUTE: 
            case HOUR: 
            case NANOSECOND: 
            case NATIVE: {
                this.extractField(pattern, TemporalUnit.EPOCH, unit);
                break;
            }
            default: {
                throw new SemanticException("unrecognized field: " + unit);
            }
        }
        return pattern.toString();
    }

    private void extractField(StringBuilder pattern, TemporalUnit unit, TemporalUnit toUnit) {
        String rhs = this.extractPattern(unit);
        String lhs = rhs.replace("?2", "?3");
        pattern.append('(');
        pattern.append(lhs);
        pattern.append('-');
        pattern.append(rhs);
        pattern.append(")").append(unit.conversionFactor(toUnit, (Dialect)this));
    }

    public void initializeFunctionRegistry(FunctionContributions functionContributions) {
        super.initializeFunctionRegistry(functionContributions);
        BasicTypeRegistry basicTypeRegistry = functionContributions.getTypeConfiguration().getBasicTypeRegistry();
        BasicType stringType = basicTypeRegistry.resolve(StandardBasicTypes.STRING);
        BasicType integerType = basicTypeRegistry.resolve(StandardBasicTypes.INTEGER);
        CommonFunctionFactory functionFactory = new CommonFunctionFactory(functionContributions);
        functionFactory.mod_operator();
        functionFactory.leftRight_substr();
        functionFactory.concat_pipeOperator();
        functionFactory.characterLength_length(SqlAstNodeRenderingMode.DEFAULT);
        functionFactory.leastGreatest_minMax();
        functionFactory.radians();
        functionFactory.degrees();
        functionFactory.trunc();
        functionFactory.log();
        functionFactory.trim2();
        functionFactory.substr();
        functionFactory.substring_substr();
        functionFactory.chr_char();
        functionContributions.getFunctionRegistry().registerBinaryTernaryPattern("locate", integerType, "instr(?2,?1)", "instr(?2,?1,?3)", FunctionParameterType.STRING, FunctionParameterType.STRING, FunctionParameterType.INTEGER, functionContributions.getTypeConfiguration()).setArgumentListSignature("(pattern, string[, start])");
        functionContributions.getFunctionRegistry().registerBinaryTernaryPattern("lpad", stringType, "(substr(replace(hex(zeroblob(?2)),'00',' '),1,?2-length(?1))||?1)", "(substr(replace(hex(zeroblob(?2)),'00',?3),1,?2-length(?1))||?1)", FunctionParameterType.STRING, FunctionParameterType.INTEGER, FunctionParameterType.STRING, functionContributions.getTypeConfiguration()).setArgumentListSignature("(string, length[, padding])");
        functionContributions.getFunctionRegistry().registerBinaryTernaryPattern("rpad", stringType, "(?1||substr(replace(hex(zeroblob(?2)),'00',' '),1,?2-length(?1)))", "(?1||substr(replace(hex(zeroblob(?2)),'00',?3),1,?2-length(?1)))", FunctionParameterType.STRING, FunctionParameterType.INTEGER, FunctionParameterType.STRING, functionContributions.getTypeConfiguration()).setArgumentListSignature("(string, length[, padding])");
        functionContributions.getFunctionRegistry().namedDescriptorBuilder("format", "strftime").setInvariantType(stringType).setExactArgumentCount(2).setParameterTypes(new FunctionParameterType[]{FunctionParameterType.TEMPORAL, FunctionParameterType.STRING}).setArgumentListSignature("(TEMPORAL datetime as STRING pattern)").register();
        if (!this.supportsMathFunctions()) {
            functionContributions.getFunctionRegistry().patternDescriptorBuilder("floor", "(cast(?1 as int)-(?1<cast(?1 as int)))").setReturnTypeResolver(StandardFunctionReturnTypeResolvers.useArgType((int)1)).setExactArgumentCount(1).setParameterTypes(new FunctionParameterType[]{FunctionParameterType.NUMERIC}).register();
            functionContributions.getFunctionRegistry().patternDescriptorBuilder("ceiling", "(cast(?1 as int)+(?1>cast(?1 as int)))").setReturnTypeResolver(StandardFunctionReturnTypeResolvers.useArgType((int)1)).setExactArgumentCount(1).setParameterTypes(new FunctionParameterType[]{FunctionParameterType.NUMERIC}).register();
        }
        functionFactory.windowFunctions();
        functionFactory.listagg_groupConcat();
    }

    public String trimPattern(TrimSpec specification, char character) {
        switch (specification) {
            case BOTH: {
                return character == ' ' ? "trim(?1)" : "trim(?1,'" + character + "')";
            }
            case LEADING: {
                return character == ' ' ? "ltrim(?1)" : "ltrim(?1,'" + character + "')";
            }
            case TRAILING: {
                return character == ' ' ? "rtrim(?1)" : "rtrim(?1,'" + character + "')";
            }
        }
        throw new UnsupportedOperationException("Unsupported specification: " + specification);
    }

    protected boolean supportsMathFunctions() {
        return true;
    }

    public void contributeTypes(TypeContributions typeContributions, ServiceRegistry serviceRegistry) {
        super.contributeTypes(typeContributions, serviceRegistry);
        JdbcTypeRegistry jdbcTypeRegistry = typeContributions.getTypeConfiguration().getJdbcTypeRegistry();
        jdbcTypeRegistry.addDescriptor(2004, (JdbcType)BlobJdbcType.PRIMITIVE_ARRAY_BINDING);
        jdbcTypeRegistry.addDescriptor(2005, (JdbcType)ClobJdbcType.STRING_BINDING);
    }

    public LimitHandler getLimitHandler() {
        return LimitOffsetLimitHandler.INSTANCE;
    }

    public boolean supportsLockTimeouts() {
        return false;
    }

    public String getForUpdateString() {
        return "";
    }

    public boolean supportsOuterJoinForUpdate() {
        return false;
    }

    public boolean supportsNullPrecedence() {
        return this.getVersion().isSameOrAfter(3, 3);
    }

    public NullOrdering getNullOrdering() {
        return NullOrdering.SMALLEST;
    }

    public SqlAstTranslatorFactory getSqlAstTranslatorFactory() {
        return new StandardSqlAstTranslatorFactory(){

            protected <T extends JdbcOperation> SqlAstTranslator<T> buildTranslator(SessionFactoryImplementor sessionFactory, Statement statement) {
                return new SQLiteSqlAstTranslator(sessionFactory, statement);
            }
        };
    }

    public ViolatedConstraintNameExtractor getViolatedConstraintNameExtractor() {
        return EXTRACTOR;
    }

    public SQLExceptionConversionDelegate buildSQLExceptionConversionDelegate() {
        return (sqlException, message, sql) -> {
            int errorCode = JdbcExceptionHelper.extractErrorCode((SQLException)sqlException);
            switch (errorCode) {
                case 18: 
                case 20: {
                    return new DataException(message, sqlException, sql);
                }
                case 5: 
                case 6: {
                    return new LockAcquisitionException(message, sqlException, sql);
                }
                case 26: {
                    return new JDBCConnectionException(message, sqlException, sql);
                }
            }
            if (errorCode >= 10 && errorCode <= 15) {
                return new JDBCConnectionException(message, sqlException, sql);
            }
            return null;
        };
    }

    public boolean canCreateSchema() {
        return false;
    }

    public boolean hasAlterTable() {
        return false;
    }

    public boolean dropConstraints() {
        return false;
    }

    public boolean qualifyIndexName() {
        return false;
    }

    public String getDropForeignKeyString() {
        throw new UnsupportedOperationException("No drop foreign key syntax supported by SQLiteDialect");
    }

    public String getAddForeignKeyConstraintString(String constraintName, String[] foreignKey, String referencedTable, String[] primaryKey, boolean referencesPrimaryKey) {
        throw new UnsupportedOperationException("No add foreign key syntax supported by SQLiteDialect");
    }

    public String getAddPrimaryKeyConstraintString(String constraintName) {
        throw new UnsupportedOperationException("No add primary key syntax supported by SQLiteDialect");
    }

    public boolean supportsCommentOn() {
        return true;
    }

    public boolean supportsIfExistsBeforeTableName() {
        return true;
    }

    public boolean doesReadCommittedCauseWritersToBlockReaders() {
        return true;
    }

    public boolean doesRepeatableReadCauseReadersToBlockWriters() {
        return true;
    }

    public boolean supportsTupleDistinctCounts() {
        return false;
    }

    public int getInExpressionCountLimit() {
        return 1000;
    }

    public boolean supportsWindowFunctions() {
        return true;
    }

    public IdentityColumnSupport getIdentityColumnSupport() {
        return IDENTITY_COLUMN_SUPPORT;
    }

    public String getSelectGUIDString() {
        return "select hex(randomblob(16))";
    }

    public ScrollMode defaultScrollMode() {
        return ScrollMode.FORWARD_ONLY;
    }

    public String getNoColumnsInsertString() {
        return "default values";
    }

    public NationalizationSupport getNationalizationSupport() {
        return NationalizationSupport.IMPLICIT;
    }

    public String currentDate() {
        return "date('now')";
    }

    public String currentTime() {
        return "time('now')";
    }

    public String currentTimestamp() {
        return "datetime('now')";
    }

    public void appendDatetimeFormat(SqlAppender appender, String format) {
        appender.appendSql(SQLiteDialect.datetimeFormat(format).result());
    }

    public static Replacer datetimeFormat(String format) {
        return new Replacer(format, "'", "").replace("%", "%%").replace("yyyy", "%Y").replace("yyy", "%Y").replace("yy", "%y").replace("y", "%y").replace("MMMM", "%B").replace("MMM", "%b").replace("MM", "%m").replace("M", "%m").replace("EEEE", "%A").replace("EEE", "%a").replace("ee", "%w").replace("e", "%w").replace("dd", "%d").replace("d", "%d").replace("a", "%p").replace("hh", "%I").replace("HH", "%H").replace("h", "%I").replace("H", "%H").replace("mm", "%M").replace("m", "%M").replace("ss", "%S").replace("s", "%S").replace("SSSSSS", "%f").replace("SSSSS", "%f").replace("SSSS", "%f").replace("SSS", "%f").replace("SS", "%f").replace("S", "%f");
    }

    public String translateExtractField(TemporalUnit unit) {
        throw new UnsupportedOperationException("Unsupported unit: " + unit);
    }

    public void appendDateTimeLiteral(SqlAppender appender, TemporalAccessor temporalAccessor, TemporalType precision, TimeZone jdbcTimeZone) {
        switch (precision) {
            case DATE: {
                appender.appendSql("date(");
                DateTimeUtils.appendAsDate((SqlAppender)appender, (TemporalAccessor)temporalAccessor);
                appender.appendSql(')');
                break;
            }
            case TIME: {
                appender.appendSql("time(");
                DateTimeUtils.appendAsTime((SqlAppender)appender, (TemporalAccessor)temporalAccessor, (boolean)this.supportsTemporalLiteralOffset(), (TimeZone)jdbcTimeZone);
                appender.appendSql(')');
                break;
            }
            case TIMESTAMP: {
                appender.appendSql("datetime(");
                DateTimeUtils.appendAsTimestampWithNanos((SqlAppender)appender, (TemporalAccessor)temporalAccessor, (boolean)this.supportsTemporalLiteralOffset(), (TimeZone)jdbcTimeZone);
                appender.appendSql(')');
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public void appendDateTimeLiteral(SqlAppender appender, Date date, TemporalType precision, TimeZone jdbcTimeZone) {
        switch (precision) {
            case DATE: {
                appender.appendSql("date(");
                DateTimeUtils.appendAsDate((SqlAppender)appender, (Date)date);
                appender.appendSql(')');
                break;
            }
            case TIME: {
                appender.appendSql("time(");
                DateTimeUtils.appendAsTime((SqlAppender)appender, (Date)date);
                appender.appendSql(')');
                break;
            }
            case TIMESTAMP: {
                appender.appendSql("datetime(");
                DateTimeUtils.appendAsTimestampWithNanos((SqlAppender)appender, (Date)date, (TimeZone)jdbcTimeZone);
                appender.appendSql(')');
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public void appendDateTimeLiteral(SqlAppender appender, Calendar calendar, TemporalType precision, TimeZone jdbcTimeZone) {
        switch (precision) {
            case DATE: {
                appender.appendSql("date(");
                DateTimeUtils.appendAsDate((SqlAppender)appender, (Calendar)calendar);
                appender.appendSql(')');
                break;
            }
            case TIME: {
                appender.appendSql("time(");
                DateTimeUtils.appendAsTime((SqlAppender)appender, (Calendar)calendar);
                appender.appendSql(')');
                break;
            }
            case TIMESTAMP: {
                appender.appendSql("datetime(");
                DateTimeUtils.appendAsTimestampWithMillis((SqlAppender)appender, (Calendar)calendar, (TimeZone)jdbcTimeZone);
                appender.appendSql(')');
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    private static class SQLiteUniqueDelegate
    extends AlterTableUniqueDelegate {
        public SQLiteUniqueDelegate(Dialect dialect) {
            super(dialect);
        }

        public String getColumnDefinitionUniquenessFragment(Column column, SqlStringGenerationContext context) {
            return " unique";
        }
    }
}

