/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.community.dialect;

import java.util.List;
import java.util.function.Consumer;
import org.hibernate.LockMode;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.metamodel.mapping.BasicValuedMapping;
import org.hibernate.query.sqm.ComparisonOperator;
import org.hibernate.sql.ast.SqlAstJoinType;
import org.hibernate.sql.ast.SqlAstNodeRenderingMode;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.SqlAstWalker;
import org.hibernate.sql.ast.spi.AbstractSqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.spi.SqlSelection;
import org.hibernate.sql.ast.tree.Statement;
import org.hibernate.sql.ast.tree.expression.AggregateColumnWriteExpression;
import org.hibernate.sql.ast.tree.expression.BinaryArithmeticExpression;
import org.hibernate.sql.ast.tree.expression.CaseSearchedExpression;
import org.hibernate.sql.ast.tree.expression.CaseSimpleExpression;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.Literal;
import org.hibernate.sql.ast.tree.expression.QueryLiteral;
import org.hibernate.sql.ast.tree.expression.SqlTuple;
import org.hibernate.sql.ast.tree.expression.Summarization;
import org.hibernate.sql.ast.tree.from.NamedTableReference;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableGroupJoin;
import org.hibernate.sql.ast.tree.from.UnionTableReference;
import org.hibernate.sql.ast.tree.predicate.BooleanExpressionPredicate;
import org.hibernate.sql.ast.tree.predicate.Predicate;
import org.hibernate.sql.ast.tree.select.QueryGroup;
import org.hibernate.sql.ast.tree.select.QueryPart;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.sql.ast.tree.select.SelectClause;
import org.hibernate.sql.exec.spi.JdbcOperation;

public class SybaseASELegacySqlAstTranslator<T extends JdbcOperation>
extends AbstractSqlAstTranslator<T> {
    public SybaseASELegacySqlAstTranslator(SessionFactoryImplementor sessionFactory, Statement statement) {
        super(sessionFactory, statement);
    }

    protected boolean supportsWithClause() {
        return false;
    }

    protected void visitAnsiCaseSearchedExpression(CaseSearchedExpression caseSearchedExpression, Consumer<Expression> resultRenderer) {
        if (this.getParameterRenderingMode() == SqlAstNodeRenderingMode.DEFAULT && this.areAllResultsParameters(caseSearchedExpression)) {
            List whenFragments = caseSearchedExpression.getWhenFragments();
            Expression firstResult = ((CaseSearchedExpression.WhenFragment)whenFragments.get(0)).getResult();
            super.visitAnsiCaseSearchedExpression(caseSearchedExpression, e -> {
                if (e == firstResult) {
                    this.renderCasted((Expression)e);
                } else {
                    resultRenderer.accept((Expression)e);
                }
            });
        } else {
            super.visitAnsiCaseSearchedExpression(caseSearchedExpression, resultRenderer);
        }
    }

    protected void visitAnsiCaseSimpleExpression(CaseSimpleExpression caseSimpleExpression, Consumer<Expression> resultRenderer) {
        if (this.getParameterRenderingMode() == SqlAstNodeRenderingMode.DEFAULT && this.areAllResultsParameters(caseSimpleExpression)) {
            List whenFragments = caseSimpleExpression.getWhenFragments();
            Expression firstResult = ((CaseSimpleExpression.WhenFragment)whenFragments.get(0)).getResult();
            super.visitAnsiCaseSimpleExpression(caseSimpleExpression, e -> {
                if (e == firstResult) {
                    this.renderCasted((Expression)e);
                } else {
                    resultRenderer.accept((Expression)e);
                }
            });
        } else {
            super.visitAnsiCaseSimpleExpression(caseSimpleExpression, resultRenderer);
        }
    }

    protected boolean renderNamedTableReference(NamedTableReference tableReference, LockMode lockMode) {
        super.renderNamedTableReference(tableReference, lockMode);
        if (this.getDialect().getVersion().isBefore(15, 7)) {
            if (LockMode.READ.lessThan(lockMode)) {
                this.appendSql(" holdlock");
            }
            return true;
        }
        return false;
    }

    protected void renderTableGroupJoin(TableGroupJoin tableGroupJoin, List<TableGroupJoin> tableGroupJoinCollector) {
        if (tableGroupJoin.getJoinType() == SqlAstJoinType.CROSS) {
            this.appendSql(", ");
        } else {
            this.appendSql(' ');
            this.appendSql(tableGroupJoin.getJoinType().getText());
            this.appendSql("join ");
        }
        Object predicate = tableGroupJoin.getPredicate() == null ? (tableGroupJoin.getJoinType() == SqlAstJoinType.CROSS ? null : new BooleanExpressionPredicate((Expression)new QueryLiteral((Object)true, (BasicValuedMapping)this.getBooleanType()))) : tableGroupJoin.getPredicate();
        if (predicate != null && !predicate.isEmpty()) {
            this.renderTableGroup(tableGroupJoin.getJoinedGroup(), (Predicate)predicate, tableGroupJoinCollector);
        } else {
            this.renderTableGroup(tableGroupJoin.getJoinedGroup(), null, tableGroupJoinCollector);
        }
    }

    protected void renderForUpdateClause(QuerySpec querySpec, AbstractSqlAstTranslator.ForUpdateClause forUpdateClause) {
        if (this.getDialect().getVersion().isBefore(15, 7)) {
            return;
        }
        super.renderForUpdateClause(querySpec, forUpdateClause);
    }

    protected void visitSqlSelections(SelectClause selectClause) {
        if (this.supportsTopClause()) {
            this.renderTopClause((QuerySpec)this.getQueryPartStack().getCurrent(), true, false);
        }
        super.visitSqlSelections(selectClause);
    }

    protected void renderFetchPlusOffsetExpression(Expression fetchClauseExpression, Expression offsetClauseExpression, int offset) {
        this.renderFetchPlusOffsetExpressionAsLiteral(fetchClauseExpression, offsetClauseExpression, offset);
    }

    public void visitQueryGroup(QueryGroup queryGroup) {
        if (queryGroup.hasSortSpecifications() || queryGroup.hasOffsetOrFetchClause()) {
            this.appendSql("select ");
            this.renderTopClause(queryGroup.getOffsetClauseExpression(), queryGroup.getFetchClauseExpression(), queryGroup.getFetchClauseType(), true, false);
            this.appendSql("* from (");
            this.renderQueryGroup(queryGroup, false);
            this.appendSql(") grp_(c0");
            int itemCount = queryGroup.getFirstQuerySpec().getSelectClause().getSqlSelections().size();
            for (int i = 1; i < itemCount; ++i) {
                this.appendSql(",c");
                this.appendSql(i);
            }
            this.appendSql(')');
            this.visitOrderBy(queryGroup.getSortSpecifications());
        } else {
            super.visitQueryGroup(queryGroup);
        }
    }

    public void visitOffsetFetchClause(QueryPart queryPart) {
        this.assertRowsOnlyFetchClauseType(queryPart);
        if (!queryPart.isRoot() && queryPart.hasOffsetOrFetchClause() && (queryPart.getFetchClauseExpression() != null && !this.supportsTopClause() || queryPart.getOffsetClauseExpression() != null)) {
            throw new IllegalArgumentException("Can't emulate offset fetch clause in subquery");
        }
    }

    protected void renderFetchExpression(Expression fetchExpression) {
        if (this.supportsParameterOffsetFetchExpression()) {
            super.renderFetchExpression(fetchExpression);
        } else {
            this.renderExpressionAsLiteral(fetchExpression, this.getJdbcParameterBindings());
        }
    }

    protected void renderOffsetExpression(Expression offsetExpression) {
        if (this.supportsParameterOffsetFetchExpression()) {
            super.renderOffsetExpression(offsetExpression);
        } else {
            this.renderExpressionAsLiteral(offsetExpression, this.getJdbcParameterBindings());
        }
    }

    protected void renderComparison(Expression lhs, ComparisonOperator operator, Expression rhs) {
        if (this.getDialect().isAnsiNullOn()) {
            if (this.supportsDistinctFromPredicate()) {
                this.renderComparisonEmulateIntersect(lhs, operator, rhs);
            } else {
                this.renderComparisonEmulateCase(lhs, operator, rhs);
            }
        } else {
            boolean lhsNotNullPredicate;
            boolean rhsNotNullPredicate = lhs instanceof Literal || this.isParameter(lhs);
            boolean bl = lhsNotNullPredicate = rhs instanceof Literal || this.isParameter(rhs);
            if (rhsNotNullPredicate || lhsNotNullPredicate) {
                lhs.accept((SqlAstWalker)this);
                switch (operator) {
                    case DISTINCT_FROM: {
                        this.appendSql("<>");
                        break;
                    }
                    case NOT_DISTINCT_FROM: {
                        this.appendSql('=');
                        break;
                    }
                    case LESS_THAN: 
                    case GREATER_THAN: 
                    case LESS_THAN_OR_EQUAL: 
                    case GREATER_THAN_OR_EQUAL: {
                        lhsNotNullPredicate = false;
                        rhsNotNullPredicate = false;
                    }
                    default: {
                        this.appendSql(operator.sqlText());
                    }
                }
                rhs.accept((SqlAstWalker)this);
                if (lhsNotNullPredicate) {
                    this.appendSql(" and ");
                    lhs.accept((SqlAstWalker)this);
                    this.appendSql(" is not null");
                }
                if (rhsNotNullPredicate) {
                    this.appendSql(" and ");
                    rhs.accept((SqlAstWalker)this);
                    this.appendSql(" is not null");
                }
            } else if (this.supportsDistinctFromPredicate()) {
                this.renderComparisonEmulateIntersect(lhs, operator, rhs);
            } else {
                this.renderComparisonEmulateCase(lhs, operator, rhs);
            }
        }
    }

    protected boolean supportsIntersect() {
        return false;
    }

    protected void renderSelectTupleComparison(List<SqlSelection> lhsExpressions, SqlTuple tuple, ComparisonOperator operator) {
        this.emulateSelectTupleComparison(lhsExpressions, tuple.getExpressions(), operator, true);
    }

    protected void renderPartitionItem(Expression expression) {
        if (expression instanceof Literal) {
            this.appendSql("dummy_.x");
        } else {
            if (expression instanceof Summarization) {
                throw new UnsupportedOperationException("Summarization is not supported by DBMS");
            }
            expression.accept((SqlAstWalker)this);
        }
    }

    public void visitBinaryArithmeticExpression(BinaryArithmeticExpression arithmeticExpression) {
        this.appendSql('(');
        arithmeticExpression.getLeftHandOperand().accept((SqlAstWalker)this);
        this.appendSql(arithmeticExpression.getOperator().getOperatorSqlTextString());
        arithmeticExpression.getRightHandOperand().accept((SqlAstWalker)this);
        this.appendSql(')');
    }

    public void visitColumnReference(ColumnReference columnReference) {
        String dmlTargetTableAlias = this.getDmlTargetTableAlias();
        if (dmlTargetTableAlias != null && dmlTargetTableAlias.equals(columnReference.getQualifier())) {
            List roots;
            QuerySpec currentQuerySpec = (QuerySpec)this.getQueryPartStack().getCurrent();
            if (currentQuerySpec != null && !currentQuerySpec.isRoot() && (roots = currentQuerySpec.getFromClause().getRoots()).size() == 1 && ((TableGroup)roots.get(0)).getPrimaryTableReference() instanceof UnionTableReference) {
                columnReference.appendReadExpression((SqlAppender)this);
            } else if (columnReference.isColumnExpressionFormula()) {
                this.appendSql(columnReference.getColumnExpression().replaceAll("(\\b)(" + dmlTargetTableAlias + "\\.)(\\b)", "$1$3"));
            } else {
                columnReference.appendReadExpression((SqlAppender)this, this.getCurrentDmlStatement().getTargetTable().getTableExpression());
            }
        } else {
            columnReference.appendReadExpression((SqlAppender)this);
        }
    }

    public void visitAggregateColumnWriteExpression(AggregateColumnWriteExpression aggregateColumnWriteExpression) {
        String dmlTargetTableAlias = this.getDmlTargetTableAlias();
        ColumnReference columnReference = aggregateColumnWriteExpression.getColumnReference();
        if (dmlTargetTableAlias != null && dmlTargetTableAlias.equals(columnReference.getQualifier())) {
            List roots;
            QuerySpec currentQuerySpec = (QuerySpec)this.getQueryPartStack().getCurrent();
            if (currentQuerySpec != null && !currentQuerySpec.isRoot() && (roots = currentQuerySpec.getFromClause().getRoots()).size() == 1 && ((TableGroup)roots.get(0)).getPrimaryTableReference() instanceof UnionTableReference) {
                aggregateColumnWriteExpression.appendWriteExpression((SqlAstTranslator)this, (SqlAppender)this);
            } else {
                aggregateColumnWriteExpression.appendWriteExpression((SqlAstTranslator)this, (SqlAppender)this, this.getCurrentDmlStatement().getTargetTable().getTableExpression());
            }
        } else {
            aggregateColumnWriteExpression.appendWriteExpression((SqlAstTranslator)this, (SqlAppender)this);
        }
    }

    protected boolean needsRowsToSkip() {
        return true;
    }

    protected boolean needsMaxRows() {
        return !this.supportsTopClause();
    }

    protected boolean supportsRowValueConstructorSyntax() {
        return false;
    }

    protected boolean supportsRowValueConstructorSyntaxInInList() {
        return false;
    }

    protected boolean supportsRowValueConstructorSyntaxInQuantifiedPredicates() {
        return false;
    }

    protected String getFromDual() {
        return " from (select 1) dual(c1)";
    }

    private boolean supportsTopClause() {
        return this.getDialect().getVersion().isSameOrAfter(12, 5);
    }

    private boolean supportsParameterOffsetFetchExpression() {
        return false;
    }
}

