/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.processor.util;

import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.hibernate.processor.util.AccessType;

public class AccessTypeInformation {
    private final @UnknownKeyFor @NonNull @Initialized String fqcn;
    private @Nullable @UnknownKeyFor @Initialized AccessType explicitAccessType;
    private @Nullable @UnknownKeyFor @Initialized AccessType defaultAccessType;
    static final @UnknownKeyFor @NonNull @Initialized AccessType DEFAULT_ACCESS_TYPE = AccessType.FIELD;

    public AccessTypeInformation(@UnknownKeyFor @NonNull @Initialized String fqcn, @Nullable @UnknownKeyFor @Initialized AccessType explicitAccessType, @Nullable @UnknownKeyFor @Initialized AccessType defaultAccessType) {
        this.fqcn = fqcn;
        this.explicitAccessType = explicitAccessType;
        this.defaultAccessType = defaultAccessType;
    }

    public @UnknownKeyFor @NonNull @Initialized boolean isAccessTypeResolved() {
        return this.explicitAccessType != null || this.defaultAccessType != null;
    }

    public @UnknownKeyFor @NonNull @Initialized AccessType getAccessType() {
        if (this.explicitAccessType != null) {
            return this.explicitAccessType;
        }
        if (this.defaultAccessType != null) {
            return this.defaultAccessType;
        }
        return DEFAULT_ACCESS_TYPE;
    }

    public void setDefaultAccessType(@UnknownKeyFor @NonNull @Initialized AccessType defaultAccessType) {
        this.defaultAccessType = defaultAccessType;
    }

    public void setExplicitAccessType(@UnknownKeyFor @NonNull @Initialized AccessType explicitAccessType) {
        this.explicitAccessType = explicitAccessType;
    }

    public @Nullable @UnknownKeyFor @Initialized AccessType getDefaultAccessType() {
        return this.defaultAccessType;
    }

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("AccessTypeInformation");
        sb.append("{fqcn='").append(this.fqcn).append('\'');
        sb.append(", explicitAccessType=").append((Object)this.explicitAccessType);
        sb.append(", defaultAccessType=").append((Object)this.defaultAccessType);
        sb.append('}');
        return sb.toString();
    }
}

