/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.processor.annotation;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.hibernate.AssertionFailure;
import org.hibernate.processor.annotation.AbstractAnnotatedMethod;
import org.hibernate.processor.annotation.AnnotationMetaEntity;
import org.hibernate.processor.annotation.OrderBy;
import org.hibernate.processor.util.Constants;
import org.hibernate.processor.util.TypeUtils;

public abstract class AbstractQueryMethod
extends AbstractAnnotatedMethod {
    final @UnknownKeyFor @NonNull @Initialized String methodName;
    final @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> paramNames;
    final @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> paramTypes;
    final @Nullable @UnknownKeyFor @Initialized String returnTypeName;
    final @UnknownKeyFor @NonNull @Initialized boolean belongsToDao;
    final @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized OrderBy> orderBys;
    final @UnknownKeyFor @NonNull @Initialized boolean addNonnullAnnotation;
    final @UnknownKeyFor @NonNull @Initialized boolean dataRepository;
    final @UnknownKeyFor @NonNull @Initialized String fullReturnType;
    final @UnknownKeyFor @NonNull @Initialized boolean nullable;
    static final @UnknownKeyFor @NonNull @Initialized String MAKE_KEYED_SLICE = "\t\tvar _cursors =\n\t\t\t\t_results.getKeyList()\n\t\t\t\t\t\t.stream()\n\t\t\t\t\t\t.map(_key -> Cursor.forKey(_key.toArray()))\n\t\t\t\t\t\t.collect(toList());\n\t\treturn new CursoredPageRecord<>(_results.getResultList(), _cursors, _totalResults, pageRequest,\n\t\t\t\t_results.isLastPage() ? null : afterCursor(_cursors.get(_cursors.size()-1), pageRequest.page()+1, pageRequest.size(), pageRequest.requestTotal()),\n\t\t\t\t_results.isFirstPage() ? null : beforeCursor(_cursors.get(0), pageRequest.page()-1, pageRequest.size(), pageRequest.requestTotal()))";
    static final @UnknownKeyFor @NonNull @Initialized String MAKE_KEYED_PAGE = "\tvar _unkeyedPage =\n\t\t\tpage(pageRequest.size(), (int) pageRequest.page()-1)\n\t\t\t\t\t.keyedBy(_orders);\n\tvar _keyedPage =\n\t\t\tpageRequest.cursor()\n\t\t\t\t\t.map(_cursor -> {\n\t\t\t\t\t\t@SuppressWarnings(\"unchecked\")\n\t\t\t\t\t\tvar _elements = (List<Comparable<?>>) _cursor.elements();\n\t\t\t\t\t\treturn switch (pageRequest.mode()) {\n\t\t\t\t\t\t\tcase CURSOR_NEXT -> _unkeyedPage.withKey(_elements, KEY_OF_LAST_ON_PREVIOUS_PAGE);\n\t\t\t\t\t\t\tcase CURSOR_PREVIOUS -> _unkeyedPage.withKey(_elements, KEY_OF_FIRST_ON_NEXT_PAGE);\n\t\t\t\t\t\t\tdefault -> _unkeyedPage;\n\t\t\t\t\t\t};\n\t\t\t\t\t}).orElse(_unkeyedPage);";
    private static final @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> UNSPECIALIZED_QUERY_TYPES = Set.of("jakarta.persistence.Query", "jakarta.persistence.TypedQuery", "org.hibernate.query.Query");

    AbstractQueryMethod(@UnknownKeyFor @NonNull @Initialized AnnotationMetaEntity annotationMetaEntity, @UnknownKeyFor @NonNull @Initialized ExecutableElement method, @UnknownKeyFor @NonNull @Initialized String methodName, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> paramNames, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> paramTypes, @Nullable @UnknownKeyFor @Initialized String returnTypeName, @UnknownKeyFor @NonNull @Initialized String sessionType, @UnknownKeyFor @NonNull @Initialized String sessionName, @UnknownKeyFor @NonNull @Initialized boolean belongsToDao, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized OrderBy> orderBys, @UnknownKeyFor @NonNull @Initialized boolean addNonnullAnnotation, @UnknownKeyFor @NonNull @Initialized boolean dataRepository, @UnknownKeyFor @NonNull @Initialized String fullReturnType, @UnknownKeyFor @NonNull @Initialized boolean nullable) {
        super(annotationMetaEntity, method, sessionName, sessionType);
        this.methodName = methodName;
        this.paramNames = paramNames;
        this.paramTypes = paramTypes;
        this.returnTypeName = returnTypeName;
        this.belongsToDao = belongsToDao;
        this.orderBys = orderBys;
        this.addNonnullAnnotation = addNonnullAnnotation;
        this.dataRepository = dataRepository;
        this.fullReturnType = fullReturnType;
        this.nullable = nullable;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized String getMetaType() {
        throw new UnsupportedOperationException("operation not supported");
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized String getPropertyName() {
        return this.methodName;
    }

    abstract @UnknownKeyFor @NonNull @Initialized boolean isNullable(@UnknownKeyFor @NonNull @Initialized int var1);

    @UnknownKeyFor @NonNull @Initialized boolean initiallyUnwrapped() {
        return !this.isUsingEntityManager() || this.isUsingSpecification() && !this.isReactive();
    }

    @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> parameterTypes() {
        return this.paramTypes.stream().map(paramType -> AbstractQueryMethod.isOrderParam(paramType) && paramType.endsWith("[]") ? paramType.substring(0, paramType.length() - 2) + "..." : paramType).collect(Collectors.toList());
    }

    @UnknownKeyFor @NonNull @Initialized String parameterList() {
        return this.paramTypes.stream().map(this::strip).map(this.annotationMetaEntity::importType).reduce((x, y) -> x + "," + y).orElse("");
    }

    @UnknownKeyFor @NonNull @Initialized boolean hasRestriction() {
        return this.paramTypes.stream().anyMatch(type -> AbstractQueryMethod.isRestrictionParam(type) || AbstractQueryMethod.isRangeParam(type));
    }

    @UnknownKeyFor @NonNull @Initialized boolean hasOrder() {
        return this.paramTypes.stream().anyMatch(AbstractQueryMethod::isOrderParam) || !this.orderBys.isEmpty();
    }

    @UnknownKeyFor @NonNull @Initialized String strip(@UnknownKeyFor @NonNull @Initialized String fullType) {
        String type = fullType;
        while (type.charAt(0) == '@') {
            int startIndex = type.lastIndexOf(32);
            if (startIndex <= 0) continue;
            type = type.substring(startIndex + 1);
        }
        int endIndex = type.indexOf("<");
        if (endIndex > 0) {
            type = type.substring(0, endIndex);
        }
        return fullType.endsWith("...") ? type + "..." : type;
    }

    void preamble(@UnknownKeyFor @NonNull @Initialized StringBuilder declaration, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> paramTypes) {
        declaration.append(this.annotationMetaEntity.importType(this.fullReturnType)).append(" ").append(this.methodName);
        this.parameters(paramTypes, declaration);
        declaration.append(" {\n");
    }

    void parameters(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> paramTypes, @UnknownKeyFor @NonNull @Initialized StringBuilder declaration) {
        declaration.append("(");
        this.sessionParameter(declaration);
        for (int i = 0; i < this.paramNames.size(); ++i) {
            if (i > 0) {
                declaration.append(", ");
            }
            String paramType = paramTypes.get(i);
            if (!this.isNullable(i) && !TypeUtils.isPrimitive(paramType) || AbstractQueryMethod.isSessionParameter(paramType)) {
                this.notNull(declaration);
            }
            declaration.append(this.annotationMetaEntity.importType(paramType)).append(" ").append(AbstractQueryMethod.parameterName(this.paramNames.get(i)));
        }
        declaration.append(")");
    }

    static @UnknownKeyFor @NonNull @Initialized boolean isSessionParameter(@UnknownKeyFor @NonNull @Initialized String paramType) {
        return Constants.SESSION_TYPES.contains(paramType);
    }

    void sessionParameter(@UnknownKeyFor @NonNull @Initialized StringBuilder declaration) {
        if (!this.belongsToDao) {
            if (this.paramTypes.stream().noneMatch(Constants.SESSION_TYPES::contains)) {
                this.notNull(declaration);
                declaration.append(this.annotationMetaEntity.importType(this.sessionType)).append(' ').append(this.sessionName);
                if (!this.paramNames.isEmpty()) {
                    declaration.append(", ");
                }
            }
        }
    }

    void notNull(@UnknownKeyFor @NonNull @Initialized StringBuilder declaration) {
        if (this.addNonnullAnnotation) {
            declaration.append('@').append(this.annotationMetaEntity.importType("jakarta.annotation.Nonnull")).append(' ');
        }
    }

    void see(@UnknownKeyFor @NonNull @Initialized StringBuilder declaration) {
        declaration.append("\n * @see ").append(this.annotationMetaEntity.getQualifiedName()).append("#");
        this.signature(declaration);
    }

    void signature(@UnknownKeyFor @NonNull @Initialized StringBuilder declaration) {
        declaration.append(this.methodName).append("(").append(this.parameterList()).append(")");
    }

    void chainSession(@UnknownKeyFor @NonNull @Initialized StringBuilder declaration) {
        if (this.isReactiveSessionAccess()) {
            declaration.append("\treturn ").append(this.sessionName).append(".chain(").append(this.localSessionName()).append(" -> {\n");
        }
    }

    void chainSessionEnd(@UnknownKeyFor @NonNull @Initialized boolean isUpdate, @UnknownKeyFor @NonNull @Initialized StringBuilder declaration) {
        if (this.isReactiveSessionAccess()) {
            declaration.append("\t})");
            if (isUpdate && this.returnTypeName != null && this.returnTypeName.equals("java.lang.Void")) {
                declaration.append(".replaceWithVoid();\n");
            } else {
                declaration.append(";\n");
            }
        }
    }

    void setPage(@UnknownKeyFor @NonNull @Initialized StringBuilder declaration, @UnknownKeyFor @NonNull @Initialized String paramName, @UnknownKeyFor @NonNull @Initialized String paramType) {
        boolean jakartaLimit = "jakarta.data.Limit".equals(paramType);
        boolean jakartaPageRequest = "jakarta.data.page.PageRequest".equals(paramType);
        if (jakartaLimit || jakartaPageRequest || this.isUsingEntityManager()) {
            String maxResults;
            String firstResult;
            if (jakartaLimit) {
                firstResult = "(int) " + paramName + ".startAt() - 1";
                maxResults = paramName + ".maxResults()";
            } else if (jakartaPageRequest) {
                firstResult = "(int) (" + paramName + ".page()-1) * " + paramName + ".size()";
                maxResults = paramName + ".size()";
            } else {
                firstResult = paramName + ".getFirstResult()";
                maxResults = paramName + ".getMaxResults()";
            }
            declaration.append("\t\t\t.setFirstResult(").append(firstResult).append(")\n").append("\t\t\t.setMaxResults(").append(maxResults).append(")\n");
        } else {
            declaration.append("\t\t\t.setPage(").append(paramName).append(")\n");
        }
    }

    void handlePageParameters(@UnknownKeyFor @NonNull @Initialized StringBuilder declaration, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> paramTypes, @Nullable @UnknownKeyFor @Initialized String containerType) {
        if (!AbstractQueryMethod.isJakartaCursoredPage(containerType)) {
            for (int i = 0; i < this.paramNames.size(); ++i) {
                String paramName = this.paramNames.get(i);
                String paramType = paramTypes.get(i);
                if (!AbstractQueryMethod.isPageParam(paramType)) continue;
                this.setPage(declaration, paramName, paramType);
            }
        }
    }

    void handleRestrictionParameters(@UnknownKeyFor @NonNull @Initialized StringBuilder declaration, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> paramTypes) {
        for (int i = 0; i < this.paramNames.size(); ++i) {
            String paramName = this.paramNames.get(i);
            String paramType = paramTypes.get(i);
            if (AbstractQueryMethod.isRestrictionParam(paramType)) {
                if (paramType.startsWith("java.util.List") || paramType.endsWith("[]")) {
                    declaration.append("\t_spec.restrict(").append(this.annotationMetaEntity.importType("org.hibernate.query.restriction.Restriction")).append(".all(").append(paramName).append("));\n");
                    continue;
                }
                declaration.append("\t_spec.restrict(").append(paramName).append(");\n");
                continue;
            }
            if (!AbstractQueryMethod.isRangeParam(paramType) || this.returnTypeName == null) continue;
            TypeElement entityElement = this.annotationMetaEntity.getContext().getElementUtils().getTypeElement(this.returnTypeName);
            declaration.append("\t_spec.restrict(").append(this.annotationMetaEntity.importType("org.hibernate.query.restriction.Restriction")).append(".restrict(").append(this.annotationMetaEntity.importType(TypeUtils.getGeneratedClassFullyQualifiedName(entityElement, false))).append('.').append(paramName).append(", ").append(paramName).append("));\n");
        }
    }

    void convertExceptions(@UnknownKeyFor @NonNull @Initialized StringBuilder declaration) {
        if (this.dataRepository) {
            if (!this.isReactive()) {
                declaration.append(";\n").append("\t}\n");
            }
            if (this.singleResult()) {
                this.handle(declaration, "jakarta.persistence.NoResultException", "jakarta.data.exceptions.EmptyResultException");
                this.handle(declaration, "jakarta.persistence.NonUniqueResultException", "jakarta.data.exceptions.NonUniqueResultException");
            }
            this.handle(declaration, "jakarta.persistence.PersistenceException", "jakarta.data.exceptions.DataException");
            if (this.isReactive()) {
                declaration.append(";\n");
            }
        } else {
            declaration.append(";\n");
        }
    }

    abstract @UnknownKeyFor @NonNull @Initialized boolean singleResult();

    static void closingBrace(@UnknownKeyFor @NonNull @Initialized StringBuilder declaration) {
        declaration.append("}");
    }

    void unwrapQuery(@UnknownKeyFor @NonNull @Initialized StringBuilder declaration, @UnknownKeyFor @NonNull @Initialized boolean unwrapped) {
        if (!unwrapped && this.isUsingEntityManager()) {
            declaration.append("\t\t\t.unwrap(").append(this.annotationMetaEntity.importType("org.hibernate.query.SelectionQuery")).append(".class)\n");
        }
    }

    static @UnknownKeyFor @NonNull @Initialized boolean isSpecialParam(@UnknownKeyFor @NonNull @Initialized String parameterType) {
        return AbstractQueryMethod.isPageParam(parameterType) || AbstractQueryMethod.isRestrictionParam(parameterType) || AbstractQueryMethod.isRangeParam(parameterType) || AbstractQueryMethod.isOrderParam(parameterType) || AbstractQueryMethod.isKeyedPageParam(parameterType) || AbstractQueryMethod.isSessionParameter(parameterType);
    }

    static @UnknownKeyFor @NonNull @Initialized boolean isKeyedPageParam(@UnknownKeyFor @NonNull @Initialized String parameterType) {
        return parameterType.startsWith("org.hibernate.query.KeyedPage");
    }

    static @UnknownKeyFor @NonNull @Initialized boolean isPageParam(@UnknownKeyFor @NonNull @Initialized String parameterType) {
        return "org.hibernate.query.Page".equals(parameterType) || "jakarta.data.Limit".equals(parameterType) || "jakarta.data.page.PageRequest".equals(parameterType);
    }

    static @UnknownKeyFor @NonNull @Initialized boolean isOrderParam(@UnknownKeyFor @NonNull @Initialized String parameterType) {
        return parameterType.startsWith("org.hibernate.query.Order") || parameterType.startsWith("java.util.List<org.hibernate.query.Order") || parameterType.startsWith("jakarta.data.Sort") || parameterType.startsWith("jakarta.data.Order") && !parameterType.endsWith("[]");
    }

    static @UnknownKeyFor @NonNull @Initialized boolean isRestrictionParam(@UnknownKeyFor @NonNull @Initialized String parameterType) {
        return parameterType.startsWith("org.hibernate.query.restriction.Restriction") || parameterType.startsWith("java.util.List<org.hibernate.query.restriction.Restriction");
    }

    static @UnknownKeyFor @NonNull @Initialized boolean isRangeParam(@UnknownKeyFor @NonNull @Initialized String parameterType) {
        return parameterType.startsWith("org.hibernate.query.range.Range");
    }

    static @UnknownKeyFor @NonNull @Initialized boolean isJakartaCursoredPage(@Nullable @UnknownKeyFor @Initialized String containerType) {
        return "jakarta.data.page.CursoredPage".equals(containerType);
    }

    static @UnknownKeyFor @NonNull @Initialized boolean isJakartaPage(@Nullable @UnknownKeyFor @Initialized String containerType) {
        return "jakarta.data.page.Page".equals(containerType);
    }

    void makeKeyedPage(@UnknownKeyFor @NonNull @Initialized StringBuilder declaration, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> paramTypes) {
        this.annotationMetaEntity.staticImport("org.hibernate.query.SortDirection", "*");
        this.annotationMetaEntity.staticImport("org.hibernate.query.Order", "by");
        this.annotationMetaEntity.staticImport("org.hibernate.query.Page", "page");
        this.annotationMetaEntity.staticImport("org.hibernate.query.KeyedPage.KeyInterpretation", "*");
        this.annotationMetaEntity.staticImport("java.util.stream.Collectors", "toList");
        if (this.returnTypeName == null) {
            throw new AssertionFailure("entity class cannot be null");
        }
        declaration.append(MAKE_KEYED_PAGE.replace("pageRequest", AbstractQueryMethod.parameterName("jakarta.data.page.PageRequest", paramTypes, this.paramNames)).replace("Entity", this.annotationMetaEntity.importType(this.returnTypeName))).append('\n');
    }

    void createQuery(@UnknownKeyFor @NonNull @Initialized StringBuilder declaration) {
    }

    void createSpecification(@UnknownKeyFor @NonNull @Initialized StringBuilder declaration) {
    }

    void setParameters(@UnknownKeyFor @NonNull @Initialized StringBuilder declaration, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> paramTypes, @UnknownKeyFor @NonNull @Initialized String indent) {
    }

    void tryReturn(@UnknownKeyFor @NonNull @Initialized StringBuilder declaration, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> paramTypes, @Nullable @UnknownKeyFor @Initialized String containerType) {
        if (AbstractQueryMethod.isJakartaCursoredPage(containerType)) {
            this.makeKeyedPage(declaration, paramTypes);
        }
        if (this.dataRepository && !this.isReactive()) {
            declaration.append("\ttry {\n");
        }
        if ("jakarta.data.page.CursoredPage".equals(containerType) || "jakarta.data.page.Page".equals(containerType)) {
            if (this.dataRepository) {
                declaration.append('\t');
            }
            this.totalResults(declaration, paramTypes);
        }
        if (this.dataRepository && !this.isReactive()) {
            declaration.append('\t');
        }
        declaration.append('\t');
        if (AbstractQueryMethod.isJakartaCursoredPage(containerType) || AbstractQueryMethod.isJakartaPage(containerType) && !this.isReactive()) {
            if (this.returnTypeName != null && this.isUsingEntityManager()) {
                declaration.append(this.annotationMetaEntity.importType("org.hibernate.query.KeyedResultList")).append('<').append(this.annotationMetaEntity.importType(this.returnTypeName)).append('>');
            } else {
                declaration.append("var");
            }
            declaration.append(" _results = ");
        } else if (!"void".equals(this.returnTypeName) || this.isReactiveSessionAccess()) {
            declaration.append("return ");
        }
    }

    private void totalResults(@UnknownKeyFor @NonNull @Initialized StringBuilder declaration, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> paramTypes) {
        declaration.append("\tlong _totalResults = \n\t\t\t\t");
        if (this.isReactive()) {
            declaration.append("-1;\n");
        } else {
            declaration.append(AbstractQueryMethod.parameterName("jakarta.data.page.PageRequest", paramTypes, this.paramNames)).append(".requestTotal()\n\t\t\t\t\t\t? ");
            this.createQuery(declaration);
            this.setParameters(declaration, paramTypes, "\t\t\t\t\t");
            if (this.isUsingEntityManager()) {
                declaration.append("\t\t\t\t\t");
            }
            this.unwrapQuery(declaration, !this.isUsingEntityManager());
            declaration.append("\t\t\t\t\t\t\t\t.getResultCount()\n\t\t\t\t\t\t: -1;\n");
        }
    }

    void collectOrdering(@UnknownKeyFor @NonNull @Initialized StringBuilder declaration, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> paramTypes, @Nullable @UnknownKeyFor @Initialized String containerType) {
        if (this.hasOrdering(paramTypes) && this.returnTypeName != null) {
            String add;
            boolean cursoredPage = AbstractQueryMethod.isJakartaCursoredPage(containerType);
            if (cursoredPage) {
                declaration.append("\tvar _orders = new ").append(this.annotationMetaEntity.importType("java.util.ArrayList")).append("<").append(this.annotationMetaEntity.importType("org.hibernate.query.Order")).append("<? super ").append(this.annotationMetaEntity.importType(this.returnTypeName)).append(">>();\n");
                add = "_orders.add";
            } else {
                add = "_spec.sort";
            }
            for (OrderBy orderBy : this.orderBys) {
                this.annotationMetaEntity.staticImport("org.hibernate.query.SortDirection", "*");
                declaration.append("\t").append(add).append('(').append(this.annotationMetaEntity.staticImport("org.hibernate.query.Order", orderBy.descending ? "desc" : "asc")).append('(').append(this.annotationMetaEntity.importType(this.returnTypeName)).append(".class, \"").append(orderBy.fieldName).append("\")");
                if (orderBy.ignoreCase) {
                    declaration.append("\n\t.ignoringCase()");
                }
                declaration.append(");\n");
            }
            for (int i = 0; i < paramTypes.size(); ++i) {
                String type = paramTypes.get(i);
                String name = this.paramNames.get(i);
                if (type.startsWith("org.hibernate.query.Order") && type.endsWith("...")) {
                    declaration.append("\tfor (var _sort : ").append(name).append(") {\n").append("\t\t").append(add).append("(_sort);\n").append("\t}\n");
                    continue;
                }
                if (type.startsWith("org.hibernate.query.Order")) {
                    declaration.append("\t").append(add).append('(').append(name).append(");\n");
                    continue;
                }
                if (type.startsWith("java.util.List<org.hibernate.query.Order")) {
                    if (cursoredPage) {
                        declaration.append("\t_orders.addAll(").append(name).append(");\n");
                        continue;
                    }
                    declaration.append("\tfor (var _sort : ").append(name).append(") {\n").append("\t\t").append(add).append("(_sort);\n").append("\t}\n");
                    continue;
                }
                if (type.startsWith("jakarta.data.Order")) {
                    this.annotationMetaEntity.staticImport("org.hibernate.query.SortDirection", "*");
                    declaration.append("\tfor (var _sort : ").append(name).append(".sorts()) {\n").append("\t\t").append(add).append('(').append(this.annotationMetaEntity.staticImport("org.hibernate.query.Order", "asc")).append('(').append(this.annotationMetaEntity.importType(this.returnTypeName)).append(".class, _sort.property())").append("\n\t\t\t\t\t").append(".reversedIf(_sort.isDescending())").append("\n\t\t\t\t\t").append(".ignoringCaseIf(_sort.ignoreCase()));\n").append("\t}\n");
                    continue;
                }
                if (type.startsWith("jakarta.data.Sort") && type.endsWith("...")) {
                    this.annotationMetaEntity.staticImport("org.hibernate.query.SortDirection", "*");
                    declaration.append("\tfor (var _sort : ").append(name).append(") {\n").append("\t\t").append(add).append('(').append(this.annotationMetaEntity.staticImport("org.hibernate.query.Order", "asc")).append('(').append(this.annotationMetaEntity.importType(this.returnTypeName)).append(".class, _sort.property())").append("\n\t\t\t\t\t").append(".reversedIf(_sort.isDescending())").append("\n\t\t\t\t\t").append(".ignoringCaseIf(_sort.ignoreCase()));\n").append("\t}\n");
                    continue;
                }
                if (!type.startsWith("jakarta.data.Sort")) continue;
                this.annotationMetaEntity.staticImport("org.hibernate.query.SortDirection", "*");
                declaration.append("\t").append(add).append('(').append(this.annotationMetaEntity.staticImport("org.hibernate.query.Order", "asc")).append('(').append(this.annotationMetaEntity.importType(this.returnTypeName)).append(".class, ").append(name).append(".property())").append("\n\t\t\t\t\t").append(".reversedIf(").append(name).append(".isDescending())").append("\n\t\t\t\t\t").append(".ignoringCaseIf(").append(name).append(".ignoreCase()));\n");
            }
        }
    }

    private @UnknownKeyFor @NonNull @Initialized boolean hasOrdering(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> paramTypes) {
        return paramTypes.stream().anyMatch(AbstractQueryMethod::isOrderParam) || !this.orderBys.isEmpty();
    }

    @UnknownKeyFor @NonNull @Initialized boolean isUsingSpecification() {
        return false;
    }

    protected void executeSelect(@UnknownKeyFor @NonNull @Initialized StringBuilder declaration, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> paramTypes, @Nullable @UnknownKeyFor @Initialized String containerType, @UnknownKeyFor @NonNull @Initialized boolean unwrapped, @UnknownKeyFor @NonNull @Initialized boolean mustUnwrap) {
        if (containerType == null) {
            if (this.nullable) {
                this.unwrapQuery(declaration, unwrapped);
                declaration.append("\t\t\t.getSingleResultOrNull()");
            } else {
                declaration.append("\t\t\t.getSingleResult()");
            }
        } else {
            switch (containerType) {
                case "[]": {
                    if (this.returnTypeName == null) {
                        throw new AssertionFailure("missing return type");
                    }
                    declaration.append("\t\t\t.getResultList()\n\t\t\t.toArray(new ").append(this.annotationMetaEntity.importType(this.returnTypeName)).append("[0])");
                    break;
                }
                case "java.util.Optional": {
                    this.unwrapQuery(declaration, unwrapped);
                    declaration.append("\t\t\t.uniqueResultOptional()");
                    break;
                }
                case "java.util.stream.Stream": {
                    declaration.append("\t\t\t.getResultStream()");
                    break;
                }
                case "java.util.List": {
                    declaration.append("\t\t\t.getResultList()");
                    break;
                }
                case "org.hibernate.query.KeyedResultList": {
                    this.unwrapQuery(declaration, unwrapped);
                    declaration.append("\t\t\t.getKeyedResultList(").append(AbstractQueryMethod.parameterName("org.hibernate.query.KeyedPage", paramTypes, this.paramNames)).append(")");
                    break;
                }
                case "jakarta.data.page.Page": {
                    if (this.isReactive()) {
                        if (this.returnTypeName == null) {
                            throw new AssertionFailure("entity class cannot be null");
                        }
                        declaration.append("\t\t\t.getResultList()\n").append("\t\t\t.map(_results -> (Page<").append(this.annotationMetaEntity.importType(this.returnTypeName)).append(">)");
                    } else {
                        declaration.append("\t\t\t.getResultList();\n").append("\t\treturn ");
                    }
                    declaration.append("new ").append(this.annotationMetaEntity.importType("jakarta.data.page.impl.PageRecord")).append("<>").append('(').append(AbstractQueryMethod.parameterName("jakarta.data.page.PageRequest", paramTypes, this.paramNames)).append(", _results, _totalResults)");
                    if (!this.isReactive()) break;
                    declaration.append(')');
                    break;
                }
                case "jakarta.data.page.CursoredPage": {
                    if (this.returnTypeName == null) {
                        throw new AssertionFailure("entity class cannot be null");
                    }
                    this.unwrapQuery(declaration, unwrapped);
                    declaration.append("\t\t\t.getKeyedResultList(_keyedPage);\n");
                    this.annotationMetaEntity.importType("jakarta.data.page.PageRequest");
                    this.annotationMetaEntity.importType("jakarta.data.page.PageRequest.Cursor");
                    this.annotationMetaEntity.importType("jakarta.data.page.impl.CursoredPageRecord");
                    this.annotationMetaEntity.staticImport("jakarta.data.page.PageRequest", "beforeCursor");
                    this.annotationMetaEntity.staticImport("jakarta.data.page.PageRequest", "afterCursor");
                    String fragment = MAKE_KEYED_SLICE.replace("pageRequest", AbstractQueryMethod.parameterName("jakarta.data.page.PageRequest", paramTypes, this.paramNames)).replace("Entity", this.annotationMetaEntity.importType(this.returnTypeName));
                    declaration.append(fragment);
                    break;
                }
                default: {
                    if (this.isUsingEntityManager() && !unwrapped && mustUnwrap) {
                        declaration.append("\t\t\t.unwrap(").append(this.annotationMetaEntity.importType(containerType)).append(".class)");
                        break;
                    }
                    int lastIndex = declaration.length() - 1;
                    if (declaration.charAt(lastIndex) != '\n') break;
                    declaration.setLength(lastIndex);
                }
            }
        }
    }

    private static @UnknownKeyFor @NonNull @Initialized String parameterName(@UnknownKeyFor @NonNull @Initialized String paramType, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> paramTypes, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> paramNames) {
        for (int i = 0; i < paramTypes.size(); ++i) {
            if (!paramTypes.get(i).startsWith(paramType)) continue;
            return paramNames.get(i);
        }
        throw new AssertionFailure("could not find parameter");
    }

    static @UnknownKeyFor @NonNull @Initialized boolean isUnspecializedQueryType(@Nullable @UnknownKeyFor @Initialized String containerType) {
        return containerType != null && UNSPECIALIZED_QUERY_TYPES.contains(containerType);
    }

    static @UnknownKeyFor @NonNull @Initialized boolean isHibernateQueryType(@Nullable @UnknownKeyFor @Initialized String containerType) {
        return containerType != null && containerType.startsWith("org.hibernate");
    }

    @UnknownKeyFor @NonNull @Initialized boolean isUnifiableReturnType(@Nullable @UnknownKeyFor @Initialized String containerType) {
        return containerType == null || "java.util.List".equals(containerType) || "jakarta.data.page.Page".equals(containerType) || "jakarta.data.page.CursoredPage".equals(containerType);
    }
}

