/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.processor.annotation;

import java.util.List;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.hibernate.processor.model.MetaAttribute;
import org.hibernate.processor.model.Metamodel;

public class IdClassMetaAttribute
implements MetaAttribute {
    private final @UnknownKeyFor @NonNull @Initialized Metamodel parent;
    private final @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized MetaAttribute> components;

    public IdClassMetaAttribute(@UnknownKeyFor @NonNull @Initialized Metamodel parent, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized MetaAttribute> components) {
        this.parent = parent;
        this.components = components;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean hasTypedAttribute() {
        return true;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean hasStringAttribute() {
        return false;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized String getAttributeDeclarationString() {
        StringBuilder decl = new StringBuilder().append("\n/**\n * Static ID class for {@link ").append(this.parent.getQualifiedName()).append("}\n **/\n").append("public record Id");
        String delimiter = "(";
        for (MetaAttribute component : this.components) {
            decl.append(delimiter).append(this.parent.importType(component.getTypeDeclaration())).append(' ').append(component.getPropertyName());
            delimiter = ", ";
        }
        return decl.append(") {}").toString();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized String getAttributeNameDeclarationString() {
        return "";
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized String getMetaType() {
        return "";
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized String getPropertyName() {
        return "";
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized String getTypeDeclaration() {
        return "";
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Metamodel getHostingEntity() {
        return this.parent;
    }
}

