/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.processor.annotation;

import java.util.TreeSet;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.hibernate.processor.annotation.AnnotationMeta;
import org.hibernate.processor.model.MetaAttribute;
import org.hibernate.processor.model.Metamodel;
import org.hibernate.processor.util.StringUtil;
import org.hibernate.query.sqm.SqmBindableType;
import org.hibernate.query.sqm.tree.expression.SqmParameter;
import org.hibernate.query.sqm.tree.select.SqmSelectStatement;

class NamedQueryMethod
implements MetaAttribute {
    private final @UnknownKeyFor @NonNull @Initialized AnnotationMeta annotationMeta;
    private final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized SqmSelectStatement<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> select;
    private final @UnknownKeyFor @NonNull @Initialized String name;
    private final @UnknownKeyFor @NonNull @Initialized boolean belongsToRepository;
    private final @UnknownKeyFor @NonNull @Initialized boolean reactive;
    private final @UnknownKeyFor @NonNull @Initialized String sessionVariableName;
    private final @UnknownKeyFor @NonNull @Initialized boolean addNonnullAnnotation;
    private final @UnknownKeyFor @NonNull @Initialized String resultClass;

    public NamedQueryMethod(@UnknownKeyFor @NonNull @Initialized AnnotationMeta annotationMeta, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized SqmSelectStatement<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> select, @UnknownKeyFor @NonNull @Initialized String name, @UnknownKeyFor @NonNull @Initialized boolean belongsToRepository, @Nullable @UnknownKeyFor @Initialized String sessionType, @UnknownKeyFor @NonNull @Initialized String sessionVariableName, @UnknownKeyFor @NonNull @Initialized boolean addNonnullAnnotation, @UnknownKeyFor @NonNull @Initialized String resultClass) {
        this.annotationMeta = annotationMeta;
        this.select = select;
        this.name = name;
        this.belongsToRepository = belongsToRepository;
        this.reactive = "org.hibernate.reactive.mutiny.Mutiny.Session".equals(sessionType);
        this.sessionVariableName = sessionVariableName;
        this.addNonnullAnnotation = addNonnullAnnotation;
        this.resultClass = resultClass;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean hasTypedAttribute() {
        return true;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized boolean hasStringAttribute() {
        return false;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized String getAttributeDeclarationString() {
        TreeSet sortedParameters = new TreeSet(this.select.getSqmParameters());
        StringBuilder declaration = new StringBuilder();
        this.comment(declaration);
        this.modifiers(declaration);
        this.returnType(declaration);
        this.parameters(sortedParameters, declaration);
        declaration.append(" {").append("\n\treturn ").append(this.sessionVariableName).append(".createNamedQuery(").append(this.fieldName()).append(", ").append(this.annotationMeta.importType(this.resultClass)).append(".class)");
        for (SqmParameter<?> param : sortedParameters) {
            declaration.append("\n\t\t\t.setParameter(").append(param.getName() == null ? param.getPosition() : "\"" + param.getName() + "\"").append(", ").append((String)(param.getName() == null ? "parameter" + param.getPosition() : param.getName())).append(')');
        }
        declaration.append("\n\t\t\t.getResultList();\n}");
        return declaration.toString();
    }

    private @UnknownKeyFor @NonNull @Initialized String fieldName() {
        return "QUERY_" + StringUtil.nameToFieldName(this.name);
    }

    void notNull(@UnknownKeyFor @NonNull @Initialized StringBuilder declaration) {
        if (this.addNonnullAnnotation) {
            declaration.append('@').append(this.annotationMeta.importType("jakarta.annotation.Nonnull")).append(' ');
        }
    }

    private void comment(@UnknownKeyFor @NonNull @Initialized StringBuilder declaration) {
        declaration.append("\n/**\n * Execute named query {@value #").append(this.fieldName()).append("} defined by annotation of {@link ").append(this.annotationMeta.getSimpleName()).append("}.\n **/\n");
    }

    private void modifiers(@UnknownKeyFor @NonNull @Initialized StringBuilder declaration) {
        declaration.append(this.belongsToRepository ? "public " : "public static ");
    }

    private void returnType(@UnknownKeyFor @NonNull @Initialized StringBuilder declaration) {
        if (this.reactive) {
            declaration.append(this.annotationMeta.importType("io.smallrye.mutiny.Uni")).append('<');
        }
        declaration.append(this.annotationMeta.importType("java.util.List")).append('<').append(this.annotationMeta.importType(this.resultClass)).append("> ").append(this.name);
        if (this.reactive) {
            declaration.append('>');
        }
    }

    private void parameters(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized TreeSet<@UnknownKeyFor @NonNull @Initialized SqmParameter<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> sortedParameters, @UnknownKeyFor @NonNull @Initialized StringBuilder declaration) {
        declaration.append('(');
        if (!this.belongsToRepository) {
            this.notNull(declaration);
            declaration.append(this.annotationMeta.importType("jakarta.persistence.EntityManager")).append(" ").append(this.sessionVariableName);
        }
        int i = 0;
        for (SqmParameter<?> param : sortedParameters) {
            if (0 < i++ || !this.belongsToRepository) {
                declaration.append(", ");
            }
            if (param.allowMultiValuedBinding()) {
                declaration.append(this.annotationMeta.importType("java.util.List")).append('<').append(this.parameterType(param)).append("> ").append(NamedQueryMethod.parameterName(param));
                continue;
            }
            declaration.append(this.parameterType(param)).append(" ").append(NamedQueryMethod.parameterName(param));
        }
        declaration.append(')');
    }

    private static @UnknownKeyFor @NonNull @Initialized String parameterName(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized SqmParameter<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> param) {
        return param.getName() == null ? "parameter" + param.getPosition() : param.getName();
    }

    private @UnknownKeyFor @NonNull @Initialized String parameterType(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized SqmParameter<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> param) {
        SqmBindableType expressible = param.getExpressible();
        String paramType = expressible == null ? "unknown" : expressible.getTypeName();
        return "unknown".equals(paramType) ? "Object" : this.annotationMeta.importType(paramType);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized String getAttributeNameDeclarationString() {
        throw new UnsupportedOperationException("operation not supported");
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized String getMetaType() {
        throw new UnsupportedOperationException("operation not supported");
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized String getPropertyName() {
        return this.name;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized String getTypeDeclaration() {
        return "java.util.List";
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Metamodel getHostingEntity() {
        return this.annotationMeta;
    }
}

