/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.processor.annotation;

import java.util.Collections;
import java.util.List;
import javax.lang.model.element.ExecutableElement;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.hibernate.processor.annotation.AbstractFinderMethod;
import org.hibernate.processor.annotation.AnnotationMetaEntity;

public class NaturalIdFinderMethod
extends AbstractFinderMethod {
    public static final @UnknownKeyFor @NonNull @Initialized String IDENTIFIER = "org.hibernate.reactive.common.Identifier";
    private final @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Boolean> paramNullability;

    public NaturalIdFinderMethod(@UnknownKeyFor @NonNull @Initialized AnnotationMetaEntity annotationMetaEntity, @UnknownKeyFor @NonNull @Initialized ExecutableElement method, @UnknownKeyFor @NonNull @Initialized String methodName, @UnknownKeyFor @NonNull @Initialized String entity, @Nullable @UnknownKeyFor @Initialized String containerType, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> paramNames, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> paramTypes, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Boolean> paramNullability, @UnknownKeyFor @NonNull @Initialized boolean belongsToDao, @UnknownKeyFor @NonNull @Initialized String sessionType, @UnknownKeyFor @NonNull @Initialized String sessionName, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> fetchProfiles, @UnknownKeyFor @NonNull @Initialized boolean addNonnullAnnotation, @UnknownKeyFor @NonNull @Initialized boolean dataRepository, @UnknownKeyFor @NonNull @Initialized String fullReturnType) {
        super(annotationMetaEntity, method, methodName, entity, containerType, belongsToDao, sessionType, sessionName, fetchProfiles, paramNames, paramTypes, Collections.emptyList(), addNonnullAnnotation, dataRepository, fullReturnType, true);
        this.paramNullability = paramNullability;
    }

    @Override
    @UnknownKeyFor @NonNull @Initialized boolean isNullable(@UnknownKeyFor @NonNull @Initialized int index) {
        return this.paramNullability.get(index);
    }

    @Override
    @UnknownKeyFor @NonNull @Initialized boolean singleResult() {
        return true;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized String getAttributeDeclarationString() {
        StringBuilder declaration = new StringBuilder();
        this.comment(declaration);
        this.modifiers(declaration);
        this.preamble(declaration, this.paramTypes);
        this.tryReturn(declaration);
        this.unwrapSession(declaration);
        if (this.isReactive()) {
            this.findReactively(declaration);
        } else {
            this.findBlockingly(declaration);
        }
        this.convertExceptions(declaration);
        NaturalIdFinderMethod.closingBrace(declaration);
        return declaration.toString();
    }

    private void findBlockingly(@UnknownKeyFor @NonNull @Initialized StringBuilder declaration) {
        declaration.append(".byNaturalId(").append(this.annotationMetaEntity.importType(this.entity)).append(".class)\n");
        this.enableFetchProfile(declaration, true);
        for (int i = 0; i < this.paramNames.size(); ++i) {
            if (NaturalIdFinderMethod.isSessionParameter((String)this.paramTypes.get(i))) continue;
            String paramName = (String)this.paramNames.get(i);
            declaration.append("\t\t\t.using(").append(this.annotationMetaEntity.importType(this.entity + "_")).append('.').append(paramName).append(", ").append(paramName).append(")\n");
        }
        if (this.containerType == null) {
            declaration.append("\t\t\t.load()");
        } else {
            declaration.append("\t\t\t.loadOptional()");
        }
    }

    private void findReactively(@UnknownKeyFor @NonNull @Initialized StringBuilder declaration) {
        boolean composite = this.isComposite();
        declaration.append(".find(");
        if (composite) {
            declaration.append("\n\t\t\t");
        }
        declaration.append(this.annotationMetaEntity.importType(this.entity)).append(".class, ");
        if (composite) {
            declaration.append("\n\t\t\t").append(this.annotationMetaEntity.importType(IDENTIFIER)).append(".composite(");
        }
        boolean first = true;
        for (int i = 0; i < this.paramNames.size(); ++i) {
            if (NaturalIdFinderMethod.isSessionParameter((String)this.paramTypes.get(i))) continue;
            if (first) {
                first = false;
            } else {
                declaration.append(", ");
            }
            if (composite) {
                declaration.append("\n\t\t\t\t");
            }
            String paramName = (String)this.paramNames.get(i);
            declaration.append(this.annotationMetaEntity.importType(IDENTIFIER)).append(".id(").append(this.annotationMetaEntity.importType(this.entity + "_")).append('.').append(paramName).append(", ").append(paramName).append(")");
        }
        if (composite) {
            declaration.append("\n\t\t\t)\n\t");
        }
        declaration.append(')');
    }

    private @UnknownKeyFor @NonNull @Initialized boolean isComposite() {
        return this.paramTypes.stream().filter(type -> !NaturalIdFinderMethod.isSessionParameter(type)).count() > 1L;
    }
}

