/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.processor.annotation;

import java.util.Set;
import javax.lang.model.element.ExecutableElement;
import org.hibernate.processor.annotation.AbstractAnnotatedMethod;
import org.hibernate.processor.annotation.AnnotationMetaEntity;

public class LifecycleMethod
extends AbstractAnnotatedMethod {
    private final String entity;
    private final String actualEntity;
    private final String methodName;
    private final String parameterName;
    private final String operationName;
    private final boolean addNonnullAnnotation;
    private final ParameterKind parameterKind;
    private final boolean returnArgument;
    private final boolean hasGeneratedId;
    static final Set<String> eventTypes = Set.of("insert", "update", "delete");

    public LifecycleMethod(AnnotationMetaEntity annotationMetaEntity, ExecutableElement method, String entity, String actualEntity, String methodName, String parameterName, String sessionName, String sessionType, String operationName, boolean addNonnullAnnotation, ParameterKind parameterKind, boolean returnArgument, boolean hasGeneratedId) {
        super(annotationMetaEntity, method, sessionName, sessionType);
        this.entity = entity;
        this.actualEntity = actualEntity;
        this.methodName = methodName;
        this.parameterName = parameterName;
        this.operationName = operationName;
        this.addNonnullAnnotation = addNonnullAnnotation;
        this.parameterKind = parameterKind;
        this.returnArgument = returnArgument;
        this.hasGeneratedId = hasGeneratedId;
    }

    @Override
    public boolean hasTypedAttribute() {
        return true;
    }

    @Override
    public boolean hasStringAttribute() {
        return false;
    }

    private String capitalize(String string) {
        return Character.toUpperCase(string.charAt(0)) + string.substring(1);
    }

    @Override
    public String getAttributeDeclarationString() {
        StringBuilder declaration = new StringBuilder();
        this.preamble(declaration);
        this.nullCheck(declaration, this.parameterName);
        this.fireEvents(declaration, "Pre");
        if (!this.isReactive()) {
            declaration.append("\ttry {\n");
        }
        this.delegateCall(declaration);
        this.returnArgumentReactively(declaration);
        if (!this.isReactive()) {
            declaration.append("\t}\n");
        }
        this.convertExceptions(declaration);
        if (this.isReactive()) {
            declaration.append(";\n");
        }
        this.fireEvents(declaration, "Post");
        this.returnArgument(declaration);
        declaration.append("}");
        return declaration.toString();
    }

    private void fireEvents(StringBuilder declaration, String prefix) {
        if (this.annotationMetaEntity.getContext().isDataEventPackageAvailable() && this.annotationMetaEntity.getContext().addDependentAnnotation() && eventTypes.contains(this.operationName) && !this.isReactive()) {
            String entityName = this.iterateEvents(declaration);
            this.fireEvent(declaration, entityName, prefix + this.capitalize(this.operationName) + "Event");
            this.endIterateEvents(declaration);
        }
    }

    private void fireEvent(StringBuilder declaration, String entityName, String eventType) {
        this.annotationMetaEntity.importType("jakarta.data.event.LifecycleEvent");
        this.annotationMetaEntity.importType("jakarta.enterprise.util.TypeLiteral");
        this.annotationMetaEntity.importType("jakarta.enterprise.event.Event");
        this.annotationMetaEntity.importType("jakarta.inject.Inject");
        this.annotationMetaEntity.importType("jakarta.data.event." + eventType);
        if (this.parameterKind != ParameterKind.NORMAL) {
            declaration.append("\t");
        }
        declaration.append("\tif (event != null) {\n");
        if (this.parameterKind != ParameterKind.NORMAL) {
            declaration.append("\t");
        }
        declaration.append("\t\tevent.select(new TypeLiteral<").append(eventType).append("<").append(this.annotationMetaEntity.importType(this.actualEntity)).append(">>(){})\n\t\t\t\t.fire(new ").append(eventType).append("<>(").append(entityName).append("));\n");
        if (this.parameterKind != ParameterKind.NORMAL) {
            declaration.append("\t");
        }
        declaration.append("\t}\n");
    }

    private void endIterateEvents(StringBuilder declaration) {
        if (this.parameterKind != ParameterKind.NORMAL) {
            declaration.append("\t}\n");
        }
    }

    private String iterateEvents(StringBuilder declaration) {
        if (this.parameterKind != ParameterKind.NORMAL) {
            declaration.append("\tfor (var _entity : ").append(this.parameterName).append(") {\n");
            return "_entity";
        }
        return this.parameterName;
    }

    private void returnArgument(StringBuilder declaration) {
        if (this.returnArgument && !this.isReactive()) {
            declaration.append("\treturn ").append(this.parameterName).append(";\n");
        }
    }

    private void returnArgumentReactively(StringBuilder declaration) {
        if (this.isReactive() && this.returnArgument) {
            declaration.append("\n\t\t\t.replaceWith(").append(this.parameterName).append(")");
        }
    }

    private void convertExceptions(StringBuilder declaration) {
        if (this.operationName.equals("insert")) {
            this.handle(declaration, "org.hibernate.exception.ConstraintViolationException", "jakarta.data.exceptions.EntityExistsException");
        } else {
            this.handle(declaration, "org.hibernate.StaleStateException", "jakarta.data.exceptions.OptimisticLockingFailureException");
        }
        this.handle(declaration, "jakarta.persistence.PersistenceException", "jakarta.data.exceptions.DataException");
    }

    private void delegateCall(StringBuilder declaration) {
        if (this.isReactive()) {
            this.delegateReactively(declaration);
        } else {
            this.delegateBlockingly(declaration);
        }
    }

    private void delegateBlockingly(StringBuilder declaration) {
        if (this.isGeneratedIdUpsert()) {
            declaration.append("\t\tif (").append(this.sessionName).append(this.getObjectCall()).append(".getIdentifier(").append(this.parameterName).append(") == null)\n").append("\t\t\t").append(this.sessionName).append(this.getObjectCall()).append('.').append("insert");
            this.argument(declaration);
            declaration.append(";\n").append("\t\telse\n\t");
        }
        declaration.append("\t\t").append(this.sessionName).append(this.getObjectCall()).append('.').append(this.operationName);
        this.argument(declaration);
        declaration.append(";\n");
    }

    private void argument(StringBuilder declaration) {
        switch (this.parameterKind.ordinal()) {
            case 2: {
                if (this.isReactive()) {
                    declaration.append("All").append("(").append(this.parameterName).append(".toArray()").append(")");
                    break;
                }
                declaration.append("Multiple").append("(").append(this.parameterName).append(")");
                break;
            }
            case 1: {
                if (this.isReactive()) {
                    declaration.append("All").append("((Object[]) ").append(this.parameterName).append(")");
                    break;
                }
                declaration.append("Multiple").append("(").append(this.annotationMetaEntity.importType("java.util.List")).append(".of(").append(this.parameterName).append("))");
                break;
            }
            default: {
                declaration.append('(').append(this.parameterName).append(')');
            }
        }
    }

    private void delegateReactively(StringBuilder declaration) {
        declaration.append("\treturn ");
        if (this.isReactiveSessionAccess()) {
            declaration.append(this.sessionName).append(".chain(").append(this.localSessionName()).append(" -> ");
        }
        if (this.isGeneratedIdUpsert()) {
            declaration.append("(").append(this.localSessionName()).append(".getIdentifier(").append(this.parameterName).append(") == null ? ").append(this.localSessionName()).append('.').append("insert").append('(').append(this.parameterName).append(')').append(" : ");
        }
        declaration.append(this.localSessionName()).append('.').append(this.operationName);
        this.argument(declaration);
        if (this.isGeneratedIdUpsert()) {
            declaration.append(')');
        }
        if (this.isReactiveSessionAccess()) {
            declaration.append(')');
        }
    }

    private boolean isGeneratedIdUpsert() {
        return "upsert".equals(this.operationName) && this.hasGeneratedId;
    }

    private void preamble(StringBuilder declaration) {
        declaration.append("\n@Override\npublic ").append(this.returnType()).append(' ').append(this.methodName).append('(');
        this.notNull(declaration);
        declaration.append(this.annotationMetaEntity.importType(this.entity)).append(' ').append(this.parameterName).append(')').append(" {\n");
    }

    private String returnType() {
        String entityType = this.annotationMetaEntity.importType(this.entity);
        if (this.isReactive()) {
            return this.annotationMetaEntity.importType("io.smallrye.mutiny.Uni") + "<" + (this.returnArgument ? entityType : "Void") + ">";
        }
        return this.returnArgument ? entityType : "void";
    }

    private void notNull(StringBuilder declaration) {
        if (this.addNonnullAnnotation) {
            declaration.append('@').append(this.annotationMetaEntity.importType("jakarta.annotation.Nonnull")).append(' ');
        }
    }

    @Override
    public String getAttributeNameDeclarationString() {
        throw new UnsupportedOperationException("operation not supported");
    }

    @Override
    public String getMetaType() {
        throw new UnsupportedOperationException("operation not supported");
    }

    @Override
    public String getPropertyName() {
        return this.methodName;
    }

    @Override
    public String getTypeDeclaration() {
        return this.entity;
    }

    public static enum ParameterKind {
        NORMAL,
        ARRAY,
        LIST;

    }
}

