/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.processor.util;

import jakarta.persistence.AccessType;
import java.beans.Introspector;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.SimpleTypeVisitor8;
import javax.tools.Diagnostic;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.processor.Context;
import org.hibernate.processor.MetaModelGenerationException;
import org.hibernate.processor.model.Metamodel;
import org.hibernate.processor.util.AccessTypeInformation;
import org.hibernate.processor.util.BasicAttributeVisitor;
import org.hibernate.processor.util.NullnessUtil;
import org.hibernate.processor.util.StringUtil;
import org.hibernate.processor.util.TypeRenderingVisitor;

public final class TypeUtils {
    public static final String DEFAULT_ANNOTATION_PARAMETER_NAME = "value";
    private static final Map<TypeKind, String> PRIMITIVE_WRAPPERS = new HashMap<TypeKind, String>();
    private static final Map<TypeKind, String> PRIMITIVES = new HashMap<TypeKind, String>();
    public static final Set<String> PRIMITIVE_TYPES;

    private TypeUtils() {
    }

    public static String toTypeString(TypeMirror type) {
        return type.getKind().isPrimitive() ? NullnessUtil.castNonNull(PRIMITIVE_WRAPPERS.get((Object)type.getKind())) : TypeRenderingVisitor.toString(type);
    }

    public static String toArrayTypeString(ArrayType type, Context context) {
        TypeMirror componentType = type.getComponentType();
        if (componentType.getKind().isPrimitive()) {
            return PRIMITIVES.get((Object)componentType.getKind()) + "[]";
        }
        TypeMirror component = componentType.accept(new SimpleTypeVisitor8<TypeMirror, Void>(){

            @Override
            protected TypeMirror defaultAction(TypeMirror e, Void aVoid) {
                return e;
            }
        }, null);
        return TypeUtils.extractClosestRealTypeAsString(component, context) + "[]";
    }

    public static @Nullable TypeElement getSuperclassTypeElement(TypeElement element) {
        TypeMirror superclass = element.getSuperclass();
        if (superclass.getKind() == TypeKind.DECLARED) {
            DeclaredType declaredType = (DeclaredType)superclass;
            return (TypeElement)declaredType.asElement();
        }
        return null;
    }

    public static String extractClosestRealTypeAsString(TypeMirror type, Context context) {
        TypeMirror mirror = TypeUtils.extractClosestRealType(type, context, new HashSet<TypeVariable>());
        return mirror == null ? "?" : mirror.toString();
    }

    private static @Nullable TypeMirror lowerBound(@Nullable TypeMirror bound) {
        return bound == null || bound.getKind() == TypeKind.NULL ? null : bound;
    }

    private static @Nullable TypeMirror upperBound(@Nullable TypeMirror bound) {
        if (bound != null && bound.getKind() == TypeKind.DECLARED) {
            DeclaredType type = (DeclaredType)bound;
            return type.asElement().getSimpleName().contentEquals("java.lang.Object") ? null : bound;
        }
        return null;
    }

    public static @Nullable TypeMirror extractClosestRealType(TypeMirror type, Context context, Set<TypeVariable> beingVisited) {
        if (type == null) {
            return null;
        }
        switch (type.getKind()) {
            case TYPEVAR: {
                TypeVariable typeVariable = (TypeVariable)type;
                if (!beingVisited.add(typeVariable)) {
                    return context.getTypeUtils().getWildcardType(null, null);
                }
                WildcardType wildcardType = context.getTypeUtils().getWildcardType(TypeUtils.upperBound(TypeUtils.extractClosestRealType(typeVariable.getUpperBound(), context, beingVisited)), TypeUtils.lowerBound(TypeUtils.extractClosestRealType(typeVariable.getLowerBound(), context, beingVisited)));
                beingVisited.remove(typeVariable);
                return wildcardType;
            }
            case WILDCARD: {
                WildcardType wildcardType = (WildcardType)type;
                return context.getTypeUtils().getWildcardType(TypeUtils.extractClosestRealType(wildcardType.getExtendsBound(), context, beingVisited), TypeUtils.extractClosestRealType(wildcardType.getSuperBound(), context, beingVisited));
            }
            case DECLARED: {
                DeclaredType declaredType = (DeclaredType)type;
                TypeElement typeElement = (TypeElement)declaredType.asElement();
                return context.getTypeUtils().getDeclaredType(typeElement, (TypeMirror[])declaredType.getTypeArguments().stream().map(arg -> TypeUtils.extractClosestRealType(arg, context, beingVisited)).toArray(TypeMirror[]::new));
            }
        }
        return context.getTypeUtils().erasure(type);
    }

    public static boolean containsAnnotation(Element element, String ... annotations) {
        assert (element != null);
        assert (annotations != null);
        Set<String> annotationClassNames = Set.of(annotations);
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            if (!annotationClassNames.contains(annotationMirror.getAnnotationType().toString())) continue;
            return true;
        }
        return false;
    }

    public static boolean isAnnotationMirrorOfType(AnnotationMirror annotationMirror, String qualifiedName) {
        assert (annotationMirror != null);
        assert (qualifiedName != null);
        Element element = annotationMirror.getAnnotationType().asElement();
        TypeElement typeElement = (TypeElement)element;
        return typeElement.getQualifiedName().contentEquals(qualifiedName);
    }

    public static @Nullable AnnotationMirror getAnnotationMirror(Element element, String qualifiedName) {
        assert (element != null);
        assert (qualifiedName != null);
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            if (!TypeUtils.isAnnotationMirrorOfType(annotationMirror, qualifiedName)) continue;
            return annotationMirror;
        }
        return null;
    }

    public static @Nullable AnnotationMirror getInheritedAnnotationMirror(Elements elements, Element element, String qualifiedName) {
        assert (element != null);
        assert (qualifiedName != null);
        for (AnnotationMirror annotationMirror : elements.getAllAnnotationMirrors(element)) {
            if (!TypeUtils.isAnnotationMirrorOfType(annotationMirror, qualifiedName)) continue;
            return annotationMirror;
        }
        return null;
    }

    public static boolean hasAnnotation(Element element, String qualifiedName) {
        return TypeUtils.getAnnotationMirror(element, qualifiedName) != null;
    }

    public static boolean hasAnnotation(Element element, String ... qualifiedNames) {
        for (String qualifiedName : qualifiedNames) {
            if (!TypeUtils.hasAnnotation(element, qualifiedName)) continue;
            return true;
        }
        return false;
    }

    public static @Nullable AnnotationValue getAnnotationValue(AnnotationMirror annotationMirror) {
        return TypeUtils.getAnnotationValue(annotationMirror, DEFAULT_ANNOTATION_PARAMETER_NAME);
    }

    public static @Nullable AnnotationValue getAnnotationValue(AnnotationMirror annotationMirror, String member) {
        assert (annotationMirror != null);
        assert (member != null);
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotationMirror.getElementValues().entrySet()) {
            if (!entry.getKey().getSimpleName().contentEquals(member)) continue;
            return entry.getValue();
        }
        return null;
    }

    public static void determineAccessTypeForHierarchy(TypeElement searchedElement, Context context) {
        String qualifiedName = searchedElement.getQualifiedName().toString();
        context.logMessage(Diagnostic.Kind.OTHER, "Determining access type for " + qualifiedName);
        AccessTypeInformation accessTypeInfo = context.getAccessTypeInfo(qualifiedName);
        if (accessTypeInfo != null && accessTypeInfo.isAccessTypeResolved()) {
            context.logMessage(Diagnostic.Kind.OTHER, "AccessType for " + String.valueOf(searchedElement) + " found in cache: " + String.valueOf(accessTypeInfo));
        } else {
            AccessType forcedAccessType = TypeUtils.determineAnnotationSpecifiedAccessType(searchedElement);
            if (forcedAccessType != null) {
                context.logMessage(Diagnostic.Kind.OTHER, "Explicit access type on " + String.valueOf(searchedElement) + ":" + String.valueOf(forcedAccessType));
                AccessTypeInformation newAccessTypeInfo = new AccessTypeInformation(qualifiedName, forcedAccessType, null);
                context.addAccessTypeInformation(qualifiedName, newAccessTypeInfo);
                TypeUtils.updateEmbeddableAccessType(searchedElement, context, forcedAccessType);
            } else {
                AccessType defaultAccessType = TypeUtils.getAccessTypeInCaseElementIsRoot(searchedElement, context);
                if (defaultAccessType != null) {
                    AccessTypeInformation newAccessTypeInfo = new AccessTypeInformation(qualifiedName, null, defaultAccessType);
                    context.addAccessTypeInformation(qualifiedName, newAccessTypeInfo);
                    TypeUtils.updateEmbeddableAccessType(searchedElement, context, defaultAccessType);
                    TypeUtils.setDefaultAccessTypeForMappedSuperclassesInHierarchy(searchedElement, defaultAccessType, context);
                } else {
                    AccessType newDefaultAccessType = TypeUtils.getDefaultAccessForHierarchy(searchedElement, context);
                    if (newDefaultAccessType == null) {
                        newDefaultAccessType = AccessTypeInformation.DEFAULT_ACCESS_TYPE;
                    }
                    AccessTypeInformation newAccessTypeInfo = new AccessTypeInformation(qualifiedName, null, newDefaultAccessType);
                    context.addAccessTypeInformation(qualifiedName, newAccessTypeInfo);
                    TypeUtils.updateEmbeddableAccessType(searchedElement, context, newDefaultAccessType);
                }
            }
        }
    }

    public static TypeMirror getCollectionElementType(DeclaredType type, String returnTypeName, @Nullable String explicitTargetEntityName, Context context) {
        if (explicitTargetEntityName != null) {
            return context.getElementUtils().getTypeElement(explicitTargetEntityName).asType();
        }
        List<? extends TypeMirror> typeArguments = type.getTypeArguments();
        if (typeArguments.isEmpty()) {
            throw new MetaModelGenerationException("Unable to determine collection type");
        }
        if ("java.util.Map".equals(returnTypeName)) {
            return typeArguments.get(1);
        }
        return typeArguments.get(0);
    }

    private static void updateEmbeddableAccessType(TypeElement element, Context context, AccessType defaultAccessType) {
        for (Element element2 : ElementFilter.fieldsIn(element.getEnclosedElements())) {
            TypeUtils.updateEmbeddableAccessTypeForMember(context, defaultAccessType, element2);
        }
        for (Element element3 : ElementFilter.methodsIn(element.getEnclosedElements())) {
            TypeUtils.updateEmbeddableAccessTypeForMember(context, defaultAccessType, element3);
        }
    }

    private static void updateEmbeddableAccessTypeForMember(Context context, AccessType defaultAccessType, Element member) {
        @Nullable TypeElement embedded = member.asType().accept(new EmbeddedAttributeVisitor(context), member);
        if (embedded != null) {
            TypeUtils.updateEmbeddableAccessType(context, defaultAccessType, embedded);
        }
    }

    private static void updateEmbeddableAccessType(Context context, AccessType defaultAccessType, TypeElement embedded) {
        AccessTypeInformation accessTypeInfo;
        String embeddedClassName = embedded.getQualifiedName().toString();
        AccessType forcedAccessType = TypeUtils.determineAnnotationSpecifiedAccessType(embedded);
        AccessTypeInformation accessTypeInformation = accessTypeInfo = forcedAccessType != null ? new AccessTypeInformation(embeddedClassName, null, forcedAccessType) : context.getAccessTypeInfo(embeddedClassName);
        if (accessTypeInfo == null) {
            AccessTypeInformation newAccessTypeInfo = new AccessTypeInformation(embeddedClassName, null, defaultAccessType);
            context.addAccessTypeInformation(embeddedClassName, newAccessTypeInfo);
            TypeUtils.updateEmbeddableAccessType(embedded, context, defaultAccessType);
            TypeMirror superclass = embedded.getSuperclass();
            if (superclass.getKind() == TypeKind.DECLARED) {
                DeclaredType declaredType = (DeclaredType)superclass;
                TypeElement element = (TypeElement)declaredType.asElement();
                TypeUtils.updateEmbeddableAccessType(context, defaultAccessType, element);
            }
        } else {
            accessTypeInfo.setDefaultAccessType(defaultAccessType);
        }
    }

    private static @Nullable AccessType getDefaultAccessForHierarchy(TypeElement element, Context context) {
        AccessType defaultAccessType = null;
        TypeElement superClass = element;
        do {
            if ((superClass = TypeUtils.getSuperclassTypeElement(superClass)) == null) continue;
            String qualifiedName = superClass.getQualifiedName().toString();
            AccessTypeInformation accessTypeInfo = context.getAccessTypeInfo(qualifiedName);
            if (accessTypeInfo != null && accessTypeInfo.getDefaultAccessType() != null) {
                return accessTypeInfo.getDefaultAccessType();
            }
            if (!TypeUtils.containsAnnotation(superClass, "jakarta.persistence.Entity", "jakarta.persistence.MappedSuperclass")) continue;
            defaultAccessType = TypeUtils.getAccessTypeInCaseElementIsRoot(superClass, context);
            if (defaultAccessType != null) {
                AccessTypeInformation newAccessTypeInfo = new AccessTypeInformation(qualifiedName, null, defaultAccessType);
                context.addAccessTypeInformation(qualifiedName, newAccessTypeInfo);
                TypeUtils.setDefaultAccessTypeForMappedSuperclassesInHierarchy(superClass, defaultAccessType, context);
                break;
            }
            defaultAccessType = TypeUtils.getDefaultAccessForHierarchy(superClass, context);
        } while (superClass != null);
        return defaultAccessType;
    }

    private static void setDefaultAccessTypeForMappedSuperclassesInHierarchy(TypeElement element, AccessType defaultAccessType, Context context) {
        TypeElement superClass = element;
        do {
            if ((superClass = TypeUtils.getSuperclassTypeElement(superClass)) == null) continue;
            String qualifiedName = superClass.getQualifiedName().toString();
            if (!TypeUtils.containsAnnotation(superClass, "jakarta.persistence.MappedSuperclass")) continue;
            AccessType forcedAccessType = TypeUtils.determineAnnotationSpecifiedAccessType(superClass);
            AccessTypeInformation accessTypeInfo = forcedAccessType != null ? new AccessTypeInformation(qualifiedName, null, forcedAccessType) : new AccessTypeInformation(qualifiedName, null, defaultAccessType);
            context.addAccessTypeInformation(qualifiedName, accessTypeInfo);
        } while (superClass != null);
    }

    private static @Nullable AccessType getAccessTypeInCaseElementIsRoot(TypeElement searchedElement, Context context) {
        for (Element element : searchedElement.getEnclosedElements()) {
            for (AnnotationMirror annotationMirror : context.getElementUtils().getAllAnnotationMirrors(element)) {
                if (!TypeUtils.isIdAnnotation(annotationMirror)) continue;
                return TypeUtils.getAccessTypeOfIdAnnotation(element);
            }
        }
        return null;
    }

    private static @Nullable AccessType getAccessTypeOfIdAnnotation(Element element) {
        return switch (element.getKind()) {
            case ElementKind.FIELD -> AccessType.FIELD;
            case ElementKind.METHOD -> AccessType.PROPERTY;
            default -> null;
        };
    }

    private static boolean isIdAnnotation(AnnotationMirror annotationMirror) {
        return TypeUtils.isAnnotationMirrorOfType(annotationMirror, "jakarta.persistence.Id") || TypeUtils.isAnnotationMirrorOfType(annotationMirror, "jakarta.persistence.EmbeddedId");
    }

    public static @Nullable AccessType determineAnnotationSpecifiedAccessType(Element element) {
        AnnotationValue accessType;
        AnnotationMirror mirror = TypeUtils.getAnnotationMirror(element, "jakarta.persistence.Access");
        if (mirror != null && (accessType = TypeUtils.getAnnotationValue(mirror)) != null) {
            VariableElement enumValue = (VariableElement)accessType.getValue();
            Name enumValueName = enumValue.getSimpleName();
            if (enumValueName.contentEquals(AccessType.PROPERTY.name())) {
                return AccessType.PROPERTY;
            }
            if (enumValueName.contentEquals(AccessType.FIELD.name())) {
                return AccessType.FIELD;
            }
        }
        return null;
    }

    public static ElementKind getElementKindForAccessType(AccessType accessType) {
        return accessType == AccessType.FIELD ? ElementKind.FIELD : ElementKind.METHOD;
    }

    public static String getKeyType(DeclaredType type, Context context) {
        List<? extends TypeMirror> typeArguments = type.getTypeArguments();
        if (typeArguments.isEmpty()) {
            context.logMessage(Diagnostic.Kind.ERROR, "Unable to determine type argument for " + String.valueOf(type));
            return "java.lang.Object";
        }
        return TypeUtils.extractClosestRealTypeAsString(typeArguments.get(0), context);
    }

    public static boolean isClassOrRecordType(Element element) {
        ElementKind kind = element.getKind();
        return kind.isClass() && kind != ElementKind.ENUM;
    }

    public static boolean isClassRecordOrInterfaceType(Element element) {
        ElementKind kind = element.getKind();
        return kind.isClass() && kind != ElementKind.ENUM || kind.isInterface() && kind != ElementKind.ANNOTATION_TYPE;
    }

    public static boolean primitiveClassMatchesKind(Class<?> itemType, TypeKind kind) {
        return switch (kind) {
            case TypeKind.SHORT -> itemType.equals(Short.class);
            case TypeKind.INT -> itemType.equals(Integer.class);
            case TypeKind.LONG -> itemType.equals(Long.class);
            case TypeKind.BOOLEAN -> itemType.equals(Boolean.class);
            case TypeKind.FLOAT -> itemType.equals(Float.class);
            case TypeKind.DOUBLE -> itemType.equals(Double.class);
            case TypeKind.CHAR -> itemType.equals(Character.class);
            case TypeKind.BYTE -> itemType.equals(Byte.class);
            default -> false;
        };
    }

    public static boolean isPropertyGetter(ExecutableType executable, Element element) {
        return element.getKind() == ElementKind.METHOD && StringUtil.isProperty(element.getSimpleName().toString(), TypeUtils.toTypeString(executable.getReturnType()));
    }

    public static boolean isBasicAttribute(Element element, Element returnedElement, Context context) {
        return TypeUtils.hasAnnotation(element, "jakarta.persistence.Basic", "jakarta.persistence.OneToOne", "jakarta.persistence.ManyToOne", "jakarta.persistence.Embedded", "jakarta.persistence.EmbeddedId", "jakarta.persistence.Id") || TypeUtils.hasAnnotation(element, "org.hibernate.annotations.Type") || returnedElement.asType().accept(new BasicAttributeVisitor(context), returnedElement) != false;
    }

    public static @Nullable String getFullyQualifiedClassNameOfTargetEntity(AnnotationMirror mirror, String member) {
        TypeMirror parameterType;
        AnnotationValue value = TypeUtils.getAnnotationValue(mirror, member);
        if (value != null && (parameterType = (TypeMirror)value.getValue()).getKind() != TypeKind.VOID) {
            return parameterType.toString();
        }
        return null;
    }

    public static @Nullable String getTargetEntity(List<? extends AnnotationMirror> annotations) {
        for (AnnotationMirror annotationMirror : annotations) {
            if (TypeUtils.isAnnotationMirrorOfType(annotationMirror, "jakarta.persistence.ElementCollection")) {
                return TypeUtils.getFullyQualifiedClassNameOfTargetEntity(annotationMirror, "targetClass");
            }
            if (TypeUtils.isAnnotationMirrorOfType(annotationMirror, "jakarta.persistence.OneToMany") || TypeUtils.isAnnotationMirrorOfType(annotationMirror, "jakarta.persistence.ManyToMany") || TypeUtils.isAnnotationMirrorOfType(annotationMirror, "jakarta.persistence.ManyToOne") || TypeUtils.isAnnotationMirrorOfType(annotationMirror, "jakarta.persistence.OneToOne")) {
                return TypeUtils.getFullyQualifiedClassNameOfTargetEntity(annotationMirror, "targetEntity");
            }
            if (!TypeUtils.isAnnotationMirrorOfType(annotationMirror, "org.hibernate.annotations.TargetEmbeddable")) continue;
            return TypeUtils.getFullyQualifiedClassNameOfTargetEntity(annotationMirror, DEFAULT_ANNOTATION_PARAMETER_NAME);
        }
        return null;
    }

    public static String propertyName(Element element) {
        switch (element.getKind()) {
            case FIELD: {
                return element.getSimpleName().toString();
            }
            case METHOD: {
                Name name = element.getSimpleName();
                if (name.length() > 3 && name.subSequence(0, 3).equals("get")) {
                    return Introspector.decapitalize(name.subSequence(3, name.length()).toString());
                }
                if (name.length() > 2 && name.subSequence(0, 2).equals("is")) {
                    return Introspector.decapitalize(name.subSequence(2, name.length()).toString());
                }
                return Introspector.decapitalize(name.toString());
            }
        }
        return String.valueOf(element.getSimpleName()) + "/* " + String.valueOf((Object)element.getKind()) + " */";
    }

    public static @Nullable Element findMappedSuperElement(Metamodel entity, Context context) {
        Element element = entity.getElement();
        if (element instanceof TypeElement) {
            TypeElement typeElement = (TypeElement)element;
            TypeMirror superClass = typeElement.getSuperclass();
            while (superClass.getKind() == TypeKind.DECLARED) {
                DeclaredType declaredType = (DeclaredType)superClass;
                TypeElement superClassElement = (TypeElement)declaredType.asElement();
                if (TypeUtils.extendsSuperMetaModel(superClassElement, entity.isMetaComplete(), context)) {
                    return superClassElement;
                }
                superClass = superClassElement.getSuperclass();
            }
        }
        return null;
    }

    private static boolean extendsSuperMetaModel(Element superClassElement, boolean entityMetaComplete, Context context) {
        TypeElement typeElement = (TypeElement)superClassElement;
        String superClassName = typeElement.getQualifiedName().toString();
        return context.containsMetaEntity(superClassName) || context.containsMetaEmbeddable(superClassName) || !entityMetaComplete && TypeUtils.containsAnnotation(superClassElement, "jakarta.persistence.Entity", "jakarta.persistence.MappedSuperclass");
    }

    public static boolean implementsInterface(TypeElement type, String interfaceName) {
        DeclaredType declaredType;
        TypeElement typeElement;
        for (TypeMirror typeMirror : type.getInterfaces()) {
            DeclaredType declaredType2;
            TypeElement typeElement2;
            if (typeMirror.getKind() != TypeKind.DECLARED || !(typeElement2 = (TypeElement)(declaredType2 = (DeclaredType)typeMirror).asElement()).getQualifiedName().contentEquals(interfaceName) && !TypeUtils.implementsInterface(typeElement2, interfaceName)) continue;
            return true;
        }
        TypeMirror superclass = type.getSuperclass();
        return superclass != null && superclass.getKind() == TypeKind.DECLARED && TypeUtils.implementsInterface(typeElement = (TypeElement)(declaredType = (DeclaredType)superclass).asElement(), interfaceName);
    }

    public static boolean extendsClass(TypeElement type, String className) {
        TypeMirror superclass = type.getSuperclass();
        while (superclass != null && superclass.getKind() == TypeKind.DECLARED) {
            DeclaredType declaredType = (DeclaredType)superclass;
            TypeElement typeElement = (TypeElement)declaredType.asElement();
            if (typeElement.getQualifiedName().contentEquals(className)) {
                return true;
            }
            superclass = typeElement.getSuperclass();
        }
        return false;
    }

    public static boolean isMemberType(Element element) {
        return element.getEnclosingElement() instanceof TypeElement;
    }

    public static String getGeneratedClassFullyQualifiedName(TypeElement typeElement, boolean jakartaDataStyle) {
        String simpleName = typeElement.getSimpleName().toString();
        Element enclosingElement = typeElement.getEnclosingElement();
        return TypeUtils.qualifiedName(enclosingElement, jakartaDataStyle) + "." + (jakartaDataStyle ? "_" + simpleName : simpleName + "_");
    }

    private static String qualifiedName(Element enclosingElement, boolean jakartaDataStyle) {
        if (enclosingElement instanceof TypeElement) {
            TypeElement typeElement = (TypeElement)enclosingElement;
            return TypeUtils.getGeneratedClassFullyQualifiedName(typeElement, jakartaDataStyle);
        }
        if (enclosingElement instanceof PackageElement) {
            PackageElement packageElement = (PackageElement)enclosingElement;
            return packageElement.getQualifiedName().toString();
        }
        throw new MetaModelGenerationException("Unexpected enclosing element: " + String.valueOf(enclosingElement));
    }

    public static String getGeneratedClassFullyQualifiedName(TypeElement element, String packageName, boolean jakartaDataStyle) {
        StringBuilder builder = new StringBuilder(packageName);
        Name qualifiedName = element.getQualifiedName();
        String tail = qualifiedName.subSequence(builder.length(), qualifiedName.length()).toString();
        for (String bit : StringHelper.split((String)".", (String)tail)) {
            String part = StringUtil.removeDollar(bit);
            if (!builder.isEmpty()) {
                builder.append(".");
            }
            builder.append(jakartaDataStyle ? "_" + part : part + "_");
        }
        return builder.toString();
    }

    public static boolean isPrimitive(String paramType) {
        return PRIMITIVE_TYPES.contains(paramType);
    }

    public static @Nullable TypeMirror resolveTypeMirror(TypeElement typeElement, Element element, String name) {
        Map<String, TypeMirror> mirrorMap = TypeUtils.resolveTypeParameters(typeElement.asType(), element, Map.of(), new HashSet<Element>());
        return mirrorMap == null ? null : mirrorMap.get(name);
    }

    private static @Nullable Map<String, TypeMirror> resolveTypeParameters(TypeMirror type, Element element, Map<String, TypeMirror> parametersMap, Collection<Element> visited) {
        DeclaredType declaredType;
        Element element2;
        if (!(type instanceof DeclaredType) || !((element2 = (declaredType = (DeclaredType)type).asElement()) instanceof TypeElement)) {
            return null;
        }
        TypeElement typeElement = (TypeElement)element2;
        if (!visited.add(typeElement)) {
            return null;
        }
        List<? extends TypeParameterElement> generic = typeElement.getTypeParameters();
        HashMap<String, TypeMirror> map = new HashMap<String, TypeMirror>();
        List<? extends TypeMirror> typeArguments = declaredType.getTypeArguments();
        if (!typeArguments.isEmpty() && generic.size() != typeArguments.size()) {
            return null;
        }
        for (int n = 0; n < generic.size(); ++n) {
            TypeMirror mirror = typeArguments.isEmpty() ? generic.get(0).getBounds().get(0) : typeArguments.get(n);
            String value = mirror.toString();
            map.put(generic.get(n).toString(), parametersMap.getOrDefault(value, mirror));
        }
        if (typeElement.equals(element)) {
            return map;
        }
        return Stream.concat(Stream.of(typeElement.getSuperclass()), typeElement.getInterfaces().stream()).map(tm -> TypeUtils.resolveTypeParameters(tm, element, map, visited)).filter(Objects::nonNull).findFirst().orElse(null);
    }

    static {
        PRIMITIVE_WRAPPERS.put(TypeKind.CHAR, "Character");
        PRIMITIVE_WRAPPERS.put(TypeKind.BYTE, "Byte");
        PRIMITIVE_WRAPPERS.put(TypeKind.SHORT, "Short");
        PRIMITIVE_WRAPPERS.put(TypeKind.INT, "Integer");
        PRIMITIVE_WRAPPERS.put(TypeKind.LONG, "Long");
        PRIMITIVE_WRAPPERS.put(TypeKind.BOOLEAN, "Boolean");
        PRIMITIVE_WRAPPERS.put(TypeKind.FLOAT, "Float");
        PRIMITIVE_WRAPPERS.put(TypeKind.DOUBLE, "Double");
        PRIMITIVES.put(TypeKind.CHAR, "char");
        PRIMITIVES.put(TypeKind.BYTE, "byte");
        PRIMITIVES.put(TypeKind.SHORT, "short");
        PRIMITIVES.put(TypeKind.INT, "int");
        PRIMITIVES.put(TypeKind.LONG, "long");
        PRIMITIVES.put(TypeKind.BOOLEAN, "boolean");
        PRIMITIVES.put(TypeKind.FLOAT, "float");
        PRIMITIVES.put(TypeKind.DOUBLE, "double");
        PRIMITIVE_TYPES = Set.of("boolean", "char", "long", "int", "short", "byte", "double", "float");
    }

    static class EmbeddedAttributeVisitor
    extends SimpleTypeVisitor8<TypeElement, Element> {
        private final Context context;

        EmbeddedAttributeVisitor(Context context) {
            this.context = context;
        }

        @Override
        public @Nullable TypeElement visitDeclared(DeclaredType declaredType, Element element) {
            TypeElement returnedElement = (TypeElement)this.context.getTypeUtils().asElement(declaredType);
            return TypeUtils.containsAnnotation(NullnessUtil.castNonNull(returnedElement), "jakarta.persistence.Embeddable") ? returnedElement : null;
        }

        @Override
        public @Nullable TypeElement visitExecutable(ExecutableType executable, Element element) {
            if (element.getKind().equals((Object)ElementKind.METHOD)) {
                String string = element.getSimpleName().toString();
                return StringUtil.isProperty(string, TypeUtils.toTypeString(executable.getReturnType())) ? executable.getReturnType().accept(this, element) : null;
            }
            return null;
        }
    }
}

