/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.processor.annotation;

import javax.lang.model.element.Element;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.processor.annotation.AnnotationMetaEntity;
import org.hibernate.processor.model.MetaAttribute;
import org.hibernate.processor.model.Metamodel;
import org.hibernate.processor.util.StringUtil;
import org.hibernate.processor.util.TypeUtils;

public class DataAnnotationMetaAttribute
implements MetaAttribute {
    private final Element element;
    private final AnnotationMetaEntity parent;
    private final String type;
    private final @Nullable String path;

    public DataAnnotationMetaAttribute(AnnotationMetaEntity parent, Element element, String type, @Nullable String path) {
        this.element = element;
        this.parent = parent;
        this.type = type;
        this.path = path;
    }

    @Override
    public boolean hasTypedAttribute() {
        return true;
    }

    @Override
    public boolean hasStringAttribute() {
        return true;
    }

    private boolean isTextual() {
        return "java.lang.String".equals(this.type);
    }

    @Override
    public String getAttributeDeclarationString() {
        String className = this.parent.importType(this.parent.getQualifiedName());
        String elementName = this.element.getSimpleName().toString();
        String memberName = this.path == null ? elementName : this.path + "." + elementName;
        String impl = this.isTextual() ? this.parent.importType("jakarta.data.metamodel.impl.TextAttributeRecord") : this.parent.importType("jakarta.data.metamodel.impl.SortableAttributeRecord");
        return "\n/**\n * Static metamodel for attribute {@link " + className + "#" + memberName + "}\n **/\n" + this.parent.importType(this.getMetaType()) + "<" + className + "> " + this.getPropertyName().replace('.', '_') + " = new " + impl + "<>(" + this.fieldName() + ");";
    }

    @Override
    public String getAttributeNameDeclarationString() {
        return "\n/**\n * @see " + "#" + this.getPropertyName().replace('.', '_') + "\n **/\n" + this.parent.importType("java.lang.String") + " " + this.fieldName() + " = " + "\"" + this.getPropertyName() + "\"" + ";";
    }

    private String fieldName() {
        return StringUtil.getUpperUnderscoreCaseFromLowerCamelCase(this.getPropertyName().replace('.', '_'));
    }

    @Override
    public String getPropertyName() {
        String propertyName = TypeUtils.propertyName(this.element);
        return this.path == null ? propertyName : this.path + "." + propertyName;
    }

    @Override
    public Metamodel getHostingEntity() {
        return this.parent;
    }

    @Override
    public String getMetaType() {
        return this.isTextual() ? "jakarta.data.metamodel.TextAttribute" : "jakarta.data.metamodel.SortableAttribute";
    }

    @Override
    public String getTypeDeclaration() {
        return this.type;
    }

    public String toString() {
        return "DataAnnotationMetaAttribute" + "{element=" + this.element + ", type='" + this.type + '\'' + '}';
    }
}

