/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.processor.validation;

import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.persister.entity.Joinable;
import org.hibernate.processor.validation.MockSessionFactory;
import org.hibernate.type.CollectionType;
import org.hibernate.type.EntityType;
import org.hibernate.type.ListType;
import org.hibernate.type.MapType;
import org.hibernate.type.Type;

public abstract class MockCollectionPersister
implements CollectionPersister,
Joinable {
    private final String role;
    private final MockSessionFactory factory;
    private final CollectionType collectionType;
    private final String ownerEntityName;
    private final Type elementType;

    public MockCollectionPersister(String role, CollectionType collectionType, Type elementType, MockSessionFactory factory) {
        this.role = role;
        this.collectionType = collectionType;
        this.elementType = elementType;
        this.factory = factory;
        this.ownerEntityName = StringHelper.root((String)role);
    }

    String getOwnerEntityName() {
        return this.ownerEntityName;
    }

    public String getRole() {
        return this.role;
    }

    public CollectionType getCollectionType() {
        return this.collectionType;
    }

    public EntityPersister getOwnerEntityPersister() {
        return this.factory.getMetamodel().getEntityDescriptor(this.ownerEntityName);
    }

    abstract Type getElementPropertyType(String var1);

    public Type getKeyType() {
        return this.getOwnerEntityPersister().getIdentifierType();
    }

    public Type getIndexType() {
        if (this.collectionType instanceof ListType) {
            return this.factory.getTypeConfiguration().getBasicTypeForJavaType(Integer.class);
        }
        if (this.collectionType instanceof MapType) {
            return this.factory.getTypeConfiguration().getBasicTypeForJavaType(String.class);
        }
        return null;
    }

    public Type getElementType() {
        return this.elementType;
    }

    public Type getIdentifierType() {
        return this.factory.getTypeConfiguration().getBasicTypeForJavaType(Long.class);
    }

    public boolean hasIndex() {
        return this.getCollectionType() instanceof ListType || this.getCollectionType() instanceof MapType;
    }

    public EntityPersister getElementPersister() {
        if (this.elementType instanceof EntityType) {
            return this.factory.getMetamodel().getEntityDescriptor(this.elementType.getName());
        }
        return null;
    }

    public SessionFactoryImplementor getFactory() {
        return this.factory;
    }

    public boolean isOneToMany() {
        return this.elementType instanceof EntityType;
    }

    public String[] getCollectionSpaces() {
        return new String[]{this.role};
    }

    public String getMappedByProperty() {
        return null;
    }

    public String getTableName() {
        return this.role;
    }
}

