/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.mapping.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.hibernate.search.mapper.pojo.mapping.impl.AbstractPojoTypeManager;
import org.hibernate.search.mapper.pojo.mapping.impl.PojoContainedTypeManager;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeIdentifier;
import org.hibernate.search.mapper.pojo.model.spi.PojoRawTypeModel;
import org.hibernate.search.mapper.pojo.work.impl.PojoWorkContainedTypeContextProvider;
import org.hibernate.search.util.common.impl.Closer;

public class PojoContainedTypeManagerContainer
implements PojoWorkContainedTypeContextProvider {
    private final Map<PojoRawTypeIdentifier<?>, PojoContainedTypeManager<?, ?>> byExactType;
    private final Map<String, PojoContainedTypeManager<?, ?>> byEntityName;
    private final Set<PojoContainedTypeManager<?, ?>> all;

    public static Builder builder() {
        return new Builder();
    }

    private PojoContainedTypeManagerContainer(Builder builder) {
        this.byExactType = new HashMap(builder.byExactType);
        this.byEntityName = new LinkedHashMap(builder.byExactType.size());
        for (PojoContainedTypeManager typeManager : builder.byExactType.values()) {
            this.byEntityName.put(typeManager.entityName(), typeManager);
        }
        this.all = Collections.unmodifiableSet(new LinkedHashSet(this.byExactType.values()));
    }

    public <E> Optional<? extends PojoContainedTypeManager<?, E>> forExactType(PojoRawTypeIdentifier<E> typeIdentifier) {
        return Optional.ofNullable(this.byExactType.get(typeIdentifier));
    }

    public Optional<? extends PojoContainedTypeManager<?, ?>> forEntityName(String entityName) {
        return Optional.ofNullable(this.byEntityName.get(entityName));
    }

    Set<PojoContainedTypeManager<?, ?>> all() {
        return this.all;
    }

    public static class Builder {
        private final Map<PojoRawTypeIdentifier<?>, PojoContainedTypeManager<?, ?>> byExactType = new LinkedHashMap();

        private Builder() {
        }

        public <E> void add(PojoRawTypeModel<E> typeModel, PojoContainedTypeManager<?, E> typeManager) {
            this.byExactType.put(typeModel.typeIdentifier(), typeManager);
        }

        public void closeOnFailure() {
            try (Closer closer = new Closer();){
                closer.pushAll(AbstractPojoTypeManager::close, this.byExactType.values());
            }
        }

        public PojoContainedTypeManagerContainer build() {
            return new PojoContainedTypeManagerContainer(this);
        }
    }
}

