/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.jdbc;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import org.hsqldb.HsqlDateTime;
import org.hsqldb.HsqlException;
import org.hsqldb.error.Error;
import org.hsqldb.jdbc.JDBCArray;
import org.hsqldb.jdbc.JDBCBlobClient;
import org.hsqldb.jdbc.JDBCClobClient;
import org.hsqldb.jdbc.JDBCConnection;
import org.hsqldb.jdbc.JDBCPreparedStatement;
import org.hsqldb.jdbc.Util;
import org.hsqldb.lib.IntValueHashMap;
import org.hsqldb.types.BinaryData;
import org.hsqldb.types.BlobDataID;
import org.hsqldb.types.ClobDataID;
import org.hsqldb.types.DateTimeType;
import org.hsqldb.types.JavaObjectData;
import org.hsqldb.types.TimeData;
import org.hsqldb.types.TimestampData;
import org.hsqldb.types.Type;

public class JDBCCallableStatement
extends JDBCPreparedStatement
implements CallableStatement {
    private IntValueHashMap parameterNameMap = new IntValueHashMap();
    private boolean wasNullValue;

    public synchronized void registerOutParameter(int n, int n2) throws SQLException {
        this.checkGetParameterIndex(n);
        if (this.parameterModes[--n] == 1) {
            throw Util.invalidArgument();
        }
    }

    public synchronized void registerOutParameter(int n, int n2, int n3) throws SQLException {
        this.registerOutParameter(n, n2);
    }

    public synchronized boolean wasNull() throws SQLException {
        if (this.isClosed || this.connection.isClosed) {
            this.checkClosed();
        }
        return this.wasNullValue;
    }

    public synchronized String getString(int n) throws SQLException {
        return (String)this.getColumnInType(n, Type.SQL_VARCHAR);
    }

    public synchronized boolean getBoolean(int n) throws SQLException {
        Object object = this.getColumnInType(n, Type.SQL_BOOLEAN);
        return object == null ? false : (Boolean)object;
    }

    public synchronized byte getByte(int n) throws SQLException {
        Object object = this.getColumnInType(n, Type.TINYINT);
        return object == null ? (byte)0 : ((Number)object).byteValue();
    }

    public synchronized short getShort(int n) throws SQLException {
        Object object = this.getColumnInType(n, Type.SQL_SMALLINT);
        return object == null ? (short)0 : ((Number)object).shortValue();
    }

    public synchronized int getInt(int n) throws SQLException {
        Object object = this.getColumnInType(n, Type.SQL_INTEGER);
        return object == null ? 0 : ((Number)object).intValue();
    }

    public synchronized long getLong(int n) throws SQLException {
        Object object = this.getColumnInType(n, Type.SQL_BIGINT);
        return object == null ? 0L : ((Number)object).longValue();
    }

    public synchronized float getFloat(int n) throws SQLException {
        Object object = this.getColumnInType(n, Type.SQL_DOUBLE);
        return object == null ? 0.0f : ((Number)object).floatValue();
    }

    public synchronized double getDouble(int n) throws SQLException {
        Object object = this.getColumnInType(n, Type.SQL_DOUBLE);
        return object == null ? 0.0 : ((Number)object).doubleValue();
    }

    public synchronized BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        if (this.isClosed || this.connection.isClosed) {
            this.checkClosed();
        }
        if (n2 < 0) {
            throw Util.outOfRangeArgument();
        }
        BigDecimal bigDecimal = this.getBigDecimal(n);
        if (bigDecimal != null) {
            bigDecimal = bigDecimal.setScale(n2, 1);
        }
        return bigDecimal;
    }

    public synchronized byte[] getBytes(int n) throws SQLException {
        Object object = this.getColumnInType(n, Type.SQL_VARBINARY);
        if (object == null) {
            return null;
        }
        return ((BinaryData)object).getBytes();
    }

    public synchronized Date getDate(int n) throws SQLException {
        TimestampData timestampData = (TimestampData)this.getColumnInType(n, Type.SQL_DATE);
        if (timestampData == null) {
            return null;
        }
        return (Date)Type.SQL_DATE.convertSQLToJava(this.session, timestampData);
    }

    public synchronized Time getTime(int n) throws SQLException {
        TimeData timeData = (TimeData)this.getColumnInType(n, Type.SQL_TIME);
        if (timeData == null) {
            return null;
        }
        return (Time)Type.SQL_TIME.convertSQLToJava(this.session, timeData);
    }

    public synchronized Timestamp getTimestamp(int n) throws SQLException {
        TimestampData timestampData = (TimestampData)this.getColumnInType(n, Type.SQL_TIMESTAMP);
        if (timestampData == null) {
            return null;
        }
        return (Timestamp)Type.SQL_TIMESTAMP.convertSQLToJava(this.session, timestampData);
    }

    public synchronized Object getObject(int n) throws SQLException {
        this.checkGetParameterIndex(n);
        Type type = this.parameterTypes[n - 1];
        switch (type.typeCode) {
            case 91: {
                return this.getDate(n);
            }
            case 92: 
            case 94: {
                return this.getTime(n);
            }
            case 93: 
            case 95: {
                return this.getTimestamp(n);
            }
            case 60: 
            case 61: {
                return this.getBytes(n);
            }
            case 14: {
                boolean bl = this.getBoolean(n);
                return this.wasNull() ? null : (bl ? Boolean.TRUE : Boolean.FALSE);
            }
            case 1111: 
            case 2000: {
                Object object = this.getColumnInType(n, type);
                if (object == null) {
                    return null;
                }
                try {
                    return ((JavaObjectData)object).getObject();
                }
                catch (HsqlException hsqlException) {
                    throw Util.sqlException(hsqlException);
                }
            }
        }
        return this.getColumnInType(n, type);
    }

    public synchronized BigDecimal getBigDecimal(int n) throws SQLException {
        if (this.isClosed || this.connection.isClosed) {
            this.checkClosed();
        }
        Type type = this.resultMetaData.columnTypes[n - 1];
        switch (type.typeCode) {
            case 2: 
            case 3: {
                break;
            }
            case -6: 
            case 4: 
            case 5: 
            case 25: {
                type = Type.SQL_DECIMAL;
                break;
            }
            default: {
                type = Type.SQL_DECIMAL_DEFAULT;
            }
        }
        return (BigDecimal)this.getColumnInType(n, type);
    }

    public Object getObject(int n, Map map) throws SQLException {
        this.checkGetParameterIndex(n);
        throw Util.notSupported();
    }

    public Ref getRef(int n) throws SQLException {
        this.checkGetParameterIndex(n);
        throw Util.notSupported();
    }

    public synchronized Blob getBlob(int n) throws SQLException {
        this.checkGetParameterIndex(n);
        Type type = this.resultMetaData.columnTypes[n - 1];
        Object object = this.getColumnInType(n, type);
        if (object == null) {
            return null;
        }
        if (object instanceof BlobDataID) {
            return new JDBCBlobClient(this.session, (BlobDataID)object);
        }
        throw Util.sqlException(5561);
    }

    public synchronized Clob getClob(int n) throws SQLException {
        this.checkGetParameterIndex(n);
        Type type = this.resultMetaData.columnTypes[n - 1];
        Object object = this.getColumnInType(n, type);
        if (object == null) {
            return null;
        }
        if (object instanceof ClobDataID) {
            return new JDBCClobClient(this.session, (ClobDataID)object);
        }
        throw Util.sqlException(5561);
    }

    public Array getArray(int n) throws SQLException {
        this.checkGetParameterIndex(n);
        Type type = this.resultMetaData.columnTypes[n - 1];
        if (!type.isArrayType()) {
            throw Util.sqlException(5561);
        }
        Object[] objectArray = (Object[])this.parameterValues[n - 1];
        if (objectArray == null) {
            return null;
        }
        return new JDBCArray(objectArray, type.collectionBaseType(), type, this.connection);
    }

    public synchronized Date getDate(int n, Calendar calendar) throws SQLException {
        TimestampData timestampData = (TimestampData)this.getColumnInType(n, Type.SQL_DATE);
        if (timestampData == null) {
            return null;
        }
        long l = timestampData.getSeconds() * 1000L;
        if (calendar != null) {
            l = HsqlDateTime.convertMillisToCalendar(calendar, l);
        }
        return new Date(l);
    }

    public synchronized Time getTime(int n, Calendar calendar) throws SQLException {
        TimeData timeData = (TimeData)this.getColumnInType(n, Type.SQL_TIME);
        if (timeData == null) {
            return null;
        }
        long l = DateTimeType.normaliseTime(timeData.getSeconds()) * 1000;
        if (!this.resultMetaData.columnTypes[--n].isDateTimeTypeWithZone()) {
            Calendar calendar2 = calendar == null ? this.session.getCalendar() : calendar;
            l = HsqlDateTime.convertMillisToCalendar(calendar2, l);
            l = HsqlDateTime.getNormalisedTime(l);
        }
        return new Time(l);
    }

    public synchronized Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        Comparable<Calendar> comparable;
        TimestampData timestampData = (TimestampData)this.getColumnInType(n, Type.SQL_TIMESTAMP);
        if (timestampData == null) {
            return null;
        }
        long l = timestampData.getSeconds() * 1000L;
        if (!this.resultMetaData.columnTypes[--n].isDateTimeTypeWithZone()) {
            Comparable<Calendar> comparable2 = comparable = calendar == null ? this.session.getCalendar() : calendar;
            if (calendar != null) {
                l = HsqlDateTime.convertMillisToCalendar((Calendar)comparable, l);
            }
        }
        comparable = new Timestamp(l);
        ((Timestamp)comparable).setNanos(timestampData.getNanos());
        return comparable;
    }

    public synchronized void registerOutParameter(int n, int n2, String string) throws SQLException {
        this.registerOutParameter(n, n2);
    }

    public synchronized void registerOutParameter(String string, int n) throws SQLException {
        this.registerOutParameter(this.findParameterIndex(string), n);
    }

    public synchronized void registerOutParameter(String string, int n, int n2) throws SQLException {
        this.registerOutParameter(this.findParameterIndex(string), n);
    }

    public synchronized void registerOutParameter(String string, int n, String string2) throws SQLException {
        this.registerOutParameter(this.findParameterIndex(string), n);
    }

    public URL getURL(int n) throws SQLException {
        this.checkGetParameterIndex(n);
        throw Util.notSupported();
    }

    public void setURL(String string, URL uRL) throws SQLException {
        this.setURL(this.findParameterIndex(string), uRL);
    }

    public synchronized void setNull(String string, int n) throws SQLException {
        this.setNull(this.findParameterIndex(string), n);
    }

    public synchronized void setBoolean(String string, boolean bl) throws SQLException {
        this.setBoolean(this.findParameterIndex(string), bl);
    }

    public synchronized void setByte(String string, byte by) throws SQLException {
        this.setByte(this.findParameterIndex(string), by);
    }

    public synchronized void setShort(String string, short s) throws SQLException {
        this.setShort(this.findParameterIndex(string), s);
    }

    public synchronized void setInt(String string, int n) throws SQLException {
        this.setInt(this.findParameterIndex(string), n);
    }

    public synchronized void setLong(String string, long l) throws SQLException {
        this.setLong(this.findParameterIndex(string), l);
    }

    public synchronized void setFloat(String string, float f) throws SQLException {
        this.setFloat(this.findParameterIndex(string), f);
    }

    public synchronized void setDouble(String string, double d) throws SQLException {
        this.setDouble(this.findParameterIndex(string), d);
    }

    public synchronized void setBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        this.setBigDecimal(this.findParameterIndex(string), bigDecimal);
    }

    public synchronized void setString(String string, String string2) throws SQLException {
        this.setString(this.findParameterIndex(string), string2);
    }

    public synchronized void setBytes(String string, byte[] byArray) throws SQLException {
        this.setBytes(this.findParameterIndex(string), byArray);
    }

    public synchronized void setDate(String string, Date date) throws SQLException {
        this.setDate(this.findParameterIndex(string), date);
    }

    public synchronized void setTime(String string, Time time) throws SQLException {
        this.setTime(this.findParameterIndex(string), time);
    }

    public synchronized void setTimestamp(String string, Timestamp timestamp) throws SQLException {
        this.setTimestamp(this.findParameterIndex(string), timestamp);
    }

    public synchronized void setAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        this.setAsciiStream(this.findParameterIndex(string), inputStream, n);
    }

    public synchronized void setBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        this.setBinaryStream(this.findParameterIndex(string), inputStream, n);
    }

    public synchronized void setObject(String string, Object object, int n, int n2) throws SQLException {
        this.setObject(this.findParameterIndex(string), object, n, n2);
    }

    public synchronized void setObject(String string, Object object, int n) throws SQLException {
        this.setObject(this.findParameterIndex(string), object, n);
    }

    public synchronized void setObject(String string, Object object) throws SQLException {
        this.setObject(this.findParameterIndex(string), object);
    }

    public synchronized void setCharacterStream(String string, Reader reader, int n) throws SQLException {
        this.setCharacterStream(this.findParameterIndex(string), reader, n);
    }

    public synchronized void setDate(String string, Date date, Calendar calendar) throws SQLException {
        this.setDate(this.findParameterIndex(string), date, calendar);
    }

    public synchronized void setTime(String string, Time time, Calendar calendar) throws SQLException {
        this.setTime(this.findParameterIndex(string), time, calendar);
    }

    public synchronized void setTimestamp(String string, Timestamp timestamp, Calendar calendar) throws SQLException {
        this.setTimestamp(this.findParameterIndex(string), timestamp, calendar);
    }

    public synchronized void setNull(String string, int n, String string2) throws SQLException {
        this.setNull(this.findParameterIndex(string), n, string2);
    }

    public synchronized String getString(String string) throws SQLException {
        return this.getString(this.findParameterIndex(string));
    }

    public synchronized boolean getBoolean(String string) throws SQLException {
        return this.getBoolean(this.findParameterIndex(string));
    }

    public synchronized byte getByte(String string) throws SQLException {
        return this.getByte(this.findParameterIndex(string));
    }

    public synchronized short getShort(String string) throws SQLException {
        return this.getShort(this.findParameterIndex(string));
    }

    public synchronized int getInt(String string) throws SQLException {
        return this.getInt(this.findParameterIndex(string));
    }

    public synchronized long getLong(String string) throws SQLException {
        return this.getLong(this.findParameterIndex(string));
    }

    public synchronized float getFloat(String string) throws SQLException {
        return this.getFloat(this.findParameterIndex(string));
    }

    public synchronized double getDouble(String string) throws SQLException {
        return this.getDouble(this.findParameterIndex(string));
    }

    public synchronized byte[] getBytes(String string) throws SQLException {
        return this.getBytes(this.findParameterIndex(string));
    }

    public synchronized Date getDate(String string) throws SQLException {
        return this.getDate(this.findParameterIndex(string));
    }

    public synchronized Time getTime(String string) throws SQLException {
        return this.getTime(this.findParameterIndex(string));
    }

    public synchronized Timestamp getTimestamp(String string) throws SQLException {
        return this.getTimestamp(this.findParameterIndex(string));
    }

    public synchronized Object getObject(String string) throws SQLException {
        return this.getObject(this.findParameterIndex(string));
    }

    public synchronized BigDecimal getBigDecimal(String string) throws SQLException {
        return this.getBigDecimal(this.findParameterIndex(string));
    }

    public synchronized Object getObject(String string, Map map) throws SQLException {
        return this.getObject(this.findParameterIndex(string), map);
    }

    public synchronized Ref getRef(String string) throws SQLException {
        return this.getRef(this.findParameterIndex(string));
    }

    public synchronized Blob getBlob(String string) throws SQLException {
        return this.getBlob(this.findParameterIndex(string));
    }

    public synchronized Clob getClob(String string) throws SQLException {
        return this.getClob(this.findParameterIndex(string));
    }

    public synchronized Array getArray(String string) throws SQLException {
        return this.getArray(this.findParameterIndex(string));
    }

    public synchronized Date getDate(String string, Calendar calendar) throws SQLException {
        return this.getDate(this.findParameterIndex(string), calendar);
    }

    public synchronized Time getTime(String string, Calendar calendar) throws SQLException {
        return this.getTime(this.findParameterIndex(string), calendar);
    }

    public synchronized Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        return this.getTimestamp(this.findParameterIndex(string), calendar);
    }

    public URL getURL(String string) throws SQLException {
        return this.getURL(this.findParameterIndex(string));
    }

    public JDBCCallableStatement(JDBCConnection jDBCConnection, String string, int n, int n2, int n3) throws HsqlException, SQLException {
        super(jDBCConnection, string, n, n2, n3, 2, null, null);
        if (this.parameterMetaData != null) {
            String[] stringArray = this.parameterMetaData.columnLabels;
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i];
                if (string2 == null || string2.length() == 0) continue;
                this.parameterNameMap.put(string2, i);
            }
        }
    }

    void fetchResult() throws SQLException {
        super.fetchResult();
        if (this.resultIn.getType() == 43) {
            Object[] objectArray = this.resultIn.getParameterData();
            for (int i = 0; i < this.parameterValues.length; ++i) {
                this.parameterValues[i] = objectArray[i];
            }
        }
    }

    int findParameterIndex(String string) throws SQLException {
        int n;
        if (this.isClosed || this.connection.isClosed) {
            this.checkClosed();
        }
        if ((n = this.parameterNameMap.get((Object)string, -1)) >= 0) {
            return n + 1;
        }
        throw Util.sqlException(421, string);
    }

    public synchronized void close() throws SQLException {
        if (this.isClosed()) {
            return;
        }
        this.parameterNameMap = null;
        super.close();
    }

    private Object getColumnInType(int n, Type type) throws SQLException {
        this.checkGetParameterIndex(n);
        Type type2 = this.parameterTypes[--n];
        Object object = this.parameterValues[n];
        if (this.trackNull(object)) {
            return null;
        }
        if (type2.typeCode != type.typeCode) {
            try {
                object = type.convertToTypeJDBC(this.session, object, type2);
            }
            catch (HsqlException hsqlException) {
                String string = object instanceof Number || object instanceof String || object instanceof java.util.Date ? object.toString() : "instance of " + object.getClass().getName();
                String string2 = "from SQL type " + type2.getNameString() + " to " + type.getJDBCClassName() + ", value: " + string;
                HsqlException hsqlException2 = Error.error(5561, string2);
                throw Util.sqlException(hsqlException2, hsqlException);
            }
        }
        return object;
    }

    private boolean trackNull(Object object) {
        this.wasNullValue = object == null;
        return this.wasNullValue;
    }
}

