/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.jdbc.pool;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Set;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;
import org.hsqldb.jdbc.JDBCConnection;
import org.hsqldb.jdbc.pool.BaseConnectionWrapper;
import org.hsqldb.jdbc.pool.ConnectionDefaults;
import org.hsqldb.jdbc.pool.JDBCPooledConnection;

public class LifeTimeConnectionWrapper
extends BaseConnectionWrapper {
    protected JDBCConnection connection = null;
    protected PooledConnection pooledConnection = null;
    protected Set connectionListeners = new HashSet();
    protected ConnectionDefaults connectionDefaults = null;

    public LifeTimeConnectionWrapper(JDBCConnection jDBCConnection, ConnectionDefaults connectionDefaults) throws SQLException {
        this.connection = jDBCConnection;
        if (connectionDefaults != null) {
            this.connectionDefaults = connectionDefaults;
            this.connectionDefaults.setDefaults(jDBCConnection);
        } else {
            this.connectionDefaults = new ConnectionDefaults(jDBCConnection);
        }
    }

    public LifeTimeConnectionWrapper(JDBCConnection jDBCConnection) throws SQLException {
        this(jDBCConnection, null);
    }

    public void setPooledConnection(JDBCPooledConnection jDBCPooledConnection) {
        this.pooledConnection = jDBCPooledConnection;
    }

    public void addConnectionEventListener(ConnectionEventListener connectionEventListener) {
        this.connectionListeners.add(connectionEventListener);
    }

    public void removeConnectionEventListener(ConnectionEventListener connectionEventListener) {
        this.connectionListeners.remove(connectionEventListener);
    }

    protected void finalize() throws Throwable {
        this.closePhysically();
    }

    protected Connection getConnection() {
        return this.connection;
    }

    public void close() throws SQLException {
        this.validate();
        try {
            this.connection.rollback();
            this.connection.clearWarnings();
            this.connection.reset();
            this.connectionDefaults.setDefaults(this.connection);
            this.fireCloseEvent();
        }
        catch (SQLException sQLException) {
            this.fireSqlExceptionEvent(sQLException);
            throw sQLException;
        }
    }

    public void closePhysically() throws SQLException {
        SQLException sQLException = null;
        if (!this.isClosed && this.connection != null && !this.connection.isClosed()) {
            try {
                this.connection.close();
            }
            catch (SQLException sQLException2) {
                sQLException = sQLException2;
            }
        }
        this.isClosed = true;
        this.pooledConnection = null;
        this.connection = null;
        this.connectionDefaults = null;
        this.connectionListeners.clear();
        this.connectionListeners = null;
        if (sQLException != null) {
            throw sQLException;
        }
    }

    protected void fireSqlExceptionEvent(SQLException sQLException) {
        ConnectionEvent connectionEvent = new ConnectionEvent(this.pooledConnection, sQLException);
        for (ConnectionEventListener connectionEventListener : this.connectionListeners) {
            connectionEventListener.connectionErrorOccurred(connectionEvent);
        }
    }

    protected void fireCloseEvent() {
        ConnectionEvent connectionEvent = new ConnectionEvent(this.pooledConnection);
        for (ConnectionEventListener connectionEventListener : this.connectionListeners) {
            connectionEventListener.connectionClosed(connectionEvent);
        }
    }
}

