/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.csp;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.htmlunit.csp.Constants;
import org.htmlunit.csp.Directive;
import org.htmlunit.csp.FetchDirectiveKind;
import org.htmlunit.csp.PolicyList;
import org.htmlunit.csp.Utils;
import org.htmlunit.csp.directive.FrameAncestorsDirective;
import org.htmlunit.csp.directive.HostSourceDirective;
import org.htmlunit.csp.directive.PluginTypesDirective;
import org.htmlunit.csp.directive.ReportUriDirective;
import org.htmlunit.csp.directive.SandboxDirective;
import org.htmlunit.csp.directive.SourceExpressionDirective;
import org.htmlunit.csp.url.GUID;
import org.htmlunit.csp.url.URI;
import org.htmlunit.csp.url.URLWithScheme;
import org.htmlunit.csp.value.Hash;
import org.htmlunit.csp.value.Host;
import org.htmlunit.csp.value.MediaType;
import org.htmlunit.csp.value.RFC7230Token;
import org.htmlunit.csp.value.Scheme;

public final class Policy {
    private final List<NamedDirective> directives_ = new ArrayList<NamedDirective>();
    private SourceExpressionDirective baseUri_;
    private boolean blockAllMixedContent_;
    private SourceExpressionDirective formAction_;
    private FrameAncestorsDirective frameAncestors_;
    private SourceExpressionDirective navigateTo_;
    private PluginTypesDirective pluginTypes_;
    private FetchDirectiveKind prefetchSrc_;
    private RFC7230Token reportTo_;
    private ReportUriDirective reportUri_;
    private SandboxDirective sandbox_;
    private boolean upgradeInsecureRequests_;
    private final EnumMap<FetchDirectiveKind, SourceExpressionDirective> fetchDirectives_ = new EnumMap(FetchDirectiveKind.class);

    private Policy() {
    }

    public static PolicyList parseSerializedCSPList(String serialized, PolicyListErrorConsumer policyListErrorConsumer) {
        Policy.enforceAscii(serialized);
        ArrayList<Policy> policies = new ArrayList<Policy>();
        int[] index = new int[]{0};
        PolicyErrorConsumer policyErrorConsumer = (severity, message, directiveIndex, valueIndex) -> policyListErrorConsumer.add(severity, message, index[0], directiveIndex, valueIndex);
        for (String token : serialized.split(",")) {
            Policy policy = Policy.parseSerializedCSP(token, policyErrorConsumer);
            if (policy.directives_.isEmpty()) {
                index[0] = index[0] + 1;
                continue;
            }
            policies.add(policy);
            index[0] = index[0] + 1;
        }
        return new PolicyList(policies);
    }

    public static Policy parseSerializedCSP(String serialized, PolicyErrorConsumer policyErrorConsumer) {
        Policy.enforceAscii(serialized);
        if (serialized.contains(",")) {
            throw new IllegalArgumentException("Serialized CSPs cannot contain commas - you may have wanted parseSerializedCSPList");
        }
        int[] index = new int[]{0};
        Directive.DirectiveErrorConsumer directiveErrorConsumer = (severity, message, valueIndex) -> policyErrorConsumer.add(severity, message, index[0], valueIndex);
        Policy policy = new Policy();
        for (String token : serialized.split(";")) {
            String strippedLeadingAndTrailingWhitespace = Policy.stripTrailingWhitespace(Policy.stripLeadingWhitespace(token));
            if (strippedLeadingAndTrailingWhitespace.isEmpty()) {
                index[0] = index[0] + 1;
                continue;
            }
            String directiveName = Policy.collect(strippedLeadingAndTrailingWhitespace, "[^\t\n\f\r ]+");
            String remainingToken = strippedLeadingAndTrailingWhitespace.substring(directiveName.length());
            List<String> directiveValues = Utils.splitOnAsciiWhitespace(remainingToken);
            policy.add(directiveName, directiveValues, directiveErrorConsumer);
            index[0] = index[0] + 1;
        }
        return policy;
    }

    private Directive add(String name, List<String> values, Directive.DirectiveErrorConsumer directiveErrorConsumer) {
        Directive newDirective;
        String lowcaseDirectiveName;
        Policy.enforceAscii(name);
        if (Directive.containsNonDirectiveCharacter.test(name)) {
            throw new IllegalArgumentException("directive names must not contain whitespace, ',', or ';'");
        }
        if (name.isEmpty()) {
            throw new IllegalArgumentException("directive names must not be empty");
        }
        boolean wasDupe = false;
        switch (lowcaseDirectiveName = name.toLowerCase(Locale.ROOT)) {
            case "base-uri": {
                SourceExpressionDirective baseUriDirective = new SourceExpressionDirective(values, directiveErrorConsumer);
                if (this.baseUri_ == null) {
                    this.baseUri_ = baseUriDirective;
                } else {
                    wasDupe = true;
                }
                newDirective = baseUriDirective;
                break;
            }
            case "block-all-mixed-content": {
                if (this.blockAllMixedContent_) {
                    wasDupe = true;
                } else {
                    if (!values.isEmpty()) {
                        directiveErrorConsumer.add(Severity.Error, "The block-all-mixed-content directive does not support values", 0);
                    }
                    this.blockAllMixedContent_ = true;
                }
                newDirective = new Directive(values);
                break;
            }
            case "form-action": {
                SourceExpressionDirective formActionDirective = new SourceExpressionDirective(values, directiveErrorConsumer);
                if (this.formAction_ == null) {
                    this.formAction_ = formActionDirective;
                } else {
                    wasDupe = true;
                }
                newDirective = formActionDirective;
                break;
            }
            case "frame-ancestors": {
                FrameAncestorsDirective frameAncestorsDirective = new FrameAncestorsDirective(values, directiveErrorConsumer);
                if (this.frameAncestors_ == null) {
                    this.frameAncestors_ = frameAncestorsDirective;
                } else {
                    wasDupe = true;
                }
                newDirective = frameAncestorsDirective;
                break;
            }
            case "navigate-to": {
                SourceExpressionDirective navigateToDirective = new SourceExpressionDirective(values, directiveErrorConsumer);
                if (this.navigateTo_ == null) {
                    this.navigateTo_ = navigateToDirective;
                } else {
                    wasDupe = true;
                }
                newDirective = navigateToDirective;
                break;
            }
            case "plugin-types": {
                directiveErrorConsumer.add(Severity.Warning, "The plugin-types directive has been deprecated", -1);
                PluginTypesDirective pluginTypesDirective = new PluginTypesDirective(values, directiveErrorConsumer);
                if (this.pluginTypes_ == null) {
                    this.pluginTypes_ = pluginTypesDirective;
                } else {
                    wasDupe = true;
                }
                newDirective = pluginTypesDirective;
                break;
            }
            case "report-to": {
                if (this.reportTo_ == null) {
                    if (values.isEmpty()) {
                        directiveErrorConsumer.add(Severity.Error, "The report-to directive requires a value", -1);
                    } else if (values.size() == 1) {
                        String token = values.get(0);
                        Optional<RFC7230Token> matched = RFC7230Token.parseRFC7230Token(token);
                        if (matched.isPresent()) {
                            this.reportTo_ = matched.get();
                        } else {
                            directiveErrorConsumer.add(Severity.Error, "Expecting RFC 7230 token but found \"" + token + "\"", 0);
                        }
                    } else {
                        directiveErrorConsumer.add(Severity.Error, "The report-to directive requires exactly one value (found " + values.size() + ")", 1);
                    }
                } else {
                    wasDupe = true;
                }
                newDirective = new Directive(values);
                break;
            }
            case "referrer": {
                directiveErrorConsumer.add(Severity.Warning, "The referrer directive has been deprecated in favor of the Referrer-Policy header", -1);
                newDirective = new Directive(Collections.emptyList());
                break;
            }
            case "report-uri": {
                directiveErrorConsumer.add(Severity.Warning, "The report-uri directive has been deprecated in favor of the new report-to directive", -1);
                ReportUriDirective reportUriDirective = new ReportUriDirective(values, directiveErrorConsumer);
                if (this.reportUri_ == null) {
                    this.reportUri_ = reportUriDirective;
                } else {
                    wasDupe = true;
                }
                newDirective = reportUriDirective;
                break;
            }
            case "sandbox": {
                SandboxDirective sandboxDirective = new SandboxDirective(values, directiveErrorConsumer);
                if (this.sandbox_ == null) {
                    this.sandbox_ = sandboxDirective;
                } else {
                    wasDupe = true;
                }
                newDirective = sandboxDirective;
                break;
            }
            case "upgrade-insecure-requests": {
                if (this.upgradeInsecureRequests_) {
                    wasDupe = true;
                } else {
                    if (!values.isEmpty()) {
                        directiveErrorConsumer.add(Severity.Error, "The upgrade-insecure-requests directive does not support values", 0);
                    }
                    this.upgradeInsecureRequests_ = true;
                }
                newDirective = new Directive(values);
                break;
            }
            default: {
                if (!Directive.IS_DIRECTIVE_NAME.test(name)) {
                    directiveErrorConsumer.add(Severity.Error, "Directive name " + name + " contains characters outside the range ALPHA / DIGIT / \"-\"", -1);
                    newDirective = new Directive(values);
                    break;
                }
                FetchDirectiveKind fetchDirectiveKind = FetchDirectiveKind.fromString(lowcaseDirectiveName);
                if (fetchDirectiveKind != null) {
                    if (FetchDirectiveKind.PrefetchSrc == fetchDirectiveKind) {
                        directiveErrorConsumer.add(Severity.Warning, "The prefetch-src directive has been deprecated", -1);
                    }
                    SourceExpressionDirective thisDirective = new SourceExpressionDirective(values, directiveErrorConsumer);
                    if (this.fetchDirectives_.containsKey((Object)fetchDirectiveKind)) {
                        wasDupe = true;
                    } else {
                        this.fetchDirectives_.put(fetchDirectiveKind, thisDirective);
                    }
                    newDirective = thisDirective;
                    break;
                }
                directiveErrorConsumer.add(Severity.Warning, "Unrecognized directive " + lowcaseDirectiveName, -1);
                newDirective = new Directive(values);
            }
        }
        this.directives_.add(new NamedDirective(name, newDirective));
        if (wasDupe) {
            directiveErrorConsumer.add(Severity.Warning, "Duplicate directive " + lowcaseDirectiveName, -1);
        }
        return newDirective;
    }

    public String toString() {
        StringBuilder out = new StringBuilder();
        boolean first = true;
        for (NamedDirective directive : this.directives_) {
            if (!first) {
                out.append("; ");
            }
            first = false;
            out.append(directive.name_);
            for (String value : directive.directive_.getValues()) {
                out.append(' ').append(value);
            }
        }
        return out.toString();
    }

    public Optional<SourceExpressionDirective> baseUri() {
        return Optional.ofNullable(this.baseUri_);
    }

    public boolean blockAllMixedContent() {
        return this.blockAllMixedContent_;
    }

    public Optional<SourceExpressionDirective> formAction() {
        return Optional.ofNullable(this.formAction_);
    }

    public Optional<FrameAncestorsDirective> frameAncestors() {
        return Optional.ofNullable(this.frameAncestors_);
    }

    public Optional<SourceExpressionDirective> navigateTo() {
        return Optional.ofNullable(this.navigateTo_);
    }

    public Optional<PluginTypesDirective> pluginTypes() {
        return Optional.ofNullable(this.pluginTypes_);
    }

    public Optional<FetchDirectiveKind> prefetchSrc() {
        return Optional.ofNullable(this.prefetchSrc_);
    }

    public Optional<RFC7230Token> reportTo() {
        return Optional.ofNullable(this.reportTo_);
    }

    public Optional<ReportUriDirective> reportUri() {
        return Optional.ofNullable(this.reportUri_);
    }

    public Optional<SandboxDirective> sandbox() {
        return Optional.ofNullable(this.sandbox_);
    }

    public boolean upgradeInsecureRequests() {
        return this.upgradeInsecureRequests_;
    }

    public Optional<SourceExpressionDirective> getFetchDirective(FetchDirectiveKind kind) {
        return Optional.ofNullable(this.fetchDirectives_.get((Object)kind));
    }

    public boolean allowsExternalScript(Optional<String> nonce, Optional<String> integrity, Optional<URLWithScheme> scriptUrl, Optional<Boolean> parserInserted, Optional<URLWithScheme> origin) {
        String actualNonce;
        if (this.sandbox_ != null && !this.sandbox_.allowScripts()) {
            return false;
        }
        SourceExpressionDirective directive = this.getGoverningDirectiveForEffectiveDirective(FetchDirectiveKind.ScriptSrcElem).orElse(null);
        if (directive == null) {
            return true;
        }
        if (nonce.isPresent() && (actualNonce = nonce.get()).length() > 0 && directive.getNonces().stream().anyMatch(n -> n.getBase64ValuePart().equals(actualNonce))) {
            return true;
        }
        if (integrity.isPresent() && !directive.getHashes().isEmpty()) {
            String integritySources = integrity.get();
            boolean bypassDueToIntegrityMatch = true;
            boolean atLeastOneValidIntegrity = false;
            for (String source : Utils.splitOnAsciiWhitespace(integritySources)) {
                Optional<Hash> parsedIntegritySource = Hash.parseHash("'" + source + "'");
                if (!parsedIntegritySource.isPresent()) continue;
                if (!directive.getHashes().contains(parsedIntegritySource.get())) {
                    bypassDueToIntegrityMatch = false;
                    break;
                }
                atLeastOneValidIntegrity = true;
            }
            if (atLeastOneValidIntegrity && bypassDueToIntegrityMatch) {
                return true;
            }
        }
        if (directive.strictDynamic()) {
            return parserInserted.orElse(true) == false;
        }
        if (scriptUrl.isPresent()) {
            return Policy.doesUrlMatchSourceListInOrigin(scriptUrl.get(), directive, origin);
        }
        return false;
    }

    public boolean allowsInlineScript(Optional<String> nonce, Optional<String> source, Optional<Boolean> parserInserted) {
        if (this.sandbox_ != null && !this.sandbox_.allowScripts()) {
            return false;
        }
        return this.doesElementMatchSourceListForTypeAndSource(InlineType.Script, nonce, source, parserInserted);
    }

    public boolean allowsScriptAsAttribute(Optional<String> source) {
        if (this.sandbox_ != null && !this.sandbox_.allowScripts()) {
            return false;
        }
        return this.doesElementMatchSourceListForTypeAndSource(InlineType.ScriptAttribute, Optional.empty(), source, Optional.empty());
    }

    public boolean allowsEval() {
        FetchDirectiveKind governingDirective = this.fetchDirectives_.containsKey((Object)FetchDirectiveKind.ScriptSrc) ? FetchDirectiveKind.ScriptSrc : FetchDirectiveKind.DefaultSrc;
        SourceExpressionDirective sourceList = this.fetchDirectives_.get((Object)governingDirective);
        return sourceList == null || sourceList.unsafeEval();
    }

    public boolean allowsNavigation(Optional<URLWithScheme> to, Optional<Boolean> redirected, Optional<URLWithScheme> redirectedTo, Optional<URLWithScheme> origin) {
        if (this.navigateTo_ == null) {
            return true;
        }
        if (this.navigateTo_.unsafeAllowRedirects()) {
            if (!redirected.orElse(false).booleanValue()) {
                if (!to.isPresent()) {
                    return false;
                }
                if (!Policy.doesUrlMatchSourceListInOrigin(to.get(), this.navigateTo_, origin)) {
                    return false;
                }
            }
            if (redirected.orElse(true).booleanValue()) {
                if (!redirectedTo.isPresent()) {
                    return false;
                }
                if (!Policy.doesUrlMatchSourceListInOrigin(redirectedTo.get(), this.navigateTo_, origin)) {
                    return false;
                }
            }
        } else {
            if (!to.isPresent()) {
                return false;
            }
            if (!Policy.doesUrlMatchSourceListInOrigin(to.get(), this.navigateTo_, origin)) {
                return false;
            }
        }
        return true;
    }

    public boolean allowsFormAction(Optional<URLWithScheme> to, Optional<Boolean> redirected, Optional<URLWithScheme> redirectedTo, Optional<URLWithScheme> origin) {
        if (this.sandbox_ != null && !this.sandbox_.allowForms()) {
            return false;
        }
        if (this.formAction_ != null) {
            if (!to.isPresent()) {
                return false;
            }
            return Policy.doesUrlMatchSourceListInOrigin(to.get(), this.formAction_, origin);
        }
        return this.allowsNavigation(to, redirected, redirectedTo, origin);
    }

    public boolean allowsJavascriptUrlNavigation(Optional<String> source, Optional<URLWithScheme> origin) {
        return this.allowsNavigation(Optional.of(new GUID("javascript", source.orElse(""))), Optional.of(false), Optional.empty(), origin) && this.doesElementMatchSourceListForTypeAndSource(InlineType.Navigation, Optional.empty(), source.map(s -> "javascript:" + s), Optional.of(false));
    }

    public boolean allowsExternalStyle(Optional<String> nonce, Optional<URLWithScheme> styleUrl, Optional<URLWithScheme> origin) {
        String actualNonce;
        SourceExpressionDirective directive = this.getGoverningDirectiveForEffectiveDirective(FetchDirectiveKind.StyleSrcElem).orElse(null);
        if (directive == null) {
            return true;
        }
        if (nonce.isPresent() && (actualNonce = nonce.get()).length() > 0 && directive.getNonces().stream().anyMatch(n -> n.getBase64ValuePart().equals(actualNonce))) {
            return true;
        }
        if (styleUrl.isPresent()) {
            return Policy.doesUrlMatchSourceListInOrigin(styleUrl.get(), directive, origin);
        }
        return false;
    }

    public boolean allowsInlineStyle(Optional<String> nonce, Optional<String> source) {
        return this.doesElementMatchSourceListForTypeAndSource(InlineType.Style, nonce, source, Optional.empty());
    }

    public boolean allowsStyleAsAttribute(Optional<String> source) {
        return this.doesElementMatchSourceListForTypeAndSource(InlineType.StyleAttribute, Optional.empty(), source, Optional.empty());
    }

    public boolean allowsFrame(Optional<URLWithScheme> source, Optional<URLWithScheme> origin) {
        SourceExpressionDirective sourceList = this.getGoverningDirectiveForEffectiveDirective(FetchDirectiveKind.FrameSrc).orElse(null);
        if (sourceList == null) {
            return true;
        }
        if (!source.isPresent()) {
            return false;
        }
        return Policy.doesUrlMatchSourceListInOrigin(source.get(), sourceList, origin);
    }

    public boolean allowsFrameAncestor(Optional<URLWithScheme> source, Optional<URLWithScheme> origin) {
        if (this.frameAncestors_ == null) {
            return true;
        }
        if (!source.isPresent()) {
            return false;
        }
        return Policy.doesUrlMatchSourceListInOrigin(source.get(), this.frameAncestors_, origin);
    }

    public boolean allowsConnection(Optional<URLWithScheme> source, Optional<URLWithScheme> origin) {
        SourceExpressionDirective sourceList = this.getGoverningDirectiveForEffectiveDirective(FetchDirectiveKind.ConnectSrc).orElse(null);
        if (sourceList == null) {
            return true;
        }
        if (!source.isPresent()) {
            return false;
        }
        URLWithScheme actualSource = source.get();
        String scheme = actualSource.getScheme();
        URLWithScheme usedSource = actualSource;
        if (actualSource instanceof URI) {
            if ("ws".equals(scheme)) {
                usedSource = new URI("http", actualSource.getHost(), (int)actualSource.getPort(), actualSource.getPath());
            } else if ("wss".equals(scheme)) {
                usedSource = new URI("https", actualSource.getHost(), (int)actualSource.getPort(), actualSource.getPath());
            }
        }
        return Policy.doesUrlMatchSourceListInOrigin(usedSource, sourceList, origin);
    }

    public boolean allowsFont(Optional<URLWithScheme> source, Optional<URLWithScheme> origin) {
        SourceExpressionDirective sourceList = this.getGoverningDirectiveForEffectiveDirective(FetchDirectiveKind.FontSrc).orElse(null);
        if (sourceList == null) {
            return true;
        }
        if (!source.isPresent()) {
            return false;
        }
        return Policy.doesUrlMatchSourceListInOrigin(source.get(), sourceList, origin);
    }

    public boolean allowsImage(Optional<URLWithScheme> source, Optional<URLWithScheme> origin) {
        SourceExpressionDirective sourceList = this.getGoverningDirectiveForEffectiveDirective(FetchDirectiveKind.ImgSrc).orElse(null);
        if (sourceList == null) {
            return true;
        }
        if (!source.isPresent()) {
            return false;
        }
        return Policy.doesUrlMatchSourceListInOrigin(source.get(), sourceList, origin);
    }

    public boolean allowsApplicationManifest(Optional<URLWithScheme> source, Optional<URLWithScheme> origin) {
        SourceExpressionDirective sourceList = this.getGoverningDirectiveForEffectiveDirective(FetchDirectiveKind.ManifestSrc).orElse(null);
        if (sourceList == null) {
            return true;
        }
        if (!source.isPresent()) {
            return false;
        }
        return Policy.doesUrlMatchSourceListInOrigin(source.get(), sourceList, origin);
    }

    public boolean allowsMedia(Optional<URLWithScheme> source, Optional<URLWithScheme> origin) {
        SourceExpressionDirective sourceList = this.getGoverningDirectiveForEffectiveDirective(FetchDirectiveKind.MediaSrc).orElse(null);
        if (sourceList == null) {
            return true;
        }
        if (!source.isPresent()) {
            return false;
        }
        return Policy.doesUrlMatchSourceListInOrigin(source.get(), sourceList, origin);
    }

    public boolean allowsObject(Optional<URLWithScheme> source, Optional<URLWithScheme> origin) {
        SourceExpressionDirective sourceList = this.getGoverningDirectiveForEffectiveDirective(FetchDirectiveKind.ObjectSrc).orElse(null);
        if (sourceList == null) {
            return true;
        }
        if (!source.isPresent()) {
            return false;
        }
        return Policy.doesUrlMatchSourceListInOrigin(source.get(), sourceList, origin);
    }

    public boolean allowsPrefetch(Optional<URLWithScheme> source, Optional<URLWithScheme> origin) {
        SourceExpressionDirective sourceList = this.getGoverningDirectiveForEffectiveDirective(FetchDirectiveKind.PrefetchSrc).orElse(null);
        if (sourceList == null) {
            return true;
        }
        if (!source.isPresent()) {
            return false;
        }
        return Policy.doesUrlMatchSourceListInOrigin(source.get(), sourceList, origin);
    }

    public boolean allowsWorker(Optional<URLWithScheme> source, Optional<URLWithScheme> origin) {
        SourceExpressionDirective sourceList = this.getGoverningDirectiveForEffectiveDirective(FetchDirectiveKind.WorkerSrc).orElse(null);
        if (sourceList == null) {
            return true;
        }
        if (!source.isPresent()) {
            return false;
        }
        return Policy.doesUrlMatchSourceListInOrigin(source.get(), sourceList, origin);
    }

    public boolean allowsPlugin(Optional<MediaType> mediaType) {
        if (this.pluginTypes_ == null) {
            return true;
        }
        if (!mediaType.isPresent()) {
            return false;
        }
        return this.pluginTypes_.getMediaTypes().contains(mediaType.get());
    }

    public Optional<SourceExpressionDirective> getGoverningDirectiveForEffectiveDirective(FetchDirectiveKind kind) {
        for (FetchDirectiveKind candidate : FetchDirectiveKind.getFetchDirectiveFallbackList(kind)) {
            SourceExpressionDirective list = this.fetchDirectives_.get((Object)candidate);
            if (list == null) continue;
            return Optional.of(list);
        }
        return Optional.empty();
    }

    private boolean doesElementMatchSourceListForTypeAndSource(InlineType type, Optional<String> nonce, Optional<String> source, Optional<Boolean> parserInserted) {
        String actualNonce;
        boolean allowAllInline;
        SourceExpressionDirective directive = this.getGoverningDirectiveForEffectiveDirective(type.effectiveDirective_).orElse(null);
        if (directive == null) {
            return true;
        }
        boolean bl = allowAllInline = directive.getNonces().isEmpty() && directive.getHashes().isEmpty() && (type != InlineType.Script && type != InlineType.ScriptAttribute && type != InlineType.Navigation || !directive.strictDynamic()) && directive.unsafeInline();
        if (allowAllInline) {
            return true;
        }
        if (nonce.isPresent() && (actualNonce = nonce.get()).length() > 0 && directive.getNonces().stream().anyMatch(n -> n.getBase64ValuePart().equals(actualNonce))) {
            return true;
        }
        if (source.isPresent() && !directive.getHashes().isEmpty() && (type == InlineType.Script || type == InlineType.Style || directive.unsafeHashes())) {
            byte[] actualSource = source.get().getBytes(StandardCharsets.UTF_8);
            Base64.Encoder base64encoder = Base64.getEncoder();
            String actualSha256 = null;
            String actualSha384 = null;
            String actualSha512 = null;
            try {
                block7: for (Hash hash : directive.getHashes()) {
                    switch (hash.getAlgorithm()) {
                        case SHA256: {
                            if (actualSha256 == null) {
                                actualSha256 = base64encoder.encodeToString(MessageDigest.getInstance("SHA-256").digest(actualSource));
                            }
                            if (!actualSha256.equals(Policy.normalizeBase64Url(hash.getBase64ValuePart()))) continue block7;
                            return true;
                        }
                        case SHA384: {
                            if (actualSha384 == null) {
                                actualSha384 = base64encoder.encodeToString(MessageDigest.getInstance("SHA-384").digest(actualSource));
                            }
                            if (!actualSha384.equals(Policy.normalizeBase64Url(hash.getBase64ValuePart()))) continue block7;
                            return true;
                        }
                        case SHA512: {
                            if (actualSha512 == null) {
                                actualSha512 = base64encoder.encodeToString(MessageDigest.getInstance("SHA-512").digest(actualSource));
                            }
                            if (!actualSha512.equals(Policy.normalizeBase64Url(hash.getBase64ValuePart()))) continue block7;
                            return true;
                        }
                    }
                    throw new IllegalArgumentException("Unknown hash algorithm " + (Object)((Object)hash.getAlgorithm()));
                }
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
        }
        return type == InlineType.Script && directive.strictDynamic() && parserInserted.orElse(true) == false;
    }

    private static String normalizeBase64Url(String input) {
        return input.replace('-', '+').replace('_', '/');
    }

    public static boolean doesUrlMatchSourceListInOrigin(URLWithScheme url, HostSourceDirective list, Optional<URLWithScheme> origin) {
        String urlScheme = url.getScheme();
        if (list.star()) {
            if (Objects.equals(urlScheme, "ftp") || Objects.equals(urlScheme, "http") || Objects.equals(urlScheme, "https")) {
                return true;
            }
            if (origin.isPresent() && Objects.equals(urlScheme, origin.get().getScheme())) {
                return true;
            }
        }
        for (Scheme scheme : list.getSchemes()) {
            if (!Policy.schemePartMatches(scheme.getValue(), urlScheme)) continue;
            return true;
        }
        for (Host expression : list.getHosts()) {
            String scheme = expression.getScheme();
            if (scheme == null ? !origin.isPresent() || !Policy.schemePartMatches(origin.get().getScheme(), urlScheme) : !Policy.schemePartMatches(scheme, urlScheme)) continue;
            if (url.getHost() == null || !Policy.hostPartMatches(expression.getHost(), url.getHost()) || !Policy.portPartMatches(expression.getPort(), url.getPort(), urlScheme) || !Policy.pathPartMatches(expression.getPath(), url.getPath())) continue;
            return true;
        }
        if (list.self() && origin.isPresent()) {
            URLWithScheme actualOrigin = origin.get();
            String originScheme = actualOrigin.getScheme();
            if (Objects.equals(actualOrigin.getHost(), url.getHost()) && (Objects.equals(actualOrigin.getPort(), url.getPort()) || Objects.equals(actualOrigin.getPort(), URI.defaultPortForProtocol(originScheme)) && Objects.equals(url.getPort(), URI.defaultPortForProtocol(urlScheme))) && ("https".equals(urlScheme) || "wss".equals(urlScheme) || "http".equals(originScheme) && ("http".equals(urlScheme) || "ws".equals(urlScheme)))) {
                return true;
            }
        }
        return false;
    }

    private static boolean schemePartMatches(String a, String b) {
        return a.equals(b) || "http".equals(a) && "https".equals(b) || "ws".equals(a) && ("wss".equals(b) || "http".equals(b) || "https".equals(b)) || "wss".equals(a) && "https".equals(b);
    }

    private static boolean hostPartMatches(String a, String b) {
        if (a.startsWith("*")) {
            String remaining = a.substring(1);
            return b.toLowerCase(Locale.ROOT).endsWith(remaining.toLowerCase(Locale.ROOT));
        }
        if (!a.equalsIgnoreCase(b)) {
            return false;
        }
        Matcher ipv4Matcher = Constants.IPv4address.matcher(a);
        Matcher ipv6Matcher = Constants.IPv6addressWithOptionalBracket.matcher(a);
        Matcher ipv6LoopbackMatcher = Constants.IPV6loopback.matcher(a);
        return (!ipv4Matcher.find() || "127.0.0.1".equals(a)) && !ipv6Matcher.find() && !ipv6LoopbackMatcher.find();
    }

    private static boolean portPartMatches(int a, int portB, String schemeB) {
        if (a == -1) {
            return portB == URI.defaultPortForProtocol(schemeB);
        }
        if (a == -200) {
            return true;
        }
        if (a == portB) {
            return true;
        }
        if (portB == -1) {
            return a == URI.defaultPortForProtocol(schemeB);
        }
        return false;
    }

    private static boolean pathPartMatches(String pathA, String pathB) {
        if (pathA == null) {
            pathA = "";
        }
        if (pathB == null) {
            pathB = "";
        }
        if (pathA.isEmpty()) {
            return true;
        }
        if ("/".equals(pathA) && pathB.isEmpty()) {
            return true;
        }
        boolean exactMatch = !pathA.endsWith("/");
        List<String> pathListA = Utils.strictlySplit(pathA, '/');
        List<String> pathListB = Utils.strictlySplit(pathB, '/');
        if (pathListA.size() > pathListB.size()) {
            return false;
        }
        if (exactMatch && pathListA.size() != pathListB.size()) {
            return false;
        }
        if (!exactMatch) {
            pathListA.remove(pathListA.size() - 1);
        }
        Iterator<String> it1 = pathListA.iterator();
        Iterator<String> it2 = pathListB.iterator();
        while (it1.hasNext()) {
            String b;
            String a = Utils.decodeString(it1.next());
            if (a.equals(b = Utils.decodeString(it2.next()))) continue;
            return false;
        }
        return true;
    }

    static void enforceAscii(String s) {
        if (!StandardCharsets.US_ASCII.newEncoder().canEncode(s)) {
            throw new IllegalArgumentException("string is not ascii: \"" + s + "\"");
        }
    }

    private static String stripLeadingWhitespace(String string) {
        return Constants.LEADING_WHITESPACE_PATTERN.matcher(string).replaceFirst("");
    }

    private static String stripTrailingWhitespace(String string) {
        return Constants.TRAILING_WHITESPACE_PATTERN.matcher(string).replaceAll("");
    }

    private static String collect(String input, String regex) {
        Matcher matcher = Pattern.compile(regex).matcher(input);
        if (!matcher.find() || matcher.start() != 0) {
            return "";
        }
        return input.substring(0, matcher.end());
    }

    @FunctionalInterface
    public static interface PolicyListErrorConsumer {
        public static final PolicyListErrorConsumer ignored = (severity, message, policyIndex, directiveIndex, valueIndex) -> {};

        public void add(Severity var1, String var2, int var3, int var4, int var5);
    }

    @FunctionalInterface
    public static interface PolicyErrorConsumer {
        public static final PolicyErrorConsumer ignored = (severity, message, directiveIndex, valueIndex) -> {};

        public void add(Severity var1, String var2, int var3, int var4);
    }

    public static enum Severity {
        Info,
        Warning,
        Error;

    }

    private static final class NamedDirective {
        private final String name_;
        private final Directive directive_;

        private NamedDirective(String name, Directive directive) {
            this.name_ = name;
            this.directive_ = directive;
        }
    }

    private static enum InlineType {
        Script(FetchDirectiveKind.ScriptSrcElem),
        ScriptAttribute(FetchDirectiveKind.ScriptSrcAttr),
        Style(FetchDirectiveKind.StyleSrcElem),
        StyleAttribute(FetchDirectiveKind.StyleSrcAttr),
        Navigation(FetchDirectiveKind.ScriptSrcElem);

        private final FetchDirectiveKind effectiveDirective_;

        private InlineType(FetchDirectiveKind effectiveDirective) {
            this.effectiveDirective_ = effectiveDirective;
        }
    }
}

