/*
 * Decompiled with CFR 0.152.
 */
package org.http4s.metrics.prometheus;

import cats.data.NonEmptyList;
import cats.effect.Sync;
import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.Counter;
import io.prometheus.client.Gauge;
import io.prometheus.client.Histogram;
import io.prometheus.client.SimpleTimer;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.http4s.Method;
import org.http4s.Method$;
import org.http4s.Status;
import org.http4s.metrics.MetricsOps;
import org.http4s.metrics.TerminationType;
import org.http4s.metrics.prometheus.AbnormalTermination$;
import org.http4s.metrics.prometheus.AbnormalTermination$Abnormal$;
import org.http4s.metrics.prometheus.AbnormalTermination$Error$;
import org.http4s.metrics.prometheus.AbnormalTermination$Timeout$;
import org.http4s.metrics.prometheus.MetricsCollection;
import org.http4s.metrics.prometheus.Phase$;
import org.http4s.metrics.prometheus.Phase$Body$;
import org.http4s.metrics.prometheus.Phase$Headers$;
import scala.Function0;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.List$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction0;

public final class Prometheus$ {
    public static Prometheus$ MODULE$;
    private final NonEmptyList<Object> DefaultHistogramBuckets;

    static {
        new Prometheus$();
    }

    public <F> F apply(CollectorRegistry registry, String prefix, NonEmptyList<Object> responseDurationSecondsHistogramBuckets, Sync<F> F) {
        return (F)F.delay((Function0 & Serializable & scala.Serializable)() -> new MetricsOps<F>(F, responseDurationSecondsHistogramBuckets, prefix, registry){
            private final MetricsCollection metrics;
            private final Sync F$1;

            public F increaseActiveRequests(Option<String> classifier) {
                return (F)this.F$1.delay((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((Gauge.Child)this.metrics().activeRequests().labels(new String[]{this.label(classifier)})).inc());
            }

            public F decreaseActiveRequests(Option<String> classifier) {
                return (F)this.F$1.delay((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((Gauge.Child)this.metrics().activeRequests().labels(new String[]{this.label(classifier)})).dec());
            }

            public F recordHeadersTime(Method method, long elapsed, Option<String> classifier) {
                return (F)this.F$1.delay((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((Histogram.Child)this.metrics().responseDuration().labels(new String[]{this.label(classifier), this.reportMethod(method), Phase$.MODULE$.report(Phase$Headers$.MODULE$)})).observe(SimpleTimer.elapsedSecondsFromNanos((long)0L, (long)elapsed)));
            }

            public F recordTotalTime(Method method, Status status, long elapsed, Option<String> classifier) {
                return (F)this.F$1.delay((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    ((Histogram.Child)this.metrics().responseDuration().labels(new String[]{this.label(classifier), this.reportMethod(method), Phase$.MODULE$.report(Phase$Body$.MODULE$)})).observe(SimpleTimer.elapsedSecondsFromNanos((long)0L, (long)elapsed));
                    ((Counter.Child)this.metrics().requests().labels(new String[]{this.label(classifier), this.reportMethod(method), this.reportStatus(status)})).inc();
                });
            }

            public F recordAbnormalTermination(long elapsed, TerminationType terminationType, Option<String> classifier) {
                F f;
                TerminationType terminationType2 = terminationType;
                if (TerminationType.Abnormal$.MODULE$.equals(terminationType2)) {
                    f = this.recordAbnormal(elapsed, classifier);
                } else if (TerminationType.Error$.MODULE$.equals(terminationType2)) {
                    f = this.recordError(elapsed, classifier);
                } else if (TerminationType.Timeout$.MODULE$.equals(terminationType2)) {
                    f = this.recordTimeout(elapsed, classifier);
                } else {
                    throw new MatchError((Object)terminationType2);
                }
                return f;
            }

            private F recordAbnormal(long elapsed, Option<String> classifier) {
                return (F)this.F$1.delay((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((Histogram.Child)this.metrics().abnormalTerminations().labels(new String[]{this.label(classifier), AbnormalTermination$.MODULE$.report(AbnormalTermination$Abnormal$.MODULE$)})).observe(SimpleTimer.elapsedSecondsFromNanos((long)0L, (long)elapsed)));
            }

            private F recordError(long elapsed, Option<String> classifier) {
                return (F)this.F$1.delay((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((Histogram.Child)this.metrics().abnormalTerminations().labels(new String[]{this.label(classifier), AbnormalTermination$.MODULE$.report(AbnormalTermination$Error$.MODULE$)})).observe(SimpleTimer.elapsedSecondsFromNanos((long)0L, (long)elapsed)));
            }

            private F recordTimeout(long elapsed, Option<String> classifier) {
                return (F)this.F$1.delay((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> ((Histogram.Child)this.metrics().abnormalTerminations().labels(new String[]{this.label(classifier), AbnormalTermination$.MODULE$.report(AbnormalTermination$Timeout$.MODULE$)})).observe(SimpleTimer.elapsedSecondsFromNanos((long)0L, (long)elapsed)));
            }

            private String label(Option<String> classifier) {
                return (String)classifier.getOrElse((Function0 & Serializable & scala.Serializable)() -> "");
            }

            private String reportStatus(Status status) {
                int n = status.code();
                switch (n) {
                    default: 
                }
                return n < 200 ? "1xx" : (n < 300 ? "2xx" : (n < 400 ? "3xx" : (n < 500 ? "4xx" : "5xx")));
            }

            private String reportMethod(Method m) {
                String string;
                Method method = m;
                Method.Semantics$.Safe safe = Method$.MODULE$.GET();
                Method method2 = method;
                if (!(safe != null ? !safe.equals(method2) : method2 != null)) {
                    string = "get";
                } else {
                    Method.Semantics$.Idempotent idempotent = Method$.MODULE$.PUT();
                    Method method3 = method;
                    if (!(idempotent != null ? !idempotent.equals(method3) : method3 != null)) {
                        string = "put";
                    } else {
                        Method.Semantics$.Default default_ = Method$.MODULE$.POST();
                        Method method4 = method;
                        if (!(default_ != null ? !default_.equals(method4) : method4 != null)) {
                            string = "post";
                        } else {
                            Method.Semantics$.Safe safe2 = Method$.MODULE$.HEAD();
                            Method method5 = method;
                            if (!(safe2 != null ? !safe2.equals(method5) : method5 != null)) {
                                string = "head";
                            } else {
                                Method method6 = Method$.MODULE$.MOVE();
                                Method method7 = method;
                                if (!(method6 != null ? !method6.equals(method7) : method7 != null)) {
                                    string = "move";
                                } else {
                                    Method.Semantics$.Safe safe3 = Method$.MODULE$.OPTIONS();
                                    Method method8 = method;
                                    if (!(safe3 != null ? !safe3.equals(method8) : method8 != null)) {
                                        string = "options";
                                    } else {
                                        Method.Semantics$.Safe safe4 = Method$.MODULE$.TRACE();
                                        Method method9 = method;
                                        if (!(safe4 != null ? !safe4.equals(method9) : method9 != null)) {
                                            string = "trace";
                                        } else {
                                            Method.Semantics$.Default default_2 = Method$.MODULE$.CONNECT();
                                            Method method10 = method;
                                            if (!(default_2 != null ? !default_2.equals(method10) : method10 != null)) {
                                                string = "connect";
                                            } else {
                                                Method.Semantics$.Idempotent idempotent2 = Method$.MODULE$.DELETE();
                                                Method method11 = method;
                                                string = !(idempotent2 != null ? !idempotent2.equals(method11) : method11 != null) ? "delete" : "other";
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
                return string;
            }

            private MetricsCollection metrics() {
                return this.metrics;
            }
            {
                this.F$1 = F$1;
                this.metrics = new MetricsCollection((Histogram)Histogram.build().buckets((double[])responseDurationSecondsHistogramBuckets$1.toList().toArray(ClassTag$.MODULE$.Double())).name(new StringBuilder(26).append(prefix$1).append("_").append("response_duration_seconds").toString()).help("Response Duration in seconds.").labelNames(new String[]{"classifier", "method", "phase"}).register(registry$1), (Gauge)Gauge.build().name(new StringBuilder(21).append(prefix$1).append("_").append("active_request_count").toString()).help("Total Active Requests.").labelNames(new String[]{"classifier"}).register(registry$1), (Counter)Counter.build().name(new StringBuilder(14).append(prefix$1).append("_").append("request_count").toString()).help("Total Requests.").labelNames(new String[]{"classifier", "method", "status"}).register(registry$1), (Histogram)Histogram.build().name(new StringBuilder(22).append(prefix$1).append("_").append("abnormal_terminations").toString()).help("Total Abnormal Terminations.").labelNames(new String[]{"classifier", "termination_type"}).register(registry$1));
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$increaseActiveRequests$1(org.http4s.metrics.prometheus.Prometheus$$anon$1 scala.Option ), $anonfun$decreaseActiveRequests$1(org.http4s.metrics.prometheus.Prometheus$$anon$1 scala.Option ), $anonfun$recordHeadersTime$1(org.http4s.metrics.prometheus.Prometheus$$anon$1 scala.Option org.http4s.Method long ), $anonfun$recordTotalTime$1(org.http4s.metrics.prometheus.Prometheus$$anon$1 scala.Option org.http4s.Method long org.http4s.Status ), $anonfun$recordAbnormal$1(org.http4s.metrics.prometheus.Prometheus$$anon$1 scala.Option long ), $anonfun$recordError$1(org.http4s.metrics.prometheus.Prometheus$$anon$1 scala.Option long ), $anonfun$recordTimeout$1(org.http4s.metrics.prometheus.Prometheus$$anon$1 scala.Option long ), $anonfun$label$1()}, serializedLambda);
            }
        });
    }

    public <F> String apply$default$2() {
        return "org_http4s_server";
    }

    public <F> NonEmptyList<Object> apply$default$3() {
        return this.DefaultHistogramBuckets();
    }

    private NonEmptyList<Object> DefaultHistogramBuckets() {
        return this.DefaultHistogramBuckets;
    }

    private Prometheus$() {
        MODULE$ = this;
        this.DefaultHistogramBuckets = new NonEmptyList((Object)BoxesRunTime.boxToDouble((double)0.005), List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.01, 0.025, 0.05, 0.075, 0.1, 0.25, 0.5, 0.75, 1.0, 2.5, 5.0, 7.5, 10.0})));
    }
}

