/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.component.outputchart;

import com.icesoft.faces.component.outputchart.AbstractChart;
import com.icesoft.faces.component.outputchart.OutputChart;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import javax.faces.component.UIComponent;
import org.krysalis.jcharts.chartData.AxisChartDataSet;
import org.krysalis.jcharts.chartData.DataSeries;
import org.krysalis.jcharts.chartData.interfaces.IAxisDataSeries;
import org.krysalis.jcharts.chartData.interfaces.IAxisPlotDataSet;
import org.krysalis.jcharts.properties.AreaChartProperties;
import org.krysalis.jcharts.properties.AxisProperties;
import org.krysalis.jcharts.properties.BarChartProperties;
import org.krysalis.jcharts.properties.ChartProperties;
import org.krysalis.jcharts.properties.ChartTypeProperties;
import org.krysalis.jcharts.properties.ClusteredBarChartProperties;
import org.krysalis.jcharts.properties.LineChartProperties;
import org.krysalis.jcharts.properties.PointChartProperties;
import org.krysalis.jcharts.properties.StackedAreaChartProperties;
import org.krysalis.jcharts.properties.StackedBarChartProperties;
import org.krysalis.jcharts.test.TestDataGenerator;
import org.krysalis.jcharts.types.ChartType;

public class AxisChart
extends AbstractChart {
    private Shape[] shapes;
    String[] xaxisLabels = null;
    String[] labels = null;
    private double[][] data = null;

    public AxisChart(UIComponent uiComponent) throws Throwable {
        super(uiComponent);
    }

    protected void buildChart() throws Throwable {
        if (this.data == null) {
            this.getData(this.outputChart.getData());
        }
        if (this.type.equalsIgnoreCase(OutputChart.AREA_CHART_TYPE)) {
            this.buildAreaChart();
        } else if (this.type.equalsIgnoreCase(OutputChart.AREA_STACKED_CHART_TYPE)) {
            this.buildAreaStackedChart();
        } else if (this.type.equalsIgnoreCase(OutputChart.BAR_CHART_TYPE)) {
            this.buildBarChart();
        } else if (this.type.equalsIgnoreCase(OutputChart.BAR_STACKED_CHART_TYPE)) {
            this.buildBarStackedChart();
        } else if (this.type.equalsIgnoreCase(OutputChart.BAR_CLUSTERED_CHART_TYPE)) {
            this.buildBarClusteredChart();
        } else if (this.type.equalsIgnoreCase(OutputChart.LINE_CHART_TYPE)) {
            this.buildLineChart();
        } else if (this.type.equalsIgnoreCase(OutputChart.POINT_CHART_TYPE)) {
            this.buildPointChart();
        }
    }

    private void buildAreaChart() throws Throwable {
        AreaChartProperties areaChartProperties = new AreaChartProperties();
        this.buildAxisChart(ChartType.AREA, (ChartTypeProperties)areaChartProperties);
    }

    private void buildAreaStackedChart() throws Throwable {
        StackedAreaChartProperties areaChartProperties = new StackedAreaChartProperties();
        this.buildAxisChart(ChartType.AREA_STACKED, (ChartTypeProperties)areaChartProperties);
    }

    private void buildBarChart() throws Throwable {
        BarChartProperties barChartProperties = new BarChartProperties();
        this.buildAxisChart(ChartType.BAR, (ChartTypeProperties)barChartProperties);
    }

    private void buildBarStackedChart() throws Throwable {
        StackedBarChartProperties barChartProperties = new StackedBarChartProperties();
        this.buildAxisChart(ChartType.BAR_STACKED, (ChartTypeProperties)barChartProperties);
    }

    private void buildBarClusteredChart() throws Throwable {
        ClusteredBarChartProperties barChartProperties = new ClusteredBarChartProperties();
        this.buildAxisChart(ChartType.BAR_CLUSTERED, (ChartTypeProperties)barChartProperties);
    }

    private void buildLineChart() throws Throwable {
        Stroke[] strokes = new Stroke[this.data.length];
        for (int i = 0; i < this.data.length; ++i) {
            strokes[i] = LineChartProperties.DEFAULT_LINE_STROKE;
        }
        LineChartProperties lineChartProperties = new LineChartProperties(strokes, this.getShapes(this.outputChart.getShapes()));
        this.buildAxisChart(ChartType.LINE, (ChartTypeProperties)lineChartProperties);
    }

    private void buildPointChart() throws Throwable {
        Paint[] outlinePaints = TestDataGenerator.getRandomPaints((int)this.data.length);
        boolean[] fillPointFlags = new boolean[this.data.length];
        for (int i = 0; i < this.data.length; ++i) {
            fillPointFlags[i] = true;
        }
        PointChartProperties pointChartProperties = new PointChartProperties(this.getShapes(this.outputChart.getShapes()), fillPointFlags, outlinePaints);
        this.buildAxisChart(ChartType.POINT, (ChartTypeProperties)pointChartProperties);
    }

    void buildAxisChart(ChartType chartType, ChartTypeProperties chartTypeProperties) throws Throwable {
        DataSeries dataSeries = new DataSeries(this.getAsXaxisLabelsArray(this.outputChart.getXaxisLabels()), this.outputChart.getXaxisTitle(), this.outputChart.getYaxisTitle(), this.outputChart.getChartTitle());
        AxisChartDataSet axisChartDataSet = new AxisChartDataSet(this.getAs2dDoubleArray(this.outputChart.getData()), this.getAsLabelsArray(this.outputChart.getLabels()), this.getPaints(this.outputChart.getColors()), chartType, chartTypeProperties);
        AxisProperties axisProperties = (chartType.equals(ChartType.BAR) || chartType.equals(ChartType.BAR_CLUSTERED)) && this.outputChart.isHorizontal() ? new AxisProperties(true) : new AxisProperties();
        dataSeries.addIAxisPlotDataSet((IAxisPlotDataSet)axisChartDataSet);
        this.chart = new org.krysalis.jcharts.axisChart.AxisChart((IAxisDataSeries)dataSeries, new ChartProperties(), axisProperties, this.getLegendProperties(), new Integer(this.outputChart.getWidth()).intValue(), new Integer(this.outputChart.getHeight()).intValue());
    }

    private Shape[] getShapes(Object obj) {
        if (obj == null && this.shapes == null) {
            this.shapes = this.getGeneratedShapes(this.data.length);
            return this.shapes;
        }
        if (obj == null && this.shapes != null) {
            return this.shapes;
        }
        this.shapes = this.getAsShapeArray(obj);
        return this.shapes;
    }

    public String[] getAsXaxisLabelsArray(Object obj) {
        if (obj == null && this.xaxisLabels == null) {
            this.xaxisLabels = this.getGeneratedLabels("Xlabel", this.data[0].length);
            return this.xaxisLabels;
        }
        if (obj == null && this.xaxisLabels != null) {
            return this.xaxisLabels;
        }
        return this.getAsStringArray(obj);
    }

    public String[] getAsLabelsArray(Object obj) {
        if (obj == null && this.labels == null) {
            this.labels = this.getGeneratedLabels("Label", this.data.length);
            return this.labels;
        }
        if (obj == null && this.labels != null) {
            return this.labels;
        }
        return this.getAsStringArray(obj);
    }

    public double[][] getData(Object obj) {
        if (obj instanceof String && this.data != null) {
            return this.data;
        }
        this.data = this.getAs2dDoubleArray(obj);
        return this.data;
    }

    public Paint[] getPaints(Object obj) {
        return this.getPaints(obj, this.data.length);
    }
}

