/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.component.selectinputdate;

import com.icesoft.faces.component.ext.HtmlCommandLink;
import com.icesoft.faces.component.ext.HtmlGraphicImage;
import com.icesoft.faces.component.ext.HtmlOutputText;
import com.icesoft.faces.component.ext.renderkit.FormRenderer;
import com.icesoft.faces.component.ext.taglib.Util;
import com.icesoft.faces.component.selectinputdate.SelectInputDate;
import com.icesoft.faces.component.util.CustomComponentUtils;
import com.icesoft.faces.context.BridgeFacesContext;
import com.icesoft.faces.context.DOMContext;
import com.icesoft.faces.renderkit.dom_html_basic.DomBasicInputRenderer;
import com.icesoft.faces.renderkit.dom_html_basic.PassThruAttributeRenderer;
import com.icesoft.faces.util.CoreUtils;
import com.icesoft.faces.utils.MessageUtils;
import java.io.IOException;
import java.text.DateFormatSymbols;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.faces.component.UIComponent;
import javax.faces.component.UIParameter;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.ConverterException;
import javax.faces.convert.DateTimeConverter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class SelectInputDateRenderer
extends DomBasicInputRenderer {
    private static final Log log = LogFactory.getLog((Class)SelectInputDateRenderer.class);
    private static final String CALENDAR_TABLE = "_calendarTable";
    private static final String CALENDAR_BUTTON = "_calendarButton";
    private static final String CALENDAR_POPUP = "_calendarPopup";
    private static final String HIDDEN_FIELD_NAME = "showPopup";
    private static final String DATE_SELECTED = "dateSelected";
    private static final String PREV_MONTH = "_prevmo";
    private static final String NEXT_MONTH = "_nextmo";
    private static final String PREV_YEAR = "_prevyr";
    private static final String NEXT_YEAR = "_nextyr";
    private static final String CALENDAR = "_calendar";
    private static final String INPUT_TEXT_TITLE = "com.icesoft.faces.component.selectinputdate.INPUT_TEXT_TITLE";
    private static final String CALENDAR_TITLE = "com.icesoft.faces.component.selectinputdate.CALENDAR_TITLE";
    private static final String CALENDAR_SUMMARY = "com.icesoft.faces.component.selectinputdate.CALENDAR_SUMMARY";
    private static final String POPUP_CALENDAR_TITLE = "com.icesoft.faces.component.selectinputdate.POPUP_CALENDAR_TITLE";
    private static final String POPUP_CALENDAR_SUMMARY = "com.icesoft.faces.component.selectinputdate.POPUP_CALENDAR_SUMMARY";
    private static final String YEAR_MONTH_SUMMARY = "com.icesoft.faces.component.selectinputdate.YEAR_MONTH_SUMMARY";
    private static final String OPEN_POPUP_ALT = "com.icesoft.faces.component.selectinputdate.OPEN_POPUP_ALT";
    private static final String OPEN_POPUP_TITLE = "com.icesoft.faces.component.selectinputdate.OPEN_POPUP_TITLE";
    private static final String CLOSE_POPUP_ALT = "com.icesoft.faces.component.selectinputdate.CLOSE_POPUP_ALT";
    private static final String CLOSE_POPUP_TITLE = "com.icesoft.faces.component.selectinputdate.CLOSE_POPUP_TITLE";
    private static final String PREV_YEAR_ALT = "com.icesoft.faces.component.selectinputdate.PREV_YEAR_ALT";
    private static final String PREV_YEAR_TITLE = "com.icesoft.faces.component.selectinputdate.PREV_YEAR_TITLE";
    private static final String NEXT_YEAR_ALT = "com.icesoft.faces.component.selectinputdate.NEXT_YEAR_ALT";
    private static final String NEXT_YEAR_TITLE = "com.icesoft.faces.component.selectinputdate.NEXT_YEAR_TITLE";
    private static final String PREV_MONTH_ALT = "com.icesoft.faces.component.selectinputdate.PREV_MONTH_ALT";
    private static final String PREV_MONTH_TITLE = "com.icesoft.faces.component.selectinputdate.PREV_MONTH_TITLE";
    private static final String NEXT_MONTH_ALT = "com.icesoft.faces.component.selectinputdate.NEXT_MONTH_ALT";
    private static final String NEXT_MONTH_TITLE = "com.icesoft.faces.component.selectinputdate.NEXT_MONTH_TITLE";

    public boolean getRendersChildren() {
        return true;
    }

    public void encodeChildren(FacesContext facesContext, UIComponent uiComponent) {
    }

    private String getHiddenFieldName(FacesContext facesContext, UIComponent uiComponent) {
        UIComponent form = SelectInputDateRenderer.findForm((UIComponent)uiComponent);
        String formId = form.getClientId(facesContext);
        String clientId = uiComponent.getClientId(facesContext);
        String hiddenFieldName = formId + ':' + "_id" + clientId + HIDDEN_FIELD_NAME;
        return hiddenFieldName;
    }

    public void encodeEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        Date value;
        String clientId;
        this.validateParameters(facesContext, uiComponent, SelectInputDate.class);
        DOMContext domContext = DOMContext.attachDOMContext((FacesContext)facesContext, (UIComponent)uiComponent);
        SelectInputDate selectInputDate = (SelectInputDate)uiComponent;
        UIComponent parentForm = SelectInputDateRenderer.findForm((UIComponent)selectInputDate);
        if (parentForm == null) {
            log.error((Object)"SelectInputDate::must be in a FORM");
            return;
        }
        if (!domContext.isInitialized()) {
            Element root = domContext.createRootElement("div");
            boolean popupState = selectInputDate.isShowPopup();
            SelectInputDateRenderer.setRootElementId((FacesContext)facesContext, (Element)root, (UIComponent)uiComponent);
            clientId = uiComponent.getClientId(facesContext);
            if (selectInputDate.isRenderAsPopup()) {
                String resolvedSrc;
                if (log.isTraceEnabled()) {
                    log.trace((Object)"Render as popup");
                }
                root.setAttribute("class", Util.getQualifiedStyleClass(uiComponent, "Popup", false));
                Element dateText = domContext.createElement("input");
                dateText.setAttribute("type", "text");
                dateText.setAttribute("value", selectInputDate.getTextToRender());
                dateText.setAttribute("id", clientId + "_calendarInputtext");
                dateText.setAttribute("name", clientId + "_calendarInputtext");
                dateText.setAttribute("class", selectInputDate.getCalendarInputClass());
                dateText.setAttribute("onfocus", "setFocus('');");
                ((Object)((Object)this)).getClass();
                dateText.setAttribute("onkeypress", "iceSubmit(form,this,event);");
                StringBuffer stringBuffer = new StringBuffer().append("setFocus('');");
                ((Object)((Object)this)).getClass();
                dateText.setAttribute("onblur", stringBuffer.append("iceSubmitPartial(form, this, event);").toString());
                if (selectInputDate.getAutocomplete() != null) {
                    dateText.setAttribute("autocomplete", selectInputDate.getAutocomplete());
                }
                String tooltip = null;
                tooltip = selectInputDate.getTitle();
                if (tooltip == null || tooltip.length() == 0) {
                    tooltip = this.getMessageWithParamFromResource(facesContext, INPUT_TEXT_TITLE, selectInputDate.getSpecifiedPopupDateFormat());
                }
                if (tooltip != null && tooltip.length() > 0) {
                    dateText.setAttribute("title", tooltip);
                }
                if (selectInputDate.isDisabled()) {
                    dateText.setAttribute("disabled", "disabled");
                }
                root.appendChild(dateText);
                Element calendarButton = domContext.createElement("input");
                calendarButton.setAttribute("id", clientId + CALENDAR_BUTTON);
                calendarButton.setAttribute("name", clientId + CALENDAR_BUTTON);
                calendarButton.setAttribute("type", "image");
                calendarButton.setAttribute("onfocus", "setFocus('');");
                String onClick = "document.forms['" + parentForm.getClientId(facesContext) + "']['" + this.getLinkId(facesContext, uiComponent) + "'].value='" + clientId + CALENDAR_BUTTON + "';" + "document.forms['" + parentForm.getClientId(facesContext) + "']['" + this.getHiddenFieldName(facesContext, uiComponent) + "'].value='toggle';" + "iceSubmitPartial( document.forms['" + parentForm.getClientId(facesContext) + "'], this,event); return false;";
                calendarButton.setAttribute("onclick", onClick);
                if (selectInputDate.isDisabled()) {
                    calendarButton.setAttribute("disabled", "disabled");
                }
                root.appendChild(calendarButton);
                FormRenderer.addHiddenField((FacesContext)facesContext, (String)this.getHiddenFieldName(facesContext, uiComponent));
                if (popupState) {
                    if (selectInputDate.isImageDirSet()) {
                        resolvedSrc = CoreUtils.resolveResourceURL((FacesContext)facesContext, (String)(selectInputDate.getImageDir() + selectInputDate.getClosePopupImage()));
                    } else {
                        calendarButton.setAttribute("class", selectInputDate.getClosePopupClass());
                        resolvedSrc = CoreUtils.resolveResourceURL((FacesContext)facesContext, (String)(selectInputDate.getImageDir() + "spacer.gif"));
                    }
                } else {
                    String resolvedSrc2;
                    if (selectInputDate.isImageDirSet()) {
                        resolvedSrc2 = CoreUtils.resolveResourceURL((FacesContext)facesContext, (String)(selectInputDate.getImageDir() + selectInputDate.getOpenPopupImage()));
                    } else {
                        calendarButton.setAttribute("class", selectInputDate.getOpenPopupClass());
                        resolvedSrc2 = CoreUtils.resolveResourceURL((FacesContext)facesContext, (String)(selectInputDate.getImageDir() + "spacer.gif"));
                    }
                    calendarButton.setAttribute("src", resolvedSrc2);
                    this.addAttributeToElementFromResource(facesContext, OPEN_POPUP_ALT, calendarButton, "alt");
                    this.addAttributeToElementFromResource(facesContext, OPEN_POPUP_TITLE, calendarButton, "title");
                    FormRenderer.addHiddenField((FacesContext)facesContext, (String)(parentForm.getClientId(facesContext) + ":_idcl"));
                    PassThruAttributeRenderer.renderAttributes((FacesContext)facesContext, (UIComponent)uiComponent, (String[])new String[]{"title"});
                    domContext.stepOver();
                    return;
                }
                calendarButton.setAttribute("src", resolvedSrc);
                this.addAttributeToElementFromResource(facesContext, CLOSE_POPUP_ALT, calendarButton, "alt");
                this.addAttributeToElementFromResource(facesContext, CLOSE_POPUP_TITLE, calendarButton, "title");
                if (!domContext.isStreamWriting()) {
                    Text br = domContext.createTextNode("<br/>");
                    root.appendChild(br);
                }
                Element calendarDiv = domContext.createElement("div");
                calendarDiv.setAttribute("id", clientId + CALENDAR_POPUP);
                calendarDiv.setAttribute("name", clientId + CALENDAR_POPUP);
                calendarDiv.setAttribute("style", "position:absolute;z-index:10;");
                this.addAttributeToElementFromResource(facesContext, POPUP_CALENDAR_TITLE, calendarDiv, "title");
                Element table = domContext.createElement("table");
                table.setAttribute("id", clientId + CALENDAR_TABLE);
                table.setAttribute("name", clientId + CALENDAR_TABLE);
                table.setAttribute("class", selectInputDate.getStyleClass());
                table.setAttribute("style", "position:absolute;");
                table.setAttribute("cellpadding", "0");
                table.setAttribute("cellspacing", "0");
                String mouseOver = selectInputDate.getOnmouseover();
                table.setAttribute("onmouseover", mouseOver);
                String mouseOut = selectInputDate.getOnmouseout();
                table.setAttribute("onmouseout", mouseOut);
                String mouseMove = selectInputDate.getOnmousemove();
                table.setAttribute("onmousemove", mouseMove);
                this.addAttributeToElementFromResource(facesContext, POPUP_CALENDAR_SUMMARY, table, "summary");
                calendarDiv.appendChild(table);
                Text iframe = domContext.createTextNode("<!--[if lte IE 6.5]><iframe src='" + CoreUtils.resolveResourceURL((FacesContext)FacesContext.getCurrentInstance(), (String)"/xmlhttp/blank") + "' class=\"iceSelInpDateIFrameFix\"></iframe><![endif]-->");
                calendarDiv.appendChild(iframe);
                root.appendChild(calendarDiv);
            } else {
                if (log.isTraceEnabled()) {
                    log.trace((Object)"Select input Date Normal");
                }
                Element table = domContext.createElement("table");
                table.setAttribute("id", clientId + CALENDAR_TABLE);
                table.setAttribute("name", clientId + CALENDAR_TABLE);
                table.setAttribute("class", selectInputDate.getStyleClass());
                this.addAttributeToElementFromResource(facesContext, CALENDAR_TITLE, table, "title");
                table.setAttribute("cellpadding", "0");
                table.setAttribute("cellspacing", "0");
                String mouseOver = selectInputDate.getOnmouseover();
                table.setAttribute("onmouseover", mouseOver);
                String mouseOut = selectInputDate.getOnmouseout();
                table.setAttribute("onmouseout", mouseOut);
                String mouseMove = selectInputDate.getOnmousemove();
                table.setAttribute("onmousemove", mouseMove);
                this.addAttributeToElementFromResource(facesContext, CALENDAR_SUMMARY, table, "summary");
                root.appendChild(table);
            }
        }
        clientId = uiComponent.getClientId(facesContext);
        if (selectInputDate.isNavEvent()) {
            if (log.isTraceEnabled()) {
                log.trace((Object)"Rendering Nav Event");
            }
            value = selectInputDate.getNavDate();
        } else {
            if (log.isTraceEnabled()) {
                log.trace((Object)"Logging non nav event");
            }
            value = CustomComponentUtils.getDateValue((UIComponent)selectInputDate);
        }
        TimeZone tz = selectInputDate.resolveTimeZone(facesContext);
        Locale currentLocale = selectInputDate.resolveLocale(facesContext);
        Calendar timeKeeper = Calendar.getInstance(tz, currentLocale);
        timeKeeper.setTime(value != null ? value : new Date());
        DateFormatSymbols symbols = new DateFormatSymbols(currentLocale);
        String[] weekdays = SelectInputDateRenderer.mapWeekdays(symbols);
        String[] weekdaysLong = SelectInputDateRenderer.mapWeekdaysLong(symbols);
        String[] months = SelectInputDateRenderer.mapMonths(symbols);
        int lastDayInMonth = timeKeeper.getActualMaximum(5);
        int currentDay = timeKeeper.get(5);
        if (currentDay > lastDayInMonth) {
            currentDay = lastDayInMonth;
        }
        timeKeeper.set(5, 1);
        int weekDayOfFirstDayOfMonth = this.mapCalendarDayToCommonDay(timeKeeper.get(7));
        int weekStartsAtDayIndex = this.mapCalendarDayToCommonDay(timeKeeper.getFirstDayOfWeek());
        ResponseWriter writer = facesContext.getResponseWriter();
        Element root = (Element)domContext.getRootNode();
        if (selectInputDate.isRenderAsPopup()) {
            if (log.isTraceEnabled()) {
                log.trace((Object)"SelectInputDate as Popup");
            }
            Element dateText = (Element)root.getFirstChild();
            dateText.setAttribute("type", "text");
            dateText.setAttribute("value", selectInputDate.getTextToRender());
            NodeList tables = root.getElementsByTagName("table");
            Element table = (Element)tables.item(0);
            PassThruAttributeRenderer.renderAttributes((FacesContext)facesContext, (UIComponent)uiComponent, (String[])new String[]{"title"});
            Element tr1 = domContext.createElement("tr");
            table.appendChild(tr1);
            this.writeMonthYearHeader(domContext, facesContext, writer, selectInputDate, timeKeeper, currentDay, tr1, selectInputDate.getMonthYearRowClass(), currentLocale, months, weekdays, weekdaysLong);
            Element tr2 = domContext.createElement("tr");
            table.appendChild(tr2);
            this.writeWeekDayNameHeader(domContext, weekStartsAtDayIndex, weekdays, facesContext, writer, selectInputDate, tr2, selectInputDate.getWeekRowClass(), timeKeeper, months, weekdaysLong);
            this.writeDays(domContext, facesContext, writer, selectInputDate, timeKeeper, currentDay, weekStartsAtDayIndex, weekDayOfFirstDayOfMonth, lastDayInMonth, table, months, weekdays, weekdaysLong);
        } else {
            if (log.isTraceEnabled()) {
                log.trace((Object)"renderNormal::endcodeEnd");
            }
            Element table = (Element)root.getFirstChild();
            PassThruAttributeRenderer.renderAttributes((FacesContext)facesContext, (UIComponent)uiComponent, (String[])new String[]{"title"});
            Element tr1 = domContext.createElement("tr");
            table.appendChild(tr1);
            this.writeMonthYearHeader(domContext, facesContext, writer, selectInputDate, timeKeeper, currentDay, tr1, selectInputDate.getMonthYearRowClass(), currentLocale, months, weekdays, weekdaysLong);
            Element tr2 = domContext.createElement("tr");
            this.writeWeekDayNameHeader(domContext, weekStartsAtDayIndex, weekdays, facesContext, writer, selectInputDate, tr2, selectInputDate.getWeekRowClass(), timeKeeper, months, weekdaysLong);
            table.appendChild(tr2);
            this.writeDays(domContext, facesContext, writer, selectInputDate, timeKeeper, currentDay, weekStartsAtDayIndex, weekDayOfFirstDayOfMonth, lastDayInMonth, table, months, weekdays, weekdaysLong);
        }
        selectInputDate.getChildren().removeAll(selectInputDate.getChildren());
        domContext.stepOver();
        domContext.streamWrite(facesContext, uiComponent);
    }

    private void writeMonthYearHeader(DOMContext domContext, FacesContext facesContext, ResponseWriter writer, SelectInputDate inputComponent, Calendar timeKeeper, int currentDay, Element headerTr, String styleClass, Locale currentLocale, String[] months, String[] weekdays, String[] weekdaysLong) throws IOException {
        Element table = domContext.createElement("table");
        table.setAttribute("cellpadding", "0");
        table.setAttribute("cellspacing", "0");
        table.setAttribute("width", "100%");
        this.addAttributeToElementFromResource(facesContext, YEAR_MONTH_SUMMARY, table, "summary");
        Element tr = domContext.createElement("tr");
        Element headertd = domContext.createElement("td");
        table.appendChild(tr);
        headertd.appendChild(table);
        headerTr.appendChild(headertd);
        headertd.setAttribute("colspan", "7");
        Calendar cal = this.shiftMonth(facesContext, timeKeeper, currentDay, -1);
        this.writeCell(domContext, facesContext, writer, inputComponent, "<", cal.getTime(), styleClass, tr, inputComponent.getImageDir() + inputComponent.getMovePreviousImage(), -1, timeKeeper, months, weekdaysLong);
        Element td = domContext.createElement("td");
        td.setAttribute("class", styleClass);
        td.setAttribute("width", "40%");
        Text text = domContext.createTextNode(months[timeKeeper.get(2)] + "");
        td.appendChild(text);
        tr.appendChild(td);
        cal = this.shiftMonth(facesContext, timeKeeper, currentDay, 1);
        int calYear = cal.get(1);
        if (inputComponent.getHightlightRules().containsKey("1$" + calYear)) {
            inputComponent.setHighlightYearClass(inputComponent.getHightlightRules().get("1$" + calYear) + " ");
        } else {
            inputComponent.setHighlightYearClass("");
        }
        int calMonth = cal.get(2);
        if (inputComponent.getHightlightRules().containsKey("2$" + calMonth)) {
            inputComponent.setHighlightMonthClass(inputComponent.getHightlightRules().get("2$" + calMonth) + " ");
        } else {
            inputComponent.setHighlightMonthClass("");
        }
        this.writeCell(domContext, facesContext, writer, inputComponent, ">", cal.getTime(), styleClass, tr, inputComponent.getImageDir() + inputComponent.getMoveNextImage(), -1, timeKeeper, months, weekdaysLong);
        Element emptytd = domContext.createElement("td");
        emptytd.setAttribute("class", styleClass);
        Text emptytext = domContext.createTextNode("");
        emptytd.appendChild(emptytext);
        tr.appendChild(emptytd);
        cal = this.shiftYear(facesContext, timeKeeper, currentDay, -1);
        this.writeCell(domContext, facesContext, writer, inputComponent, "<<", cal.getTime(), styleClass, tr, inputComponent.getImageDir() + inputComponent.getMovePreviousImage(), -1, timeKeeper, months, weekdaysLong);
        Element yeartd = domContext.createElement("td");
        yeartd.setAttribute("class", styleClass);
        Text yeartext = domContext.createTextNode("" + timeKeeper.get(1));
        yeartd.appendChild(yeartext);
        tr.appendChild(yeartd);
        cal = this.shiftYear(facesContext, timeKeeper, currentDay, 1);
        this.writeCell(domContext, facesContext, writer, inputComponent, ">>", cal.getTime(), styleClass, tr, inputComponent.getImageDir() + inputComponent.getMoveNextImage(), -1, timeKeeper, months, weekdaysLong);
    }

    private Calendar shiftMonth(FacesContext facesContext, Calendar timeKeeper, int currentDay, int shift) {
        Calendar cal = this.copyCalendar(facesContext, timeKeeper);
        cal.set(2, cal.get(2) + shift);
        if (currentDay > cal.getActualMaximum(5)) {
            currentDay = cal.getActualMaximum(5);
        }
        cal.set(5, currentDay);
        return cal;
    }

    private Calendar shiftYear(FacesContext facesContext, Calendar timeKeeper, int currentDay, int shift) {
        Calendar cal = this.copyCalendar(facesContext, timeKeeper);
        cal.set(1, cal.get(1) + shift);
        if (currentDay > cal.getActualMaximum(5)) {
            currentDay = cal.getActualMaximum(5);
        }
        cal.set(5, currentDay);
        return cal;
    }

    private Calendar copyCalendar(FacesContext facesContext, Calendar timeKeeper) {
        Calendar cal = (Calendar)timeKeeper.clone();
        return cal;
    }

    private void writeWeekDayNameHeader(DOMContext domContext, int weekStartsAtDayIndex, String[] weekdays, FacesContext facesContext, ResponseWriter writer, SelectInputDate inputComponent, Element tr, String styleClass, Calendar timeKeeper, String[] months, String[] weekdaysLong) throws IOException {
        int i;
        for (i = weekStartsAtDayIndex; i < weekdays.length; ++i) {
            this.writeCell(domContext, facesContext, writer, inputComponent, weekdays[i], null, styleClass, tr, null, i, timeKeeper, months, weekdaysLong);
        }
        for (i = 0; i < weekStartsAtDayIndex; ++i) {
            this.writeCell(domContext, facesContext, writer, inputComponent, weekdays[i], null, styleClass, tr, null, i, timeKeeper, months, weekdaysLong);
        }
    }

    private void writeDays(DOMContext domContext, FacesContext facesContext, ResponseWriter writer, SelectInputDate inputComponent, Calendar timeKeeper, int currentDay, int weekStartsAtDayIndex, int weekDayOfFirstDayOfMonth, int lastDayInMonth, Element table, String[] months, String[] weekdays, String[] weekdaysLong) throws IOException {
        int i;
        int space;
        int n = space = weekStartsAtDayIndex < weekDayOfFirstDayOfMonth ? weekDayOfFirstDayOfMonth - weekStartsAtDayIndex : weekdays.length - weekStartsAtDayIndex + weekDayOfFirstDayOfMonth;
        if (space == weekdays.length) {
            space = 0;
        }
        int columnIndexCounter = 0;
        Element tr1 = null;
        for (int i2 = 0; i2 < space; ++i2) {
            if (columnIndexCounter == 0) {
                tr1 = domContext.createElement("tr");
                table.appendChild(tr1);
            }
            this.writeCell(domContext, facesContext, writer, inputComponent, "&nbsp;", null, inputComponent.getDayCellClass(), tr1, null, (weekStartsAtDayIndex + i2) % 7, timeKeeper, months, weekdaysLong);
            ++columnIndexCounter;
        }
        Element tr2 = null;
        for (i = 0; i < lastDayInMonth; ++i) {
            if (columnIndexCounter == 0) {
                tr2 = domContext.createElement("tr");
                table.appendChild(tr2);
            }
            Calendar cal = this.copyCalendar(facesContext, timeKeeper);
            cal.set(5, i + 1);
            int day = 0;
            int month = 0;
            int year = 0;
            try {
                Date currentDate = (Date)inputComponent.getValue();
                Calendar current = this.copyCalendar(facesContext, timeKeeper);
                current.setTime(currentDate);
                day = current.get(5);
                month = current.get(2);
                year = current.get(1);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (inputComponent.getHightlightRules().size() > 0) {
                int weekOfYear = cal.get(3);
                int weekOfMonth = cal.get(4);
                int date = cal.get(5);
                int dayOfYear = cal.get(6);
                int dayOfWeek = cal.get(7);
                int dayOfWeekInMonth = cal.get(8);
                if (inputComponent.getHightlightRules().containsKey("3$" + weekOfYear)) {
                    inputComponent.addHighlightWeekClass(String.valueOf(inputComponent.getHightlightRules().get("3$" + weekOfYear)));
                }
                if (inputComponent.getHightlightRules().containsKey("4$" + weekOfMonth)) {
                    inputComponent.addHighlightWeekClass(String.valueOf(inputComponent.getHightlightRules().get("4$" + weekOfMonth)));
                }
                if (inputComponent.getHightlightRules().containsKey("5$" + date)) {
                    inputComponent.addHighlightDayClass(String.valueOf(inputComponent.getHightlightRules().get("5$" + date)));
                }
                if (inputComponent.getHightlightRules().containsKey("6$" + dayOfYear)) {
                    inputComponent.addHighlightDayClass(String.valueOf(inputComponent.getHightlightRules().get("6$" + dayOfYear)));
                }
                if (inputComponent.getHightlightRules().containsKey("7$" + dayOfWeek)) {
                    inputComponent.addHighlightDayClass(String.valueOf(inputComponent.getHightlightRules().get("7$" + dayOfWeek)));
                }
                if (inputComponent.getHightlightRules().containsKey("8$" + dayOfWeekInMonth)) {
                    inputComponent.addHighlightDayClass(String.valueOf(inputComponent.getHightlightRules().get("8$" + dayOfWeekInMonth)));
                }
            }
            String cellStyle = inputComponent.getDayCellClass() + " " + inputComponent.getHighlightDayCellClass();
            if (cal.get(5) == day && cal.get(2) == month && cal.get(1) == year) {
                cellStyle = inputComponent.getCurrentDayCellClass();
            }
            if (cal.get(5) == day && cal.get(2) == month && cal.get(1) == year) {
                cellStyle = inputComponent.getCurrentDayCellClass();
            }
            if (tr2 == null) {
                this.writeCell(domContext, facesContext, writer, inputComponent, String.valueOf(i + 1), cal.getTime(), cellStyle, tr1, null, i, timeKeeper, months, weekdaysLong);
            } else {
                this.writeCell(domContext, facesContext, writer, inputComponent, String.valueOf(i + 1), cal.getTime(), cellStyle, tr2, null, i, timeKeeper, months, weekdaysLong);
            }
            if (++columnIndexCounter == weekdays.length) {
                columnIndexCounter = 0;
            }
            inputComponent.resetHighlightClasses(3);
        }
        if (columnIndexCounter != 0 && tr2 != null) {
            for (i = columnIndexCounter; i < weekdays.length; ++i) {
                this.writeCell(domContext, facesContext, writer, inputComponent, "&nbsp;", null, inputComponent.getDayCellClass(), tr2, null, (weekStartsAtDayIndex + i) % 7, timeKeeper, months, weekdaysLong);
            }
        }
    }

    private void writeCell(DOMContext domContext, FacesContext facesContext, ResponseWriter writer, SelectInputDate component, String content, Date valueForLink, String styleClass, Element tr, String imgSrc, int weekDayIndex, Calendar timeKeeper, String[] months, String[] weekdaysLong) throws IOException {
        Element td = domContext.createElement("td");
        tr.appendChild(td);
        if (styleClass != null) {
            td.setAttribute("class", styleClass);
        }
        if (valueForLink == null) {
            if (content != null && content.length() > 0) {
                Text text = domContext.createTextNode(content);
                td.setAttribute("title", weekdaysLong[weekDayIndex]);
                td.appendChild(text);
            }
        } else {
            domContext.setCursorParent((Node)td);
            domContext.streamWrite(facesContext, (UIComponent)component, domContext.getRootNode(), (Node)td);
            this.writeLink(content, component, facesContext, valueForLink, styleClass, imgSrc, td, timeKeeper, months, weekdaysLong);
            domContext.stepOver();
        }
    }

    private void writeLink(String content, SelectInputDate component, FacesContext facesContext, Date valueForLink, String styleClass, String imgSrc, Element td, Calendar timeKeeper, String[] months, String[] weekdaysLong) throws IOException {
        DateTimeConverter converter = component.resolveDateTimeConverter(facesContext);
        HtmlCommandLink link = new HtmlCommandLink();
        Calendar cal = this.copyCalendar(facesContext, timeKeeper);
        cal.setTime(valueForLink);
        String month = months[cal.get(2)];
        String year = String.valueOf(cal.get(1));
        int dayInt = cal.get(7);
        dayInt = this.mapCalendarDayToCommonDay(dayInt);
        String day = weekdaysLong[dayInt];
        String altText = null;
        String titleText = null;
        if (content.equals("<")) {
            link.setId(component.getId() + PREV_MONTH);
            altText = this.getMessageWithParamFromResource(facesContext, PREV_MONTH_ALT, month);
            titleText = this.getMessageWithParamFromResource(facesContext, PREV_MONTH_TITLE, month);
        } else if (content.equals(">")) {
            link.setId(component.getId() + NEXT_MONTH);
            altText = this.getMessageWithParamFromResource(facesContext, NEXT_MONTH_ALT, month);
            titleText = this.getMessageWithParamFromResource(facesContext, NEXT_MONTH_TITLE, month);
        } else if (content.equals(">>")) {
            link.setId(component.getId() + NEXT_YEAR);
            altText = this.getMessageWithParamFromResource(facesContext, NEXT_YEAR_ALT, year);
            titleText = this.getMessageWithParamFromResource(facesContext, NEXT_YEAR_TITLE, year);
        } else if (content.equals("<<")) {
            link.setId(component.getId() + PREV_YEAR);
            altText = this.getMessageWithParamFromResource(facesContext, PREV_YEAR_ALT, year);
            titleText = this.getMessageWithParamFromResource(facesContext, PREV_YEAR_TITLE, year);
        } else {
            link.setId(component.getId() + "_" + content.hashCode() + CALENDAR);
            if (log.isDebugEnabled()) {
                log.debug((Object)("linkId=" + component.getId() + "_" + content.hashCode() + CALENDAR));
            }
        }
        link.setPartialSubmit(true);
        link.setTransient(true);
        link.setImmediate(component.isImmediate());
        link.setDisabled(component.isDisabled());
        if (imgSrc != null) {
            HtmlGraphicImage img = new HtmlGraphicImage();
            if (component.isImageDirSet()) {
                img.setUrl(imgSrc);
            } else {
                img.setUrl(component.getImageDir() + "spacer.gif");
                if (content.equals("<") || content.equals("<<")) {
                    img.setStyleClass(component.getMovePrevClass());
                } else if (content.equals(">") || content.equals(">>")) {
                    img.setStyleClass(component.getMoveNextClass());
                }
            }
            img.setHeight("16");
            img.setWidth("17");
            img.setStyle("border:none;");
            if (altText != null) {
                img.setAlt(altText);
            }
            if (titleText != null) {
                img.setTitle(titleText);
            }
            img.setId(component.getId() + "_" + content.hashCode() + "_img");
            img.setTransient(true);
            link.getChildren().add(img);
        } else {
            HtmlOutputText text = new HtmlOutputText();
            text.setValue(content);
            text.setId(component.getId() + "_" + content.hashCode() + "_text");
            text.setTransient(true);
            text.setTitle(day);
            link.getChildren().add(text);
        }
        UIParameter parameter = new UIParameter();
        parameter.setId(component.getId() + "_" + valueForLink.getTime() + "_param");
        parameter.setTransient(true);
        parameter.setName(component.getClientId(facesContext));
        parameter.setValue((Object)converter.getAsString(facesContext, (UIComponent)component, (Object)valueForLink));
        component.getChildren().add(link);
        link.getChildren().add(parameter);
        if (!(content.equals("<") || content.equals(">") || content.equals(">>") || content.equals("<<"))) {
            parameter = new UIParameter();
            parameter.setId(component.getId() + "_" + valueForLink.getTime() + "_" + DATE_SELECTED);
            parameter.setName(this.getHiddenFieldName(facesContext, (UIComponent)component));
            parameter.setValue((Object)"false");
            link.getChildren().add(parameter);
        }
        link.encodeBegin(facesContext);
        link.encodeChildren(facesContext);
        link.encodeEnd(facesContext);
        td.setAttribute("id", link.getClientId(facesContext) + "td");
        try {
            Integer.parseInt(content);
            component.getLinkMap().put(link.getClientId(facesContext), td);
            if (styleClass.equals("iceSelInpDateCur")) {
                component.setSelectedDayLink(link.getClientId(facesContext));
            }
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
    }

    protected void addAttributeToElementFromResource(FacesContext facesContext, String resName, Element elem, String attrib) {
        String res = MessageUtils.getResource(facesContext, resName);
        if (res != null && res.length() > 0) {
            elem.setAttribute(attrib, res);
        }
    }

    protected String getMessageWithParamFromResource(FacesContext facesContext, String resName, String param) {
        String messagePattern;
        String msg = null;
        if (param != null && param.length() > 0 && (messagePattern = MessageUtils.getResource(facesContext, resName)) != null && messagePattern.length() > 0) {
            msg = MessageFormat.format(messagePattern, param);
        }
        return msg;
    }

    private int mapCalendarDayToCommonDay(int day) {
        switch (day) {
            case 3: {
                return 1;
            }
            case 4: {
                return 2;
            }
            case 5: {
                return 3;
            }
            case 6: {
                return 4;
            }
            case 7: {
                return 5;
            }
            case 1: {
                return 6;
            }
        }
        return 0;
    }

    private static String[] mapWeekdays(DateFormatSymbols symbols) {
        String[] weekdays = new String[7];
        String[] localeWeekdays = symbols.getShortWeekdays();
        weekdays[0] = localeWeekdays[2];
        weekdays[1] = localeWeekdays[3];
        weekdays[2] = localeWeekdays[4];
        weekdays[3] = localeWeekdays[5];
        weekdays[4] = localeWeekdays[6];
        weekdays[5] = localeWeekdays[7];
        weekdays[6] = localeWeekdays[1];
        return weekdays;
    }

    private static String[] mapWeekdaysLong(DateFormatSymbols symbols) {
        String[] weekdays = new String[7];
        String[] localeWeekdays = symbols.getWeekdays();
        weekdays[0] = localeWeekdays[2];
        weekdays[1] = localeWeekdays[3];
        weekdays[2] = localeWeekdays[4];
        weekdays[3] = localeWeekdays[5];
        weekdays[4] = localeWeekdays[6];
        weekdays[5] = localeWeekdays[7];
        weekdays[6] = localeWeekdays[1];
        return weekdays;
    }

    public static String[] mapMonths(DateFormatSymbols symbols) {
        String[] months = new String[12];
        String[] localeMonths = symbols.getMonths();
        months[0] = localeMonths[0];
        months[1] = localeMonths[1];
        months[2] = localeMonths[2];
        months[3] = localeMonths[3];
        months[4] = localeMonths[4];
        months[5] = localeMonths[5];
        months[6] = localeMonths[6];
        months[7] = localeMonths[7];
        months[8] = localeMonths[8];
        months[9] = localeMonths[9];
        months[10] = localeMonths[10];
        months[11] = localeMonths[11];
        return months;
    }

    public String getLinkId(FacesContext facesContext, UIComponent uiComponent) {
        UIComponent form = SelectInputDateRenderer.findForm((UIComponent)uiComponent);
        String formId = form.getClientId(facesContext);
        return formId + ":_idcl";
    }

    private boolean checkLink(String clickedLink, String clientId) {
        if (clickedLink == null) {
            return false;
        }
        boolean found = false;
        String REGEX = clientId;
        String INPUT = clickedLink;
        Pattern pattern = Pattern.compile(REGEX);
        Matcher matcher = pattern.matcher(INPUT);
        while (matcher.find()) {
            found = true;
        }
        return found;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void decode(FacesContext facesContext, UIComponent component) {
        block10: {
            String sclickedLink;
            block12: {
                block11: {
                    this.validateParameters(facesContext, component, SelectInputDate.class);
                    Map requestParameterMap = facesContext.getExternalContext().getRequestParameterMap();
                    String linkId = this.getLinkId(facesContext, component);
                    Object clickedLink = requestParameterMap.get(linkId);
                    String clientId = component.getClientId(facesContext);
                    if (clickedLink == null) return;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("linkId::" + linkId + "  clickedLink::" + clickedLink + "  clientId::" + clientId));
                    }
                    if (!this.checkLink(sclickedLink = (String)clickedLink, clientId)) break block10;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"---------------------------------");
                        log.debug((Object)"----------START::DECODE----------");
                        log.debug((Object)"---------------------------------");
                        log.debug((Object)("decode::linkId::" + linkId + "=" + clickedLink + " clientId::" + clientId));
                    }
                    if (sclickedLink.endsWith(PREV_MONTH)) break block11;
                    if (sclickedLink.endsWith(NEXT_MONTH)) break block11;
                    if (sclickedLink.endsWith(PREV_YEAR)) break block11;
                    if (!sclickedLink.endsWith(NEXT_YEAR)) break block12;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)"-------------Navigation Event-------------");
                }
                this.decodeNavigation(facesContext, component);
                return;
            }
            if (sclickedLink.endsWith(CALENDAR)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"-------------Select Date Event-------------");
                }
                this.decodeSelectDate(facesContext, component);
                return;
            }
            if (!sclickedLink.endsWith(CALENDAR_BUTTON)) return;
            if (log.isDebugEnabled()) {
                log.debug((Object)"-------------Popup Event-------------------");
            }
            this.decodePopup(facesContext, component);
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"-------------InputText enterkey Event ??----");
        }
        this.decodeInputText(facesContext, component);
    }

    private void decodeNavigation(FacesContext facesContext, UIComponent component) {
        Map requestParameterMap = facesContext.getExternalContext().getRequestParameterMap();
        SelectInputDate dateSelect = (SelectInputDate)component;
        if (log.isDebugEnabled()) {
            log.debug((Object)"setNavDate::");
            log.debug((Object)"#################################");
        }
        dateSelect.setNavEvent(true);
        dateSelect.setNavDate((Date)this.getConvertedValue(facesContext, (UIComponent)dateSelect, requestParameterMap.get(dateSelect.getClientId(facesContext))));
    }

    private void decodePopup(FacesContext facesContext, UIComponent component) {
        Map requestParameterMap = facesContext.getExternalContext().getRequestParameterMap();
        String popupState = this.getHiddenFieldName(facesContext, component);
        String showPopup = (String)requestParameterMap.get(popupState);
        SelectInputDate dateSelect = (SelectInputDate)component;
        if (log.isDebugEnabled()) {
            log.debug((Object)("decodePopup::" + showPopup));
            log.debug((Object)"#################################");
        }
        if (showPopup != null) {
            dateSelect.setShowPopup(!dateSelect.isShowPopup());
        }
        dateSelect.setNavEvent(false);
    }

    private void decodeSelectDate(FacesContext facesContext, UIComponent component) {
        String inputDateTextId;
        Map requestParameterMap = facesContext.getExternalContext().getRequestParameterMap();
        String popupState = this.getHiddenFieldName(facesContext, component);
        String showPopup = (String)requestParameterMap.get(popupState);
        SelectInputDate dateSelect = (SelectInputDate)component;
        if (log.isDebugEnabled()) {
            log.debug((Object)("selectDate::showPopup" + showPopup));
            log.debug((Object)"#################################");
        }
        if (showPopup != null) {
            if (showPopup.equalsIgnoreCase("true")) {
                dateSelect.setShowPopup(true);
            } else {
                dateSelect.setShowPopup(false);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"decodeUIInput::");
            log.debug((Object)"#################################");
        }
        if (requestParameterMap.containsKey(inputDateTextId = component.getClientId(facesContext) + "_calendarInputtext")) {
            String inputDateButtonId = component.getClientId(facesContext) + CALENDAR_BUTTON;
            ((BridgeFacesContext)facesContext).setFocusId(inputDateButtonId);
        }
        CustomComponentUtils.decodeUIInput(facesContext, component);
        dateSelect.setNavEvent(false);
    }

    private void decodeInputText(FacesContext facesContext, UIComponent component) {
        Map requestParameterMap = facesContext.getExternalContext().getRequestParameterMap();
        String popupState = this.getHiddenFieldName(facesContext, component);
        String showPopup = (String)requestParameterMap.get(popupState);
        SelectInputDate dateSelect = (SelectInputDate)component;
        String clientId = dateSelect.getClientId(facesContext);
        String linkId = this.getLinkId(facesContext, component);
        Object clickedLink = requestParameterMap.get(linkId);
        String inputTextDateId = component.getClientId(facesContext) + "_calendarInputtext";
        Object inputTextDate = requestParameterMap.get(inputTextDateId);
        if (requestParameterMap.containsKey(inputTextDateId) && dateSelect.isRenderAsPopup()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"decoding InputText EnterKey::");
                log.debug((Object)"###################################");
            }
            if (showPopup != null) {
                if (this.checkLink((String)clickedLink, clientId)) {
                    if (showPopup.equalsIgnoreCase("true")) {
                        dateSelect.setShowPopup(true);
                    } else {
                        dateSelect.setShowPopup(false);
                    }
                }
                if (inputTextDate == null) {
                    dateSelect.setSubmittedValue(null);
                } else if (String.valueOf(inputTextDate).trim().length() == 0) {
                    dateSelect.setSubmittedValue("");
                } else {
                    dateSelect.setSubmittedValue(inputTextDate);
                }
            }
        }
    }

    public Object getConvertedValue(FacesContext facesContext, UIComponent uiComponent, Object submittedValue) throws ConverterException {
        this.validateParameters(facesContext, uiComponent, SelectInputDate.class);
        DateTimeConverter converter = ((SelectInputDate)uiComponent).resolveDateTimeConverter(facesContext);
        if (submittedValue != null && !(submittedValue instanceof String)) {
            throw new IllegalArgumentException("Submitted value of type String expected");
        }
        Object o = converter.getAsObject(facesContext, uiComponent, (String)submittedValue);
        return o;
    }
}

