/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.component.tree;

import com.icesoft.faces.component.ext.taglib.Util;
import com.icesoft.faces.component.tree.ChildState;
import com.icesoft.faces.component.tree.IceUserObject;
import com.icesoft.faces.component.tree.MalformedTreeTagException;
import com.icesoft.faces.component.tree.TreeNode;
import com.icesoft.faces.component.tree.TreeRenderer;
import com.icesoft.faces.util.CoreUtils;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.NamingContainer;
import javax.faces.component.UICommand;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ActionEvent;
import javax.faces.event.FacesEvent;
import javax.faces.event.FacesListener;
import javax.faces.event.PhaseId;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeModel;

public class Tree
extends UICommand
implements NamingContainer {
    private static final String DEFAULT_CSSIMAGEDIR = "/xmlhttp/css/xp/css-images/";
    private static final String DEFAULT_NAV_OPEN_TOP_GIF = "tree_nav_top_open.gif";
    private static final String DEFAULT_NAV_CLOSE_TOP_GIF = "tree_nav_top_close.gif";
    private static final String DEFAULT_NAV_OPEN_TOP_NO_SIBLINGS_GIF = "tree_nav_top_open_no_siblings.gif";
    private static final String DEFAULT_NAV_CLOSE_TOP_NO_SIBLINGS_GIF = "tree_nav_top_close_no_siblings.gif";
    private static final String DEFAULT_NAV_OPEN_MIDDLE_GIF = "tree_nav_middle_open.gif";
    private static final String DEFAULT_NAV_CLOSE_MIDDLE_GIF = "tree_nav_middle_close.gif";
    private static final String DEFAULT_NAV_CLOSE_BOTTOM_GIF = "tree_nav_bottom_close.gif";
    private static final String DEFAULT_NAV_OPEN_BOTTOM_GIF = "tree_nav_bottom_open.gif";
    private static final String DEFAULT_LINE_MIDDLE_NODE_GIF = "tree_line_middle_node.gif";
    private static final String DEFAULT_LINE_VERTICAL_GIF = "tree_line_vertical.gif";
    private static final String DEFAULT_LINE_BLANK_GIF = "tree_line_blank.gif";
    private static final String DEFAULT_LINE_BOTTOM_NODE_GIF = "tree_line_last_node.gif";
    private static final String DEFAULT_DOCUMENT_GIF = "tree_document.gif";
    private static final String DEFAULT_FOLDER_GIF = "tree_folder_close.gif";
    private static final String DEFAULT_FOLDER_OPEN_GIF = "tree_folder_open.gif";
    public static final String NAVIGATION_EVENT_COLLAPSE = "collapse";
    public static final String NAVIGATION_EVENT_EXPAND = "expand";
    public static final String ID_PREFIX = "n-";
    private DefaultMutableTreeNode navigatedNode;
    private String navigationEventType;
    private String imageDir;
    private String navOpenTop;
    private String navOpenTopNoSiblings;
    private String navCloseTopNoSiblings;
    private String navCloseTop;
    private String navCloseMiddle;
    private String navOpenMiddle;
    private String lineMiddleNode;
    private String lineBottomNode;
    private String lineVertical;
    private String lineBlank;
    private String documentImage;
    private String folderImage;
    private String folderOpenImage;
    private String navCloseBottom;
    private String navOpenBottom;
    private String var;
    private String styleClass;
    private String style;
    private Boolean hideRootNode;
    private Boolean hideNavigation;
    private DefaultMutableTreeNode currentNode;
    private String nodePath;
    private String title;
    public static final String COMPONENT_TYPE = "com.icesoft.faces.TreeView";
    protected Map savedChildren = new HashMap();

    public String getRendererType() {
        return "com.icesoft.faces.View";
    }

    public String getComponentType() {
        return COMPONENT_TYPE;
    }

    public String getFamily() {
        return COMPONENT_TYPE;
    }

    public void setCurrentNode(DefaultMutableTreeNode currentNode) {
        this.currentNode = currentNode;
    }

    public DefaultMutableTreeNode getCurrentNode() {
        return this.currentNode;
    }

    public void setNodePath(String nodePath) {
        FacesContext facesContext = this.getFacesContext();
        this.saveChildrenState(facesContext);
        this.nodePath = nodePath;
        this.restoreChildrenState(facesContext);
        this.setCurrentVarToRequestMap(facesContext, this.getCurrentNode());
    }

    public String getNodePath() {
        return this.nodePath;
    }

    public TreeModel getModel() {
        ValueBinding vb = this.getValueBinding("value");
        return (TreeModel)vb.getValue(this.getFacesContext());
    }

    public TreeNode getTreeNodeTemplate() throws MalformedTreeTagException {
        TreeNode template = null;
        int childCount = this.getChildCount();
        if (childCount != 1) {
            throw new MalformedTreeTagException("The tree tag requires a single treeNode child tag. Found [" + childCount + "] children");
        }
        UIComponent treeNodeTemplate = (UIComponent)this.getChildren().get(0);
        if (treeNodeTemplate == null) {
            throw new MalformedTreeTagException("The Tree requires a TreeNode child. None found.");
        }
        if (!(treeNodeTemplate instanceof TreeNode)) {
            throw new MalformedTreeTagException("The Tree requires a TreeNode child. Found child of type [" + treeNodeTemplate.getClass() + "]");
        }
        return template;
    }

    public DefaultMutableTreeNode getNodeAtPathsEnd(String pathToSelectedNode) {
        if (pathToSelectedNode.equalsIgnoreCase("root")) {
            return (DefaultMutableTreeNode)this.getModel().getRoot();
        }
        String[] indices = pathToSelectedNode.split("-");
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)this.getModel().getRoot();
        for (int i = 0; i < indices.length; ++i) {
            parent = (DefaultMutableTreeNode)parent.getChildAt(Integer.parseInt(indices[i]));
        }
        return parent;
    }

    public String getImageDir() {
        if (this.imageDir != null) {
            return this.imageDir;
        }
        ValueBinding vb = this.getValueBinding("imageDir");
        return CoreUtils.resolveResourceURL((FacesContext)this.getFacesContext(), (String)(vb != null ? (String)vb.getValue(this.getFacesContext()) : DEFAULT_CSSIMAGEDIR));
    }

    public String getStyleClass() {
        return Util.getQualifiedStyleClass((UIComponent)this, this.styleClass, "iceTree", "styleClass");
    }

    public void setStyleClass(String styleClass) {
        this.styleClass = styleClass;
    }

    public String getStyle() {
        if (this.style != null) {
            return this.style;
        }
        ValueBinding vb = this.getValueBinding("style");
        return vb != null ? (String)vb.getValue(this.getFacesContext()) : "";
    }

    public void setStyle(String style) {
        this.style = style;
    }

    String getTreeRowStyleClass() {
        return Util.getQualifiedStyleClass((UIComponent)this, "Row");
    }

    public String getImage(String imageProperty, String bindingName, String defaultImage) {
        if (imageProperty != null) {
            return imageProperty;
        }
        ValueBinding vb = this.getValueBinding(bindingName);
        if (vb != null) {
            return (String)vb.getValue(this.getFacesContext());
        }
        return this.getImageDir() + defaultImage;
    }

    public String getFolderImage() {
        return this.getImage(this.folderImage, "folderImage", DEFAULT_FOLDER_GIF);
    }

    public String getFolderOpenImage() {
        return this.getImage(this.folderOpenImage, "folderOpenImage", DEFAULT_FOLDER_OPEN_GIF);
    }

    public String getDocumentImage() {
        return this.getImage(this.documentImage, "documentImage", DEFAULT_DOCUMENT_GIF);
    }

    public String getLineBottomImage() {
        return this.getImage(this.lineBottomNode, "lineBottom", DEFAULT_LINE_BOTTOM_NODE_GIF);
    }

    public String getLineVerticalImage() {
        return this.getImage(this.lineVertical, "lineVertical", DEFAULT_LINE_VERTICAL_GIF);
    }

    public String getLineMiddleImage() {
        return this.getImage(this.lineMiddleNode, "lineMiddle", DEFAULT_LINE_MIDDLE_NODE_GIF);
    }

    public String getNavCloseMiddleImage() {
        return this.getImage(this.navCloseMiddle, "navCloseMiddleImage", DEFAULT_NAV_CLOSE_MIDDLE_GIF);
    }

    public String getNavOpenMiddleImage() {
        return this.getImage(this.navOpenMiddle, "navOpenMiddle", DEFAULT_NAV_OPEN_MIDDLE_GIF);
    }

    public String getNavCloseTopImage() {
        return this.getImage(this.navCloseTop, "navCloseTop", DEFAULT_NAV_CLOSE_TOP_GIF);
    }

    public String getNavOpenTopImage() {
        return this.getImage(this.navOpenTop, "navOpenTopImage", DEFAULT_NAV_OPEN_TOP_GIF);
    }

    public String getNavOpenTopNoSiblingsImage() {
        return this.getImage(this.navOpenTopNoSiblings, "navOpenTopNoSiblingsImage", DEFAULT_NAV_OPEN_TOP_NO_SIBLINGS_GIF);
    }

    public String getNavCloseTopNoSiblingsImage() {
        return this.getImage(this.navCloseTopNoSiblings, "navCloseTopNoSiblingsImage", DEFAULT_NAV_CLOSE_TOP_NO_SIBLINGS_GIF);
    }

    public String getNavCloseBottomImage() {
        return this.getImage(this.navCloseBottom, "navCloseBottomImage", DEFAULT_NAV_CLOSE_BOTTOM_GIF);
    }

    public String getNavOpenBottomImage() {
        return this.getImage(this.navOpenBottom, "navOpenBottomImage", DEFAULT_NAV_OPEN_BOTTOM_GIF);
    }

    public String getLineBlankImage() {
        return this.getImage(this.lineBlank, "lineBlank", DEFAULT_LINE_BLANK_GIF);
    }

    public String getLineBottomNode() {
        return this.lineBottomNode;
    }

    public void setLineBottomNode(String lineBottomNode) {
        this.lineBottomNode = lineBottomNode;
    }

    public String getLineMiddleNode() {
        return this.lineMiddleNode;
    }

    public void setLineMiddleNode(String lineMiddleNode) {
        this.lineMiddleNode = lineMiddleNode;
    }

    public String getLineVertical() {
        return this.lineVertical;
    }

    public void setLineVertical(String lineVertical) {
        this.lineVertical = lineVertical;
    }

    public String getNavExpandedMiddle() {
        return this.navCloseMiddle;
    }

    public void setNavExpandedMiddle(String navExpandedMiddle) {
        this.navCloseMiddle = navExpandedMiddle;
    }

    public String getNavExpandedTop() {
        return this.navOpenTop;
    }

    public void setNavExpandedTop(String navExpandedTop) {
        this.navOpenTop = navExpandedTop;
    }

    public void setImageDir(String imageDir) {
        this.imageDir = imageDir;
    }

    public void setDocumentImage(String documentImage) {
        this.documentImage = documentImage;
    }

    public void setFolderImage(String folderImage) {
        this.folderImage = folderImage;
    }

    public String getNavCloseTop() {
        return this.navCloseTop;
    }

    public void setNavCloseTop(String navCloseTop) {
        this.navCloseTop = navCloseTop;
    }

    public String getNavOpenTop() {
        return this.navOpenTop;
    }

    public void setNavOpenTop(String navOpenTop) {
        this.navOpenTop = navOpenTop;
    }

    public String getNavOpenTopNoSiblings() {
        return this.navOpenTopNoSiblings;
    }

    public void setNavOpenTopNoSiblings(String navOpenTopNoSiblings) {
        this.navOpenTopNoSiblings = navOpenTopNoSiblings;
    }

    public String getNavCloseTopNoSiblings() {
        return this.navCloseTopNoSiblings;
    }

    public void setNavCloseTopNoSiblings(String navCloseTopNoSiblings) {
        this.navCloseTopNoSiblings = navCloseTopNoSiblings;
    }

    public void setFolderOpenImage(String folderOpenImage) {
        this.folderOpenImage = folderOpenImage;
    }

    public String getNavCloseBottom() {
        return this.navCloseBottom;
    }

    public void setNavCloseBottom(String navCloseBottom) {
        this.navCloseBottom = navCloseBottom;
    }

    public String getNavCloseMiddle() {
        return this.navCloseMiddle;
    }

    public void setNavCloseMiddle(String navCloseMiddle) {
        this.navCloseMiddle = navCloseMiddle;
    }

    public String getNavOpenBottom() {
        return this.navOpenBottom;
    }

    public void setNavOpenBottom(String navOpenBottom) {
        this.navOpenBottom = navOpenBottom;
    }

    public String getNavOpenMiddle() {
        return this.navOpenMiddle;
    }

    public void setNavOpenMiddle(String navOpenMiddle) {
        this.navOpenMiddle = navOpenMiddle;
    }

    public String getVar() {
        return this.var;
    }

    public void setVar(String var) {
        this.var = var;
    }

    public String getLineBlank() {
        return this.lineBlank;
    }

    public void setLineBlank(String lineBlank) {
        this.lineBlank = lineBlank;
    }

    public DefaultMutableTreeNode getNavigatedNode() {
        return this.navigatedNode;
    }

    public void setNavigatedNode(DefaultMutableTreeNode navigatedNode) {
        this.navigatedNode = navigatedNode;
    }

    public void setNavigationEventType(String string) {
        this.navigationEventType = string;
    }

    public String getNavigationEventType() {
        return this.navigationEventType;
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{super.saveState(context), this.navigatedNode, this.navigationEventType, this.imageDir, this.navOpenTop, this.navOpenTopNoSiblings, this.navCloseTopNoSiblings, this.navCloseTop, this.navCloseMiddle, this.navOpenMiddle, this.lineMiddleNode, this.lineBottomNode, this.lineVertical, this.lineBlank, this.documentImage, this.folderImage, this.folderOpenImage, this.navCloseBottom, this.navOpenBottom, this.var, this.styleClass, this.style, this.hideRootNode, this.hideNavigation, this.currentNode, this.nodePath};
        return values;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this.navigatedNode = (DefaultMutableTreeNode)values[1];
        this.navigationEventType = (String)values[2];
        this.imageDir = (String)values[3];
        this.navOpenTop = (String)values[4];
        this.navOpenTopNoSiblings = (String)values[5];
        this.navCloseTopNoSiblings = (String)values[6];
        this.navCloseTop = (String)values[7];
        this.navCloseMiddle = (String)values[8];
        this.navOpenMiddle = (String)values[9];
        this.lineMiddleNode = (String)values[10];
        this.lineBottomNode = (String)values[11];
        this.lineVertical = (String)values[12];
        this.lineBlank = (String)values[13];
        this.documentImage = (String)values[14];
        this.folderImage = (String)values[15];
        this.folderOpenImage = (String)values[16];
        this.navCloseBottom = (String)values[17];
        this.navOpenBottom = (String)values[18];
        this.var = (String)values[19];
        this.styleClass = (String)values[20];
        this.style = (String)values[21];
        this.hideRootNode = (Boolean)values[22];
        this.hideNavigation = (Boolean)values[23];
        this.currentNode = (DefaultMutableTreeNode)values[24];
        this.nodePath = (String)values[25];
    }

    public void processDecodes(FacesContext context) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        if (!this.isRendered()) {
            return;
        }
        this.savedChildren = new HashMap();
        this.processTreeNodes((DefaultMutableTreeNode)this.getModel().getRoot(), PhaseId.APPLY_REQUEST_VALUES, context);
        try {
            this.setNodePath(null);
            this.setCurrentNode(null);
            this.decode(context);
        }
        catch (RuntimeException e) {
            context.renderResponse();
            throw e;
        }
    }

    public void processValidators(FacesContext context) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        if (!this.isRendered()) {
            return;
        }
        this.processTreeNodes((DefaultMutableTreeNode)this.getModel().getRoot(), PhaseId.PROCESS_VALIDATIONS, context);
        this.setNodePath(null);
        this.setCurrentNode(null);
    }

    public void processUpdates(FacesContext context) {
        if (context == null) {
            throw new NullPointerException("context");
        }
        if (!this.isRendered()) {
            return;
        }
        this.processTreeNodes((DefaultMutableTreeNode)this.getModel().getRoot(), PhaseId.UPDATE_MODEL_VALUES, context);
        this.setNodePath(null);
        this.setCurrentNode(null);
    }

    private void processTreeNodes(DefaultMutableTreeNode currentNode, Object phaseId, FacesContext context) {
        IceUserObject userObject;
        this.setCurrentNode(currentNode);
        TreeNode treeNodeTemplate = (TreeNode)((Object)this.getChildren().get(0));
        String pathToCurrentNode = TreeRenderer.getPathAsString(currentNode, (DefaultMutableTreeNode)this.getModel().getRoot());
        treeNodeTemplate.setMutable(currentNode);
        treeNodeTemplate.setId(ID_PREFIX + pathToCurrentNode);
        treeNodeTemplate.setParent((UIComponent)this);
        this.setNodePath(pathToCurrentNode);
        UIComponent iconFacet = treeNodeTemplate.getIcon();
        UIComponent contentFacet = treeNodeTemplate.getContent();
        if (phaseId == PhaseId.APPLY_REQUEST_VALUES) {
            if (iconFacet != null) {
                iconFacet.processDecodes(context);
            }
            if (contentFacet != null) {
                contentFacet.processDecodes(context);
            }
        } else if (phaseId == PhaseId.PROCESS_VALIDATIONS) {
            if (iconFacet != null) {
                iconFacet.processValidators(context);
            }
            if (contentFacet != null) {
                contentFacet.processValidators(context);
            }
        } else if (phaseId == PhaseId.UPDATE_MODEL_VALUES) {
            if (iconFacet != null) {
                iconFacet.processUpdates(context);
            }
            if (contentFacet != null) {
                contentFacet.processUpdates(context);
            }
        }
        if ((userObject = (IceUserObject)currentNode.getUserObject()).isExpanded()) {
            int childCount = currentNode.getChildCount();
            for (int childIndex = 0; childIndex < childCount; ++childIndex) {
                DefaultMutableTreeNode nextNode = (DefaultMutableTreeNode)currentNode.getChildAt(childIndex);
                this.processTreeNodes(nextNode, phaseId, context);
            }
        }
    }

    public void queueEvent(FacesEvent event) {
        UIComponent parentTreeNode;
        UIComponent eventComponent = event.getComponent();
        for (parentTreeNode = eventComponent.getParent(); parentTreeNode != null && !(parentTreeNode instanceof TreeNode); parentTreeNode = parentTreeNode.getParent()) {
        }
        if (parentTreeNode != null) {
            event = new NodeEvent((UIComponent)this, event, ((TreeNode)parentTreeNode).getMutable());
        }
        if (event instanceof ActionEvent && !((Object)((Object)this)).equals(event.getComponent()) && this.getParent() != null) {
            this.getParent().queueEvent(event);
        } else {
            super.queueEvent(event);
        }
    }

    public void broadcast(FacesEvent event) throws AbortProcessingException {
        if (!(event instanceof NodeEvent)) {
            super.broadcast(event);
            return;
        }
        NodeEvent wrapperEvent = (NodeEvent)event;
        DefaultMutableTreeNode eventNode = wrapperEvent.getNode();
        this.setCurrentNode(eventNode);
        this.setNodePath(TreeRenderer.getPathAsString(eventNode, (DefaultMutableTreeNode)this.getModel().getRoot()));
        FacesEvent facesEvent = wrapperEvent.getFacesEvent();
        facesEvent.getComponent().broadcast(facesEvent);
    }

    private void setCurrentVarToRequestMap(FacesContext context, DefaultMutableTreeNode currentVar) {
        Map requestMap = context.getExternalContext().getRequestMap();
        String varAttribute = this.getVar();
        if (currentVar != null) {
            requestMap.put(varAttribute, currentVar);
        }
    }

    public String getHideNavigation() {
        if (this.hideNavigation != null) {
            return this.hideNavigation.toString();
        }
        ValueBinding vb = this.getValueBinding("hideNavigation");
        if (vb != null) {
            return vb.getValue(this.getFacesContext()).toString();
        }
        return String.valueOf(false);
    }

    public void setHideNavigation(String b) {
        this.hideNavigation = new Boolean(b);
    }

    public String getHideRootNode() {
        if (this.hideRootNode != null) {
            return this.hideRootNode.toString();
        }
        ValueBinding vb = this.getValueBinding("hideRootNode");
        if (vb != null) {
            return vb.getValue(this.getFacesContext()).toString();
        }
        return String.valueOf(false);
    }

    public void setHideRootNode(String b) {
        this.hideRootNode = new Boolean(b);
    }

    public String getTitle() {
        if (this.title != null) {
            return this.title;
        }
        ValueBinding vb = this.getValueBinding("title");
        if (vb == null) {
            return null;
        }
        return (String)vb.getValue(this.getFacesContext());
    }

    public void setTitle(String title) {
        this.title = title;
    }

    protected void restoreChildrenState(FacesContext context) {
        Iterator kids = this.getChildren().iterator();
        while (kids.hasNext()) {
            UIComponent kid = (UIComponent)kids.next();
            this.restoreChildState(kid, context);
        }
    }

    protected void restoreChild(UIComponent component, FacesContext context) {
        if (component instanceof EditableValueHolder) {
            EditableValueHolder input = (EditableValueHolder)component;
            String clientId = component.getClientId(context);
            ChildState state = (ChildState)this.savedChildren.get(clientId);
            if (state == null) {
                state = new ChildState();
            }
            input.setValue(state.getValue());
            input.setValid(state.isValid());
            input.setSubmittedValue(state.getSubmittedValue());
            input.setLocalValueSet(state.isLocalValueSet());
        }
    }

    private void restoreChildState(UIComponent component, FacesContext context) {
        String id = component.getId();
        component.setId(id);
        this.restoreChild(component, context);
        Iterator kids = component.getFacetsAndChildren();
        while (kids.hasNext()) {
            this.restoreChildState((UIComponent)kids.next(), context);
        }
    }

    protected void saveChildrenState(FacesContext context) {
        Iterator kids = this.getChildren().iterator();
        while (kids.hasNext()) {
            UIComponent kid = (UIComponent)kids.next();
            this.saveChildState(kid, context);
        }
    }

    protected void saveChild(UIComponent component, FacesContext context) {
        if (component instanceof EditableValueHolder) {
            EditableValueHolder input = (EditableValueHolder)component;
            String clientId = component.getClientId(context);
            ChildState state = (ChildState)this.savedChildren.get(clientId);
            if (state == null) {
                state = new ChildState();
                this.savedChildren.put(clientId, state);
            }
            state.setValue(input.getLocalValue());
            state.setValid(input.isValid());
            state.setSubmittedValue(input.getSubmittedValue());
            state.setLocalValueSet(input.isLocalValueSet());
        }
    }

    protected void saveChildState(UIComponent component, FacesContext context) {
        this.saveChild(component, context);
        Iterator kids = component.getFacetsAndChildren();
        while (kids.hasNext()) {
            this.saveChildState((UIComponent)kids.next(), context);
        }
    }

    class NodeEvent
    extends FacesEvent {
        private static final long serialVersionUID = 1L;
        private FacesEvent event;
        private DefaultMutableTreeNode node;

        public NodeEvent(UIComponent component, FacesEvent event, DefaultMutableTreeNode node) {
            super(component);
            this.event = null;
            this.node = null;
            this.event = event;
            this.node = node;
        }

        public DefaultMutableTreeNode getNode() {
            return this.node;
        }

        public void setNode(DefaultMutableTreeNode node) {
            this.node = node;
        }

        public FacesEvent getFacesEvent() {
            return this.event;
        }

        public PhaseId getPhaseId() {
            return this.event.getPhaseId();
        }

        public void setPhaseId(PhaseId phaseId) {
            this.event.setPhaseId(phaseId);
        }

        public boolean isAppropriateListener(FacesListener listener) {
            return false;
        }

        public void processListener(FacesListener listener) {
            throw new IllegalStateException();
        }
    }
}

